/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.reports.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetUsage;
import org.egov.services.budget.BudgetGroupService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.BudgetFolioDetail;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.reports.entity.EstimateAppropriationRegisterSearchRequest;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimateAppropriationRegisterService {
    private static final Logger logger = Logger.getLogger(EstimateAppropriationRegisterService.class);
    private static final String DEPTID = "deptid";
    private static final String BUDGETHEADID = "budgetheadid";
    private static final String FUNDID = "fundid";
    private static final String FUNCTIONID = "functionid";
    private static final String FINANCIALYEARID = "financialyearid";
    private static final String FROMDATE = "fromDate";
    private static final String TODATE = "toDate";
    private static final String REGULAR = "Regular";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private BudgetGroupService budgetGroupService;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Map<String, List> searchEstimateAppropriationRegister(EstimateAppropriationRegisterSearchRequest estimateAppropriationRegisterSearchRequest) {
        HashMap<String, Object> queryParamMap = new HashMap<String, Object>();
        BigDecimal totalGrant = BigDecimal.ZERO;
        Map<String, List> approvedBudgetFolioDetailsMap = null;
        this.setQueryParamMapValues(estimateAppropriationRegisterSearchRequest, queryParamMap);
        if (estimateAppropriationRegisterSearchRequest != null && estimateAppropriationRegisterSearchRequest.getDepartment() != null) {
            queryParamMap.put(DEPTID, estimateAppropriationRegisterSearchRequest.getDepartment());
        }
        if (estimateAppropriationRegisterSearchRequest != null && estimateAppropriationRegisterSearchRequest.getFinancialYear() != null) {
            queryParamMap.put(FINANCIALYEARID, estimateAppropriationRegisterSearchRequest.getFinancialYear());
            queryParamMap.put(FROMDATE, this.financialYearHibernateDAO.getFinancialYearById(estimateAppropriationRegisterSearchRequest.getFinancialYear()).getStartingDate());
            queryParamMap.put(TODATE, new Date());
        }
        if (!queryParamMap.isEmpty()) {
            BigDecimal planningBudgetPerc = BigDecimal.ZERO;
            try {
                totalGrant = this.budgetDetailsDAO.getBudgetedAmtForYear(queryParamMap);
                if (estimateAppropriationRegisterSearchRequest != null) {
                    queryParamMap.put(DEPTID, estimateAppropriationRegisterSearchRequest.getDepartment().intValue());
                }
                planningBudgetPerc = this.getPlanningBudgetPercentage(queryParamMap);
            }
            catch (ValidationException valEx) {
                logger.error((Object)valEx);
            }
            if (planningBudgetPerc != null && planningBudgetPerc.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal totalGrantPerc = totalGrant.multiply(planningBudgetPerc.divide(new BigDecimal(100)));
                queryParamMap.put("totalGrantPerc", totalGrantPerc);
            }
            approvedBudgetFolioDetailsMap = this.getApprovedAppropriationDetailsForBugetHead(queryParamMap);
        }
        return approvedBudgetFolioDetailsMap;
    }

    private void setQueryParamMapValues(EstimateAppropriationRegisterSearchRequest estimateAppropriationRegisterSearchRequest, Map<String, Object> queryParamMap) {
        if (estimateAppropriationRegisterSearchRequest != null && estimateAppropriationRegisterSearchRequest.getFund() != null) {
            queryParamMap.put(FUNDID, estimateAppropriationRegisterSearchRequest.getFund().intValue());
        }
        if (estimateAppropriationRegisterSearchRequest != null && estimateAppropriationRegisterSearchRequest.getFunction() != null) {
            queryParamMap.put(FUNCTIONID, estimateAppropriationRegisterSearchRequest.getFunction());
        }
        if (estimateAppropriationRegisterSearchRequest != null && estimateAppropriationRegisterSearchRequest.getBudgetHead() != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            BudgetGroup budgetGroup = (BudgetGroup)this.budgetGroupService.findById((Serializable)estimateAppropriationRegisterSearchRequest.getBudgetHead(), true);
            budgetheadid.add(budgetGroup);
            queryParamMap.put(BUDGETHEADID, budgetheadid);
        }
    }

    private BigDecimal getPlanningBudgetPercentage(Map<String, Object> queryParamMap) {
        return this.budgetDetailsDAO.getPlanningPercentForYear(queryParamMap);
    }

    public Map<String, List> getApprovedAppropriationDetailsForBugetHead(Map<String, Object> queryParamMap) {
        ArrayList<BudgetFolioDetail> approvedBudgetFolioResultList = new ArrayList<BudgetFolioDetail>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (queryParamMap.get(BUDGETHEADID) != null) {
            List budgetheadid = (List)queryParamMap.get(BUDGETHEADID);
            BudgetGroup bg = (BudgetGroup)budgetheadid.get(0);
            paramMap.put("budgetgroupId", bg.getId());
        }
        if (queryParamMap.get(DEPTID) != null) {
            paramMap.put("ExecutionDepartmentId", queryParamMap.get(DEPTID));
        }
        if (queryParamMap.get(FUNCTIONID) != null) {
            paramMap.put("functionId", queryParamMap.get(FUNCTIONID));
        }
        if (queryParamMap.get(FUNDID) != null) {
            paramMap.put("fundId", queryParamMap.get(FUNDID));
        }
        if (queryParamMap.get(FINANCIALYEARID) != null) {
            paramMap.put("financialYearId", queryParamMap.get(FINANCIALYEARID));
        }
        if (queryParamMap.get(FROMDATE) != null) {
            paramMap.put(FROMDATE, queryParamMap.get(FROMDATE));
        }
        if (queryParamMap.get(TODATE) != null) {
            paramMap.put(TODATE, queryParamMap.get(TODATE));
        }
        Integer moduleId = 11;
        paramMap.put("moduleId", moduleId);
        List budgetUsageList = this.budgetDetailsDAO.getListBudgetUsage(paramMap);
        if (budgetUsageList != null && !budgetUsageList.isEmpty()) {
            return this.addApprovedEstimateResultList(approvedBudgetFolioResultList, budgetUsageList, new BigDecimal(queryParamMap.get("totalGrantPerc").toString()));
        }
        return new HashMap<String, List>();
    }

    public Map<String, List> addApprovedEstimateResultList(List<BudgetFolioDetail> budgetFolioResultList, List<BudgetUsage> budgetUsageList, BigDecimal totalGrantPerc) {
        int srlNo = 1;
        Double cumulativeTotal = 0.0;
        HashMap<String, List> budgetFolioMap = new HashMap<String, List>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", new Locale("en", "IN"));
        for (BudgetUsage budgetUsage : budgetUsageList) {
            BudgetFolioDetail budgetFolioDetail = this.getBudgetFolioDetail();
            budgetFolioDetail.setSrlNo(srlNo++);
            EstimateAppropriation estimateAppropriation = this.estimateAppropriationService.findLatestByBudgetUsage(budgetUsage.getId());
            if (estimateAppropriation != null && estimateAppropriation.getLineEstimateDetails() != null) {
                LineEstimateDetails led = estimateAppropriation.getLineEstimateDetails();
                if (led != null) {
                    this.setBudgetFolioDetailsForLE(sdf, budgetFolioDetail, led);
                }
            } else if (estimateAppropriation != null && estimateAppropriation.getAbstractEstimate() != null) {
                AbstractEstimate ae = estimateAppropriation.getAbstractEstimate();
                this.setBudgetFolioDetailsForAE(sdf, budgetFolioDetail, ae);
            }
            budgetFolioDetail.setBudgetApprNo(budgetUsage.getAppropriationnumber());
            budgetFolioDetail.setCumulativeTotal(cumulativeTotal);
            BigDecimal balanceAvailable = totalGrantPerc.subtract(this.getCumulativeTotal(cumulativeTotal));
            budgetFolioDetail.setBalanceAvailable(balanceAvailable);
            budgetFolioDetail.setAppDate(sdf.format(this.getBudgetUsageUpdatedTime(budgetUsage)));
            budgetFolioDetail.setAppType(this.getApporpriationType());
            budgetFolioResultList.add(budgetFolioDetail);
            if (budgetUsage.getReleasedAmount() > 0.0) {
                cumulativeTotal = cumulativeTotal - budgetUsage.getReleasedAmount();
                budgetFolioDetail.setAppropriatedValue(0.0 - budgetUsage.getReleasedAmount());
                continue;
            }
            cumulativeTotal = cumulativeTotal + budgetUsage.getConsumedAmount();
            budgetFolioDetail.setAppropriatedValue(budgetUsage.getConsumedAmount());
        }
        ArrayList<Number> calculatedValuesList = new ArrayList<Number>();
        calculatedValuesList.add(cumulativeTotal);
        calculatedValuesList.add(totalGrantPerc.subtract(this.getCumulativeTotal(cumulativeTotal)));
        budgetFolioMap.put("budgetFolioList", budgetFolioResultList);
        budgetFolioMap.put("calculatedValues", calculatedValuesList);
        return budgetFolioMap;
    }

    private void setBudgetFolioDetailsForAE(SimpleDateFormat sdf, BudgetFolioDetail budgetFolioDetail, AbstractEstimate ae) {
        if (StringUtils.isNotBlank((String)ae.getEstimateNumber())) {
            budgetFolioDetail.setEstimateNo(ae.getEstimateNumber());
        } else {
            budgetFolioDetail.setEstimateNo("");
        }
        if (ae.getParent() == null) {
            budgetFolioDetail.setNameOfWork(ae.getName());
        } else if (ae.getParent() != null) {
            budgetFolioDetail.setNameOfWork(ae.getParent().getName());
        } else {
            budgetFolioDetail.setNameOfWork("");
        }
        if (StringUtils.isNotBlank((String)ae.getEstimateValue().toString())) {
            budgetFolioDetail.setWorkValue(ae.getEstimateValue().doubleValue());
        } else {
            budgetFolioDetail.setWorkValue(Double.valueOf(""));
        }
        if (StringUtils.isNotBlank((String)ae.getEstimateDate().toString())) {
            budgetFolioDetail.setEstimateDate(sdf.format(ae.getEstimateDate()));
        } else {
            budgetFolioDetail.setEstimateDate("");
        }
        if (ae.getProjectCode() != null) {
            budgetFolioDetail.setWorkIdentificationNumber(ae.getProjectCode().getCode());
        } else if (ae.getParent() != null) {
            budgetFolioDetail.setWorkIdentificationNumber(ae.getParent().getProjectCode().getCode());
        } else {
            budgetFolioDetail.setWorkIdentificationNumber("");
        }
    }

    private void setBudgetFolioDetailsForLE(SimpleDateFormat sdf, BudgetFolioDetail budgetFolioDetail, LineEstimateDetails led) {
        if (StringUtils.isNotBlank((String)led.getEstimateNumber())) {
            budgetFolioDetail.setEstimateNo(led.getEstimateNumber());
        } else {
            budgetFolioDetail.setEstimateNo("");
        }
        if (StringUtils.isNotBlank((String)led.getNameOfWork())) {
            budgetFolioDetail.setNameOfWork(led.getNameOfWork());
        } else {
            budgetFolioDetail.setNameOfWork("");
        }
        if (StringUtils.isNotBlank((String)led.getEstimateAmount().toString())) {
            budgetFolioDetail.setWorkValue(led.getEstimateAmount().doubleValue());
        } else {
            budgetFolioDetail.setWorkValue(Double.valueOf(""));
        }
        if (StringUtils.isNotBlank((String)led.getLineEstimate().getLineEstimateDate().toString())) {
            budgetFolioDetail.setEstimateDate(sdf.format(led.getLineEstimate().getLineEstimateDate()));
        } else {
            budgetFolioDetail.setEstimateDate("");
        }
        if (led.getProjectCode() != null) {
            budgetFolioDetail.setWorkIdentificationNumber(led.getProjectCode().getCode());
        } else {
            budgetFolioDetail.setWorkIdentificationNumber("");
        }
    }

    private BudgetFolioDetail getBudgetFolioDetail() {
        return new BudgetFolioDetail();
    }

    public String getApporpriationType() {
        return REGULAR;
    }

    private Date getBudgetUsageUpdatedTime(BudgetUsage budgetUsage) {
        return new Date(budgetUsage.getUpdatedTime().getTime());
    }

    private BigDecimal getCumulativeTotal(Double cumulativeTotal) {
        return new BigDecimal(cumulativeTotal.toString());
    }
}

