/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.milestone.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.entity.TrackMilestoneActivity;
import org.egov.works.milestone.repository.MilestoneRepository;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.utils.WorksUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MilestoneService {
    @Autowired
    private MilestoneRepository milestoneRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private WorksUtils worksUtils;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<Milestone> getMilestoneByWorkOrderEstimateId(Long id) {
        return this.milestoneRepository.findByWorkOrderEstimate_Id(id);
    }

    public List<Milestone> searchMilestone(SearchRequestMilestone searchRequestMilestone) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Milestone.class).createAlias("workOrderEstimate", "woe").createAlias("woe.estimate", "estimate").createAlias("status", "status").createAlias("woe.workOrder", "wo").createAlias("estimate.projectCode", "projectCode").createAlias("trackMilestone", "tm", JoinType.LEFT_OUTER_JOIN).createAlias("tm.status", "trackStatus", JoinType.LEFT_OUTER_JOIN);
        if (searchRequestMilestone != null) {
            if (searchRequestMilestone.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.executingDepartment.id", (Object)searchRequestMilestone.getDepartment()));
            }
            if (searchRequestMilestone.getMilestoneFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"createdDate", (Object)searchRequestMilestone.getMilestoneFromDate()));
            }
            if (searchRequestMilestone.getMilestoneToDate() != null) {
                DateTime dateTime = new DateTime(searchRequestMilestone.getMilestoneToDate().getTime()).plusDays(1);
                criteria.add((Criterion)Restrictions.le((String)"createdDate", (Object)dateTime.toDate()));
            }
            if (searchRequestMilestone.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestMilestone.getStatus()));
            }
            if (searchRequestMilestone.getSubTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.category.id", (Object)searchRequestMilestone.getSubTypeOfWork()));
            }
            if (searchRequestMilestone.getTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.parentCategory.id", (Object)searchRequestMilestone.getTypeOfWork()));
            }
            if (searchRequestMilestone.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"projectCode.code", (Object)searchRequestMilestone.getWorkIdentificationNumber()).ignoreCase());
            }
            if (searchRequestMilestone.getWorkOrderNumber() != null) {
                criteria.add(Restrictions.ilike((String)"wo.workOrderNumber", (String)searchRequestMilestone.getWorkOrderNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"trackMilestone"), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"tm.projectCompleted", (Object)false), (Criterion)Restrictions.eq((String)"trackStatus.code", (Object)"CANCELLED"))));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<Milestone> searchMilestoneForView(SearchRequestMilestone searchRequestMilestone) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Milestone.class).createAlias("workOrderEstimate", "woe").createAlias("woe.estimate", "estimate").createAlias("status", "status").createAlias("woe.workOrder", "wo").createAlias("estimate.projectCode", "projectCode");
        if (searchRequestMilestone != null) {
            if (searchRequestMilestone.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.executingDepartment.id", (Object)searchRequestMilestone.getDepartment()));
            }
            if (searchRequestMilestone.getMilestoneFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"createdDate", (Object)searchRequestMilestone.getMilestoneFromDate()));
            }
            if (searchRequestMilestone.getMilestoneToDate() != null) {
                DateTime dateTime = new DateTime(searchRequestMilestone.getMilestoneToDate().getTime()).plusDays(1);
                criteria.add((Criterion)Restrictions.le((String)"createdDate", (Object)dateTime.toDate()));
            }
            if (searchRequestMilestone.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestMilestone.getStatus()));
            }
            if (searchRequestMilestone.getSubTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.category.id", (Object)searchRequestMilestone.getSubTypeOfWork()));
            }
            if (searchRequestMilestone.getTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.parentCategory.id", (Object)searchRequestMilestone.getTypeOfWork()));
            }
            if (searchRequestMilestone.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"projectCode.code", (Object)searchRequestMilestone.getWorkIdentificationNumber()).ignoreCase());
            }
            if (searchRequestMilestone.getWorkOrderNumber() != null) {
                criteria.add(Restrictions.ilike((String)"wo.workOrderNumber", (String)searchRequestMilestone.getWorkOrderNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public Milestone getMilestoneById(Long id) {
        return (Milestone)this.milestoneRepository.findOne(id);
    }

    @Transactional
    public Milestone save(Milestone milestone) {
        Milestone newMilestone = (Milestone)this.milestoneRepository.save(milestone);
        return newMilestone;
    }

    @Transactional
    public Milestone create(Milestone milestone) throws IOException {
        if (milestone.getState() == null) {
            milestone.setStatus(this.worksUtils.getStatusByModuleAndCode("Milestone", Milestone.MilestoneStatus.APPROVED.toString()));
        }
        for (MilestoneActivity activity : milestone.getActivities()) {
            activity.setMilestone(milestone);
        }
        Milestone newMilestone = (Milestone)this.milestoneRepository.save(milestone);
        return newMilestone;
    }

    @Transactional
    public Milestone update(Milestone milestone) {
        for (TrackMilestone tm : milestone.getTrackMilestone()) {
            tm.setMilestone(milestone);
            tm.setStatus(this.worksUtils.getStatusByModuleAndCode("TrackMilestone", Milestone.MilestoneStatus.APPROVED.toString()));
            if (tm.getApprovedDate() == null) {
                tm.setApprovedDate(new Date());
            }
            Integer count = 0;
            double totalPercentage = 0.0;
            for (TrackMilestoneActivity tma : tm.getActivities()) {
                tma.setMilestoneActivity(milestone.getActivities().get(count));
                tma.setTrackMilestone(tm);
                totalPercentage += milestone.getActivities().get(count).getPercentage() / 100.0 * tma.getCompletedPercentage();
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            tm.setTotalPercentage(BigDecimal.valueOf(totalPercentage));
            if (totalPercentage == 100.0) {
                tm.setProjectCompleted(true);
            } else {
                tm.setProjectCompleted(false);
            }
            this.trackMilestoneService.save(tm);
        }
        return (Milestone)this.milestoneRepository.save(milestone);
    }

    public List<String> findLoaNumbersToCancelMilestone(String code) {
        List<String> loaNumbers = this.milestoneRepository.findLoaNumbersToCancelMilestone("%" + code + "%", "APPROVED".toString());
        return loaNumbers;
    }

    @Transactional
    public Milestone cancel(Milestone milestone) {
        milestone.setStatus(this.worksUtils.getStatusByModuleAndCode("Milestone", "CANCELLED"));
        for (TrackMilestone tm : milestone.getTrackMilestone()) {
            tm.setStatus(this.worksUtils.getStatusByModuleAndCode("TrackMilestone", "CANCELLED"));
        }
        return (Milestone)this.milestoneRepository.save(milestone);
    }

    public List<Milestone> searchMilestonesToCancel(SearchRequestMilestone searchRequestMilestone) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Milestone.class).createAlias("workOrderEstimate", "woe").createAlias("woe.estimate", "estimate").createAlias("status", "status").createAlias("woe.workOrder", "wo").createAlias("wo.contractor", "contractor").createAlias("estimate.projectCode", "projectCode");
        if (searchRequestMilestone != null) {
            if (searchRequestMilestone.getWorkIdentificationNumber() != null) {
                criteria.add(Restrictions.ilike((String)"projectCode.code", (String)searchRequestMilestone.getWorkIdentificationNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestMilestone.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestMilestone.getStatus()));
            }
            if (searchRequestMilestone.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"wo.workOrderNumber", (Object)searchRequestMilestone.getWorkOrderNumber()));
            }
            if (searchRequestMilestone.getContractor() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"contractor.name", (Object)searchRequestMilestone.getContractor()).ignoreCase());
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findContractorsToCancelMilestone(String code) {
        List<String> loaNumbers = this.milestoneRepository.findContractorsToSearchMilestoneToCancel("%" + code + "%", "APPROVED".toString());
        return loaNumbers;
    }

    public boolean checkMilestoneCreated(Long workOrderId) {
        Long milestoneId = this.milestoneRepository.findWorkOrderToCreateMilestone(workOrderId, "CANCELLED", "CANCELLED");
        boolean flag = false;
        if (milestoneId != null) {
            flag = true;
        }
        return flag;
    }
}

