/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.entity.MBMeasurementSheet;
import org.egov.works.mb.entity.SearchRequestCancelMB;
import org.egov.works.mb.entity.SearchRequestMBHeader;
import org.egov.works.mb.repository.MBHeaderRepository;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.history.Revisions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class MBHeaderService {
    private static final Logger LOG = LoggerFactory.getLogger(MBHeaderService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final MBHeaderRepository mbHeaderRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<MBHeader> mbHeaderWorkflowService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private ScriptService scriptService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public MBHeaderService(MBHeaderRepository mbHeaderRepository) {
        this.mbHeaderRepository = mbHeaderRepository;
    }

    public MBHeader getMBHeaderById(Long id) {
        return (MBHeader)((Object)this.mbHeaderRepository.findOne(id));
    }

    public List<MBHeader> getApprovedMBsForContractorBillByWorkOrderEstimateId(Long workOrderEstimateId) {
        return this.mbHeaderRepository.findByWorkOrderEstimateId(workOrderEstimateId, MBHeader.MeasurementBookStatus.APPROVED.toString(), ContractorBillRegister.BillStatus.CANCELLED.toString());
    }

    public List<MBHeader> getMBHeadersByWorkOrder(WorkOrder workOrder) {
        return this.mbHeaderRepository.findByWorkOrder(workOrder);
    }

    public List<MBHeader> getMBHeadersByWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        return this.mbHeaderRepository.findByWorkOrderEstimate(workOrderEstimate);
    }

    public List<MBHeader> getApprovedMBHeadersByWorkOrder(WorkOrder workOrder) {
        return this.mbHeaderRepository.findByWorkOrderAndEgwStatus_codeEqualsOrderById(workOrder, MBHeader.MeasurementBookStatus.APPROVED.toString());
    }

    public List<MBHeader> getApprovedMBHeadersByContractorBill(ContractorBillRegister contractorBillRegister) {
        return this.mbHeaderRepository.findByEgBillregisterAndEgwStatus_codeEquals(contractorBillRegister, MBHeader.MeasurementBookStatus.APPROVED.toString());
    }

    public List<MBHeader> getMBHeadersByContractorBill(ContractorBillRegister contractorBillRegister) {
        return this.mbHeaderRepository.findByEgBillregister(contractorBillRegister);
    }

    public List<MBHeader> getMBHeadersByWorkOrderEstimateIdAndNotEgwStatusCode(Long workOrderEstimateId, String statusCode) {
        return this.mbHeaderRepository.findByWorkOrderEstimate_IdAndEgwStatus_codeNotOrderById(workOrderEstimateId, statusCode);
    }

    public Revisions<Integer, MBHeader> findRevisions(Long id) {
        return this.mbHeaderRepository.findRevisions(id);
    }

    @Transactional
    public MBHeader save(MBHeader mbHeader) {
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        return savedMBHeader;
    }

    @Transactional
    public MBHeader create(MBHeader mbHeader, MultipartFile[] files, Long approvalPosition, String approvalComent, String workFlowAction, String additionalRule) throws IOException {
        List<DocumentDetails> documentDetails;
        if (mbHeader.getState() == null) {
            if (workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CREATED.toString()));
            } else if (StringUtils.isBlank((CharSequence)workFlowAction) || "Create And Approve".equalsIgnoreCase(workFlowAction)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.APPROVED.toString()));
            } else {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.NEW.toString()));
            }
        }
        this.mergeSorAndNonSorMBDetails(mbHeader);
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        if (StringUtils.isNotBlank((CharSequence)workFlowAction)) {
            this.createMBHeaderWorkflowTransition(savedMBHeader, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        if ("Create And Approve".equalsIgnoreCase(workFlowAction)) {
            savedMBHeader.setApprovedDate(new Date());
        }
        if (!(documentDetails = this.worksUtils.getDocumentDetails(files, (Object)(savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)savedMBHeader))), "MBHeader")).isEmpty()) {
            savedMBHeader.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedMBHeader;
    }

    @Transactional
    public MBHeader update(MBHeader mbHeader, Long approvalPosition, String approvalComent, String workFlowAction, String removedDetailIds, MultipartFile[] files) throws IOException {
        Boolean isMBEditable = false;
        String addtionalRule = (String)this.cityService.cityDataAsMap().get("cityGrade");
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SECOND_LEVEL_EDIT_MB");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            isMBEditable = true;
        }
        if ((mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString()) || mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.REJECTED.toString()) || isMBEditable.booleanValue()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION) && !workFlowAction.equals("Cancel")) {
            List<MBDetails> mbDetails = new ArrayList<MBDetails>(mbHeader.getMbDetails());
            mbDetails = this.removeDeletedMBDetails(mbDetails, removedDetailIds);
            mbHeader.setMbDetails(mbDetails);
            this.mergeSorAndNonSorMBDetails(mbHeader);
            for (DocumentDetails docs : mbHeader.getDocumentDetails()) {
                this.worksUtils.deleteDocuments(docs.getId());
            }
            List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)mbHeader, "MBHeader");
            if (!documentDetails.isEmpty()) {
                mbHeader.setDocumentDetails(documentDetails);
                this.worksUtils.persistDocuments(documentDetails);
            }
        }
        MBHeader updatedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        this.mbHeaderStatusChange(updatedMBHeader, workFlowAction);
        if (updatedMBHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.APPROVED.toString())) {
            updatedMBHeader.setApprovedDate(new Date());
        }
        this.createMBHeaderWorkflowTransition(updatedMBHeader, approvalPosition, approvalComent, addtionalRule, workFlowAction);
        updatedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)updatedMBHeader));
        return updatedMBHeader;
    }

    private void removeEmptyMBMS(MBDetails mbDetails) {
        LinkedList<MBMeasurementSheet> toRemove = new LinkedList<MBMeasurementSheet>();
        for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
            if (mbms.getQuantity() != null && (mbms.getQuantity() == null || !mbms.getQuantity().equals(""))) continue;
            toRemove.add(mbms);
        }
        for (MBMeasurementSheet msremove : toRemove) {
            mbDetails.getMeasurementSheets().remove((Object)msremove);
        }
    }

    private List<MBDetails> removeDeletedMBDetails(List<MBDetails> mbDetails, String removedDetailIds) {
        ArrayList<MBDetails> mbDetailsList = new ArrayList<MBDetails>();
        if (null != removedDetailIds) {
            String[] ids = removedDetailIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (MBDetails details : mbDetails) {
                if (details.getId() != null) {
                    if (strList.contains(details.getId().toString())) continue;
                    mbDetailsList.add(details);
                    continue;
                }
                mbDetailsList.add(details);
            }
        } else {
            return mbDetails;
        }
        return mbDetailsList;
    }

    private void mergeSorAndNonSorMBDetails(MBHeader mbHeader) {
        for (MBDetails mbDetails : mbHeader.getSorMbDetails()) {
            if (mbDetails.getId() == null) {
                this.removeEmptyMBMS(mbDetails);
                mbDetails.setMbHeader(mbHeader);
                mbDetails.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(mbDetails.getWorkOrderActivity().getId()));
                for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
                    mbms.setMbDetails(mbDetails);
                }
                mbHeader.addMbDetails(mbDetails);
                continue;
            }
            for (MBDetails oldMBDetails : mbHeader.getSORMBDetails()) {
                if (!oldMBDetails.getId().equals(mbDetails.getId())) continue;
                this.updateMBDetails(oldMBDetails, mbDetails);
            }
        }
        for (MBDetails mbDetails : mbHeader.getNonSorMbDetails()) {
            if (mbDetails.getId() == null) {
                this.removeEmptyMBMS(mbDetails);
                mbDetails.setMbHeader(mbHeader);
                mbDetails.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(mbDetails.getWorkOrderActivity().getId()));
                for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
                    mbms.setMbDetails(mbDetails);
                }
                mbHeader.addMbDetails(mbDetails);
                continue;
            }
            for (MBDetails oldMBDetails : mbHeader.getNonSORMBDetails()) {
                if (!oldMBDetails.getId().equals(mbDetails.getId())) continue;
                this.updateMBDetails(oldMBDetails, mbDetails);
            }
        }
        for (MBDetails mbDetails : mbHeader.getNonTenderedMbDetails()) {
            if (mbDetails.getId() == null) {
                this.removeEmptyMBMS(mbDetails);
                mbDetails.setMbHeader(mbHeader);
                mbDetails.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(mbDetails.getWorkOrderActivity().getId()));
                for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
                    mbms.setMbDetails(mbDetails);
                }
                mbHeader.addMbDetails(mbDetails);
                continue;
            }
            for (MBDetails oldMBDetails : mbHeader.getNonTenderedMBDetails()) {
                if (!oldMBDetails.getId().equals(mbDetails.getId())) continue;
                this.updateMBDetails(oldMBDetails, mbDetails);
            }
        }
        for (MBDetails mbDetails : mbHeader.getLumpSumMbDetails()) {
            if (mbDetails.getId() == null) {
                this.removeEmptyMBMS(mbDetails);
                mbDetails.setMbHeader(mbHeader);
                mbDetails.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(mbDetails.getWorkOrderActivity().getId()));
                for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
                    mbms.setMbDetails(mbDetails);
                }
                mbHeader.addMbDetails(mbDetails);
                continue;
            }
            for (MBDetails oldMBDetails : mbHeader.getLumpSumMBDetails()) {
                if (!oldMBDetails.getId().equals(mbDetails.getId())) continue;
                this.updateMBDetails(oldMBDetails, mbDetails);
            }
        }
    }

    private void updateMBDetails(MBDetails oldMBDetails, MBDetails mbDetails) {
        oldMBDetails.setQuantity(mbDetails.getQuantity());
        oldMBDetails.setRate(mbDetails.getRate());
        oldMBDetails.setRemarks(mbDetails.getRemarks());
        oldMBDetails.setAmount(mbDetails.getAmount());
        oldMBDetails.setMeasurementSheets(this.mergeMBMeasurementSheet(oldMBDetails, mbDetails));
    }

    private List<MBMeasurementSheet> mergeMBMeasurementSheet(MBDetails oldMBDetails, MBDetails mbDetails) {
        for (MBMeasurementSheet msnew : mbDetails.getMeasurementSheets()) {
            if (msnew.getId() == null && msnew.getQuantity() != null) {
                msnew.setMbDetails(oldMBDetails);
                oldMBDetails.getMeasurementSheets().add(msnew);
                continue;
            }
            for (MBMeasurementSheet msold : oldMBDetails.getMeasurementSheets()) {
                if (msold.getId() == null || msnew.getId() != msold.getId()) continue;
                msold.setLength(msnew.getLength());
                msold.setWidth(msnew.getWidth());
                msold.setDepthOrHeight(msnew.getDepthOrHeight());
                msold.setNo(msnew.getNo());
                msold.setRemarks(msnew.getRemarks());
                msold.setQuantity(msnew.getQuantity());
            }
        }
        this.removeEmptyMBMS(oldMBDetails);
        return oldMBDetails.getMeasurementSheets();
    }

    public void mbHeaderStatusChange(MBHeader mbHeader, String workFlowAction) {
        if (null != mbHeader && null != mbHeader.getEgwStatus() && null != mbHeader.getEgwStatus().getCode()) {
            if (workFlowAction.equals("Save")) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.NEW.toString()));
            } else if (workFlowAction.equals("Cancel") && mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CANCELLED.toString()));
            } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString()) && !"Create And Approve".equalsIgnoreCase(workFlowAction)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CREATED.toString()));
            } else if (workFlowAction.equals("Approve") || "Create And Approve".equalsIgnoreCase(workFlowAction)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.APPROVED.toString()));
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.REJECTED.toString()));
            } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.REJECTED.toString()) && workFlowAction.equals("Cancel")) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CANCELLED.toString()));
            } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.RESUBMITTED.toString()));
            } else if (("RESUBMITTED".equalsIgnoreCase(mbHeader.getEgwStatus().getCode()) || "CREATED".equalsIgnoreCase(mbHeader.getEgwStatus().getCode()) || "CHECKED".equalsIgnoreCase(mbHeader.getEgwStatus().getCode())) && mbHeader.getState() != null && "Submit".equalsIgnoreCase(workFlowAction)) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", "CHECKED"));
            }
        }
    }

    @Transactional
    public MBHeader cancel(MBHeader mbHeader) {
        mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CANCELLED.toString()));
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        return savedMBHeader;
    }

    public List<User> getMBHeaderCreatedByUsers() {
        return this.mbHeaderRepository.findMBHeaderCreatedByUsers();
    }

    public List<MBHeader> searchMBHeader(SearchRequestMBHeader searchRequestMBHeader) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(MBHeader.class, "mbh").createAlias("workOrderEstimate", "woe").createAlias("workOrderEstimate.workOrder", "wo").createAlias("workOrderEstimate.estimate", "e").createAlias("workOrderEstimate.estimate.executingDepartment", "department").createAlias("workOrderEstimate.workOrder.contractor", "woc").createAlias("mbh.egwStatus", "status");
        if (searchRequestMBHeader != null) {
            if (searchRequestMBHeader.getMbReferenceNumber() != null) {
                criteria.add(Restrictions.ilike((String)"mbh.mbRefNo", (Object)("%" + searchRequestMBHeader.getMbReferenceNumber() + "%")));
            }
            if (searchRequestMBHeader.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"wo.workOrderNumber", (Object)searchRequestMBHeader.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestMBHeader.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"mbh.mbDate", (Object)searchRequestMBHeader.getFromDate()));
            }
            if (searchRequestMBHeader.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"mbh.mbDate", (Object)searchRequestMBHeader.getToDate()));
            }
            if (searchRequestMBHeader.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"e.estimateNumber", (Object)searchRequestMBHeader.getEstimateNumber()).ignoreCase());
            }
            if (StringUtils.isNotBlank((CharSequence)searchRequestMBHeader.getContractorName())) {
                criteria.add((Criterion)Restrictions.ge((String)"woc.name", (Object)searchRequestMBHeader.getContractorName()));
            }
            if (searchRequestMBHeader.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)searchRequestMBHeader.getDepartment()));
            }
            if (searchRequestMBHeader.getMbStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.id", (Object)Integer.valueOf(searchRequestMBHeader.getMbStatus().toString())));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)"status.code", (Object)"NEW"));
            }
            if (searchRequestMBHeader.getCreatedBy() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"mbh.createdBy.id", (Object)searchRequestMBHeader.getCreatedBy()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<EgwStatus> getMBHeaderStatus() {
        List statusList = this.egwStatusHibernateDAO.getStatusByModule("MBHeader");
        ArrayList<EgwStatus> latestStatusList = new ArrayList<EgwStatus>();
        if (!statusList.isEmpty()) {
            for (EgwStatus egwStatus : statusList) {
                if (egwStatus.getCode().equals("NEW")) continue;
                latestStatusList.add(egwStatus);
            }
        }
        return latestStatusList;
    }

    public void validateMBInDrafts(Long workOrderEstimateId, JsonObject jsonObject, BindingResult errors) {
        MBHeader mbHeader = this.mbHeaderRepository.findByWorkOrderEstimate_IdAndEgwStatus_codeEquals(workOrderEstimateId, "NEW");
        String userName = "";
        if (mbHeader != null) {
            userName = this.worksUtils.getApproverName(mbHeader.getState().getOwnerPosition().getId());
            String message = this.messageSource.getMessage("error.mbheader.newstatus", (Object[])new String[]{mbHeader.getMbRefNo(), mbHeader.getEgwStatus().getDescription(), userName}, null);
            jsonObject.addProperty("draftsError", message);
            if (errors != null) {
                errors.reject("draftsError", message);
            }
        }
    }

    public void validateMBInWorkFlow(Long workOrderEstimateId, JsonObject jsonObject, BindingResult errors) {
        MBHeader mBHeader = this.mbHeaderRepository.findByWorkOrderEstimateAndStatus(workOrderEstimateId, MBHeader.MeasurementBookStatus.CANCELLED.toString(), MBHeader.MeasurementBookStatus.APPROVED.toString(), MBHeader.MeasurementBookStatus.NEW.toString());
        String userName = "";
        if (mBHeader != null) {
            userName = this.worksUtils.getApproverName(mBHeader.getState().getOwnerPosition().getId());
            String message = this.messageSource.getMessage("error.mbheader.workflow", (Object[])new String[]{mBHeader.getMbRefNo(), mBHeader.getEgwStatus().getDescription(), userName}, null);
            jsonObject.addProperty("workFlowError", message);
            if (errors != null) {
                errors.reject("workFlowError", message);
            }
        }
    }

    public Long getApprovalPositionByMatrixDesignation(MBHeader mbHeader, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.mbHeaderWorkflowService.getWfMatrix(mbHeader.getStateType(), null, null, additionalRule, mbHeader.getCurrentState().getValue(), null);
        if (mbHeader.getEgwStatus() != null && mbHeader.getEgwStatus().getCode() != null && (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.CREATED.toString()) || mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.RESUBMITTED.toString())) && !"Approve".toString().equalsIgnoreCase(workFlowAction) && mbHeader.getState() != null) {
            approvalPosition = mode.equals("edit") ? mbHeader.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), mbHeader.getState(), mbHeader.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    public Double getPreviousCumulativeQuantity(Long mbHeaderId, Long woActivityId) {
        return this.mbHeaderRepository.getPreviousCumulativeQuantity(mbHeaderId, MBHeader.MeasurementBookStatus.CANCELLED.toString(), woActivityId);
    }

    public void createMBHeaderWorkflowTransition(MBHeader mbHeader, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Measurement Book";
        WorkFlowMatrix wfmatrix = null;
        if (null != mbHeader.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(mbHeader.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                mbHeader.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Measurement Book");
            } else {
                mbHeader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Measurement Book");
            }
        } else if ("Save".toString().equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.mbHeaderWorkflowService.getWfMatrix(mbHeader.getStateType(), null, mbHeader.getMbAmount(), additionalRule, "NEW", null);
            if (mbHeader.getState() == null) {
                mbHeader.transition(true).start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("NEW").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Pending Submission").withNatureOfTask("Measurement Book");
            }
        } else {
            if (!(null == approvalPosition || approvalPosition == -1L || approvalPosition.equals(0L) || "Cancel".toString().equalsIgnoreCase(workFlowAction) || "Approve".toString().equalsIgnoreCase(workFlowAction) || "Create And Approve".equalsIgnoreCase(workFlowAction))) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == mbHeader.getState()) {
                wfmatrix = this.mbHeaderWorkflowService.getWfMatrix(mbHeader.getStateType(), null, mbHeader.getMbAmount(), additionalRule, "", null);
                mbHeader.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Measurement Book");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                mbHeader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Measurement Book");
            } else {
                wfmatrix = this.mbHeaderWorkflowService.getWfMatrix(mbHeader.getStateType(), null, mbHeader.getMbAmount(), additionalRule, mbHeader.getCurrentState().getValue(), mbHeader.getState().getNextAction());
                mbHeader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Measurement Book");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public void fillWorkflowData(JsonObject jsonObject, HttpServletRequest request, MBHeader mbHeader) {
        jsonObject.addProperty("stateType", ((Object)((Object)mbHeader)).getClass().getSimpleName());
        if (mbHeader.getCurrentState() != null && !mbHeader.getCurrentState().getValue().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
            jsonObject.addProperty("currentState", mbHeader.getCurrentState().getValue());
        }
        if (mbHeader.getState() != null && mbHeader.getState().getNextAction() != null) {
            jsonObject.addProperty("nextAction", mbHeader.getState().getNextAction());
            jsonObject.addProperty("pendingActions", mbHeader.getState().getNextAction());
        }
        jsonObject.addProperty("additionalRule", request.getParameter("additionalRule"));
        jsonObject.addProperty("id", (Number)mbHeader.getId());
        if (!mbHeader.getMbDetails().isEmpty()) {
            JsonArray detailIds = new JsonArray();
            JsonObject mbDetail = new JsonObject();
            for (MBDetails mbDetails : mbHeader.getMbDetails()) {
                mbDetail.addProperty("id", (Number)mbDetails.getId());
                if (mbDetails.getWorkOrderActivity().getActivity().getSchedule() != null) {
                    mbDetail.addProperty("sorType", "SOR");
                } else {
                    mbDetail.addProperty("sorType", "Non SOR");
                }
                if (!mbDetails.getMeasurementSheets().isEmpty()) {
                    JsonArray msIds = new JsonArray();
                    for (MBMeasurementSheet mbms : mbDetails.getMeasurementSheets()) {
                        JsonObject msId = new JsonObject();
                        msId.addProperty("id", (Number)mbms.getId());
                        msIds.add((JsonElement)msId);
                    }
                    mbDetail.add("msIds", (JsonElement)msIds);
                } else {
                    mbDetail.add("msIds", (JsonElement)new JsonArray());
                }
                detailIds.add((JsonElement)mbDetail);
            }
            jsonObject.add("detailIds", (JsonElement)detailIds);
        } else {
            jsonObject.add("detailIds", (JsonElement)new JsonObject());
        }
    }

    public void validateMBHeader(MBHeader mbHeader, JsonObject jsonObject, BindingResult errors, String mode) {
        OfflineStatus offlineStatus;
        List<MBHeader> previousMBHeaders;
        Double totalMBAmountOfMBs = this.getTotalMBAmountOfMBs(mbHeader.getId() == null ? -1L : mbHeader.getId(), mbHeader.getWorkOrderEstimate().getId(), MBHeader.MeasurementBookStatus.CANCELLED.toString());
        String message = "";
        DecimalFormat df = new DecimalFormat("#.##");
        Double totalMBAmount = null;
        totalMBAmount = totalMBAmountOfMBs != null ? Double.valueOf(totalMBAmountOfMBs + mbHeader.getMbAmount().doubleValue()) : Double.valueOf(mbHeader.getMbAmount().doubleValue());
        if (mbHeader.getMbDate() != null && mbHeader.getMbDate().after(new Date())) {
            message = this.messageSource.getMessage("error.mb.entry.future.date", (Object[])new String[0], null);
            jsonObject.addProperty("errorMBEntryFutureDate", message);
            errors.reject("errorMBEntryFutureDate", message);
        }
        if (!(previousMBHeaders = this.getPreviousMBHeaders(mbHeader.getId(), mbHeader.getWorkOrderEstimate().getId())).isEmpty() && previousMBHeaders.get(previousMBHeaders.size() - 1).getMbDate().after(mbHeader.getMbDate())) {
            message = this.messageSource.getMessage("error.previous.mb.date", (Object[])new String[0], null);
            jsonObject.addProperty("errorPreviousMBDate", message);
            errors.reject("errorPreviousMBDate", message);
        }
        if (mbHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount() < totalMBAmount) {
            message = this.messageSource.getMessage("error.sum.mb.workorder.amount", (Object[])new String[]{df.format(totalMBAmount), df.format(totalMBAmount - mbHeader.getWorkOrder().getWorkOrderAmount())}, null);
            jsonObject.addProperty("errorSumOfMBWorkOrderAmount", message);
            errors.reject("errorSumOfMBWorkOrderAmount", message);
        }
        if ((offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(mbHeader.getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase())) != null) {
            if (offlineStatus.getStatusDate().after(mbHeader.getMbDate())) {
                message = this.messageSource.getMessage("error.mb.entry.date.commenced.date", (Object[])new String[]{mbHeader.getMbDate().toString(), offlineStatus.getStatusDate().toString()}, null);
                jsonObject.addProperty("errorEntryCommencedDate", message);
                errors.reject("errorEntryCommencedDate", message);
            }
            if (mbHeader.getMbIssuedDate() != null && offlineStatus.getStatusDate().after(mbHeader.getMbIssuedDate()) && offlineStatus.getStatusDate().after(mbHeader.getMbDate())) {
                message = this.messageSource.getMessage("error.mb.issued.date.commenced.date", (Object[])new String[0], null);
                jsonObject.addProperty("errorIssuedCommencedDate", message);
                errors.reject("errorIssuedCommencedDate", message);
            }
        }
        if (mbHeader.getMbIssuedDate() != null && mbHeader.getMbIssuedDate().after(mbHeader.getMbDate())) {
            message = this.messageSource.getMessage("error.mb.issued.date.entry.date", (Object[])new String[0], null);
            jsonObject.addProperty("errorEntryIssuedDate", message);
            errors.reject("errorEntryIssuedDate", message);
        }
        if (mbHeader.getFromPageNo() > mbHeader.getToPageNo()) {
            message = this.messageSource.getMessage("error.from.to.page", (Object[])new String[0], null);
            jsonObject.addProperty("errorFromToPageNumber", message);
            errors.reject("errorFromToPageNumber", message);
        }
        if (!mode.equalsIgnoreCase("workflowView")) {
            this.validateMBDetails(mbHeader, jsonObject, errors);
        }
    }

    public void validateMBDetails(MBHeader mbHeader, JsonObject jsonObject, BindingResult errors) {
        String message = "";
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "MB_QUANTITY_TOLERANCE_LEVEL");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (mbHeader.getSorMbDetails().isEmpty() && mbHeader.getNonSorMbDetails().isEmpty() && mbHeader.getNonTenderedMbDetails().isEmpty() && mbHeader.getLumpSumMbDetails().isEmpty()) {
            message = this.messageSource.getMessage("error.mb.sor.nonsor.required", (Object[])new String[0], null);
            jsonObject.addProperty("errorSorNonSorMandatory", message);
            errors.reject("errorSorNonSorMandatory", message);
        }
        for (MBDetails details : mbHeader.getSorMbDetails()) {
            details.setMbHeader(mbHeader);
            this.validateMBDetail(details, jsonObject, errors, Double.parseDouble(value.getValue()));
        }
        for (MBDetails details : mbHeader.getNonSorMbDetails()) {
            details.setMbHeader(mbHeader);
            this.validateMBDetail(details, jsonObject, errors, Double.parseDouble(value.getValue()));
        }
        for (MBDetails details : mbHeader.getNonTenderedMbDetails()) {
            details.setMbHeader(mbHeader);
            this.validateMBDetail(details, jsonObject, errors, Double.parseDouble(value.getValue()));
        }
        for (MBDetails details : mbHeader.getLumpSumMbDetails()) {
            details.setMbHeader(mbHeader);
            this.validateMBDetail(details, jsonObject, errors, Double.parseDouble(value.getValue()));
        }
    }

    private void validateMBDetail(MBDetails details, JsonObject jsonObject, BindingResult errors, Double toleranceLimit) {
        details.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(details.getWorkOrderActivity().getId()));
        String message = this.messageSource.getMessage("error.approved.quantity.cumulative", (Object[])new String[]{Double.toString(toleranceLimit)}, null);
        Double toleranceQuantity = details.getWorkOrderActivity().getApprovedQuantity() * (toleranceLimit / 100.0);
        Double prevCumulativeQuantity = this.getPreviousCumulativeQuantity(details.getMbHeader().getId(), details.getWorkOrderActivity().getId());
        if (prevCumulativeQuantity == null) {
            prevCumulativeQuantity = 0.0;
        }
        if (toleranceQuantity < details.getQuantity() + prevCumulativeQuantity) {
            jsonObject.addProperty("errorApprovedCumulativeQuantity", message);
            errors.reject("errorApprovedCumulativeQuantity", message);
        }
        details.setPrevCumlvQuantity(prevCumulativeQuantity);
    }

    public Double getTotalMBAmountOfMBs(Long mbHeaderId, Long workOrderEstimateId, String statusCode) {
        return this.mbHeaderRepository.getTotalMBAmountOfMBs(mbHeaderId, workOrderEstimateId, statusCode);
    }

    public List<MBHeader> getMBHeadersToCancelLOA(WorkOrderEstimate workOrderEstimate) {
        return this.mbHeaderRepository.findByWorkOrderEstimate_IdAndEgwStatus_codeNotOrderById(workOrderEstimate.getId(), "CANCELLED");
    }

    public List<MBHeader> searchMBsToCancel(SearchRequestCancelMB searchRequestCancelMB) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(MBHeader.class, "mb").createAlias("mb.workOrderEstimate", "woe").createAlias("woe.workOrder", "wo").createAlias("woe.estimate", "estimate").createAlias("estimate.projectCode", "projectCode").createAlias("wo.contractor", "woc").createAlias("mb.egwStatus", "status");
        if (searchRequestCancelMB != null) {
            if (searchRequestCancelMB.getMbReferenceNumber() != null) {
                criteria.add(Restrictions.ilike((String)"mb.mbRefNo", (String)searchRequestCancelMB.getMbReferenceNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestCancelMB.getContractorName() != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestCancelMB.getContractorName()).ignoreCase(), (Criterion)Restrictions.eq((String)"woc.code", (Object)searchRequestCancelMB.getContractorName()).ignoreCase()));
            }
            if (searchRequestCancelMB.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimate.executingDepartment.id", (Object)searchRequestCancelMB.getDepartment()));
            }
            if (searchRequestCancelMB.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"projectCode.code", (Object)searchRequestCancelMB.getWorkIdentificationNumber()));
            }
            if (searchRequestCancelMB.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestCancelMB.getStatus()));
            }
            if (searchRequestCancelMB.getLoaNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"wo.workOrderNumber", (Object)searchRequestCancelMB.getLoaNumber()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findLoaNumbersToCancelMB(String code) {
        List<String> loaNumbers = this.mbHeaderRepository.findLoaNumbersToCancelMB("%" + code + "%", MBHeader.MeasurementBookStatus.APPROVED.toString());
        return loaNumbers;
    }

    public List<String> findContractorsToCancelMB(String code) {
        List<String> loaNumbers = this.mbHeaderRepository.findContractorsToSearchMBToCancel("%" + code + "%", MBHeader.MeasurementBookStatus.APPROVED.toString());
        return loaNumbers;
    }

    public List<String> findWorkIdentificationNumbersToCancelMB(String code) {
        List<String> workIdNumbers = this.mbHeaderRepository.findWorkIdentificationNumbersToCancelMB("%" + code + "%", MBHeader.MeasurementBookStatus.APPROVED.toString());
        return workIdNumbers;
    }

    public MBHeader getLatestMBHeader(Long workOrderEstimateId) {
        return this.mbHeaderRepository.findLatestMBHeaderToValidateMB(workOrderEstimateId, MBHeader.MeasurementBookStatus.CANCELLED.toString());
    }

    public List<MBHeader> getPreviousMBHeaders(Long mbHeaderId, Long workOrderEstimateId) {
        return this.mbHeaderRepository.getPreviousMBHeaders(mbHeaderId, workOrderEstimateId, MBHeader.MeasurementBookStatus.CANCELLED.toString());
    }

    public MBHeader getLatestMBHeaderToValidateBillDate(Long workOrderEstimateId, Date billDate) {
        return this.mbHeaderRepository.findLatestMBHeaderToValidateBillDate(workOrderEstimateId, billDate, MBHeader.MeasurementBookStatus.APPROVED.toString(), MBHeader.MeasurementBookStatus.CANCELLED.toString());
    }

    public List<MBHeader> getMBHeaderBasedOnBillDate(Long workOrderEstimateId, Date billDate) {
        return this.mbHeaderRepository.findMBHeaderBasedOnbillDate(workOrderEstimateId, billDate, MBHeader.MeasurementBookStatus.APPROVED.toString(), MBHeader.MeasurementBookStatus.CANCELLED.toString());
    }

    public List<Hashtable<String, Object>> getMeasurementsForMB(MBHeader mBHeader) {
        ArrayList<Hashtable<String, Object>> measurementSheetList = new ArrayList<Hashtable<String, Object>>();
        Hashtable<String, Object> measurementSheetMap = null;
        int slno = 1;
        ArrayList<String> characters = new ArrayList<String>(26);
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            characters.add(String.valueOf(c));
        }
        for (MBDetails mbDetail : mBHeader.getMbDetails()) {
            WorkOrderActivity workOrderActivity = mbDetail.getWorkOrderActivity();
            if (mbDetail != null && !mbDetail.getMeasurementSheets().isEmpty()) {
                measurementSheetList.add(this.addMBDetails(mbDetail, slno));
                int measurementSNo = 1;
                for (MBMeasurementSheet mBMeasurement : mbDetail.getMeasurementSheets()) {
                    measurementSheetMap = new Hashtable<String, Object>(0);
                    measurementSheetMap.put("sNo", String.valueOf(slno) + (String)characters.get((measurementSNo - 1) % 26));
                    measurementSheetMap.put("scheduleCode", "");
                    measurementSheetMap.put("scheduleCategory", "");
                    measurementSheetMap.put("description", mBMeasurement.getWoMeasurementSheet().getMeasurementSheet().getRemarks() != null ? mBMeasurement.getWoMeasurementSheet().getMeasurementSheet().getRemarks() : "");
                    measurementSheetMap.put("woNo", mBMeasurement.getWoMeasurementSheet().getNo() != null ? mBMeasurement.getWoMeasurementSheet().getNo() : "");
                    measurementSheetMap.put("woLength", mBMeasurement.getWoMeasurementSheet().getLength() != null ? mBMeasurement.getWoMeasurementSheet().getLength() : "");
                    measurementSheetMap.put("woWidth", mBMeasurement.getWoMeasurementSheet().getWidth() != null ? mBMeasurement.getWoMeasurementSheet().getWidth() : "");
                    measurementSheetMap.put("woDepthHeight", mBMeasurement.getWoMeasurementSheet().getDepthOrHeight() != null ? mBMeasurement.getWoMeasurementSheet().getDepthOrHeight() : "");
                    measurementSheetMap.put("woQuantity", mBMeasurement.getWoMeasurementSheet().getQuantity());
                    measurementSheetMap.put("mbNo", mBMeasurement.getNo() != null ? mBMeasurement.getNo() : "");
                    measurementSheetMap.put("mbLength", mBMeasurement.getLength() != null ? mBMeasurement.getLength() : "");
                    measurementSheetMap.put("mbwidth", mBMeasurement.getWidth() != null ? mBMeasurement.getWidth() : "");
                    measurementSheetMap.put("mbDepthHeight", mBMeasurement.getDepthOrHeight() != null ? mBMeasurement.getDepthOrHeight() : "");
                    measurementSheetMap.put("mbQuantity", mBMeasurement.getQuantity());
                    measurementSheetMap.put("rate", "");
                    measurementSheetMap.put("uom", "");
                    measurementSheetMap.put("amount", "");
                    measurementSheetMap.put("completedMeasurement", "");
                    ++measurementSNo;
                    measurementSheetList.add(measurementSheetMap);
                }
                if (mbDetail.getMeasurementSheets().size() != 0) {
                    measurementSheetMap = new Hashtable(0);
                    measurementSheetMap.put("sNo", "");
                    measurementSheetMap.put("scheduleCode", "");
                    measurementSheetMap.put("scheduleCategory", "");
                    measurementSheetMap.put("description", "");
                    measurementSheetMap.put("woNo", "");
                    measurementSheetMap.put("woLength", "");
                    measurementSheetMap.put("woWidth", "");
                    measurementSheetMap.put("woDepthHeight", "");
                    measurementSheetMap.put("woQuantity", workOrderActivity.getApprovedQuantity());
                    Double prevCumulaticeqty = this.getPreviousCumulativeQuantity(mBHeader.getId(), mbDetail.getWorkOrderActivity().getId());
                    measurementSheetMap.put("completedMeasurement", BigDecimal.valueOf(mbDetail.getQuantity()).add(prevCumulaticeqty != null ? BigDecimal.valueOf(prevCumulaticeqty) : BigDecimal.ZERO));
                    measurementSheetMap.put("mbNo", "");
                    measurementSheetMap.put("mbLength", "");
                    measurementSheetMap.put("mbwidth", "");
                    measurementSheetMap.put("mbDepthHeight", "");
                    measurementSheetMap.put("mbQuantity", mbDetail.getQuantity());
                    measurementSheetMap.put("rate", workOrderActivity.getActivity().getEstimateRate());
                    measurementSheetMap.put("uom", workOrderActivity.getActivity().getUom().getUom());
                    measurementSheetMap.put("amount", BigDecimal.valueOf(workOrderActivity.getActivity().getRate()).multiply(BigDecimal.valueOf(mbDetail.getQuantity())));
                    measurementSheetList.add(measurementSheetMap);
                }
            }
            ++slno;
        }
        return measurementSheetList;
    }

    private Hashtable<String, Object> addMBDetails(MBDetails mbDetail, int slNo) {
        Hashtable<String, Object> measurementSheetMap = new Hashtable<String, Object>(0);
        WorkOrderActivity workOrderActivity = mbDetail.getWorkOrderActivity();
        measurementSheetMap.put("sNo", slNo);
        if (workOrderActivity.getActivity().getSchedule() != null) {
            measurementSheetMap.put("scheduleCode", workOrderActivity.getActivity().getSchedule().getCode());
            measurementSheetMap.put("scheduleCategory", workOrderActivity.getActivity().getSchedule().getScheduleCategory().getCode());
            measurementSheetMap.put("description", workOrderActivity.getActivity().getSchedule().getDescription());
        } else {
            measurementSheetMap.put("scheduleCode", "N/A");
            measurementSheetMap.put("scheduleCategory", "N/A");
            measurementSheetMap.put("description", workOrderActivity.getActivity().getNonSor().getDescription());
        }
        measurementSheetMap.put("woNo", "");
        measurementSheetMap.put("woLength", "");
        measurementSheetMap.put("woWidth", "");
        measurementSheetMap.put("woDepthHeight", "");
        measurementSheetMap.put("woQuantity", "");
        measurementSheetMap.put("mbNo", "");
        measurementSheetMap.put("mbLength", "");
        measurementSheetMap.put("mbwidth", "");
        measurementSheetMap.put("mbDepthHeight", "");
        measurementSheetMap.put("mbQuantity", "");
        measurementSheetMap.put("completedMeasurement", "");
        measurementSheetMap.put("rate", "");
        measurementSheetMap.put("uom", "");
        measurementSheetMap.put("completedMeasurement", "");
        measurementSheetMap.put("amount", "");
        return measurementSheetMap;
    }

    public Double getMeasurementsPreviousCumulativeQuantity(Long mbHeaderId, Long woMeasurementSheetId) {
        return this.mbHeaderRepository.getMeasurementsPreviousCumulativeQuantity(mbHeaderId, MBHeader.MeasurementBookStatus.CANCELLED.toString(), woMeasurementSheetId);
    }

    public List<MBHeader> getMBHeaderForBillTillDate(Long contractorBillId, Long workOrderEstimateId) {
        return this.mbHeaderRepository.findMBHeadersTillDate(contractorBillId, workOrderEstimateId);
    }

    public List<MBHeader> getMBHeadersForTenderedLumpSumAcivitiesToCancelRE(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate workOrderEstimate) {
        return this.mbHeaderRepository.findMBHeadersForRevisionEstimate(revisionEstimate.getParent().getId(), revisionEstimate.getId(), workOrderEstimate.getId(), RevisionType.NON_TENDERED_ITEM, RevisionType.LUMP_SUM_ITEM, MBHeader.MeasurementBookStatus.CANCELLED.toString());
    }

    public void validateWorkflowActionButton(MBHeader mbHeader, JsonObject jsonObject, BindingResult errors, String additionalRule, String workFlowAction) {
        HashMap map = new HashMap();
        map.putAll((Map)this.scriptService.executeScript("MB-APPROVALRULES", ScriptService.createContext((Object[])new Object[]{"mbAmount", mbHeader.getMbAmount(), "cityGrade", additionalRule})));
        String message = "";
        boolean validateWorkflowButton = (Boolean)map.get("createAndApproveFieldsRequired");
        if (validateWorkflowButton && WorksConstants.FORWARD_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("error.create.approve", (Object[])new String[]{null}, null);
            jsonObject.addProperty("workFlowError", message);
        } else if (!validateWorkflowButton && "Create And Approve".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("error.forward.approve", (Object[])new String[]{null}, null);
            jsonObject.addProperty("workFlowError", message);
        }
        if (errors != null) {
            errors.reject("workFlowError", message);
        }
    }
}

