/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.repository;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MBHeaderRepository
extends JpaRepository<MBHeader, Long>,
RevisionRepository<MBHeader, Long, Integer> {
    public MBHeader findById(Long var1);

    public List<MBHeader> findByWorkOrder(WorkOrder var1);

    public List<MBHeader> findByWorkOrderEstimate(WorkOrderEstimate var1);

    public List<MBHeader> findByWorkOrder_id(Long var1);

    @Query(value="select mbh from MBHeader as mbh where mbh.workOrderEstimate.id =:workOrderEstimateId and mbh.egwStatus.code =:mbStatus  and not exists (select distinct cbr from ContractorBillRegister cbr where upper(cbr.billstatus) != :billStatus and cbr = mbh.egBillregister) ")
    public List<MBHeader> findByWorkOrderEstimateId(@Param(value="workOrderEstimateId") Long var1, @Param(value="mbStatus") String var2, @Param(value="billStatus") String var3);

    public List<MBHeader> findByWorkOrderAndEgwStatus_codeEqualsOrderById(WorkOrder var1, String var2);

    public List<MBHeader> findByEgBillregisterAndEgwStatus_codeEquals(ContractorBillRegister var1, String var2);

    public List<MBHeader> findByEgBillregister(ContractorBillRegister var1);

    public MBHeader findByWorkOrderEstimate_IdAndEgwStatus_codeEquals(Long var1, String var2);

    @Query(value="select mbh from MBHeader as mbh where mbh.workOrderEstimate.id =:workOrderEstimateId and egwStatus.code not in (:status1, :status2, :status3)")
    public MBHeader findByWorkOrderEstimateAndStatus(@Param(value="workOrderEstimateId") Long var1, @Param(value="status1") String var2, @Param(value="status2") String var3, @Param(value="status3") String var4);

    @Query(value="select distinct(mbh.createdBy) from MBHeader as mbh")
    public List<User> findMBHeaderCreatedByUsers();

    public List<MBHeader> findByWorkOrderEstimate_IdAndEgwStatus_codeNotOrderById(Long var1, String var2);

    @Query(value="select sum(mbd.quantity) from MBDetails mbd where (mbd.mbHeader.createdDate < (select createdDate from MBHeader where id = :mbHeaderId) or (select count(*) from MBHeader where id = :mbHeaderId) = 0 ) and mbd.mbHeader.egwStatus.code != :status group by mbd.workOrderActivity having mbd.workOrderActivity.id = :woActivityId")
    public Double getPreviousCumulativeQuantity(@Param(value="mbHeaderId") Long var1, @Param(value="status") String var2, @Param(value="woActivityId") Long var3);

    @Query(value="select sum(mbAmount) from MBHeader where id != :mbHeaderId and egwStatus.code != :statusCode and workOrderEstimate.id = :workOrderEstimateId")
    public Double getTotalMBAmountOfMBs(@Param(value="mbHeaderId") Long var1, @Param(value="workOrderEstimateId") Long var2, @Param(value="statusCode") String var3);

    @Query(value="select distinct(mb.workOrderEstimate.workOrder.workOrderNumber) from MBHeader as mb where upper(mb.workOrderEstimate.workOrder.workOrderNumber) like upper(:code) and mb.egwStatus.code = :status")
    public List<String> findLoaNumbersToCancelMB(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(mb.workOrderEstimate.workOrder.contractor.name) from MBHeader as mb where upper(mb.workOrderEstimate.workOrder.contractor.name) like upper(:code) or upper(mb.workOrderEstimate.workOrder.contractor.code) like upper(:code) and mb.egwStatus.code = :status")
    public List<String> findContractorsToSearchMBToCancel(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(mb.workOrderEstimate.estimate.projectCode.code) from MBHeader as mb  where upper(mb.workOrderEstimate.estimate.projectCode.code) like upper(:code) and mb.egwStatus.code = :status")
    public List<String> findWorkIdentificationNumbersToCancelMB(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select mbh from MBHeader as mbh where createdDate = (select max(mb.createdDate) from MBHeader as mb where mb.workOrderEstimate.id = :workOrderEstimateId and mb.egwStatus.code != :statusCode)")
    public MBHeader findLatestMBHeaderToValidateMB(@Param(value="workOrderEstimateId") Long var1, @Param(value="statusCode") String var2);

    @Query(value="select mbh from MBHeader mbh where mbh.workOrderEstimate.id = :woeId and (mbh.createdDate < (select createdDate from MBHeader where id = :mbHeaderId  and mbh.egwStatus.code != :status) or (select count(*) from MBHeader where id = :mbHeaderId) = 0) order by mbh.id")
    public List<MBHeader> getPreviousMBHeaders(@Param(value="mbHeaderId") Long var1, @Param(value="woeId") Long var2, @Param(value="status") String var3);

    @Query(value="select mbh from MBHeader as mbh where createdDate = (select max(mb.createdDate) from MBHeader as mb where mb.workOrderEstimate.id = :workOrderEstimateId and mbDate <= :billDate and mb.egwStatus.code = :approvedStatusCode and not exists (select cbr from ContractorBillRegister cbr where cbr.status.code != :cancelStatusCode and cbr = mb.egBillregister))")
    public MBHeader findLatestMBHeaderToValidateBillDate(@Param(value="workOrderEstimateId") Long var1, @Param(value="billDate") Date var2, @Param(value="approvedStatusCode") String var3, @Param(value="cancelStatusCode") String var4);

    @Query(value="select mb from MBHeader as mb where mb.workOrderEstimate.id = :workOrderEstimateId  and mbDate <= :billDate and mb.egwStatus.code = :approvedStatusCode and not exists (select cbr from ContractorBillRegister cbr where cbr.status.code != :cancelStatusCode and cbr = mb.egBillregister))")
    public List<MBHeader> findMBHeaderBasedOnbillDate(@Param(value="workOrderEstimateId") Long var1, @Param(value="billDate") Date var2, @Param(value="approvedStatusCode") String var3, @Param(value="cancelStatusCode") String var4);

    @Query(value="select sum(mbms.quantity) from MBMeasurementSheet mbms where (mbms.mbDetails.mbHeader.createdDate < (select createdDate from MBHeader where id = :mbHeaderId) or (select count(*) from MBHeader where id = :mbHeaderId) = 0 ) and mbms.mbDetails.mbHeader.egwStatus.code != :status group by mbms.woMeasurementSheet having mbms.woMeasurementSheet.id = :woMeasurementSheetId")
    public Double getMeasurementsPreviousCumulativeQuantity(@Param(value="mbHeaderId") Long var1, @Param(value="status") String var2, @Param(value="woMeasurementSheetId") Long var3);

    @Query(value="select mbh from MBHeader mbh where mbh.workOrderEstimate.id = :workOrderEstimateId and mbh.egBillregister.id < :contractorBillId ")
    public List<MBHeader> findMBHeadersTillDate(@Param(value="contractorBillId") Long var1, @Param(value="workOrderEstimateId") Long var2);

    @Query(value="select mbh from MBHeader mbh where exists (select mbd.mbHeader from MBDetails mbd where mbh = mbd.mbHeader and mbd.workOrderActivity.workOrderEstimate.estimate.id =:abstractEstimateId and mbd.workOrderActivity.workOrderEstimate.id =:workOrderEstimateId and  mbd.mbHeader.egwStatus.code != :mbStatus and exists (select a from Activity a where a.abstractEstimate.id =:revisionEstimateId and a.abstractEstimate.parent = mbd.workOrderActivity.workOrderEstimate.estimate and a.abstractEstimate.parent.id =:abstractEstimateId and a.revisionType in(:nonTenderderRevisionType,:lumpSumRevisionType))) ")
    public List<MBHeader> findMBHeadersForRevisionEstimate(@Param(value="abstractEstimateId") Long var1, @Param(value="revisionEstimateId") Long var2, @Param(value="workOrderEstimateId") Long var3, @Param(value="nonTenderderRevisionType") RevisionType var4, @Param(value="lumpSumRevisionType") RevisionType var5, @Param(value="mbStatus") String var6);
}

