/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.envers.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.utils.DateUtils;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.entity.MBHistory;
import org.egov.works.mb.service.MBHeaderService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.history.Revision;
import org.springframework.data.history.Revisions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MBHistoryService {
    @Autowired
    private AssignmentService assignmentService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private MBHeaderService mbHeaderService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<MBHeader> getAuditedMbHeaderById(Long id) {
        Revisions<Integer, MBHeader> revisions = this.mbHeaderService.findRevisions(id);
        ArrayList<MBHeader> auditedMbs = new ArrayList<MBHeader>();
        for (Revision revision : revisions.getContent()) {
            auditedMbs.add((MBHeader)((Object)revision.getEntity()));
        }
        return auditedMbs;
    }

    public List<MBHistory> getMBHistory(Long mbHeaderId) {
        List<MBHeader> mbHeaders = this.getAuditedMbHeaderById(mbHeaderId);
        List<MBHistory> mbHistorys = this.prepareHistory(mbHeaders);
        return mbHistorys;
    }

    private List<MBHistory> prepareHistory(List<MBHeader> mbHeaders) {
        Assignment userAssignment = null;
        ArrayList<MBHistory> mbHistorys = new ArrayList<MBHistory>();
        HashSet<Activity> sorActivities = new HashSet<Activity>(0);
        HashSet<Activity> nonSorActivities = new HashSet<Activity>(0);
        HashSet<Activity> nonTenActivities = new HashSet<Activity>(0);
        HashSet<Activity> lumpSumActivities = new HashSet<Activity>(0);
        HashMap<Long, Activity> sorActivitiesMap = new HashMap<Long, Activity>();
        HashMap<Long, Activity> nonSorActivitiesMap = new HashMap<Long, Activity>();
        HashMap<Long, Activity> ntActivitiesMap = new HashMap<Long, Activity>();
        HashMap<Long, Activity> lsActivitiesMap = new HashMap<Long, Activity>();
        ArrayList<MBDetails> mbDetails = new ArrayList<MBDetails>();
        MBDetails detail = null;
        MBHistory history = null;
        for (MBHeader header : mbHeaders) {
            if (MBHeader.MeasurementBookStatus.NEW.toString().equals(header.getEgwStatus().getCode())) continue;
            history = new MBHistory();
            userAssignment = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(header.getLastModifiedBy().getId(), new Date()).get(0);
            history.setStatus(header.getEgwStatus().getDescription());
            history.setOwnerName(userAssignment.getDesignation().getName() + " - " + header.getLastModifiedBy().getName());
            history.setDateTime(DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime((Object)header.getLastModifiedDate())));
            history.setMbAmount(header.getMbAmount());
            history.setSorMbDetails((List)header.getSORMBDetails());
            history.setNonSorMbDetails((List)header.getNonSORMBDetails());
            history.setNonTenderedMbDetails((List)header.getNonTenderedMBDetails());
            history.setLumpSumMbDetails((List)header.getLumpSumMBDetails());
            for (MBDetails details : header.getSORMBDetails()) {
                sorActivitiesMap.put(details.getWorkOrderActivity().getActivity().getId(), details.getWorkOrderActivity().getActivity());
                sorActivities.add(details.getWorkOrderActivity().getActivity());
            }
            for (MBDetails details : header.getNonSORMBDetails()) {
                nonSorActivitiesMap.put(details.getWorkOrderActivity().getActivity().getId(), details.getWorkOrderActivity().getActivity());
                nonSorActivities.add(details.getWorkOrderActivity().getActivity());
            }
            for (MBDetails details : header.getNonTenderedMBDetails()) {
                ntActivitiesMap.put(details.getWorkOrderActivity().getActivity().getId(), details.getWorkOrderActivity().getActivity());
                nonTenActivities.add(details.getWorkOrderActivity().getActivity());
            }
            for (MBDetails details : header.getLumpSumMBDetails()) {
                lsActivitiesMap.put(details.getWorkOrderActivity().getActivity().getId(), details.getWorkOrderActivity().getActivity());
                lumpSumActivities.add(details.getWorkOrderActivity().getActivity());
            }
            mbHistorys.add(history);
        }
        for (MBHistory hstr : mbHistorys) {
            hstr.getSorActivities().addAll(sorActivities);
            hstr.getNonSorActivities().addAll(nonSorActivities);
            hstr.getNonTenActivities().addAll(nonTenActivities);
            hstr.getLumpSumActivities().addAll(lumpSumActivities);
            mbDetails = new ArrayList();
            for (Long activityId : sorActivitiesMap.keySet()) {
                detail = new MBDetails();
                for (MBDetails details : hstr.getSorMbDetails()) {
                    if (!activityId.equals(details.getWorkOrderActivity().getActivity().getId())) continue;
                    detail = details;
                }
                mbDetails.add(detail);
            }
            hstr.setSorMbDetails(mbDetails);
            mbDetails = new ArrayList();
            for (Long activityId : nonSorActivitiesMap.keySet()) {
                detail = new MBDetails();
                for (MBDetails details : hstr.getNonSorMbDetails()) {
                    if (!activityId.equals(details.getWorkOrderActivity().getActivity().getId())) continue;
                    detail = details;
                }
                mbDetails.add(detail);
            }
            hstr.setNonSorMbDetails(mbDetails);
            mbDetails = new ArrayList();
            for (Long activityId : ntActivitiesMap.keySet()) {
                detail = new MBDetails();
                for (MBDetails details : hstr.getNonTenderedMbDetails()) {
                    if (!activityId.equals(details.getWorkOrderActivity().getActivity().getId())) continue;
                    detail = details;
                }
                mbDetails.add(detail);
            }
            hstr.setNonTenderedMbDetails(mbDetails);
            mbDetails = new ArrayList();
            for (Long activityId : lsActivitiesMap.keySet()) {
                detail = new MBDetails();
                for (MBDetails details : hstr.getLumpSumMbDetails()) {
                    if (!activityId.equals(details.getWorkOrderActivity().getActivity().getId())) continue;
                    detail = details;
                }
                mbDetails.add(detail);
            }
            hstr.setLumpSumMbDetails(mbDetails);
        }
        return mbHistorys;
    }
}

