/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.masters.entity.MarketRate;
import org.egov.works.masters.entity.SORRate;
import org.egov.works.masters.entity.ScheduleOfRate;
import org.egov.works.masters.repository.ScheduleOfRateRepository;
import org.egov.works.services.WorksService;
import org.egov.works.uploadsor.UploadScheduleOfRate;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Session;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ScheduleOfRateService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ScheduleOfRateRepository scheduleOfRateRepository;
    @Autowired
    private WorksService worksService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;

    public ScheduleOfRate getScheduleOfRateById(Long scheduleOfRateId) {
        ScheduleOfRate scheduleOfRate = (ScheduleOfRate)((Object)this.entityManager.find(ScheduleOfRate.class, (Object)scheduleOfRateId));
        return scheduleOfRate;
    }

    public List<ScheduleOfRate> getAllScheduleOfRates() {
        Query query = this.entityManager.createQuery("from ScheduleOfRate sor order by code asc");
        List scheduleOfRateList = query.getResultList();
        return scheduleOfRateList;
    }

    public List getAllAbstractEstimateByScheduleOrRateId(Long scheduleOfRateId) {
        Query query = this.entityManager.createQuery("select ae from AbstractEstimate ae, Activity act where act.abstractEstimate = ae and act.abstractEstimate.parent is null and act.abstractEstimate.egwStatus.code <> 'CANCELLED' and act.schedule.id = :scheduleOfRateId");
        query.setParameter("scheduleOfRateId", (Object)scheduleOfRateId);
        List list = query.getResultList();
        return list;
    }

    public List getAllWorkOrderEstimateByScheduleOfRateId(Long scheduleOfRateId) {
        Query query = this.entityManager.createQuery("select distinct(woa.workOrderEstimate) from WorkOrderActivity woa where woa.workOrderEstimate.estimate.parent.id is not null and woa.workOrderEstimate.estimate.egwStatus.code<> 'CANCELLED' and exists (select sor.id from ScheduleOfRate sor where sor.id = woa.activity.schedule.id and sor.id = :scheduleOfRateId )");
        query.setParameter("scheduleOfRateId", (Object)scheduleOfRateId);
        List list = query.getResultList();
        return list;
    }

    public SearchQuery prepareSearchQuery(Long scheduleCategoryId, String code, String description) {
        StringBuffer scheduleOfRateSql = new StringBuffer(100);
        String scheduleOfRateStr = "";
        ArrayList<Object> paramList = new ArrayList<Object>();
        scheduleOfRateSql.append(" from ScheduleOfRate sor where sor.scheduleCategory.id=?");
        paramList.add(scheduleCategoryId);
        if (code != null && !code.equals("")) {
            scheduleOfRateSql.append(" and UPPER(sor.code) like ?");
            paramList.add("%" + code.toUpperCase() + "%");
        }
        if (description != null && !description.equals("")) {
            scheduleOfRateSql.append(" and UPPER(sor.description) like ?");
            paramList.add("%" + description.toUpperCase() + "%");
        }
        scheduleOfRateStr = scheduleOfRateSql.toString();
        String countQuery = "select count(*) " + scheduleOfRateStr;
        return new SearchQueryHQL(scheduleOfRateStr, countQuery, paramList);
    }

    @Transactional
    public ScheduleOfRate save(ScheduleOfRate scheduleOfRate) {
        return (ScheduleOfRate)((Object)this.scheduleOfRateRepository.save((Object)scheduleOfRate));
    }

    public ScheduleOfRate findById(Long id, boolean b) {
        return (ScheduleOfRate)((Object)this.scheduleOfRateRepository.findOne(id));
    }

    public List<ScheduleOfRate> getScheduleOfRatesByCodeAndScheduleOfCategories(String code, String ids, Date estimateDate) {
        String[] split;
        ArrayList<Long> scheduleOfCategoryIds = new ArrayList<Long>();
        for (String s : split = ids.split(",")) {
            scheduleOfCategoryIds.add(Long.parseLong(s));
        }
        if (estimateDate == null) {
            estimateDate = new Date();
        }
        List<ScheduleOfRate> scheduleOfRates = this.scheduleOfRateRepository.findByCodeContainingIgnoreCaseAndScheduleCategory_IdInOrderByCode(code.toUpperCase(), scheduleOfCategoryIds, estimateDate);
        for (ScheduleOfRate rate : scheduleOfRates) {
            rate.setSorRateValue(rate.getRateOn(estimateDate).getRate().getValue());
        }
        return scheduleOfRates;
    }

    public List<ScheduleOfRate> getScheduleOfRatesByCodeAndScheduleOfCategoriesAndEstimateId(String code, String ids, Date estimateDate, Long estimateId) {
        String[] split;
        ArrayList<Long> scheduleOfCategoryIds = new ArrayList<Long>();
        ArrayList<Long> estimateIds = new ArrayList<Long>();
        List<AbstractEstimate> estimates = this.estimateService.getAbstractEstimateByParentId(estimateId);
        for (AbstractEstimate abstractEstimate : estimates) {
            estimateIds.add(abstractEstimate.getId());
        }
        estimateIds.add(estimateId);
        for (String s : split = ids.split(",")) {
            scheduleOfCategoryIds.add(Long.parseLong(s));
        }
        if (estimateDate == null) {
            estimateDate = new Date();
        }
        List<ScheduleOfRate> list = this.scheduleOfRateRepository.findByCodeAndScheduleOfCategoriesAndEstimateId(code.toUpperCase(), scheduleOfCategoryIds, estimateDate, estimateIds);
        for (ScheduleOfRate rate : list) {
            rate.setSorRateValue(rate.getRateOn(estimateDate).getRate().getValue());
        }
        return list;
    }

    public ScheduleOfRate setPrimaryDetails(ScheduleOfRate scheduleOfRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        if (scheduleOfRate.getId() == null) {
            scheduleOfRate.setCreatedBy(user);
            scheduleOfRate.setCreatedDate(new Date());
        }
        scheduleOfRate.setModifiedBy(user);
        scheduleOfRate.setModifiedDate(new Date());
        return scheduleOfRate;
    }

    public SORRate setPrimaryDetailsForSorRates(SORRate sorRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        sorRate.setCreatedBy(user);
        sorRate.setCreatedDate(new Date());
        sorRate.setModifiedBy(user);
        sorRate.setModifiedDate(new Date());
        return sorRate;
    }

    public MarketRate setPrimaryDetailsForMarketRates(MarketRate marketRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        marketRate.setCreatedBy(user);
        marketRate.setCreatedDate(new Date());
        marketRate.setModifiedBy(user);
        marketRate.setModifiedDate(new Date());
        return marketRate;
    }

    public ScheduleOfRate getByCode(String code) {
        return this.scheduleOfRateRepository.findByCode(code);
    }

    public ScheduleOfRate getByCodeAndScheduleCategoryId(String code, Long id) {
        return this.scheduleOfRateRepository.findByCodeAndScheduleCategory_id(code, id);
    }

    @Transactional
    public List<UploadScheduleOfRate> createScheduleOfRate(List<UploadScheduleOfRate> uploadSORRatesList) {
        Date currentDate = new Date();
        for (UploadScheduleOfRate obj : uploadSORRatesList) {
            ScheduleOfRate scheduleOfRate = new ScheduleOfRate();
            SORRate sorRate = new SORRate();
            MarketRate marketRate = new MarketRate();
            scheduleOfRate.setCode(obj.getSorCode());
            scheduleOfRate.setScheduleCategory(obj.getScheduleCategory());
            scheduleOfRate.setUom(obj.getUom());
            scheduleOfRate.setDescription(obj.getSorDescription());
            sorRate.setRate(new Money(obj.getRate().doubleValue()));
            sorRate.setValidity(new Period(obj.getFromDate(), obj.getToDate() != null ? obj.getToDate() : null));
            sorRate.setScheduleOfRate(scheduleOfRate);
            sorRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            sorRate.setCreatedDate(currentDate);
            sorRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            sorRate.setModifiedDate(currentDate);
            scheduleOfRate.getSorRates().add(sorRate);
            if (obj.getMarketRate() != null) {
                marketRate.setMarketRate(new Money(obj.getMarketRate().doubleValue()));
                marketRate.setValidity(new Period(obj.getMarketFromDate(), obj.getMarketToDate() != null ? obj.getMarketToDate() : null));
                marketRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                marketRate.setCreatedDate(currentDate);
                marketRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                marketRate.setModifiedDate(currentDate);
                marketRate.setScheduleOfRate(scheduleOfRate);
                scheduleOfRate.getMarketRates().add(marketRate);
            }
            scheduleOfRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            scheduleOfRate.setCreatedDate(currentDate);
            scheduleOfRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            scheduleOfRate.setModifiedDate(currentDate);
            this.save(scheduleOfRate);
            obj.setFinalStatus("Success");
        }
        return uploadSORRatesList;
    }

    @Transactional
    public List<UploadScheduleOfRate> createSORRate(List<UploadScheduleOfRate> uploadSORRatesList) {
        Date currentDate = new Date();
        for (UploadScheduleOfRate obj : uploadSORRatesList) {
            ScheduleOfRate scheduleOfRate = obj.getScheduleOfRate();
            SORRate sorRate = new SORRate();
            MarketRate marketRate = new MarketRate();
            sorRate.setRate(new Money(obj.getRate().doubleValue()));
            sorRate.setValidity(new Period(obj.getFromDate(), obj.getToDate() != null ? obj.getToDate() : null));
            sorRate.setScheduleOfRate(scheduleOfRate);
            sorRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            sorRate.setCreatedDate(currentDate);
            sorRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            sorRate.setModifiedDate(currentDate);
            scheduleOfRate.getSorRates().add(sorRate);
            if (obj.getMarketRate() != null) {
                marketRate.setMarketRate(new Money(obj.getMarketRate().doubleValue()));
                marketRate.setValidity(new Period(obj.getMarketFromDate(), obj.getMarketToDate() != null ? obj.getMarketToDate() : null));
                marketRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                marketRate.setCreatedDate(currentDate);
                marketRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                marketRate.setModifiedDate(currentDate);
                marketRate.setScheduleOfRate(scheduleOfRate);
                scheduleOfRate.getMarketRates().add(marketRate);
            }
            scheduleOfRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            scheduleOfRate.setModifiedDate(currentDate);
            this.save(scheduleOfRate);
            obj.setFinalStatus("Success");
        }
        return uploadSORRatesList;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Boolean validateRates(List<UploadScheduleOfRate> uploadSORRatesList) {
        Boolean errorInMasterData = false;
        List<AbstractEstimate> estimates = null;
        List<WorkOrderEstimate> woe = null;
        Period checkPeriod = null;
        String error = "";
        LocalDate existingStartDate = null;
        LocalDate existingEndDate = null;
        LocalDate checkStartDate = null;
        Boolean toDateUpdated = false;
        Boolean isLatestRate = false;
        block0: for (UploadScheduleOfRate obj : uploadSORRatesList) {
            checkPeriod = new Period(obj.getFromDate(), obj.getToDate());
            error = "";
            if (obj.getScheduleOfRate() != null && obj.getScheduleOfRate().getSorRatesOrderById().get(0).getValidity().getEndDate() == null) {
                obj.setIsToDateNull(true);
            }
            isLatestRate = false;
            toDateUpdated = false;
            if (obj.getScheduleOfRate() == null) continue;
            for (SORRate rate : obj.getScheduleOfRate().getSorRatesOrderById()) {
                LocalDate previousDay;
                LocalDate rateFromDate;
                if (!isLatestRate.booleanValue()) {
                    isLatestRate = true;
                }
                existingStartDate = new LocalDate((Object)rate.getValidity().getStartDate());
                if (rate.getValidity().getEndDate() != null) {
                    existingEndDate = new LocalDate((Object)rate.getValidity().getEndDate());
                }
                checkStartDate = new LocalDate((Object)obj.getFromDate());
                if (obj.getToDate() != null) {
                    new LocalDate((Object)obj.getToDate());
                }
                if (isLatestRate.booleanValue() && checkStartDate.compareTo((ReadablePartial)existingStartDate) <= 0) {
                    error = error + " " + this.messageSource.getMessage("error.sor.rate.dates.overlap", null, null) + ",";
                    if (obj.getErrorReason() != null) {
                        error = obj.getErrorReason() + error;
                    }
                    obj.setErrorReason(error);
                    continue block0;
                }
                if (obj.getIsToDateNull() != null && obj.getIsToDateNull().booleanValue()) {
                    estimates = this.estimateService.getBySorIdAndEstimateDate(obj.getScheduleOfRate().getId(), obj.getFromDate());
                    woe = this.estimateService.getBySorIdAndWorkOrderDate(obj.getScheduleOfRate().getId(), obj.getFromDate());
                    if (woe != null && !woe.isEmpty()) {
                        error = error + " " + this.messageSource.getMessage("error.active.revisionestimate.exist.for.given.date.range", null, null) + ",";
                    }
                    if (estimates != null && !estimates.isEmpty()) {
                        error = error + " " + this.messageSource.getMessage("error.active.estimates.exist.for.given.date.range", null, null) + ",";
                    } else if (!toDateUpdated.booleanValue() && isLatestRate.booleanValue()) {
                        rateFromDate = new LocalDate((Object)rate.getValidity().getStartDate());
                        previousDay = new LocalDate((Object)obj.getFromDate()).minusDays(1);
                        if (previousDay.compareTo((ReadablePartial)rateFromDate) <= 0) {
                            error = error + " " + this.messageSource.getMessage("error.sor.rate.dates.overlap", null, null) + ",";
                            if (obj.getErrorReason() != null) {
                                error = obj.getErrorReason() + error;
                            }
                            obj.setErrorReason(error);
                            continue block0;
                        }
                        rate.setValidity(new Period(rate.getValidity().getStartDate(), previousDay.toDate()));
                        toDateUpdated = true;
                    }
                    if (!obj.getScheduleOfRate().isWithin(rate.getValidity(), obj.getFromDate()) && (obj.getToDate() == null || !obj.getScheduleOfRate().isWithin(rate.getValidity(), obj.getToDate())) && !obj.getScheduleOfRate().isWithin(checkPeriod, rate.getValidity().getStartDate()) && (rate.getValidity().getEndDate() == null || !obj.getScheduleOfRate().isWithin(checkPeriod, rate.getValidity().getEndDate()))) continue;
                    error = error + " " + this.messageSource.getMessage("error.sor.rate.dates.overlap", null, null) + ",";
                    if (obj.getErrorReason() != null) {
                        error = obj.getErrorReason() + error;
                    }
                    obj.setErrorReason(error);
                    continue;
                }
                if (existingEndDate.compareTo((ReadablePartial)checkStartDate) > 0) {
                    estimates = this.estimateService.getBySorIdAndEstimateDate(obj.getScheduleOfRate().getId(), obj.getFromDate());
                    woe = this.estimateService.getBySorIdAndWorkOrderDate(obj.getScheduleOfRate().getId(), obj.getFromDate());
                    if (woe != null && !woe.isEmpty()) {
                        error = error + " " + this.messageSource.getMessage("error.active.revisionestimate.exist.for.given.date.range", null, null) + ",";
                    }
                    if (estimates != null && !estimates.isEmpty()) {
                        error = error + " " + this.messageSource.getMessage("error.active.estimates.exist.for.given.date.range", null, null) + ",";
                    } else if (!toDateUpdated.booleanValue() && isLatestRate.booleanValue()) {
                        rateFromDate = new LocalDate((Object)rate.getValidity().getStartDate());
                        previousDay = new LocalDate((Object)obj.getFromDate()).minusDays(1);
                        if (previousDay.compareTo((ReadablePartial)rateFromDate) <= 0) {
                            error = error + " " + this.messageSource.getMessage("error.sor.rate.dates.overlap", null, null) + ",";
                            if (obj.getErrorReason() != null) {
                                error = obj.getErrorReason() + error;
                            }
                            obj.setErrorReason(error);
                            continue block0;
                        }
                        rate.setValidity(new Period(rate.getValidity().getStartDate(), previousDay.toDate()));
                        toDateUpdated = true;
                    }
                }
                if (!obj.getScheduleOfRate().isWithin(rate.getValidity(), obj.getFromDate()) && (obj.getToDate() == null || !obj.getScheduleOfRate().isWithin(rate.getValidity(), obj.getToDate())) && !obj.getScheduleOfRate().isWithin(checkPeriod, rate.getValidity().getStartDate()) && (rate.getValidity().getEndDate() == null || !obj.getScheduleOfRate().isWithin(checkPeriod, rate.getValidity().getEndDate()))) continue;
                error = error + " " + this.messageSource.getMessage("error.sor.rate.dates.overlap", null, null) + ",";
                if (obj.getErrorReason() != null) {
                    error = obj.getErrorReason() + error;
                }
                obj.setErrorReason(error);
            }
        }
        if (!error.equalsIgnoreCase("")) {
            errorInMasterData = true;
        }
        return errorInMasterData;
    }
}

