/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.masters.entity.ScheduleCategory;
import org.egov.works.masters.entity.ScheduleOfRate;
import org.egov.works.masters.entity.SearchRequestScheduleCategory;
import org.egov.works.masters.repository.ScheduleCategoryRepository;
import org.egov.works.masters.repository.ScheduleOfRateRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ScheduleCategoryService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ScheduleCategoryRepository scheduleCategoryRepository;
    @Autowired
    private ScheduleOfRateRepository scheduleOfRateRepository;

    public ScheduleCategory getScheduleCategoryById(Long scheduleCategoryId) {
        return (ScheduleCategory)((Object)this.scheduleCategoryRepository.findOne(scheduleCategoryId));
    }

    public boolean checkForSOR(Long categoryId) {
        List<ScheduleOfRate> rates = this.scheduleOfRateRepository.findByScheduleCategory_id(categoryId);
        return rates == null || rates.isEmpty();
    }

    public List<ScheduleCategory> getAllScheduleCategories() {
        return this.scheduleCategoryRepository.findAll();
    }

    @Transactional
    public ScheduleCategory save(ScheduleCategory scheduleCategory) {
        return (ScheduleCategory)((Object)this.scheduleCategoryRepository.save((Object)scheduleCategory));
    }

    public List<String> getCategoryNames(String categoryName) {
        List<ScheduleCategory> scheduleCategory = this.scheduleCategoryRepository.findByDescriptionContainingIgnoreCase(categoryName);
        ArrayList<String> results = new ArrayList<String>();
        for (ScheduleCategory details : scheduleCategory) {
            results.add(details.getDescription());
        }
        return results;
    }

    public List<ScheduleCategory> searchScheduleCategory(SearchRequestScheduleCategory searchRequestScheduleCategory) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ScheduleCategory.class);
        if (searchRequestScheduleCategory != null) {
            if (searchRequestScheduleCategory.getCategoryName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"description", (Object)searchRequestScheduleCategory.getCategoryName()).ignoreCase());
            }
            if (searchRequestScheduleCategory.getCategoryDescription() != null) {
                criteria.add(Restrictions.ilike((String)"code", (String)searchRequestScheduleCategory.getCategoryDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public ScheduleCategory findByCode(String code) {
        return this.scheduleCategoryRepository.findByCodeIgnoreCase(code);
    }
}

