/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.masters.entity.Overhead;
import org.egov.works.masters.entity.OverheadRate;
import org.egov.works.masters.entity.SearchRequestOverhead;
import org.egov.works.masters.repository.OverheadRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OverheadService {
    @Autowired
    private OverheadRepository overheadRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Overhead create(Overhead overhead) throws IOException {
        for (OverheadRate overheadRates : overhead.getOverheadRates()) {
            overheadRates.setOverhead(overhead);
        }
        Overhead newOverhead = (Overhead)((Object)this.overheadRepository.save((Object)overhead));
        return newOverhead;
    }

    public Overhead getOverheadById(Long overheadId) {
        return (Overhead)((Object)this.overheadRepository.findOne(overheadId));
    }

    public Overhead getOverheadByName(String name) {
        return this.overheadRepository.findByNameIgnoreCase(name);
    }

    public List<Overhead> getOverheadsByDate(Date date) {
        return this.overheadRepository.getByDate(date);
    }

    public List<Overhead> searchOverheadToModify(SearchRequestOverhead searchRequestOverhead) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Overhead.class).addOrder(Order.asc((String)"createdDate"));
        if (searchRequestOverhead != null) {
            if (searchRequestOverhead.getOverheadName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"name", (Object)searchRequestOverhead.getOverheadName()).ignoreCase());
            }
            if (searchRequestOverhead.getOverheadDescription() != null) {
                criteria.add(Restrictions.ilike((String)"description", (String)searchRequestOverhead.getOverheadDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findOverheadNameToSearchOverhead(String name) {
        List<Overhead> overhead = this.overheadRepository.findByNameContainingIgnoreCase("%" + name + "%");
        ArrayList<String> results = new ArrayList<String>();
        for (Overhead details : overhead) {
            results.add(details.getName());
        }
        return results;
    }

    public List<Overhead> searchOverheadToView(SearchRequestOverhead searchRequestOverhead) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Overhead.class).addOrder(Order.asc((String)"createdDate"));
        if (searchRequestOverhead != null) {
            if (searchRequestOverhead.getOverheadName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"name", (Object)searchRequestOverhead.getOverheadName()).ignoreCase());
            }
            if (searchRequestOverhead.getOverheadDescription() != null) {
                criteria.add(Restrictions.ilike((String)"description", (String)searchRequestOverhead.getOverheadDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public void createOverheadValues(Overhead overhead) {
        OverheadRate overheadRates = null;
        overhead.getOverheadRates().clear();
        for (OverheadRate overheadRate : overhead.getTempOverheadRateValues()) {
            overheadRates = new OverheadRate();
            overheadRates.setLumpsumAmount(overheadRate.getLumpsumAmount());
            overheadRates.setPercentage(overheadRate.getPercentage());
            overheadRates.setValidity(overheadRate.getValidity());
            overheadRates.setOverhead(overhead);
            overhead.getOverheadRates().add(overheadRates);
        }
    }
}

