/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.masters.entity.MilestoneTemplate;
import org.egov.works.masters.repository.MilestoneTemplateRepository;
import org.egov.works.milestone.entity.SearchRequestMilestoneTemplate;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MilestoneTemplateService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private MilestoneTemplateRepository milestoneTemplateRepository;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public MilestoneTemplate save(MilestoneTemplate milestoneTemplate) {
        MilestoneTemplate newMilestoneTemplate = (MilestoneTemplate)((Object)this.milestoneTemplateRepository.save((Object)milestoneTemplate));
        return newMilestoneTemplate;
    }

    public MilestoneTemplate getMilestoneTemplateById(Long id) {
        return (MilestoneTemplate)((Object)this.milestoneTemplateRepository.findOne(id));
    }

    public boolean getCode(String code) {
        MilestoneTemplate milestoneTemplate = this.milestoneTemplateRepository.findByCodeIgnoreCase(code);
        return milestoneTemplate != null;
    }

    public MilestoneTemplate getMilestoneTemplateByCode(String code) {
        return this.milestoneTemplateRepository.findByCodeIgnoreCase(code);
    }

    public List<MilestoneTemplate> findMilestoneTemplateCodeForMilestone(String code) {
        return this.milestoneTemplateRepository.findByCodeContainingIgnoreCase(code);
    }

    public List<MilestoneTemplate> searchMilestoneTemplate(SearchRequestMilestoneTemplate searchRequestMilestoneTemplate) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(MilestoneTemplate.class);
        if (searchRequestMilestoneTemplate != null) {
            if (searchRequestMilestoneTemplate.getName() != null) {
                criteria.add(Restrictions.ilike((String)"name", (String)searchRequestMilestoneTemplate.getName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestMilestoneTemplate.getDescription() != null) {
                criteria.add(Restrictions.ilike((String)"description", (String)searchRequestMilestoneTemplate.getDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestMilestoneTemplate.getTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"typeOfWork.id", (Object)searchRequestMilestoneTemplate.getTypeOfWork()));
            }
            if (searchRequestMilestoneTemplate.getSubTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"subTypeOfWork.id", (Object)searchRequestMilestoneTemplate.getSubTypeOfWork()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }
}

