/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.masters.entity.EstimateTemplate;
import org.egov.works.masters.repository.EstimateTemplateRepository;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EstimateTemplateService {
    @Autowired
    private EstimateTemplateRepository estimateTemplateRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void create(EstimateTemplate estimateTemplate) {
        this.estimateTemplateRepository.saveAndFlush((Object)estimateTemplate);
    }

    @Transactional
    public void update(EstimateTemplate estimateTemplate) {
        this.estimateTemplateRepository.saveAndFlush((Object)estimateTemplate);
    }

    @Transactional
    public void remove(EstimateTemplate estimateTemplate) {
        this.estimateTemplateRepository.delete((Object)estimateTemplate);
    }

    public List<EstimateTemplate> getAll() {
        return this.estimateTemplateRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public EstimateTemplate getEstimateTemplateById(Long estimateTemplateId) {
        return (EstimateTemplate)((Object)this.estimateTemplateRepository.findOne(estimateTemplateId));
    }

    public EstimateTemplate getEstimateTemplateByName(String name) {
        return this.estimateTemplateRepository.findByName(name);
    }

    public EstimateTemplate getEstimateTemplateByCode(String code) {
        return this.estimateTemplateRepository.findByCode(code);
    }

    public List<EstimateTemplate> getEstimateTemplateByCodeIgnoreCase(String code) {
        return this.estimateTemplateRepository.findByCodeContainingIgnoreCase(code);
    }
}

