/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.masters.entity.DepositCode;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="depositCodeService")
@Transactional(readOnly=true)
public class DepositCodeService
extends PersistenceService<DepositCode, Long>
implements EntityTypeService {
    @Autowired
    private WorksService worksService;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @PersistenceContext
    private EntityManager entityManager;

    public DepositCodeService() {
        super(DepositCode.class);
    }

    public DepositCodeService(Class<DepositCode> type) {
        super(type);
    }

    public DepositCode getDepositCodeById(Long DepositCodeId) {
        DepositCode depositCode = (DepositCode)((Object)this.entityManager.find(DepositCode.class, (Object)DepositCodeId));
        return depositCode;
    }

    public List<DepositCode> getAllDepositCodes() {
        Query query = this.entityManager.createQuery("from DepositCode");
        List depositCodeList = query.getResultList();
        return depositCodeList;
    }

    @Transactional
    public void createAccountDetailKey(DepositCode dc) {
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(dc.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public List<DepositCode> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        String param = "%" + filterKey.toUpperCase() + "%";
        Page page = this.findPageByNamedQuery("EGW_getActiveDepositCodesByCodeOrDescription", 1, pageSize, new Object[]{param, param});
        return page.getList();
    }

    public List<DepositCode> getAllActiveEntities(Integer accountDetailTypeId) {
        return this.findAllByNamedQuery("EGW_getActiveDepositCodes", new Object[0]);
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<DepositCode> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<DepositCode> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }
}

