/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.service;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.ContractorClassSearchRequest;
import org.egov.commons.ContractorGrade;
import org.egov.works.masters.repository.ContractorGradeRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractorGradeService")
@Transactional(readOnly=true)
public class ContractorGradeService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ContractorGradeRepository contractorGradeRepository;

    public ContractorGrade getContractorGradeById(Long contractorGradeId) {
        return (ContractorGrade)this.contractorGradeRepository.findOne(contractorGradeId);
    }

    public List<ContractorGrade> getAllContractorGrades() {
        return this.contractorGradeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"grade"}));
    }

    @Transactional
    public ContractorGrade save(ContractorGrade contractorGrade) {
        return (ContractorGrade)this.contractorGradeRepository.save(contractorGrade);
    }

    public List<ContractorGrade> searchContractorClassToView(ContractorClassSearchRequest contractorClassSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ContractorGrade.class).addOrder(Order.asc((String)"createdDate"));
        if (contractorClassSearchRequest != null) {
            if (contractorClassSearchRequest.getContractorClass() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"grade", (Object)contractorClassSearchRequest.getContractorClass()));
            }
            if (contractorClassSearchRequest.getMinAmount() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"minAmount", (Object)new BigDecimal(contractorClassSearchRequest.getMinAmount())));
            }
            if (contractorClassSearchRequest.getMaxAmount() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"maxAmount", (Object)new BigDecimal(contractorClassSearchRequest.getMaxAmount())));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Transactional
    public ContractorGrade update(ContractorGrade contractorGrade) {
        return (ContractorGrade)this.contractorGradeRepository.save(contractorGrade);
    }

    public List<String> getAllContractorMinAmounts() {
        return this.contractorGradeRepository.findByContractorClassMinAmount();
    }

    public List<String> getAllContractorMaxAmounts() {
        return this.contractorGradeRepository.findByContractorClassMaxAmount();
    }

    public ContractorGrade getByMinAndMaxAmount(BigDecimal minAmount, BigDecimal maxAmount) {
        return this.contractorGradeRepository.findByMinAndMaxAmount(minAmount, maxAmount);
    }

    public ContractorGrade getByContractorClass(String grade) {
        return this.contractorGradeRepository.findByGrade(grade);
    }

    public ContractorGrade findByContractorClass(String contractorClass) {
        return this.contractorGradeRepository.findByGradeIgnoreCase(contractorClass.toUpperCase());
    }
}

