/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.masters.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.masters.entity.EstimateTemplateActivity;

@Unique(fields={"code"}, id="id", tableName="EGW_ESTIMATE_TEMPLATE", columnName={"CODE"}, message="estimateTemplate.code.isunique")
public class EstimateTemplate
extends BaseModel {
    private static final long serialVersionUID = -1150757466961896868L;
    @Required(message="estimatetemplate.code.not.null")
    private String code;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="estimatetemplate.name.alphaNumeric")
    @Required(message="estimatetemplate.name.not.null")
    private String name;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="estimatetemplate.description.alphaNumeric")
    @Required(message="estimatetemplate.description.not.null")
    private String description;
    private int status;
    @Valid
    @Required(message="estimatetemplate.workType.not.null")
    private EgwTypeOfWork workType;
    private EgwTypeOfWork subType;
    @Valid
    @JsonIgnore
    private List<EstimateTemplateActivity> estimateTemplateActivities = new LinkedList<EstimateTemplateActivity>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = StringEscapeUtils.unescapeHtml((String)code);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringEscapeUtils.unescapeHtml((String)name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringEscapeUtils.unescapeHtml((String)description);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public EgwTypeOfWork getWorkType() {
        return this.workType;
    }

    public void setWorkType(EgwTypeOfWork workType) {
        this.workType = workType;
    }

    public EgwTypeOfWork getSubType() {
        return this.subType;
    }

    public void setSubType(EgwTypeOfWork subType) {
        this.subType = subType;
    }

    public List<EstimateTemplateActivity> getEstimateTemplateActivities() {
        return this.estimateTemplateActivities;
    }

    public void setEstimateTemplateActivities(List<EstimateTemplateActivity> estimateTemplateActivities) {
        this.estimateTemplateActivities = estimateTemplateActivities;
    }

    public void addActivity(EstimateTemplateActivity estimateTemplateActivity) {
        this.estimateTemplateActivities.add(estimateTemplateActivity);
    }

    @JsonIgnore
    public Collection<EstimateTemplateActivity> getSORActivities() {
        return CollectionUtils.select(this.estimateTemplateActivities, activity -> ((EstimateTemplateActivity)((Object)((Object)activity))).getSchedule() != null);
    }

    @JsonIgnore
    public Collection<EstimateTemplateActivity> getNonSORActivities() {
        return CollectionUtils.select(this.estimateTemplateActivities, activity -> ((EstimateTemplateActivity)((Object)((Object)activity))).getNonSor() != null);
    }

    public List<ValidationError> validateActivities() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (EstimateTemplateActivity estimateTemplateActivity : this.estimateTemplateActivities) {
            validationErrors.addAll(estimateTemplateActivity.validate());
        }
        return validationErrors;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        validationErrors.addAll(this.validateActivities());
        return validationErrors;
    }
}

