/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkIdentificationNumberGenerator {
    private static final String PROJECTCODE_SEQ_PREFIX = "SEQ_PROJECTCODE";
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Transactional
    public String generateWorkOrderIdentificationNumber(LineEstimateDetails lineEstimateDetails) {
        try {
            Serializable sequenceNumber;
            CFinancialYear financialYear = this.financialYearHibernateDAO.getFinYearByDate(lineEstimateDetails.getLineEstimate().getLineEstimateDate());
            String[] finYearRange = financialYear.getFinYearRange().split("-");
            String sequenceName = "SEQ_PROJECTCODE_" + finYearRange[0] + "_" + finYearRange[1];
            String workCategory = !lineEstimateDetails.getLineEstimate().getWorkCategory().toString().equals(WorkCategory.NON_SLUM.toString()) ? "SL" : "NS";
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s/%s/%05d/%02d/%s", lineEstimateDetails.getLineEstimate().getExecutingDepartment().getCode(), workCategory, sequenceNumber, this.getMonthOfTransaction(lineEstimateDetails.getLineEstimate().getLineEstimateDate()), financialYear.getFinYearRange());
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating WIN", (Throwable)e);
        }
    }

    @Transactional
    public String generateAbstractEstimateWorkOrderIdentificationNumber(AbstractEstimate abstractEstimate) {
        try {
            Serializable sequenceNumber;
            CFinancialYear financialYear = this.financialYearHibernateDAO.getFinYearByDate(abstractEstimate.getEstimateDate());
            String[] finYearRange = financialYear.getFinYearRange().split("-");
            String sequenceName = "SEQ_PROJECTCODE_" + finYearRange[0] + "_" + finYearRange[1];
            String workCategory = !abstractEstimate.getWorkCategory().toString().equals(WorkCategory.NON_SLUM.toString()) ? "SL" : "NS";
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s/%s/%05d/%02d/%s", abstractEstimate.getExecutingDepartment().getCode(), workCategory, sequenceNumber, this.getMonthOfTransaction(abstractEstimate.getEstimateDate()), financialYear.getFinYearRange());
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating WIN", (Throwable)e);
        }
    }

    private int getMonthOfTransaction(Date lineEstimateDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(lineEstimateDate);
        return cal.get(2) + 1;
    }
}

