/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.autonumber.EstimateNumberGenerator;
import org.egov.works.autonumber.LineEstimateNumberGenerator;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimatesForAbstractEstimate;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.repository.LineEstimateRepository;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LineEstimateService {
    private static final Logger LOG = LoggerFactory.getLogger(LineEstimateService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final LineEstimateRepository lineEstimateRepository;
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<LineEstimate> lineEstimateWorkflowService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private CityService cityService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public LineEstimateService(LineEstimateRepository lineEstimateRepository, LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.lineEstimateRepository = lineEstimateRepository;
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
    }

    public LineEstimate getLineEstimateById(Long id) {
        return this.lineEstimateRepository.findById(id);
    }

    @Transactional
    public LineEstimate create(LineEstimate lineEstimate, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
        CFinancialYear financialYear = this.worksUtils.getFinancialYearByDate(lineEstimate.getLineEstimateDate());
        this.mergeLineEstimateDetails(lineEstimate);
        for (LineEstimateDetails lineEstimateDetail : lineEstimate.getLineEstimateDetails()) {
            EstimateNumberGenerator e = (EstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(EstimateNumberGenerator.class);
            String estimateNumber = e.getNextNumber(lineEstimate, financialYear);
            lineEstimateDetail.setEstimateNumber(estimateNumber);
            lineEstimateDetail.setLineEstimate(lineEstimate);
        }
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            LineEstimateNumberGenerator l = (LineEstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(LineEstimateNumberGenerator.class);
            String lineEstimateNumber = l.getNextNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        this.createLineEstimateWorkflowTransition(newLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.lineEstimateRepository.save((Object)newLineEstimate);
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return newLineEstimate;
    }

    private LineEstimate update(LineEstimate lineEstimate, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws IOException {
        this.mergeLineEstimateDetails(lineEstimate);
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            if (lineEstimateDetails == null || lineEstimateDetails.getId() != null) continue;
            EstimateNumberGenerator e = (EstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(EstimateNumberGenerator.class);
            String estimateNumber = e.getNextNumber(lineEstimate, financialYear);
            lineEstimateDetails.setEstimateNumber(estimateNumber);
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        List<LineEstimateDetails> list = new ArrayList<LineEstimateDetails>(lineEstimate.getLineEstimateDetails());
        list = this.removeDeletedLineEstimateDetails(list, removedLineEstimateDetailsIds);
        lineEstimate.setLineEstimateDetails(list);
        LineEstimate persistedLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)persistedLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            persistedLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)persistedLineEstimate));
    }

    public LineEstimate getLineEstimateByLineEstimateNumber(String lineEstimateNumber) {
        return this.lineEstimateRepository.findByLineEstimateNumber(lineEstimateNumber);
    }

    public List<LineEstimateDetails> removeDeletedLineEstimateDetails(List<LineEstimateDetails> list, String removedLineEstimateDetailsIds) {
        ArrayList<LineEstimateDetails> details = new ArrayList<LineEstimateDetails>();
        if (null != removedLineEstimateDetailsIds) {
            String[] ids = removedLineEstimateDetailsIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (LineEstimateDetails line : list) {
                if (line.getId() != null) {
                    if (strList.contains(line.getId().toString())) continue;
                    details.add(line);
                    continue;
                }
                details.add(line);
            }
        } else {
            return list;
        }
        return details;
    }

    public List<LineEstimate> searchLineEstimates(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "lineEstimateDetail").createAlias("status", "les");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getAdminSanctionNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"adminSanctionNumber", (Object)lineEstimateSearchRequest.getAdminSanctionNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getBudgetHead() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"budgetHead.id", (Object)lineEstimateSearchRequest.getBudgetHead()));
            }
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getFunction() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"function.id", (Object)lineEstimateSearchRequest.getFunction()));
            }
            if (lineEstimateSearchRequest.getFund() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"fund.id", (Object)lineEstimateSearchRequest.getFund().intValue()));
            }
            if (lineEstimateSearchRequest.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionFromDate()));
            }
            if (lineEstimateSearchRequest.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionToDate()));
            }
            if (lineEstimateSearchRequest.getLineEstimateStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"les.code", (Object)lineEstimateSearchRequest.getLineEstimateStatus()));
            }
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<LineEstimateDetails> getLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate) {
        StringBuilder mainQuery = new StringBuilder();
        StringBuilder filterConditions = new StringBuilder();
        List<LineEstimateDetails> lineEstimateDetailsList = new ArrayList();
        Query query = null;
        if (lineEstimatesForAbstractEstimate.getAdminSanctionNumber() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionNumber =:adminSanctionNumber ");
        }
        if (lineEstimatesForAbstractEstimate.getExecutingDepartment() != null) {
            filterConditions.append(" and lineEstimate.executingDepartment.id =:executingDepartment ");
        }
        if (lineEstimatesForAbstractEstimate.getEstimateNumber() != null) {
            filterConditions.append(" and upper(estimateNumber) =:estimateNumber ");
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionFromDate() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionDate >=:adminSanctionFromDate ");
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionToDate() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionDate <=:adminSanctionToDate ");
        }
        if (lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy() != null) {
            filterConditions.append(" and lineEstimate.createdBy.id =:createdBy ");
        }
        if (lineEstimatesForAbstractEstimate.getWorkIdentificationNumber() != null) {
            filterConditions.append(" and upper(projectCode.code) =:projectCode ");
        }
        filterConditions.append(" and lineEstimate.abstractEstimateCreated =:spillOverFlag ");
        mainQuery.append("select led from LineEstimateDetails as led ");
        mainQuery.append(" where not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) !=:wostatus) ");
        mainQuery.append(" and (upper(led.lineEstimate.status.code) =:lestatus1 or upper(led.lineEstimate.status.code) =:lestatus2 )");
        mainQuery.append(" and  not exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:aestatus) ");
        mainQuery.append(filterConditions.toString());
        query = this.entityManager.createQuery(mainQuery.toString());
        query.setParameter("lestatus1", (Object)LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString());
        query.setParameter("lestatus2", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        query = this.setParameterToGetLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate, query);
        lineEstimateDetailsList = query.getResultList();
        mainQuery = new StringBuilder();
        mainQuery.append("select led from LineEstimateDetails as led ");
        mainQuery.append(" where not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) !=:wostatus) ");
        mainQuery.append(" and upper(led.lineEstimate.status.code) =:lestatus ");
        mainQuery.append(" and exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.state is null and not exists (select act.abstractEstimate from Activity as act where ae = act.abstractEstimate) and ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:aestatus) ");
        mainQuery.append(filterConditions.toString());
        query = null;
        query = this.entityManager.createQuery(mainQuery.toString());
        query.setParameter("lestatus", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        query = this.setParameterToGetLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate, query);
        lineEstimateDetailsList.addAll(query.getResultList());
        mainQuery = new StringBuilder();
        return lineEstimateDetailsList;
    }

    private Query setParameterToGetLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate, Query query) {
        query.setParameter("wostatus", (Object)"CANCELLED");
        query.setParameter("aestatus", (Object)"CANCELLED");
        query.setParameter("spillOverFlag", (Object)lineEstimatesForAbstractEstimate.isSpillOverFlag());
        if (lineEstimatesForAbstractEstimate.getAdminSanctionNumber() != null) {
            query.setParameter("adminSanctionNumber", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionNumber());
        }
        if (lineEstimatesForAbstractEstimate.getExecutingDepartment() != null) {
            query.setParameter("executingDepartment", (Object)lineEstimatesForAbstractEstimate.getExecutingDepartment());
        }
        if (lineEstimatesForAbstractEstimate.getEstimateNumber() != null) {
            query.setParameter("estimateNumber", (Object)lineEstimatesForAbstractEstimate.getEstimateNumber().toUpperCase());
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionFromDate() != null) {
            query.setParameter("adminSanctionFromDate", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionFromDate());
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionToDate() != null) {
            query.setParameter("adminSanctionToDate", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionToDate());
        }
        if (lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy() != null) {
            query.setParameter("createdBy", (Object)lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy());
        }
        if (lineEstimatesForAbstractEstimate.getWorkIdentificationNumber() != null) {
            query.setParameter("projectCode", (Object)lineEstimatesForAbstractEstimate.getWorkIdentificationNumber().toUpperCase());
        }
        return query;
    }

    public List<String> findLineEstimateNumbers(String name) {
        List<LineEstimate> lineEstimates = this.lineEstimateRepository.findByLineEstimateNumberContainingIgnoreCase(name);
        ArrayList<String> results = new ArrayList<String>();
        for (LineEstimate details : lineEstimates) {
            results.add(details.getLineEstimateNumber());
        }
        return results;
    }

    public List<String> findEstimateNumbersForLoa(String name) {
        List<String> lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForLoa("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED");
        return lineEstimateNumbers;
    }

    public List<String> findEstimateNumbersForAbstractEstimate(String name) {
        List<Object> lineEstimateNumbers = new ArrayList();
        lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForLoa("%" + name.toUpperCase() + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        lineEstimateNumbers.addAll(this.lineEstimateDetailsRepository.findEstimateNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED"));
        return lineEstimateNumbers;
    }

    public List<String> findAdminSanctionNumbers(String name) {
        List<String> adminSanctionNumbers = this.lineEstimateRepository.findDistinctAdminSanctionNumberContainingIgnoreCase("%" + name + "%");
        return adminSanctionNumbers;
    }

    public List<String> findAdminSanctionNumbersForLoa(String name) {
        List<String> adminSanctionNumbers = this.lineEstimateDetailsRepository.findAdminSanctionNumbersForLoa("%" + name.toUpperCase() + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), "CANCELLED");
        return adminSanctionNumbers;
    }

    public List<String> findAdminSanctionNumbersForAbstractEstimate(String name) {
        List<Object> adminSanctionNumbers = new ArrayList();
        adminSanctionNumbers = this.lineEstimateDetailsRepository.findAdminSanctionNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        adminSanctionNumbers.addAll(this.lineEstimateDetailsRepository.findAdminSanctionNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED"));
        return adminSanctionNumbers;
    }

    public List<String> findWorkIdentificationNumbersToSearchEstimatesForLoa(String name) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchEstimatesForLoa("%" + name.toUpperCase() + "%", "CANCELLED", AbstractEstimate.EstimateStatus.APPROVED.toString().toUpperCase());
        return workIdNumbers;
    }

    public List<String> findWorkIdentificationNumbersToSearchEstimates(String name) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchEstimates("%" + name.toUpperCase() + "%", "CANCELLED", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString());
        return workIdNumbers;
    }

    public List<LineEstimatesForAbstractEstimate> searchLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate) {
        List<LineEstimateDetails> lineEstimateDetails = this.getLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate);
        ArrayList<LineEstimatesForAbstractEstimate> lineEstimatesForAbstractEstimates = new ArrayList<LineEstimatesForAbstractEstimate>();
        for (LineEstimateDetails led : lineEstimateDetails) {
            LineEstimatesForAbstractEstimate result = new LineEstimatesForAbstractEstimate();
            result.setId(led.getId());
            result.setLeId(led.getLineEstimate().getId());
            result.setAdminSanctionNumber(led.getLineEstimate().getAdminSanctionNumber());
            result.setCreatedBy(led.getLineEstimate().getCreatedBy().getName());
            result.setEstimateAmount(led.getEstimateAmount());
            result.setEstimateNumber(led.getEstimateNumber());
            result.setNameOfWork(led.getNameOfWork());
            if (led.getLineEstimate().getAdminSanctionBy() != null) {
                result.setAdminSanctionBy(led.getLineEstimate().getAdminSanctionBy());
            }
            result.setActualEstimateAmount(led.getActualEstimateAmount());
            result.setWorkIdentificationNumber(led.getProjectCode().getCode());
            lineEstimatesForAbstractEstimates.add(result);
        }
        return lineEstimatesForAbstractEstimates;
    }

    public Long getApprovalPositionByMatrixDesignation(LineEstimate lineEstimate, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, lineEstimate.getCurrentState().getValue(), null);
        if (lineEstimate.getStatus() != null && lineEstimate.getStatus().getCode() != null && (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) || lineEstimate.getStatus().getCode().equals(LineEstimateStatus.RESUBMITTED.toString())) && lineEstimate.getState() != null) {
            approvalPosition = mode.equals("edit") ? lineEstimate.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString())) {
            approvalPosition = this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created") || workFlowAction.equals("Approve")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    /*
     * Unable to fully structure code
     */
    @Transactional
    public LineEstimate updateLineEstimateDetails(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws ValidationException, IOException {
        updatedLineEstimate = null;
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString())) {
            updatedLineEstimate = this.update(lineEstimate, removedLineEstimateDetailsIds, files, financialYear);
            try {
                if (!workFlowAction.equals(WorksConstants.FORWARD_ACTION) && !workFlowAction.equals("Cancel")) ** GOTO lbl25
                this.lineEstimateStatusChange(updatedLineEstimate, workFlowAction, mode);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        } else {
            try {
                if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                    this.resetAdminSanctionDetails(lineEstimate);
                } else if (workFlowAction.equals("Approve")) {
                    if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                        this.doBudgetoryAppropriation(lineEstimate);
                    }
                    this.setAdminSanctionByAndDate(lineEstimate);
                    for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                        this.lineEstimateDetailService.setProjectCode(led);
                    }
                }
                this.lineEstimateStatusChange(lineEstimate, workFlowAction, mode);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        }
lbl25:
        // 3 sources

        updatedLineEstimate = (LineEstimate)this.lineEstimateRepository.save((Object)lineEstimate);
        this.createLineEstimateWorkflowTransition(updatedLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        updatedLineEstimate = (LineEstimate)this.lineEstimateRepository.save((Object)updatedLineEstimate);
        return updatedLineEstimate;
    }

    private void resetAdminSanctionDetails(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionNumber(null);
        lineEstimate.setCouncilResolutionNumber(null);
        lineEstimate.setCouncilResolutionDate(null);
    }

    private void setAdminSanctionByAndDate(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionDate(new Date());
        lineEstimate.setAdminSanctionBy(this.securityUtils.getCurrentUser().getName());
    }

    private void doBudgetoryAppropriation(LineEstimate lineEstimate) {
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimate.getBudgetHead().getId());
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            boolean flag;
            BigDecimal appropriationAmount = lineEstimate.isBillsCreated() && led.getGrossAmountBilled() != null ? led.getEstimateAmount().subtract(led.getGrossAmountBilled()) : led.getEstimateAmount();
            if (appropriationAmount.compareTo(BigDecimal.ZERO) != 1 || (flag = this.estimateAppropriationService.checkConsumeEncumbranceBudgetForLineEstimate(led, this.worksUtils.getFinancialYearByDate(new Date()).getId(), appropriationAmount.doubleValue(), budgetheadid))) continue;
            throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
        }
    }

    public void lineEstimateStatusChange(LineEstimate lineEstimate, String workFlowAction, String mode) throws ValidationException {
        WorkFlowMatrix wfmatrix = null;
        if (LineEstimateStatus.REJECTED.toString().equals(lineEstimate.getStatus().getCode()) && "Cancel".equals(workFlowAction)) {
            lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
        } else if (WorksConstants.REJECT_ACTION.equals(workFlowAction)) {
            lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.REJECTED.toString()));
        } else if (null != lineEstimate.getState()) {
            wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), (String)this.cityService.cityDataAsMap().get("cityGrade"), lineEstimate.getCurrentState().getValue(), lineEstimate.getCurrentState().getNextAction());
            lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", wfmatrix.getNextStatus().toUpperCase()));
        }
    }

    public List<User> getLineEstimateCreatedByUsers() {
        return this.lineEstimateRepository.getLineEstimateCreatedByUsers(LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public LineEstimateDetails findByEstimateNumber(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeEquals(estimateNumber, LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public void createLineEstimateWorkflowTransition(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Estimate";
        if (null != lineEstimate.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(lineEstimate.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Estimate");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L) && !"Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == lineEstimate.getState()) {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, "", null);
                lineEstimate.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Estimate");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Estimate");
            } else {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, lineEstimate.getCurrentState().getValue(), lineEstimate.getCurrentState().getNextAction());
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Estimate");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public LineEstimate getLineEstimateByTechnicalSanctionNumber(String technicalSanctionNumber) {
        return this.lineEstimateRepository.findByTechnicalSanctionNumberIgnoreCaseAndStatus_CodeNot(technicalSanctionNumber, LineEstimateStatus.CANCELLED.toString());
    }

    public LineEstimate getLineEstimateByAdminSanctionNumber(String adminSanctionNumber) {
        return this.lineEstimateRepository.findByAdminSanctionNumberIgnoreCaseAndStatus_codeNotLike(adminSanctionNumber, "CANCELLED");
    }

    @Transactional
    public LineEstimate createSpillOver(LineEstimate lineEstimate, MultipartFile[] files) throws IOException {
        List<DocumentDetails> documentDetails;
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()));
        lineEstimate.setSpillOverFlag(true);
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            Iterator<LineEstimateDetails> l = (LineEstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(LineEstimateNumberGenerator.class);
            String lineEstimateNumber = l.getNextNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            this.lineEstimateDetailService.setProjectCode(led);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.doBudgetoryAppropriation(lineEstimate);
        }
        if (!(documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate")).isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return newLineEstimate;
    }

    public List<String> getEstimateNumberForDepartment(Long departmentId) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(departmentId);
    }

    public List<String> getEstimateNumbersForWorkIdentificationNumber(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForWorkIdentificationNumber(workIdentificationNumber);
    }

    public List<String> getEstimateNumbersForSpillOverFlag(boolean spillOverFlag) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForSpillOverFlag(spillOverFlag);
    }

    public List<User> getLineEstimateCreatedByUsersForCancelLineEstimateByDepartment(Long department) {
        return this.lineEstimateDetailsRepository.findCreatedByForCancelLineEstimateByDepartment(department, LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "APPROVED");
    }

    public List<LineEstimate> searchLineEstimatesToCancel(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "led").createAlias("executingDepartment", "ed").createAlias("led.projectCode", "pc").createAlias("status", "status");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"ed.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getLineEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getLineEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getWorkIdentificationNumber() != null) {
                criteria.add(Restrictions.ilike((String)"pc.code", (String)lineEstimateSearchRequest.getWorkIdentificationNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (lineEstimateSearchRequest.getCreatedBy() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)lineEstimateSearchRequest.getCreatedBy()));
        }
        if (lineEstimateSearchRequest.isSpillOverFlag()) {
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString()).ignoreCase(), (Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()).ignoreCase()));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public String checkIfLOAsCreated(Long lineEstimateId) {
        List<String> listString = this.letterOfAcceptanceService.getEstimateNumbersToCancelLineEstimate(lineEstimateId);
        String estimateNumbers = "";
        for (String estimateNumber : listString) {
            estimateNumbers = estimateNumbers + estimateNumber + ", ";
        }
        if (estimateNumbers.equals("")) {
            return "";
        }
        return estimateNumbers;
    }

    @Transactional
    public LineEstimate cancel(LineEstimate lineEstimate) {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                this.estimateAppropriationService.releaseBudgetOnReject(led, null, null);
            }
        }
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            Long id = led.getId();
            AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByLineEstimateDetailsForCancelLineEstimate(id);
            if (abstractEstimate == null || !abstractEstimate.getActivities().isEmpty()) continue;
            abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
            abstractEstimate.getProjectCode().setActive(Boolean.FALSE);
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
    }

    public LineEstimate getLineEstimateByCouncilResolutionNumber(String councilResolutionNumber) {
        return this.lineEstimateRepository.findByCouncilResolutionNumberIgnoreCaseAndStatus_codeNotLike(councilResolutionNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByContractCommitteeApprovalNumber(String contractCommitteeApprovalNumber) {
        return this.lineEstimateRepository.findByContractCommitteeApprovalNumberIgnoreCaseAndStatus_codeNotLike(contractCommitteeApprovalNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByStandingCommitteeApprovalNumber(String standingCommitteeApprovalNumber) {
        return this.lineEstimateRepository.findByStandingCommitteeApprovalNumberIgnoreCaseAndStatus_codeNotLike(standingCommitteeApprovalNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByGovernmentApprovalNumber(String governmentApprovalNumber) {
        return this.lineEstimateRepository.findByGovernmentApprovalNumberIgnoreCaseAndStatus_codeNotLike(governmentApprovalNumber, "CANCELLED");
    }

    public String checkAbstractEstimatesWithBOQForLineEstimate(Long lineEstimateId) {
        List<String> listString = this.estimateService.getAbstractEstimateNumbersToCancelLineEstimate(lineEstimateId);
        String estimateNumbers = "";
        for (String estimateNumber : listString) {
            estimateNumbers = estimateNumbers + estimateNumber + ", ";
        }
        if (estimateNumbers.equals("")) {
            return "";
        }
        return estimateNumbers;
    }

    public List<String> getEstimateNumbersForEstimatePhotograph(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForEstimatePhotograph("%" + estimateNumber + "%", "CANCELLED");
    }

    public List<String> getWinForEstimatePhotograph(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findWorkIdentificationNumberForEstimatePhotograph("%" + workIdentificationNumber + "%", "CANCELLED");
    }

    public List<LineEstimateDetails> searchLineEstimatesForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClauseForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        Query query = this.setParameterForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        List lineEstimateDetailsList = query.getResultList();
        return lineEstimateDetailsList;
    }

    private void buildWhereClauseForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        queryStr.append("select distinct led from LineEstimateDetails as led where led.lineEstimate.status.code != :lineEstimateStatus ");
        if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
            queryStr.append(" and led.lineEstimate.executingDepartment.id = :executingDepartment");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
            queryStr.append(" and upper(led.projectCode.code) = :workIdentificationNumber");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getEstimateNumber())) {
            queryStr.append(" and upper(led.estimateNumber) = :estimateNumber");
        }
        if (estimatePhotographSearchRequest.getFromDate() != null) {
            queryStr.append(" and led.lineEstimate.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getToDate() != null) {
            queryStr.append(" and led.lineEstimate.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
            queryStr.append(" and led.lineEstimate.natureOfWork.id = :natureOfWork");
        }
    }

    private Query setParameterForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("lineEstimateStatus", (Object)"CANCELLED");
        if (estimatePhotographSearchRequest != null) {
            if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
                qry.setParameter("executingDepartment", (Object)estimatePhotographSearchRequest.getExecutingDepartment());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
                qry.setParameter("workIdentificationNumber", (Object)estimatePhotographSearchRequest.getWorkIdentificationNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getEstimateNumber())) {
                qry.setParameter("estimateNumber", (Object)estimatePhotographSearchRequest.getEstimateNumber().toUpperCase());
            }
            if (estimatePhotographSearchRequest.getFromDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getFromDate());
            }
            if (estimatePhotographSearchRequest.getToDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getToDate());
            }
            if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
                qry.setParameter("natureOfWork", (Object)estimatePhotographSearchRequest.getNatureOfWork());
            }
        }
        return qry;
    }

    public Map<String, Object> getWorkFlowLevelFields(LineEstimate lineEstimate) {
        String cityGrade = (String)this.cityService.cityDataAsMap().get("cityGrade");
        return (Map)this.scriptService.executeScript("LINEESTIMATE-APPROVALRULES", ScriptService.createContext((Object[])new Object[]{"estimateAmount", lineEstimate.getTotalEstimateAmount(), "cityGrade", cityGrade}));
    }

    public void validateAdminSanctionFields(LineEstimate lineEstimate, BindingResult errors) {
        if (StringUtils.isBlank((String)lineEstimate.getCouncilResolutionNumber())) {
            errors.rejectValue("councilResolutionNumber", "error.councilResolutionNumber.required");
        } else {
            LineEstimate LEByCouncilResolutionNumber = this.getLineEstimateByCouncilResolutionNumber(lineEstimate.getCouncilResolutionNumber());
            if (LEByCouncilResolutionNumber != null) {
                errors.rejectValue("councilResolutionNumber", "error.councilresolutionnumber.unique");
            }
            if (lineEstimate.getCouncilResolutionDate() == null) {
                errors.rejectValue("councilResolutionDate", "error.councilResolutionDate.required");
            }
        }
    }

    public void validateLineEstimateDetails(LineEstimate lineEstimate, BindingResult errors) {
        BigDecimal estimateAmount = BigDecimal.ZERO;
        for (LineEstimateDetails led : lineEstimate.getTempLineEstimateDetails()) {
            estimateAmount = estimateAmount.add(led.getEstimateAmount());
        }
        List nominationLimit = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_AMOUNT_LIMIT");
        AppConfigValues value = (AppConfigValues)nominationLimit.get(0);
        List<AppConfigValues> nominationName = this.estimateService.getNominationName();
        if (value.getValue() != null && !value.getValue().isEmpty() && lineEstimate.getModeOfAllotment().equalsIgnoreCase(!nominationName.isEmpty() ? nominationName.get(0).getValue() : "") && Double.parseDouble(estimateAmount.toString()) > Double.parseDouble(value.getValue())) {
            errors.reject("error.lineestimate.modeofentrustment", (Object[])new String[]{!nominationName.isEmpty() ? nominationName.get(0).getValue() : "", estimateAmount.toString()}, "error.lineestimate.modeofentrustment");
        }
    }

    public void loadModelValues(LineEstimate lineEstimate, Model model) {
        List nominationName;
        List nominationLimit = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_AMOUNT_LIMIT");
        AppConfigValues value = (AppConfigValues)nominationLimit.get(0);
        if (!value.getValue().isEmpty()) {
            model.addAttribute("nominationLimit", (Object)value.getValue());
        }
        model.addAttribute("nominationName", (Object)(!(nominationName = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_NAME")).isEmpty() ? ((AppConfigValues)nominationName.get(0)).getValue() : ""));
    }

    private void mergeLineEstimateDetails(LineEstimate lineEstimate) {
        for (LineEstimateDetails details : lineEstimate.getTempLineEstimateDetails()) {
            if (details.getId() == null) {
                details.setLineEstimate(lineEstimate);
                lineEstimate.getLineEstimateDetails().add(details);
                continue;
            }
            for (LineEstimateDetails oldDetails : lineEstimate.getLineEstimateDetails()) {
                if (!oldDetails.getId().equals(details.getId())) continue;
                this.updateLineEstimateDetailsValues(oldDetails, details);
            }
        }
    }

    public void updateLineEstimateDetailsValues(LineEstimateDetails oldDetails, LineEstimateDetails details) {
        oldDetails.setNameOfWork(details.getNameOfWork());
        oldDetails.setUom(details.getUom());
        oldDetails.setEstimateAmount(details.getEstimateAmount());
        oldDetails.setBeneficiary(details.getBeneficiary());
        oldDetails.setQuantity(details.getQuantity());
    }

    public List getLineEstimateHiddenFields() {
        return Arrays.asList(this.worksApplicationProperties.lineEstimateHideFields());
    }

    public String getLineEstimateMultipleWorkDetailsAllowed() {
        return this.worksApplicationProperties.lineEstimateMultipleWorkDetailsAllowed();
    }
}

