/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.util.List;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.works.abstractestimate.entity.ProjectCode;
import org.egov.works.abstractestimate.service.ProjectCodeService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.WorkIdentificationNumberGenerator;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LineEstimateDetailService {
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    @Qualifier(value="projectCodeService")
    private ProjectCodeService projectCodeService;
    @Autowired
    private WorkIdentificationNumberGenerator workIdentificationNumberGenerator;
    @Autowired
    private WorksUtils worksUtils;

    @Autowired
    public LineEstimateDetailService(LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
    }

    @Transactional
    public void save(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.save((Object)lineEstimateDetails);
    }

    @Transactional
    public void update(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.saveAndFlush((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.delete((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(List<LineEstimateDetails> lineEstimateDetailsList) {
        this.lineEstimateDetailsRepository.delete(lineEstimateDetailsList);
    }

    public LineEstimateDetails getById(Long id) {
        return (LineEstimateDetails)((Object)this.lineEstimateDetailsRepository.findOne(id));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void setProjectCode(LineEstimateDetails lineEstimateDetails) {
        ProjectCode projectCode = null;
        if (lineEstimateDetails.getProjectCode() != null && lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            projectCode = lineEstimateDetails.getProjectCode();
            projectCode.setCode(lineEstimateDetails.getProjectCode().getCode());
        } else {
            projectCode = new ProjectCode();
            projectCode.setCode(this.workIdentificationNumberGenerator.generateWorkOrderIdentificationNumber(lineEstimateDetails));
            lineEstimateDetails.setProjectCode(projectCode);
        }
        projectCode.setCodeName(lineEstimateDetails.getNameOfWork());
        projectCode.setDescription(lineEstimateDetails.getNameOfWork());
        projectCode.setActive(true);
        projectCode.setEgwStatus(this.worksUtils.getStatusByModuleAndCode(ProjectCode.class.getSimpleName(), "CREATED"));
        this.projectCodeService.applyAuditing(projectCode);
        this.projectCodeService.persist((Object)projectCode);
        this.createAccountDetailKey(projectCode);
    }

    protected void createAccountDetailKey(ProjectCode proj) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("PROJECTCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(proj.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public LineEstimateDetails findLineEstimateByEstimateNumber(String estimatenumber, String status) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeEquals(estimatenumber, status);
    }

    public LineEstimateDetails getLineEstimateDetailsByProjectCode(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findByProjectCode_codeAndLineEstimate_Status_CodeNotLike(workIdentificationNumber, "CANCELLED");
    }

    public LineEstimateDetails getLineEstimateDetailsByEstimateNumber(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeNot(estimateNumber, "CANCELLED");
    }
}

