/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.budget.BudgetUsage;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.autonumber.BudgetAppropriationNumberGenerator;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.EstimateAppropriationRepository;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EstimateAppropriationService {
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private EstimateAppropriationRepository estimateAppropriationRepository;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;

    @Autowired
    public EstimateAppropriationService(LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
    }

    @Transactional
    public void save(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.save((Object)lineEstimateDetails);
    }

    @Transactional
    public void update(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.saveAndFlush((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.delete((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(List<LineEstimateDetails> lineEstimateDetailsList) {
        this.lineEstimateDetailsRepository.delete(lineEstimateDetailsList);
    }

    public LineEstimateDetails getById(Long id) {
        return (LineEstimateDetails)((Object)this.lineEstimateDetailsRepository.findOne(id));
    }

    public EstimateAppropriation findLatestByLineEstimateDetails(LineEstimateDetails lineEstimateDetails) {
        return this.estimateAppropriationRepository.findLatestByLineEstimateDetails(lineEstimateDetails);
    }

    public EstimateAppropriation findLatestByAbstractEstimate(AbstractEstimate abstractEstimate) {
        return this.estimateAppropriationRepository.findLatestByAbstractEstimate(abstractEstimate);
    }

    public EstimateAppropriation findLatestByAbstractEstimate(Long abstractEstimateId) {
        return this.estimateAppropriationRepository.findLatestByAbstractEstimate_Id(abstractEstimateId);
    }

    public EstimateAppropriation findLatestByBudgetUsage(Long budgetUsageId) {
        return this.estimateAppropriationRepository.findByBudgetUsage_Id(budgetUsageId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public String generateBudgetAppropriationNumber(Date estimateDate) {
        BudgetAppropriationNumberGenerator e = (BudgetAppropriationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BudgetAppropriationNumberGenerator.class);
        String budgetAppropriationNumber = e.getNextNumber(estimateDate);
        return budgetAppropriationNumber;
    }

    @Transactional
    public boolean checkConsumeEncumbranceBudgetForLineEstimate(LineEstimateDetails lineEstimateDetails, Long finyrId, double budgApprAmnt, List<Long> budgetheadid) {
        boolean flag = true;
        BudgetUsage budgetUsage = null;
        LineEstimate lineEstimate = lineEstimateDetails.getLineEstimate();
        budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(this.generateBudgetAppropriationNumber(lineEstimate.getLineEstimateDate()), finyrId, Integer.valueOf(11), lineEstimateDetails.getEstimateNumber(), Integer.valueOf(Integer.parseInt(lineEstimate.getExecutingDepartment().getId().toString())), lineEstimate.getFunction() == null ? null : lineEstimate.getFunction().getId(), null, lineEstimate.getScheme() == null ? null : lineEstimate.getScheme().getId(), lineEstimate.getSubScheme() == null ? null : lineEstimate.getSubScheme().getId(), lineEstimate.getWard() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getWard().getId().toString())), budgetheadid, lineEstimate.getFund() == null ? null : lineEstimate.getFund().getId(), budgApprAmnt);
        if (budgetUsage == null) {
            return false;
        }
        this.persistBudgetAppropriationDetails(lineEstimateDetails, null, budgetUsage);
        return true;
    }

    @Transactional
    public void persistBudgetAppropriationDetails(LineEstimateDetails lineEstimateDetails, AbstractEstimate abstractEstimate, BudgetUsage budgetUsage) {
        EstimateAppropriation lineEstimateAppropriation = null;
        lineEstimateAppropriation = lineEstimateDetails != null ? this.findLatestByLineEstimateDetails(lineEstimateDetails) : this.findLatestByAbstractEstimate(abstractEstimate);
        if (lineEstimateAppropriation != null) {
            lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        } else {
            lineEstimateAppropriation = new EstimateAppropriation();
            if (lineEstimateDetails != null) {
                lineEstimateAppropriation.setLineEstimateDetails(lineEstimateDetails);
            } else {
                lineEstimateAppropriation.setAbstractEstimate(abstractEstimate);
            }
            lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        }
        this.estimateAppropriationRepository.save((Object)lineEstimateAppropriation);
    }

    @Transactional
    public boolean checkConsumeEncumbranceBudgetForAbstractEstimate(AbstractEstimate abstractEstimate, Long finyrId, double budgApprAmnt, List<Long> budgetheadid) {
        boolean flag = true;
        BudgetUsage budgetUsage = null;
        FinancialDetail financialDetail = abstractEstimate.getFinancialDetails().get(0);
        budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(this.generateBudgetAppropriationNumber(abstractEstimate.getEstimateDate()), finyrId, Integer.valueOf(11), abstractEstimate.getEstimateNumber(), Integer.valueOf(Integer.parseInt(abstractEstimate.getExecutingDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), abstractEstimate.getWard() == null ? null : Integer.valueOf(Integer.parseInt(abstractEstimate.getWard().getId().toString())), budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), budgApprAmnt);
        if (budgetUsage == null) {
            return false;
        }
        this.persistBudgetAppropriationDetails(null, abstractEstimate, budgetUsage);
        return true;
    }

    @Transactional
    public boolean checkConsumeEncumbranceBudgetForRevisionEstimate(RevisionAbstractEstimate revisionAbstractEstimate, Long finyrId, double budgApprAmnt, List<Long> budgetheadid) {
        boolean flag = true;
        BudgetUsage budgetUsage = null;
        FinancialDetail financialDetail = revisionAbstractEstimate.getParent().getFinancialDetails().get(0);
        budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(this.generateBudgetAppropriationNumber(revisionAbstractEstimate.getEstimateDate()), finyrId, Integer.valueOf(11), revisionAbstractEstimate.getEstimateNumber(), Integer.valueOf(Integer.parseInt(revisionAbstractEstimate.getParent().getExecutingDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), revisionAbstractEstimate.getParent().getWard() == null ? null : Integer.valueOf(Integer.parseInt(revisionAbstractEstimate.getParent().getWard().getId().toString())), budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), budgApprAmnt);
        if (budgetUsage == null) {
            return false;
        }
        this.persistBudgetAppropriationDetails(null, revisionAbstractEstimate, budgetUsage);
        return true;
    }

    @Transactional
    public boolean releaseBudgetOnReject(LineEstimateDetails lineEstimateDetails, Double budgApprAmnt, String appropriationnumber) throws ValidationException {
        EstimateAppropriation lineEstimateAppropriation = this.estimateAppropriationRepository.findLatestByLineEstimateDetails(lineEstimateDetails);
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
        BudgetUsage budgetUsage = null;
        boolean flag = true;
        if (lineEstimateAppropriation != null) {
            if (budgApprAmnt == null) {
                budgApprAmnt = lineEstimateAppropriation.getBudgetUsage().getConsumedAmount();
            }
            if (appropriationnumber == null) {
                appropriationnumber = lineEstimateAppropriation.getBudgetUsage().getAppropriationnumber();
            }
            BudgetAppropriationNumberGenerator b = (BudgetAppropriationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BudgetAppropriationNumberGenerator.class);
            budgetUsage = this.budgetDetailsDAO.releaseEncumbranceBudget(lineEstimateAppropriation.getBudgetUsage() == null ? null : b.generateCancelledBudgetAppropriationNumber(appropriationnumber), Long.valueOf(lineEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), lineEstimateAppropriation.getLineEstimateDetails().getEstimateNumber(), Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getExecutingDepartment().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction().getId(), null, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getBudgetHead() == null ? null : budgetheadid, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund().getId(), budgApprAmnt.doubleValue());
            if (budgetUsage != null) {
                this.persistBudgetReleaseDetails(lineEstimateDetails, null, budgetUsage);
            } else {
                return false;
            }
        }
        return true;
    }

    @Transactional
    public boolean releaseBudgetOnRejectForEstimate(AbstractEstimate abstractEstimate, Double budgApprAmnt, String appropriationnumber) throws ValidationException {
        EstimateAppropriation estimateAppropriation = this.estimateAppropriationRepository.findLatestByAbstractEstimate(abstractEstimate);
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        if (abstractEstimate.getParent() != null) {
            budgetheadid.add(abstractEstimate.getParent().getFinancialDetails().get(0).getBudgetGroup().getId());
        } else {
            budgetheadid.add(abstractEstimate.getFinancialDetails().get(0).getBudgetGroup().getId());
        }
        BudgetUsage budgetUsage = null;
        boolean flag = true;
        if (estimateAppropriation != null) {
            if (budgApprAmnt == null) {
                budgApprAmnt = estimateAppropriation.getBudgetUsage().getConsumedAmount();
            }
            if (appropriationnumber == null) {
                appropriationnumber = estimateAppropriation.getBudgetUsage().getAppropriationnumber();
            }
            BudgetAppropriationNumberGenerator b = (BudgetAppropriationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BudgetAppropriationNumberGenerator.class);
            budgetUsage = abstractEstimate.getParent() == null ? this.budgetDetailsDAO.releaseEncumbranceBudget(estimateAppropriation.getBudgetUsage() == null ? null : b.generateCancelledBudgetAppropriationNumber(appropriationnumber), Long.valueOf(estimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), estimateAppropriation.getAbstractEstimate().getEstimateNumber(), Integer.valueOf(Integer.parseInt(estimateAppropriation.getAbstractEstimate().getExecutingDepartment().getId().toString())), estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getFunction() == null ? null : estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getFunction().getId(), null, estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getScheme() == null ? null : estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getScheme().getId(), estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getSubScheme() == null ? null : estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getSubScheme().getId(), estimateAppropriation.getAbstractEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(estimateAppropriation.getAbstractEstimate().getWard().getId().toString())), estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getBudgetGroup() == null ? null : budgetheadid, estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getFund() == null ? null : estimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0).getFund().getId(), budgApprAmnt.doubleValue()) : this.budgetDetailsDAO.releaseEncumbranceBudget(estimateAppropriation.getBudgetUsage() == null ? null : b.generateCancelledBudgetAppropriationNumber(appropriationnumber), Long.valueOf(estimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), estimateAppropriation.getAbstractEstimate().getEstimateNumber(), Integer.valueOf(Integer.parseInt(estimateAppropriation.getAbstractEstimate().getParent().getExecutingDepartment().getId().toString())), estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getFunction() == null ? null : estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getFunction().getId(), null, estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getScheme() == null ? null : estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getScheme().getId(), estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getSubScheme() == null ? null : estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getSubScheme().getId(), estimateAppropriation.getAbstractEstimate().getParent().getWard() == null ? null : Integer.valueOf(Integer.parseInt(estimateAppropriation.getAbstractEstimate().getParent().getWard().getId().toString())), estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getBudgetGroup() == null ? null : budgetheadid, estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getFund() == null ? null : estimateAppropriation.getAbstractEstimate().getParent().getFinancialDetails().get(0).getFund().getId(), budgApprAmnt.doubleValue());
            if (budgetUsage != null) {
                this.persistBudgetReleaseDetails(null, abstractEstimate, budgetUsage);
            } else {
                return false;
            }
        }
        return true;
    }

    @Transactional
    private void persistBudgetReleaseDetails(LineEstimateDetails lineEstimateDetails, AbstractEstimate abstractEstimate, BudgetUsage budgetUsage) {
        EstimateAppropriation lineEstimateAppropriation = null;
        lineEstimateAppropriation = lineEstimateDetails != null ? this.estimateAppropriationRepository.findLatestByLineEstimateDetails(lineEstimateDetails) : this.estimateAppropriationRepository.findLatestByAbstractEstimate(abstractEstimate);
        lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        this.estimateAppropriationRepository.save((Object)lineEstimateAppropriation);
    }
}

