/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.budget.BudgetGroup;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.masters.entity.NatureOfWork;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_LINEESTIMATE")
@Unique(id="id", tableName="EGW_LINEESTIMATE", columnName={"lineestimatenumber"}, fields={"lineEstimateNumber"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGW_LINEESTIMATE", sequenceName="SEQ_EGW_LINEESTIMATE", allocationSize=1)
public class LineEstimate
extends StateAware {
    private static final long serialVersionUID = -366602348464540736L;
    public static final String SEQ_EGW_LINEESTIMATE = "SEQ_EGW_LINEESTIMATE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_LINEESTIMATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    @Length(max=50)
    @Column(unique=true)
    private String lineEstimateNumber;
    @SafeHtml
    @Length(max=256)
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="lineestimate.subject.alphaNumeric")
    private String subject;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fund", nullable=false)
    private Fund fund;
    @NotNull
    @SafeHtml
    @Length(max=1024)
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="lineestimate.reference.alphaNumeric")
    private String reference;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="function", nullable=false)
    private CFunction function;
    @SafeHtml
    @Length(max=1024)
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="lineestimate.description.alphaNumeric")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="budgethead", nullable=false)
    private BudgetGroup budgetHead;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scheme")
    private Scheme scheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subscheme")
    private SubScheme subScheme;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date lineEstimateDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="executingdepartment", nullable=false)
    private Department executingDepartment;
    @SafeHtml
    @Length(max=50)
    private String adminSanctionNumber;
    @Temporal(value=TemporalType.DATE)
    private Date adminSanctionDate;
    private String adminSanctionBy;
    @OrderBy(value="id")
    @OneToMany(mappedBy="lineEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=LineEstimateDetails.class)
    private final List<LineEstimateDetails> lineEstimateDetails = new ArrayList<LineEstimateDetails>(0);
    private final transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Enumerated(value=EnumType.STRING)
    private Beneficiary beneficiary;
    @NotNull
    private String modeOfAllotment;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="typeofwork")
    private EgwTypeOfWork typeOfWork;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subtypeofwork")
    private EgwTypeOfWork subTypeOfWork;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="natureofwork", nullable=false)
    private NatureOfWork natureOfWork;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ward", nullable=false)
    private Boundary ward;
    @SafeHtml
    @Length(max=50)
    private String technicalSanctionNumber;
    @Temporal(value=TemporalType.DATE)
    private Date technicalSanctionDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="technicalSanctionBy")
    private User technicalSanctionBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="location")
    private Boundary location;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private WorkCategory workCategory;
    private String councilResolutionNumber;
    @Temporal(value=TemporalType.DATE)
    private Date councilResolutionDate;
    private boolean workOrderCreated;
    private boolean billsCreated;
    private boolean spillOverFlag;
    private String cancellationReason;
    private String cancellationRemarks;
    private boolean abstractEstimateCreated;
    private String contractCommitteeApprovalNumber;
    @Temporal(value=TemporalType.DATE)
    private Date contractCommitteeApprovalDate;
    private String standingCommitteeApprovalNumber;
    @Temporal(value=TemporalType.DATE)
    private Date standingCommitteeApprovalDate;
    private String governmentApprovalNumber;
    @Temporal(value=TemporalType.DATE)
    private Date governmentApprovalDate;
    @Transient
    private List<LineEstimateDetails> tempLineEstimateDetails = new ArrayList<LineEstimateDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLineEstimateNumber() {
        return this.lineEstimateNumber;
    }

    public void setLineEstimateNumber(String lineEstimateNumber) {
        this.lineEstimateNumber = lineEstimateNumber;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BudgetGroup getBudgetHead() {
        return this.budgetHead;
    }

    public void setBudgetHead(BudgetGroup budgetHead) {
        this.budgetHead = budgetHead;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public SubScheme getSubScheme() {
        return this.subScheme;
    }

    public void setSubScheme(SubScheme subScheme) {
        this.subScheme = subScheme;
    }

    public Date getLineEstimateDate() {
        return this.lineEstimateDate;
    }

    public void setLineEstimateDate(Date lineEstimateDate) {
        this.lineEstimateDate = lineEstimateDate;
    }

    public Department getExecutingDepartment() {
        return this.executingDepartment;
    }

    public void setExecutingDepartment(Department executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public List<LineEstimateDetails> getLineEstimateDetails() {
        return this.lineEstimateDetails;
    }

    public void setLineEstimateDetails(List<LineEstimateDetails> lineEstimateDetails) {
        this.lineEstimateDetails.clear();
        if (lineEstimateDetails != null) {
            this.lineEstimateDetails.addAll(lineEstimateDetails);
        }
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getStateDetails() {
        return "Estimate Number : " + this.getLineEstimateNumber();
    }

    public String getAdminSanctionNumber() {
        return this.adminSanctionNumber;
    }

    public void setAdminSanctionNumber(String adminSanctionNumber) {
        this.adminSanctionNumber = adminSanctionNumber;
    }

    public Date getAdminSanctionDate() {
        return this.adminSanctionDate;
    }

    public void setAdminSanctionDate(Date adminSanctionDate) {
        this.adminSanctionDate = adminSanctionDate;
    }

    public Beneficiary getBeneficiary() {
        return this.beneficiary;
    }

    public void setBeneficiary(Beneficiary beneficiary) {
        this.beneficiary = beneficiary;
    }

    public String getModeOfAllotment() {
        return this.modeOfAllotment;
    }

    public void setModeOfAllotment(String modeOfAllotment) {
        this.modeOfAllotment = modeOfAllotment;
    }

    public EgwTypeOfWork getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(EgwTypeOfWork typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public NatureOfWork getNatureOfWork() {
        return this.natureOfWork;
    }

    public void setNatureOfWork(NatureOfWork natureOfWork) {
        this.natureOfWork = natureOfWork;
    }

    public Boundary getWard() {
        return this.ward;
    }

    public void setWard(Boundary ward) {
        this.ward = ward;
    }

    public EgwTypeOfWork getSubTypeOfWork() {
        return this.subTypeOfWork;
    }

    public void setSubTypeOfWork(EgwTypeOfWork subTypeOfWork) {
        this.subTypeOfWork = subTypeOfWork;
    }

    public Boundary getLocation() {
        return this.location;
    }

    public void setLocation(Boundary location) {
        this.location = location;
    }

    public WorkCategory getWorkCategory() {
        return this.workCategory;
    }

    public void setWorkCategory(WorkCategory workCategory) {
        this.workCategory = workCategory;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public String getTechnicalSanctionNumber() {
        return this.technicalSanctionNumber;
    }

    public void setTechnicalSanctionNumber(String technicalSanctionNumber) {
        this.technicalSanctionNumber = technicalSanctionNumber;
    }

    public Date getTechnicalSanctionDate() {
        return this.technicalSanctionDate;
    }

    public void setTechnicalSanctionDate(Date technicalSanctionDate) {
        this.technicalSanctionDate = technicalSanctionDate;
    }

    public User getTechnicalSanctionBy() {
        return this.technicalSanctionBy;
    }

    public void setTechnicalSanctionBy(User technicalSanctionBy) {
        this.technicalSanctionBy = technicalSanctionBy;
    }

    public String getCouncilResolutionNumber() {
        return this.councilResolutionNumber;
    }

    public void setCouncilResolutionNumber(String councilResolutionNumber) {
        this.councilResolutionNumber = councilResolutionNumber;
    }

    public Date getCouncilResolutionDate() {
        return this.councilResolutionDate;
    }

    public void setCouncilResolutionDate(Date councilResolutionDate) {
        this.councilResolutionDate = councilResolutionDate;
    }

    public boolean isWorkOrderCreated() {
        return this.workOrderCreated;
    }

    public void setWorkOrderCreated(boolean workOrderCreated) {
        this.workOrderCreated = workOrderCreated;
    }

    public boolean isBillsCreated() {
        return this.billsCreated;
    }

    public void setBillsCreated(boolean billsCreated) {
        this.billsCreated = billsCreated;
    }

    public boolean isSpillOverFlag() {
        return this.spillOverFlag;
    }

    public void setSpillOverFlag(boolean spillOverFlag) {
        this.spillOverFlag = spillOverFlag;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public boolean isAbstractEstimateCreated() {
        return this.abstractEstimateCreated;
    }

    public void setAbstractEstimateCreated(boolean abstractEstimateCreated) {
        this.abstractEstimateCreated = abstractEstimateCreated;
    }

    public BigDecimal getTotalEstimateAmount() {
        BigDecimal totalEstimateAmount = BigDecimal.ZERO;
        for (LineEstimateDetails lineEstimateDetails : this.lineEstimateDetails) {
            totalEstimateAmount = totalEstimateAmount.add(lineEstimateDetails.getEstimateAmount());
        }
        return totalEstimateAmount;
    }

    public String getContractCommitteeApprovalNumber() {
        return this.contractCommitteeApprovalNumber;
    }

    public void setContractCommitteeApprovalNumber(String contractCommitteeApprovalNumber) {
        this.contractCommitteeApprovalNumber = contractCommitteeApprovalNumber;
    }

    public Date getContractCommitteeApprovalDate() {
        return this.contractCommitteeApprovalDate;
    }

    public void setContractCommitteeApprovalDate(Date contractCommitteeApprovalDate) {
        this.contractCommitteeApprovalDate = contractCommitteeApprovalDate;
    }

    public String getGovernmentApprovalNumber() {
        return this.governmentApprovalNumber;
    }

    public void setGovernmentApprovalNumber(String governmentApprovalNumber) {
        this.governmentApprovalNumber = governmentApprovalNumber;
    }

    public String getStandingCommitteeApprovalNumber() {
        return this.standingCommitteeApprovalNumber;
    }

    public void setStandingCommitteeApprovalNumber(String standingCommitteeApprovalNumber) {
        this.standingCommitteeApprovalNumber = standingCommitteeApprovalNumber;
    }

    public Date getStandingCommitteeApprovalDate() {
        return this.standingCommitteeApprovalDate;
    }

    public void setStandingCommitteeApprovalDate(Date standingCommitteeApprovalDate) {
        this.standingCommitteeApprovalDate = standingCommitteeApprovalDate;
    }

    public Date getGovernmentApprovalDate() {
        return this.governmentApprovalDate;
    }

    public void setGovernmentApprovalDate(Date governmentApprovalDate) {
        this.governmentApprovalDate = governmentApprovalDate;
    }

    public List<LineEstimateDetails> getTempLineEstimateDetails() {
        return this.tempLineEstimateDetails;
    }

    public void setTempLineEstimateDetails(List<LineEstimateDetails> tempLineEstimateDetails) {
        this.tempLineEstimateDetails = tempLineEstimateDetails;
    }

    public String getAdminSanctionBy() {
        return this.adminSanctionBy;
    }

    public void setAdminSanctionBy(String adminSanctionBy) {
        this.adminSanctionBy = adminSanctionBy;
    }
}

