/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorportal.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.infra.messaging.MessagePriority;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.token.service.TokenService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.works.autonumber.ContractorMBNumberGenerator;
import org.egov.works.contractorportal.entity.ContractorMBDetails;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.egov.works.contractorportal.entity.ContractorMBMeasurementSheet;
import org.egov.works.contractorportal.repository.ContractorMBHeaderRepository;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class ContractorMBHeaderService {
    private static final String CONTRACTOR_MB_SERVICE = "Contractor Measurement Book";
    @PersistenceContext
    private EntityManager entityManager;
    private final ContractorMBHeaderRepository contractorMBHeaderRepository;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private MessagingService messagingService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ContractorMBHeaderService(ContractorMBHeaderRepository contractorMBHeaderRepository) {
        this.contractorMBHeaderRepository = contractorMBHeaderRepository;
    }

    public ContractorMBHeader getContractorMBHeaderById(Long id) {
        return (ContractorMBHeader)((Object)this.contractorMBHeaderRepository.findOne(id));
    }

    public List<ContractorMBHeader> getContractorMBHeaderByWorkOrderEstimateId(Long id) {
        return this.contractorMBHeaderRepository.findByWorkOrderEstimate_Id(id);
    }

    @Transactional
    public ContractorMBHeader create(ContractorMBHeader contractorMBHeader, MultipartFile[] files) throws IOException {
        ArrayList<ContractorMBDetails> filteredDetails = new ArrayList<ContractorMBDetails>();
        for (ContractorMBDetails details : contractorMBHeader.getContractorMBDetails()) {
            if (!(details.getAmount() > 0.0)) continue;
            details.setWorkOrderActivity(this.workOrderActivityService.getWorkOrderActivityById(details.getWorkOrderActivity().getId()));
            for (ContractorMBMeasurementSheet cmbms : details.getMeasurementSheets()) {
                cmbms.setContractorMBDetails(details);
            }
            details.setContractorMBHeader(contractorMBHeader);
            filteredDetails.add(details);
        }
        contractorMBHeader.setContractorMBDetails(filteredDetails);
        contractorMBHeader.setMbDate(new Date());
        this.mergeAdditionalItemDetails(contractorMBHeader);
        CFinancialYear financialYear = this.worksUtils.getFinancialYearByDate(contractorMBHeader.getMbDate());
        ContractorMBNumberGenerator numberGenerator = (ContractorMBNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ContractorMBNumberGenerator.class);
        contractorMBHeader.setMbRefNo(numberGenerator.getNextNumber(contractorMBHeader, financialYear));
        ContractorMBHeader savedContractorMBHeader = (ContractorMBHeader)((Object)this.contractorMBHeaderRepository.save((Object)contractorMBHeader));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)savedContractorMBHeader, "ContractorMBHeader");
        if (!documentDetails.isEmpty()) {
            savedContractorMBHeader.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedContractorMBHeader;
    }

    public void populateContractorMBDetails(ContractorMBHeader contractorMBHeader) {
        List<WorkOrderActivity> workOrderActivities = this.workOrderActivityService.getWorkOrderActivitiesForContractorPortal(contractorMBHeader.getWorkOrderEstimate().getWorkOrder().getId());
        ArrayList<WorkOrderActivity> mergedActivities = new ArrayList<WorkOrderActivity>();
        for (WorkOrderActivity workOrderActivity : workOrderActivities) {
            if (workOrderActivity.getActivity().getParent() != null) continue;
            mergedActivities.add(workOrderActivity);
        }
        for (WorkOrderActivity workOrderActivity : workOrderActivities) {
            for (WorkOrderActivity activity : mergedActivities) {
                if (workOrderActivity.getActivity().getParent() == null || activity.getActivity().getId() != workOrderActivity.getActivity().getParent().getId()) continue;
                activity.setApprovedQuantity(activity.getApprovedQuantity() + workOrderActivity.getApprovedQuantity());
            }
        }
        if (contractorMBHeader.getContractorMBDetails().isEmpty()) {
            for (WorkOrderActivity activity : mergedActivities) {
                ContractorMBDetails details = new ContractorMBDetails();
                details.setWorkOrderActivity(activity);
                details.setRate(activity.getApprovedRate());
                contractorMBHeader.getContractorMBDetails().add(details);
            }
        } else {
            for (ContractorMBDetails contractorMBDetails : contractorMBHeader.getContractorMBDetails()) {
                WorkOrderActivity woa = this.workOrderActivityService.getWorkOrderActivityById(contractorMBDetails.getWorkOrderActivity().getId());
                contractorMBDetails.setWorkOrderActivity(woa);
                contractorMBDetails.setRate(woa.getApprovedRate());
            }
        }
    }

    public String validateContractorMBHeader(ContractorMBHeader contractorMBHeader) {
        String message = "";
        boolean quantityExists = false;
        boolean additionalQuantityExists = false;
        for (ContractorMBDetails contractorMBDetails : contractorMBHeader.getContractorMBDetails()) {
            if (!(contractorMBDetails.getQuantity() > 0.0)) continue;
            quantityExists = true;
        }
        for (ContractorMBDetails contractorMBDetails : contractorMBHeader.getAdditionalMBDetails()) {
            if (!(contractorMBDetails.getQuantity() > 0.0)) continue;
            additionalQuantityExists = true;
        }
        if (!quantityExists && !additionalQuantityExists) {
            message = this.messageSource.getMessage("error.mbdetails.quantity.zero", (Object[])new String[0], null);
        }
        return message;
    }

    @Transactional
    public Boolean sendOTPMessage(String mobileNumber) {
        String otp = RandomStringUtils.randomNumeric((int)5);
        this.tokenService.generate(otp, mobileNumber, CONTRACTOR_MB_SERVICE);
        this.messagingService.sendSMS(mobileNumber, this.messageSource.getMessage("contractormb.otp.sms", (Object[])new String[]{otp}, null), MessagePriority.HIGH);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean isValidOTP(String otp, String mobileNumber) {
        return this.tokenService.redeemToken(otp, mobileNumber, CONTRACTOR_MB_SERVICE);
    }

    private void mergeAdditionalItemDetails(ContractorMBHeader contractorMBHeader) {
        for (ContractorMBDetails details : contractorMBHeader.getAdditionalMBDetails()) {
            if (details.getId() != null) continue;
            this.removeEmptyMS(details);
            details.setContractorMBHeader(contractorMBHeader);
            for (ContractorMBMeasurementSheet ms : details.getMeasurementSheets()) {
                ms.setContractorMBDetails(details);
            }
            contractorMBHeader.getContractorMBDetails().add(details);
        }
    }

    private void removeEmptyMS(ContractorMBDetails details) {
        LinkedList<ContractorMBMeasurementSheet> toRemove = new LinkedList<ContractorMBMeasurementSheet>();
        for (ContractorMBMeasurementSheet ms : details.getMeasurementSheets()) {
            if (ms.getQuantity() != null && (ms.getQuantity() == null || !ms.getQuantity().equals(""))) continue;
            toRemove.add(ms);
        }
        for (ContractorMBMeasurementSheet msremove : toRemove) {
            details.getMeasurementSheets().remove((Object)msremove);
        }
    }
}

