/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorportal.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.common.entity.UOM;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.egov.works.contractorportal.entity.ContractorMBMeasurementSheet;
import org.egov.works.workorder.entity.WorkOrderActivity;

@Entity
@Table(name="EGW_CONTRACTOR_MB_DETAILS")
@SequenceGenerator(name="SEQ_EGW_CONTRACTOR_MB_DETAILS", sequenceName="SEQ_EGW_CONTRACTOR_MB_DETAILS", allocationSize=1)
public class ContractorMBDetails
extends AbstractAuditable {
    private static final long serialVersionUID = -5088074625605584344L;
    public static final String SEQ_EGW_CONTRACTOR_MB_DETAILS = "SEQ_EGW_CONTRACTOR_MB_DETAILS";
    @Id
    @GeneratedValue(generator="SEQ_EGW_CONTRACTOR_MB_DETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="mbdetails.mbheader.null")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTRACTOR_MBHEADER_ID", nullable=false)
    @JsonIgnore
    private ContractorMBHeader contractorMBHeader;
    @Required(message="mbdetails.activity.null")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WO_ACTIVITY_ID", nullable=true)
    @JsonIgnore
    private WorkOrderActivity workOrderActivity;
    @GreaterThan(value=0L, message="mbdetails.quantity.non.negative")
    private double quantity;
    private double rate;
    private double amount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="uom", nullable=true)
    private UOM uom;
    private String description;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contractorMBDetails", targetEntity=ContractorMBMeasurementSheet.class)
    @OrderBy(value="id")
    private List<ContractorMBMeasurementSheet> measurementSheets = new ArrayList<ContractorMBMeasurementSheet>();

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.contractorMBHeader != null && (this.contractorMBHeader.getId() == null || this.contractorMBHeader.getId() == 0L || this.contractorMBHeader.getId() == -1L)) {
            validationErrors.add(new ValidationError("mbHeader", "mbdetails.mbheader.null"));
        }
        if (this.workOrderActivity != null && (this.workOrderActivity.getId() == null || this.workOrderActivity.getId() == 0L || this.workOrderActivity.getId() == -1L)) {
            validationErrors.add(new ValidationError("workOrderActivity", "mbdetails.activity.null"));
        }
        return validationErrors;
    }

    public void setContractorMBHeader(ContractorMBHeader contractorMBHeader) {
        this.contractorMBHeader = contractorMBHeader;
    }

    public ContractorMBHeader getContractorMBHeader() {
        return this.contractorMBHeader;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public WorkOrderActivity getWorkOrderActivity() {
        return this.workOrderActivity;
    }

    public void setWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivity = workOrderActivity;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public List<ContractorMBMeasurementSheet> getMeasurementSheets() {
        return this.measurementSheets;
    }

    public void setMeasurementSheets(List<ContractorMBMeasurementSheet> measurementSheets) {
        this.measurementSheets = measurementSheets;
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uom) {
        this.uom = uom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

