/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorbill.entity;

import java.util.Date;
import java.util.List;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.works.workorder.entity.WorkOrderEstimate;

public class WorkCompletionInfo {
    private WorkOrderEstimate workOrderEstimate;
    private String mbNumbers;
    private Date workCommencedOnDate;
    private List<StateHistory> workflowHistory;

    public WorkCompletionInfo(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public WorkCompletionInfo() {
    }

    public WorkCompletionInfo(WorkOrderEstimate workOrderEstimate, String mbNumbers) {
        this.workOrderEstimate = workOrderEstimate;
        this.mbNumbers = mbNumbers;
    }

    public String getWorkName() {
        return this.workOrderEstimate.getEstimate().getName();
    }

    public String getEstimateNo() {
        return this.workOrderEstimate.getEstimate().getEstimateNumber();
    }

    public String getEstimateAmount() {
        return this.workOrderEstimate.getEstimate().getTotalAmount().getFormattedString();
    }

    public Double getEstimateAmountValue() {
        return this.workOrderEstimate.getEstimate().getTotalAmount().getValue();
    }

    public String getEstimateName() {
        return this.workOrderEstimate.getEstimate().getName();
    }

    public String getBudgetHeader() {
        return this.workOrderEstimate.getEstimate().getFinancialDetails() == null ? null : (this.workOrderEstimate.getEstimate().getFinancialDetails().get(0).getBudgetGroup() == null ? null : this.workOrderEstimate.getEstimate().getFinancialDetails().get(0).getBudgetGroup().getName());
    }

    public String getApprNo() {
        return "";
    }

    public String getProjectCode() {
        return this.workOrderEstimate.getEstimate().getProjectCode() == null ? null : this.workOrderEstimate.getEstimate().getProjectCode().getCode();
    }

    public String getContractorName() {
        return this.workOrderEstimate.getWorkOrder().getContractor().getName();
    }

    public String getAllMBNO() {
        return this.mbNumbers;
    }

    public Date getWorkCommencedOn() {
        return this.workCommencedOnDate;
    }

    public void setWorkCommencedOn(Date workCommencedOnDate) {
        this.workCommencedOnDate = workCommencedOnDate;
    }

    public Date getWorkCompletedDate() {
        return this.workOrderEstimate.getWorkCompletionDate();
    }

    public void setWorkflowHistory(List<StateHistory> workflowHistory) {
        this.workflowHistory = workflowHistory;
    }

    public List<StateHistory> getWorkflowHistory() {
        return this.workflowHistory;
    }
}

