/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorbill.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.infra.admin.master.entity.User;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.works.contractorbill.entity.AssetForBill;
import org.egov.works.contractorbill.entity.DeductionTypeForBill;
import org.egov.works.contractorbill.entity.StatutoryDeductionsForBill;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="EGW_CONTRACTORBILL")
@Audited
public class ContractorBillRegister
extends EgBillregister {
    private static final long serialVersionUID = -6056638534067396998L;
    private Integer billSequenceNumber;
    @Temporal(value=TemporalType.DATE)
    private Date approvedDate;
    @NotAudited
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="egbill", targetEntity=AssetForBill.class)
    private List<AssetForBill> assetDetailsList = new LinkedList<AssetForBill>();
    @NotAudited
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="egbill", targetEntity=DeductionTypeForBill.class)
    private List<DeductionTypeForBill> deductionTypeList = new LinkedList<DeductionTypeForBill>();
    @NotAudited
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="egBillReg", targetEntity=StatutoryDeductionsForBill.class)
    private List<StatutoryDeductionsForBill> statutoryDeductionsList = new LinkedList<StatutoryDeductionsForBill>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="approvedBy")
    private User approvedBy;
    @Transient
    private String owner;
    @Transient
    private List<String> billActions = new ArrayList<String>();
    private final transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    @Transient
    private List<EgBilldetails> billDetailes = new ArrayList<EgBilldetails>(0);
    @Transient
    private List<EgBilldetails> refundBillDetails = new ArrayList<EgBilldetails>(0);
    @Transient
    private List<EgBilldetails> statutoryDeductionDetailes = new ArrayList<EgBilldetails>(0);
    @Transient
    private List<EgBilldetails> otherDeductionDetailes = new ArrayList<EgBilldetails>(0);
    @Transient
    private List<EgBilldetails> retentionMoneyDeductionDetailes = new ArrayList<EgBilldetails>(0);
    @Transient
    private List<EgBilldetails> advanceAdjustmentDetails = new ArrayList<EgBilldetails>(0);
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Transient
    private MBHeader mbHeader;
    @Transient
    private Long[] mbHeaderIds;
    @NotAudited
    private String cancellationReason;
    @NotAudited
    private String cancellationRemarks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workOrderEstimate", nullable=false)
    @NotAudited
    private WorkOrderEstimate workOrderEstimate;

    public String getStateDetails() {
        return "Contractor Bill No: " + this.getBillnumber();
    }

    public List<AssetForBill> getAssetDetailsList() {
        return this.assetDetailsList;
    }

    public void setAssetDetailsList(List<AssetForBill> assetDetailsList) {
        this.assetDetailsList = assetDetailsList;
    }

    public void addAssetDetails(AssetForBill assetForBill) {
        this.assetDetailsList.add(assetForBill);
    }

    public void addDeductionType(DeductionTypeForBill deductionTypeForBill) {
        this.deductionTypeList.add(deductionTypeForBill);
    }

    public List<DeductionTypeForBill> getDeductionTypeList() {
        return this.deductionTypeList;
    }

    public void setDeductionTypeList(List<DeductionTypeForBill> deductionTypeList) {
        this.deductionTypeList = deductionTypeList;
    }

    public Integer getBillSequenceNumber() {
        return this.billSequenceNumber;
    }

    public void setBillSequenceNumber(Integer billSequenceNumber) {
        this.billSequenceNumber = billSequenceNumber;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getBillActions() {
        return this.billActions;
    }

    public void setBillActions(List<String> billActions) {
        this.billActions = billActions;
    }

    public List<StatutoryDeductionsForBill> getStatutoryDeductionsList() {
        return this.statutoryDeductionsList;
    }

    public List<EgBilldetails> getAdvanceAdjustmentDetails() {
        return this.advanceAdjustmentDetails;
    }

    public void setAdvanceAdjustmentDetails(List<EgBilldetails> advanceAdjustmentDetails) {
        this.advanceAdjustmentDetails = advanceAdjustmentDetails;
    }

    public void setStatutoryDeductionsList(List<StatutoryDeductionsForBill> statutoryDeductionsList) {
        this.statutoryDeductionsList = statutoryDeductionsList;
    }

    public void addStatutoryDeductions(StatutoryDeductionsForBill statutoryDeductionsForBill) {
        this.statutoryDeductionsList.add(statutoryDeductionsForBill);
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public List<EgBilldetails> getBillDetailes() {
        return this.billDetailes;
    }

    public void setBillDetailes(List<EgBilldetails> billDetailes) {
        this.billDetailes = billDetailes;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public User getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(User approvedBy) {
        this.approvedBy = approvedBy;
    }

    public MBHeader getMbHeader() {
        return this.mbHeader;
    }

    public void setMbHeader(MBHeader mbHeader) {
        this.mbHeader = mbHeader;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public List<EgBilldetails> getStatutoryDeductionDetailes() {
        return this.statutoryDeductionDetailes;
    }

    public void setStatutoryDeductionDetailes(List<EgBilldetails> statutoryDeductionDetailes) {
        this.statutoryDeductionDetailes = statutoryDeductionDetailes;
    }

    public List<EgBilldetails> getOtherDeductionDetailes() {
        return this.otherDeductionDetailes;
    }

    public void setOtherDeductionDetailes(List<EgBilldetails> otherDeductionDetailes) {
        this.otherDeductionDetailes = otherDeductionDetailes;
    }

    public List<EgBilldetails> getRetentionMoneyDeductionDetailes() {
        return this.retentionMoneyDeductionDetailes;
    }

    public void setRetentionMoneyDeductionDetailes(List<EgBilldetails> retentionMoneyDeductionDetailes) {
        this.retentionMoneyDeductionDetailes = retentionMoneyDeductionDetailes;
    }

    public Long[] getMbHeaderIds() {
        return this.mbHeaderIds;
    }

    public void setMbHeaderIds(Long[] mbHeaderIds) {
        this.mbHeaderIds = mbHeaderIds;
    }

    public List<EgBilldetails> getRefundBillDetails() {
        return this.refundBillDetails;
    }

    public void setRefundBillDetails(List<EgBilldetails> refundBillDetails) {
        this.refundBillDetails = refundBillDetails;
    }

    public static enum BillStatus {
        CREATED,
        APPROVED,
        REJECTED,
        CANCELLED,
        RESUBMITTED,
        CHECKED;

    }
}

