/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractoradvance.service;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.repository.AccountdetailtypeRepository;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.advance.EgAdvanceReqPayeeDetails;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.pims.commons.Position;
import org.egov.works.autonumber.AdvanceBillNumberGenerator;
import org.egov.works.autonumber.AdvanceRequisitionNumberGenerator;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.entity.SearchRequestContractorRequisition;
import org.egov.works.contractoradvance.repository.ContractorAdvanceRepository;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class ContractorAdvanceService {
    private static final Logger LOG = LoggerFactory.getLogger(ContractorAdvanceService.class);
    @Autowired
    private ContractorAdvanceRepository contractorAdvanceRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private AdvanceRequisitionNumberGenerator advanceRequisitionNumberGenerator;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<ContractorAdvanceRequisition> contractorAdvanceRequisitionWorkflowService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private AccountdetailtypeRepository accountdetailtypeRepository;
    @Autowired
    private AdvanceBillNumberGenerator advanceBillNumberGenerator;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public ContractorAdvanceRequisition getContractorAdvanceRequisitionById(Long id) {
        return (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.findOne(id));
    }

    public List<String> getAdvanceRequisitionNumberToSearchCR(String advanceRequisitionNumber) {
        List<String> advanceRequisitionNumbers = this.contractorAdvanceRepository.findAdvanceRequisitionNumberToSearchCR("%" + advanceRequisitionNumber + "%");
        return advanceRequisitionNumbers;
    }

    public List<String> getWorkOrderNumberToSearchCR(String workOrderNumber) {
        List<String> workOrderNumbers = this.contractorAdvanceRepository.findWorkOrderNumberToSearchCR("%" + workOrderNumber + "%");
        return workOrderNumbers;
    }

    public List<String> getContractorsToSearchCR(String contractorName) {
        List<String> contractorNames = this.contractorAdvanceRepository.findContractorsToSearchCR("%" + contractorName + "%");
        return contractorNames;
    }

    public List<ContractorAdvanceRequisition> searchContractorAdvance(SearchRequestContractorRequisition searchRequestContractorRequisition) {
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClause(searchRequestContractorRequisition, queryStr);
        Query query = this.setParameterForSearchContractorAdvance(searchRequestContractorRequisition, queryStr);
        List contractorAdvanceRequisitionList = query.getResultList();
        return contractorAdvanceRequisitionList;
    }

    private void buildWhereClause(SearchRequestContractorRequisition searchRequestContractorRequisition, StringBuilder queryStr) {
        queryStr.append("select car from ContractorAdvanceRequisition as car where 1=1 ");
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getAdvanceRequisitionNumber())) {
            queryStr.append(" and upper(car.advanceRequisitionNumber) = :advanceRequisitionNumber");
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getWorkOrderNumber())) {
            queryStr.append(" and upper(car.workOrderEstimate.workOrder.workOrderNumber) = :workOrderNumber");
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getContractorName())) {
            queryStr.append(" and upper(car.workOrderEstimate.workOrder.contractor.name) = :contractorName");
        }
        if (searchRequestContractorRequisition.getFromDate() != null) {
            queryStr.append(" and car.advanceRequisitionDate >= :fromDate");
        }
        if (searchRequestContractorRequisition.getToDate() != null) {
            queryStr.append(" and car.advanceRequisitionDate <= :toDate");
        }
        if (searchRequestContractorRequisition.getEgwStatus() != null) {
            queryStr.append(" and car.status.code = :status)");
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getAdvanceBillNumber())) {
            queryStr.append(" and upper(car.egAdvanceReqMises.egBillregister.billnumber) = :advanceBillNumber)");
        }
    }

    private Query setParameterForSearchContractorAdvance(SearchRequestContractorRequisition searchRequestContractorRequisition, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchRequestContractorRequisition != null) {
            this.setSearchParameterForContractorAdvance(searchRequestContractorRequisition, qry);
            if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getAdvanceBillNumber())) {
                qry.setParameter("advanceBillNumber", (Object)searchRequestContractorRequisition.getAdvanceBillNumber().toUpperCase());
            }
        }
        return qry;
    }

    public ContractorAdvanceRequisition getContractorAdvanceByARFNumber(String arfNumber) {
        return this.contractorAdvanceRepository.findByAdvanceRequisitionNumber(arfNumber);
    }

    @Transactional
    public ContractorAdvanceRequisition create(ContractorAdvanceRequisition contractorAdvanceRequisition, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CREATED.toString()));
        contractorAdvanceRequisition.setAdvanceRequisitionDate(new Date());
        contractorAdvanceRequisition.setAdvanceRequisitionNumber(this.advanceRequisitionNumberGenerator.getNextNumber(contractorAdvanceRequisition));
        contractorAdvanceRequisition.setArftype("Contractor");
        for (EgAdvanceRequisitionDetails details : contractorAdvanceRequisition.getEgAdvanceReqDetailses()) {
            details.setEgAdvanceRequisition((EgAdvanceRequisition)contractorAdvanceRequisition);
        }
        contractorAdvanceRequisition.setEgAdvanceReqMises(this.setEgAdvanceReqMis(contractorAdvanceRequisition));
        ContractorAdvanceRequisition savedContractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)contractorAdvanceRequisition));
        this.createContractorAdvanceWorkflowTransition(savedContractorAdvanceRequisition, approvalPosition, approvalComent, additionalRule, workFlowAction);
        savedContractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)savedContractorAdvanceRequisition));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)savedContractorAdvanceRequisition, "CONTRACTORADVANCE");
        if (!documentDetails.isEmpty()) {
            savedContractorAdvanceRequisition.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedContractorAdvanceRequisition;
    }

    private EgAdvanceRequisitionMis setEgAdvanceReqMis(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        EgAdvanceRequisitionMis requisitionMis = new EgAdvanceRequisitionMis();
        requisitionMis.setEgAdvanceRequisition((EgAdvanceRequisition)contractorAdvanceRequisition);
        requisitionMis.setFieldId(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getWard());
        requisitionMis.setPayto(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getName());
        requisitionMis.setEgDepartment(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getExecutingDepartment());
        requisitionMis.setFundsource(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFundSource());
        if (!contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().isEmpty()) {
            requisitionMis.setFunction(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunction());
            requisitionMis.setFunctionaryId(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunctionary());
            requisitionMis.setFund(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFund());
            requisitionMis.setScheme(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getScheme());
            requisitionMis.setSubScheme(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getSubScheme());
        }
        return requisitionMis;
    }

    public void getEgAdvanceRequisitionDetails(ContractorAdvanceRequisition contractorAdvanceRequisition, EgAdvanceRequisitionDetails egAdvanceRequisitionDetails, BindingResult errors) {
        boolean isDebit = false;
        CChartOfAccounts coa = null;
        if (egAdvanceRequisitionDetails.getChartofaccounts().getId() != 0L) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egAdvanceRequisitionDetails.getChartofaccounts().getId(), false);
        }
        if (egAdvanceRequisitionDetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egAdvanceRequisitionDetails.getDebitamount()) != 0) {
            isDebit = true;
        }
        if (coa != null && coa.getGlcode() != null) {
            Accountdetailtype contractorAccountDetailType = null;
            contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
            if (contractorAccountDetailType != null) {
                if (egAdvanceRequisitionDetails.getEgAdvanceReqpayeeDetailses().isEmpty()) {
                    egAdvanceRequisitionDetails.getEgAdvanceReqpayeeDetailses().add(this.getEgAdvanceReqPayeeDetails(egAdvanceRequisitionDetails, contractorAccountDetailType.getId(), new EgAdvanceReqPayeeDetails(), isDebit ? egAdvanceRequisitionDetails.getDebitamount() : egAdvanceRequisitionDetails.getCreditamount(), isDebit, Integer.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getId().toString())));
                } else {
                    for (EgAdvanceReqPayeeDetails payeeDetails : egAdvanceRequisitionDetails.getEgAdvanceReqpayeeDetailses()) {
                        payeeDetails = this.getEgAdvanceReqPayeeDetails(egAdvanceRequisitionDetails, contractorAccountDetailType.getId(), payeeDetails, isDebit ? egAdvanceRequisitionDetails.getDebitamount() : egAdvanceRequisitionDetails.getCreditamount(), isDebit, Integer.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getId().toString()));
                    }
                }
            } else {
                errors.reject("error.contractoradvance.validate.glcode.for.subledger", (Object[])new String[]{coa.getGlcode()}, null);
            }
        }
    }

    public EgAdvanceReqPayeeDetails getEgAdvanceReqPayeeDetails(EgAdvanceRequisitionDetails egAdvanceRequisitionDetails, Integer accountsDetailTypeId, EgAdvanceReqPayeeDetails egAdvanceReqPayeeDetails, BigDecimal amount, boolean isDebit, Integer accountsDetailKeyId) {
        egAdvanceReqPayeeDetails.setAccountdetailKeyId(accountsDetailKeyId);
        egAdvanceReqPayeeDetails.setAccountDetailType((Accountdetailtype)this.accountdetailtypeRepository.findOne((Serializable)accountsDetailTypeId));
        if (isDebit) {
            egAdvanceReqPayeeDetails.setDebitAmount(amount);
        } else {
            egAdvanceReqPayeeDetails.setCreditAmount(amount);
        }
        egAdvanceReqPayeeDetails.setEgAdvanceRequisitionDetails(egAdvanceRequisitionDetails);
        return egAdvanceReqPayeeDetails;
    }

    public void createContractorAdvanceWorkflowTransition(ContractorAdvanceRequisition contractorAdvanceRequisition, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Contractor Advance Requisition";
        if (null != contractorAdvanceRequisition.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(contractorAdvanceRequisition.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            contractorAdvanceRequisition.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Contractor Advance Requisition");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L) && !"Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == contractorAdvanceRequisition.getState()) {
                wfmatrix = this.contractorAdvanceRequisitionWorkflowService.getWfMatrix(contractorAdvanceRequisition.getStateType(), null, null, additionalRule, "", null);
                contractorAdvanceRequisition.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Contractor Advance Requisition");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                contractorAdvanceRequisition.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Contractor Advance Requisition");
            } else {
                wfmatrix = this.contractorAdvanceRequisitionWorkflowService.getWfMatrix(contractorAdvanceRequisition.getStateType(), null, contractorAdvanceRequisition.getAdvanceRequisitionAmount(), additionalRule, contractorAdvanceRequisition.getCurrentState().getValue(), contractorAdvanceRequisition.getState().getNextAction());
                contractorAdvanceRequisition.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Contractor Advance Requisition");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    @Transactional
    public ContractorAdvanceRequisition updateContractorAdvanceRequisition(ContractorAdvanceRequisition contractorAdvanceRequisition, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, MultipartFile[] files) throws ValidationException, IOException {
        ContractorAdvanceRequisition updatedContractorAdvanceRequisition = null;
        if (contractorAdvanceRequisition.getStatus().getCode().equals(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString())) {
            updatedContractorAdvanceRequisition = this.update(contractorAdvanceRequisition, files);
            this.contractorContractorAdvanceStatusChange(updatedContractorAdvanceRequisition, workFlowAction, mode);
        } else {
            this.contractorContractorAdvanceStatusChange(contractorAdvanceRequisition, workFlowAction, mode);
            if (workFlowAction.equalsIgnoreCase("approve")) {
                contractorAdvanceRequisition.setApprovedBy(this.securityUtils.getCurrentUser());
                this.createAndApproveAdvanceBills(contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister(), new ArrayList<String>());
                contractorAdvanceRequisition.getEgAdvanceReqMises().setSourcePath("/egworks/contractoradvance/view/" + contractorAdvanceRequisition.getId());
            }
        }
        updatedContractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)contractorAdvanceRequisition));
        this.createContractorAdvanceWorkflowTransition(updatedContractorAdvanceRequisition, approvalPosition, approvalComent, additionalRule, workFlowAction);
        updatedContractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)updatedContractorAdvanceRequisition));
        return updatedContractorAdvanceRequisition;
    }

    @Transactional
    public List<String> createAndApproveAdvanceBills(EgBillregister egBillregister, List<String> errorMessages) {
        this.validateLedgerAndSubledger(egBillregister, errorMessages);
        if (errorMessages.isEmpty()) {
            this.expenseBillService.create(egBillregister);
            egBillregister.getEgBillregistermis().setSourcePath("/EGF/expensebill/view/" + egBillregister.getId());
        }
        return errorMessages;
    }

    @Transactional
    public void generateAdvanceBills(ContractorAdvanceRequisition contractorAdvanceRequisition, EgBillregister egBillregister, BindingResult errors) {
        this.populateBillRegister(contractorAdvanceRequisition, egBillregister);
        this.populateBillDetails(contractorAdvanceRequisition, egBillregister, errors);
        this.populateBillregistermis(contractorAdvanceRequisition, egBillregister);
    }

    private void populateBillRegister(ContractorAdvanceRequisition contractorAdvanceRequisition, EgBillregister egBillregister) {
        egBillregister.setApprovalComent(contractorAdvanceRequisition.getApprovalComent());
        egBillregister.setApprovalDepartment(contractorAdvanceRequisition.getApprovalDepartment());
        egBillregister.setApprovedOn(contractorAdvanceRequisition.getApprovedDate());
        egBillregister.setApprover(contractorAdvanceRequisition.getApprovedBy());
        egBillregister.setBillamount(contractorAdvanceRequisition.getAdvanceRequisitionAmount());
        egBillregister.setBilldate(contractorAdvanceRequisition.getApprovedDate());
        egBillregister.setBillnumber(this.advanceBillNumberGenerator.getNextNumber(egBillregister));
        egBillregister.setBillstatus(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        egBillregister.setBilltype(BillTypes.Final_Bill.toString());
        egBillregister.setPassedamount(contractorAdvanceRequisition.getAdvanceRequisitionAmount());
        egBillregister.setStatus(this.worksUtils.getStatusByModuleAndCode("ADVANCEBILL", "APPROVED"));
        egBillregister.setExpendituretype("Advance");
    }

    private void populateBillDetails(ContractorAdvanceRequisition contractorAdvanceRequisition, EgBillregister egBillregister, BindingResult errors) {
        for (EgAdvanceRequisitionDetails details : contractorAdvanceRequisition.getEgAdvanceReqDetailses()) {
            EgBilldetails egBilldetails = new EgBilldetails();
            egBilldetails.setFunctionid(BigDecimal.valueOf(contractorAdvanceRequisition.getEgAdvanceReqMises().getFunction().getId()));
            egBilldetails.setCreditamount(details.getCreditamount());
            egBilldetails.setDebitamount(details.getDebitamount());
            egBilldetails.setChartOfAccounts(details.getChartofaccounts());
            egBilldetails.setEgBillregister(egBillregister);
            egBilldetails.setGlcodeid(BigDecimal.valueOf(details.getChartofaccounts().getId()));
            egBilldetails.setLastupdatedtime(new Date());
            egBillregister.addEgBilldetailes(this.getEgBillPayeeDetails(contractorAdvanceRequisition, egBilldetails, errors));
        }
    }

    private EgBilldetails getEgBillPayeeDetails(ContractorAdvanceRequisition contractorAdvanceRequisition, EgBilldetails egBilldetails, BindingResult errors) {
        boolean isDebit = false;
        CChartOfAccounts coa = null;
        if (BigDecimal.ZERO.compareTo(egBilldetails.getGlcodeid()) != 0) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
        }
        if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
            isDebit = true;
        }
        if (coa != null && coa.getGlcode() != null) {
            Accountdetailtype contractorAccountDetailType = null;
            contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
            if (contractorAccountDetailType != null) {
                egBilldetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(egBilldetails, contractorAccountDetailType.getId(), isDebit ? egBilldetails.getDebitamount() : egBilldetails.getCreditamount(), isDebit, Integer.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getId().toString())));
            } else {
                errors.reject("error.contractoradvance.validate.glcode.for.subledger", (Object[])new String[]{coa.getGlcode()}, null);
            }
        }
        return egBilldetails;
    }

    public EgBillPayeedetails getEgPayeeDetails(EgBilldetails billDetails, Integer accountsDetailTypeId, BigDecimal amount, boolean isDebit, Integer accountsDetailKeyId) {
        EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
        egBillPaydetail.setAccountDetailKeyId(accountsDetailKeyId);
        egBillPaydetail.setAccountDetailTypeId(accountsDetailTypeId);
        if (isDebit) {
            egBillPaydetail.setDebitAmount(amount);
        } else {
            egBillPaydetail.setCreditAmount(amount);
        }
        egBillPaydetail.setEgBilldetailsId(billDetails);
        egBillPaydetail.setLastUpdatedTime(new Date());
        return egBillPaydetail;
    }

    private void populateBillregistermis(ContractorAdvanceRequisition contractorAdvanceRequisition, EgBillregister egBillregister) {
        EgBillregistermis billregistermis = new EgBillregistermis();
        billregistermis.setEgBillregister(egBillregister);
        billregistermis.setFieldid(contractorAdvanceRequisition.getEgAdvanceReqMises().getFieldId());
        billregistermis.setFunction(contractorAdvanceRequisition.getEgAdvanceReqMises().getFunction());
        billregistermis.setFunctionaryid(contractorAdvanceRequisition.getEgAdvanceReqMises().getFunctionaryId());
        billregistermis.setFund(contractorAdvanceRequisition.getEgAdvanceReqMises().getFund());
        billregistermis.setPayto(contractorAdvanceRequisition.getEgAdvanceReqMises().getPayto());
        billregistermis.setScheme(contractorAdvanceRequisition.getEgAdvanceReqMises().getScheme());
        billregistermis.setSubScheme(contractorAdvanceRequisition.getEgAdvanceReqMises().getSubScheme());
        billregistermis.setEgDepartment(contractorAdvanceRequisition.getEgAdvanceReqMises().getEgDepartment());
        billregistermis.setFundsource(contractorAdvanceRequisition.getEgAdvanceReqMises().getFundsource());
        billregistermis.setLastupdatedtime(new Date());
        egBillregister.setEgBillregistermis(billregistermis);
    }

    private ContractorAdvanceRequisition update(ContractorAdvanceRequisition contractorAdvanceRequisition, MultipartFile[] files) throws IOException {
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)contractorAdvanceRequisition, "CONTRACTORADVANCE");
        if (!documentDetails.isEmpty()) {
            contractorAdvanceRequisition.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)contractorAdvanceRequisition));
    }

    public void contractorContractorAdvanceStatusChange(ContractorAdvanceRequisition contractorAdvanceRequisition, String workFlowAction, String mode) throws ValidationException {
        if (null != contractorAdvanceRequisition && null != contractorAdvanceRequisition.getStatus() && null != contractorAdvanceRequisition.getStatus().getCode()) {
            if (workFlowAction.equalsIgnoreCase("approve")) {
                contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString()));
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString()));
            } else if (contractorAdvanceRequisition.getStatus().getCode().equals(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString()) && workFlowAction.equals("Cancel")) {
                contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString()));
            } else if (contractorAdvanceRequisition.getStatus().getCode().equals(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.RESUBMITTED.toString()));
            } else if (("RESUBMITTED".equalsIgnoreCase(contractorAdvanceRequisition.getStatus().getCode()) || "CREATED".equalsIgnoreCase(contractorAdvanceRequisition.getStatus().getCode()) || "CHECKED".equalsIgnoreCase(contractorAdvanceRequisition.getStatus().getCode())) && contractorAdvanceRequisition.getState() != null && "Submit".equalsIgnoreCase(workFlowAction)) {
                contractorAdvanceRequisition.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORADVANCE", "CHECKED"));
            }
        }
    }

    public Double getTotalAdvancePaid(Long contractorAdvanceId, Long workOrderEstimateId, String approvedCode) {
        return this.contractorAdvanceRepository.getTotalAdvancePaid(contractorAdvanceId, workOrderEstimateId, approvedCode);
    }

    public Double getTotalAdvanceBillsPaid(Long workOrderEstimateId, String approvedCode) {
        return this.contractorAdvanceRepository.getTotalAdvanceBillsPaid(workOrderEstimateId, approvedCode);
    }

    public void validateInput(ContractorAdvanceRequisition contractorAdvanceRequisition, BindingResult errors) {
        Double advancePaidTillNow = this.getTotalAdvancePaid(contractorAdvanceRequisition.getId() == null ? -1L : contractorAdvanceRequisition.getId(), contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        Double totalPartBillsAmount = this.contractorBillRegisterService.getTotalPartBillsAmount((long)contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString(), BillTypes.Part_Bill.toString());
        List<MBHeader> mbHeaders = this.mbHeaderService.getMBHeadersByWorkOrderEstimateIdAndNotEgwStatusCode(contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString());
        if (!mbHeaders.isEmpty()) {
            errors.reject("error.mb.created", (Object[])new String[0], null);
        }
        if (totalPartBillsAmount == null) {
            totalPartBillsAmount = 0.0;
        }
        if (advancePaidTillNow == null) {
            advancePaidTillNow = 0.0;
        }
        if (contractorAdvanceRequisition.getAdvanceRequisitionAmount().add(BigDecimal.valueOf(advancePaidTillNow + totalPartBillsAmount)).compareTo(BigDecimal.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount())) > 0) {
            Double diffAmount = advancePaidTillNow + totalPartBillsAmount + (double)contractorAdvanceRequisition.getAdvanceRequisitionAmount().longValue() - contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount();
            errors.reject("error.advance.exceeded", (Object[])new String[]{diffAmount.toString()}, null);
        }
    }

    public void validateARFInDrafts(Long contractorAdvanceRegisterId, Long workOrderEstimateId, JsonObject jsonObject, BindingResult errors) {
        ContractorAdvanceRequisition contractorAdvanceRequisition = null;
        contractorAdvanceRequisition = this.contractorAdvanceRepository.findByWorkOrderEstimate_IdAndStatus_codeEquals(workOrderEstimateId, "NEW");
        String userName = "";
        if (contractorAdvanceRequisition != null && contractorAdvanceRequisition.getState() != null && contractorAdvanceRequisition.getState().getOwnerPosition() != null) {
            userName = this.worksUtils.getApproverName(contractorAdvanceRequisition.getState().getOwnerPosition().getId());
            String message = this.messageSource.getMessage("error.arf.newstatus", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), contractorAdvanceRequisition.getStatus().getDescription(), userName}, null);
            jsonObject.addProperty("draftsError", message);
            if (errors != null) {
                errors.reject("draftsError", message);
            }
        }
    }

    public void validateARFInWorkFlow(Long contractorAdvanceRegisterId, Long workOrderEstimateId, JsonObject jsonObject, BindingResult errors) {
        ContractorAdvanceRequisition contractorAdvanceRequisition = null;
        contractorAdvanceRequisition = this.contractorAdvanceRepository.findByWorkOrderEstimateAndStatus(workOrderEstimateId, ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.NEW.toString());
        String userName = "";
        if (contractorAdvanceRequisition != null && contractorAdvanceRequisition.getState() != null && contractorAdvanceRequisition.getState().getOwnerPosition() != null) {
            userName = this.worksUtils.getApproverName(contractorAdvanceRequisition.getState().getOwnerPosition().getId());
            String message = this.messageSource.getMessage("error.arf.workflow", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), contractorAdvanceRequisition.getStatus().getDescription(), userName}, null);
            jsonObject.addProperty("workFlowError", message);
            if (errors != null) {
                errors.reject("workFlowError", message);
            }
        }
    }

    public List<String> findAdvanceBillNumber(String advanceBillNumber) {
        List<String> advanceBillNumbers = this.contractorAdvanceRepository.findAdvanceBillNumber("%" + advanceBillNumber + "%");
        return advanceBillNumbers;
    }

    public void validateLedgerAndSubledger(EgBillregister egBillregister, List<String> errorMessages) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            if (details.getDebitamount() != null) {
                totalDrAmt = totalDrAmt.add(details.getDebitamount());
            }
            if (details.getCreditamount() != null) {
                totalCrAmt = totalCrAmt.add(details.getCreditamount());
            }
            if (details.getGlcodeid() == null) {
                errorMessages.add(this.messageSource.getMessage("msg.advance.bill.accdetail.accmissing", (Object[])new String[0], null));
            }
            if (details.getDebitamount() != null && details.getCreditamount() != null && details.getDebitamount().equals(BigDecimal.ZERO) && details.getCreditamount().equals(BigDecimal.ZERO) && details.getGlcodeid() != null) {
                errorMessages.add(this.messageSource.getMessage("msg.advance.bill.accdetail.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null));
            }
            if (details.getDebitamount() == null || details.getCreditamount() == null || details.getDebitamount().compareTo(BigDecimal.ZERO) != 1 || details.getCreditamount().compareTo(BigDecimal.ZERO) != 1) continue;
            errorMessages.add(this.messageSource.getMessage("msg.advance.bill.accdetail.amount", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null));
        }
        if (totalDrAmt.compareTo(totalCrAmt) != 0) {
            errorMessages.add(this.messageSource.getMessage("msg.advance.bill.accdetail.drcrmatch", (Object[])new String[0], null));
        }
        this.validateSubledgerDetails(egBillregister, errorMessages);
    }

    protected void validateSubledgerDetails(EgBillregister egBillregister, List<String> errorMessages) {
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            BigDecimal detailAmt = BigDecimal.ZERO;
            BigDecimal payeeDetailAmt = BigDecimal.ZERO;
            if (details.getDebitamount() != null && details.getDebitamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getDebitamount();
            } else if (details.getCreditamount() != null && details.getCreditamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getCreditamount();
            }
            for (EgBillPayeedetails payeeDetails : details.getEgBillPaydetailes()) {
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getCreditAmount() != null && payeeDetails.getDebitAmount().equals(BigDecimal.ZERO) && payeeDetails.getCreditAmount().equals(BigDecimal.ZERO)) {
                    errorMessages.add(this.messageSource.getMessage("msg.advance.bill.subledger.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null));
                }
                if (payeeDetails.getDebitAmount() != null) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getDebitAmount());
                } else if (payeeDetails.getCreditAmount() != null) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getCreditAmount());
                }
                Boolean check = false;
                for (CChartOfAccountDetail coaDetails : details.getChartOfAccounts().getChartOfAccountDetails()) {
                    if (payeeDetails.getAccountDetailTypeId() != coaDetails.getDetailTypeId().getId()) continue;
                    check = true;
                }
                if (check.booleanValue()) continue;
                errorMessages.add(this.messageSource.getMessage("msg.advance.bill.subledger.mismatch", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null));
            }
            if (detailAmt.compareTo(payeeDetailAmt) == 0 || details.getEgBillPaydetailes().isEmpty()) continue;
            errorMessages.add(this.messageSource.getMessage("msg.advance.bill.subledger.amtnotmatchinng", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null));
        }
    }

    public List<ContractorAdvanceRequisition> getContractorAdvancesToCancelLOA(WorkOrderEstimate workOrderEstimate) {
        return this.contractorAdvanceRepository.findByWorkOrderEstimate_IdAndStatus_CodeNot(workOrderEstimate.getId(), "CANCELLED");
    }

    public List<User> getAdvanceRequisitionCreatedByUsers() {
        return this.contractorAdvanceRepository.getAdvanceRequisitionCreatedByUsers(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
    }

    public List<String> findAdvanceRequisitionNumberToCancelContractorAdvance(String advanceRequisitionNumber) {
        List<String> advanceRequisitionNumbers = this.contractorAdvanceRepository.findAdvanceRequisitionNumberToCancelContractorAdvance("%" + advanceRequisitionNumber + "%", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        return advanceRequisitionNumbers;
    }

    public List<String> findContractorsToCancelContractorAdvance(String contractorName) {
        List<String> contractorNames = this.contractorAdvanceRepository.findContractorsToCancelContractorAdvance("%" + contractorName + "%", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        return contractorNames;
    }

    public List<String> findWorkOrderNumberToCancelContractorAdvance(String workOrderNumber) {
        List<String> workOrderNumbers = this.contractorAdvanceRepository.findWorkOrderNumberToCancelContractorAdvance("%" + workOrderNumber + "%", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        return workOrderNumbers;
    }

    public List<ContractorAdvanceRequisition> searchContractorAdvanceToCancel(SearchRequestContractorRequisition searchRequestContractorRequisition) {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select car from ContractorAdvanceRequisition as car where car.status.code =:contractorAdvanceStatus ");
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getAdvanceRequisitionNumber())) {
            queryStr.append(" and upper(car.advanceRequisitionNumber) = :advanceRequisitionNumber");
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getWorkOrderNumber())) {
            queryStr.append(" and upper(car.workOrderEstimate.workOrder.workOrderNumber) = :workOrderNumber");
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getContractorName())) {
            queryStr.append(" and upper(car.workOrderEstimate.workOrder.contractor.name) = :contractorName");
        }
        if (searchRequestContractorRequisition.getFromDate() != null) {
            queryStr.append(" and car.advanceRequisitionDate >= :fromDate");
        }
        if (searchRequestContractorRequisition.getToDate() != null) {
            queryStr.append(" and car.advanceRequisitionDate <= :toDate");
        }
        if (searchRequestContractorRequisition.getCreatedBy() != null) {
            queryStr.append(" and car.createdBy.id = :createdBy)");
        }
        Query query = this.setParameterToCancelContractorAdvance(searchRequestContractorRequisition, queryStr);
        List contractorAdvanceRequisitionList = query.getResultList();
        return contractorAdvanceRequisitionList;
    }

    private Query setParameterToCancelContractorAdvance(SearchRequestContractorRequisition searchRequestContractorRequisition, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("contractorAdvanceStatus", (Object)ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        if (searchRequestContractorRequisition != null) {
            this.setSearchParameterForContractorAdvance(searchRequestContractorRequisition, qry);
            if (searchRequestContractorRequisition.getCreatedBy() != null) {
                qry.setParameter("createdBy", (Object)searchRequestContractorRequisition.getCreatedBy());
            }
        }
        return qry;
    }

    @Transactional
    public ContractorAdvanceRequisition cancelContractorAdvance(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        contractorAdvanceRequisition.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("CONTRACTORADVANCE", ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString()));
        if (contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister() != null) {
            contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVANCEBILL", "CANCELLED"));
            contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister().setBillstatus(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString());
        }
        return (ContractorAdvanceRequisition)((Object)this.contractorAdvanceRepository.save((Object)contractorAdvanceRequisition));
    }

    public String getAdvanceRequisitionGreaterThanCurrent(Long workOrderEstimateId, Date createdDate) {
        List<ContractorAdvanceRequisition> contractorAdvanceRequisitions = this.contractorAdvanceRepository.findByWorkOrderEstimate_idAndCreatedDateAfterAndStatus_codeNotLike(workOrderEstimateId, createdDate, ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString());
        StringBuilder advanceRequistion = new StringBuilder();
        for (ContractorAdvanceRequisition revisionAbstractEstimate : contractorAdvanceRequisitions) {
            advanceRequistion.append(revisionAbstractEstimate.getAdvanceRequisitionNumber()).append(',');
        }
        return advanceRequistion.toString();
    }

    private void setSearchParameterForContractorAdvance(SearchRequestContractorRequisition searchRequestContractorRequisition, Query qry) {
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getWorkOrderNumber())) {
            qry.setParameter("workOrderNumber", (Object)searchRequestContractorRequisition.getWorkOrderNumber().toUpperCase());
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getAdvanceRequisitionNumber())) {
            qry.setParameter("advanceRequisitionNumber", (Object)searchRequestContractorRequisition.getAdvanceRequisitionNumber().toUpperCase());
        }
        if (StringUtils.isNotBlank((String)searchRequestContractorRequisition.getContractorName())) {
            qry.setParameter("contractorName", (Object)searchRequestContractorRequisition.getContractorName().toUpperCase());
        }
        if (searchRequestContractorRequisition.getFromDate() != null) {
            qry.setParameter("fromDate", (Object)searchRequestContractorRequisition.getFromDate());
        }
        if (searchRequestContractorRequisition.getToDate() != null) {
            DateTime dateTime = new DateTime(searchRequestContractorRequisition.getToDate().getTime()).plusDays(1);
            qry.setParameter("toDate", (Object)dateTime.toDate());
        }
        if (searchRequestContractorRequisition.getEgwStatus() != null) {
            qry.setParameter("status", (Object)searchRequestContractorRequisition.getEgwStatus());
        }
    }
}

