/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractoradvance.repository;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ContractorAdvanceRepository
extends JpaRepository<ContractorAdvanceRequisition, Long> {
    @Query(value="select distinct(car.advanceRequisitionNumber) from ContractorAdvanceRequisition as car where upper(car.advanceRequisitionNumber) like upper(:advanceRequisitionNumber)")
    public List<String> findAdvanceRequisitionNumberToSearchCR(@Param(value="advanceRequisitionNumber") String var1);

    @Query(value="select distinct(car.workOrderEstimate.workOrder.workOrderNumber) from ContractorAdvanceRequisition as car where upper(car.workOrderEstimate.workOrder.workOrderNumber) like upper(:workOrderNumber)")
    public List<String> findWorkOrderNumberToSearchCR(@Param(value="workOrderNumber") String var1);

    @Query(value="select distinct(car.workOrderEstimate.workOrder.contractor.name) from ContractorAdvanceRequisition as car where upper(car.workOrderEstimate.workOrder.contractor.name) like upper(:contractorName) or upper(car.workOrderEstimate.workOrder.contractor.code) like upper(:contractorName)")
    public List<String> findContractorsToSearchCR(@Param(value="contractorName") String var1);

    public ContractorAdvanceRequisition findByAdvanceRequisitionNumber(String var1);

    @Query(value="select COALESCE(sum(advanceRequisitionAmount),0) from ContractorAdvanceRequisition where (createdDate < (select createdDate from ContractorAdvanceRequisition where id = :contractorAdvanceId) or (select count(*) from ContractorAdvanceRequisition where id = :contractorAdvanceId) = 0) and status.code = :statusCode and workOrderEstimate.id = :workOrderEstimateId")
    public Double getTotalAdvancePaid(@Param(value="contractorAdvanceId") Long var1, @Param(value="workOrderEstimateId") Long var2, @Param(value="statusCode") String var3);

    public ContractorAdvanceRequisition findByWorkOrderEstimate_IdAndStatus_codeEquals(Long var1, String var2);

    @Query(value="select car from ContractorAdvanceRequisition as car where car.workOrderEstimate.id =:workOrderEstimateId and status.code not in (:cancelledStatus, :approvedStatus, :newStatus)")
    public ContractorAdvanceRequisition findByWorkOrderEstimateAndStatus(@Param(value="workOrderEstimateId") Long var1, @Param(value="cancelledStatus") String var2, @Param(value="approvedStatus") String var3, @Param(value="newStatus") String var4);

    @Query(value="select distinct(car.egAdvanceReqMises.egBillregister.billnumber) from ContractorAdvanceRequisition as car where upper(car.egAdvanceReqMises.egBillregister.billnumber) like upper(:advanceBillNumber)")
    public List<String> findAdvanceBillNumber(@Param(value="advanceBillNumber") String var1);

    public List<ContractorAdvanceRequisition> findByWorkOrderEstimate_IdAndStatus_CodeNot(Long var1, String var2);

    @Query(value="select distinct(createdBy) from ContractorAdvanceRequisition as car where car.status.code = :advanceRequisitionStatus")
    public List<User> getAdvanceRequisitionCreatedByUsers(@Param(value="advanceRequisitionStatus") String var1);

    @Query(value="select distinct(car.advanceRequisitionNumber) from ContractorAdvanceRequisition as car where upper(car.advanceRequisitionNumber) like upper(:advanceRequisitionNumber) and car.status.code = :advanceRequisitionStatus)")
    public List<String> findAdvanceRequisitionNumberToCancelContractorAdvance(@Param(value="advanceRequisitionNumber") String var1, @Param(value="advanceRequisitionStatus") String var2);

    @Query(value="select distinct(car.workOrderEstimate.workOrder.contractor.name) from ContractorAdvanceRequisition as car where upper(car.workOrderEstimate.workOrder.contractor.name) like upper(:contractorName) or upper(car.workOrderEstimate.workOrder.contractor.code) like upper(:contractorName) and car.status.code = :advanceRequisitionStatus")
    public List<String> findContractorsToCancelContractorAdvance(@Param(value="contractorName") String var1, @Param(value="advanceRequisitionStatus") String var2);

    @Query(value="select distinct(car.workOrderEstimate.workOrder.workOrderNumber) from ContractorAdvanceRequisition as car where upper(car.workOrderEstimate.workOrder.workOrderNumber) like upper(:workOrderNumber) and car.status.code = :advanceRequisitionStatus)")
    public List<String> findWorkOrderNumberToCancelContractorAdvance(@Param(value="workOrderNumber") String var1, @Param(value="advanceRequisitionStatus") String var2);

    public List<ContractorAdvanceRequisition> findByWorkOrderEstimate_idAndCreatedDateAfterAndStatus_codeNotLike(@Param(value="workOrderEstimateId") Long var1, @Param(value="createdDate") Date var2, @Param(value="status") String var3);

    @Query(value="select COALESCE(sum(car.advanceRequisitionAmount),0) from ContractorAdvanceRequisition as car, Miscbilldetail as misc where car.status.code = :statusCode and car.workOrderEstimate.id = :workOrderEstimateId and car.egAdvanceReqMises.egBillregister.egBillregistermis.voucherHeader.id = misc.billVoucherHeader.id and misc.payVoucherHeader.status = 0")
    public Double getTotalAdvanceBillsPaid(@Param(value="workOrderEstimateId") Long var1, @Param(value="statusCode") String var2);
}

