/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractoradvance.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.infra.admin.master.entity.User;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.workorder.entity.WorkOrderEstimate;

@Entity
@Table(name="EGW_CONTRACTOR_ADVANCE")
public class ContractorAdvanceRequisition
extends EgAdvanceRequisition {
    private static final long serialVersionUID = -8267145890478916279L;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ESTIMATE_ID", nullable=false)
    private WorkOrderEstimate workOrderEstimate;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Temporal(value=TemporalType.DATE)
    @Column(name="approveddate")
    private Date approvedDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="approvedby")
    private User approvedBy;
    private final transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    private String cancellationReason;
    private String cancellationRemarks;

    public String getStateDetails() {
        return "Contractor ARF Number : " + this.getAdvanceRequisitionNumber();
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public User getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(User approvedBy) {
        this.approvedBy = approvedBy;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public static enum ContractorAdvanceRequisitionStatus {
        NEW,
        CREATED,
        CHECKED,
        REJECTED,
        RESUBMITTED,
        CANCELLED,
        APPROVED;

    }
}

