/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.works.autonumber.ContractorCodeGenerator;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.masters.entity.ContractorDetail;
import org.egov.works.masters.service.ContractorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractorCodeGeneratorImpl
implements ContractorCodeGenerator {
    private static final String CONTRACTOR_CODE_SEQ_PREFIX = "SEQ_CONTRACTOR_CODE";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private ContractorService contractorService;

    @Override
    @Transactional(readOnly=true)
    public String getNextNumber(Contractor contractor) {
        ContractorDetail contractorDetail = contractor.getContractorDetails().get(0);
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(CONTRACTOR_CODE_SEQ_PREFIX);
        if (this.validateGrade(contractorDetail) && !org.egov.infra.utils.StringUtils.isBlank((String)contractorDetail.getCategory()) && !org.egov.infra.utils.StringUtils.isBlank((String)contractor.getName()) && contractor.getName().length() >= 4) {
            String contractorClass = this.contractorService.getContractorClassShortName(contractorDetail.getGrade().getGrade());
            return String.format("%s%s%s%04d", !org.egov.infra.utils.StringUtils.isBlank((String)contractorClass) ? contractorClass : "", contractorDetail.getCategory().substring(0, 1), contractor.getName().substring(0, 4), sequenceNumber);
        }
        if (!org.egov.infra.utils.StringUtils.isBlank((String)contractorDetail.getCategory()) && !org.egov.infra.utils.StringUtils.isBlank((String)contractor.getName()) && contractor.getName().length() >= 4) {
            return String.format("%s%s%04d", contractorDetail.getCategory().substring(0, 1), contractor.getName().substring(0, 4), sequenceNumber);
        }
        if (this.validateGrade(contractorDetail) && !org.egov.infra.utils.StringUtils.isBlank((String)contractor.getName()) && contractor.getName().length() >= 4) {
            String contractorClass = this.contractorService.getContractorClassShortName(contractorDetail.getGrade().getGrade());
            return String.format("%s%s%04d", !org.egov.infra.utils.StringUtils.isBlank((String)contractorClass) ? contractorClass : "", contractor.getName().substring(0, 4), sequenceNumber);
        }
        if (!org.egov.infra.utils.StringUtils.isBlank((String)contractor.getName()) && contractor.getName().length() >= 4) {
            return String.format("%s%04d", contractor.getName().substring(0, 4), sequenceNumber);
        }
        return null;
    }

    private boolean validateGrade(ContractorDetail contractorDetail) {
        return contractorDetail.getGrade() != null && !StringUtils.isBlank((String)contractorDetail.getGrade().getGrade());
    }
}

