/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.works.autonumber.BudgetAppropriationNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BudgetAppropriationNumberGeneratorImpl
implements BudgetAppropriationNumberGenerator {
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Override
    @Transactional
    public String getNextNumber(Date estimateDate) {
        CFinancialYear cFinancialYear = this.financialYearHibernateDAO.getFinYearByDate(estimateDate);
        String sequenceName = "SEQ_LINEESTIMATEAPPROPRIATION_NUMBER";
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence("SEQ_LINEESTIMATEAPPROPRIATION_NUMBER");
        return String.format("BAS/%05d/%s", sequenceNumber, cFinancialYear.getFinYearRange());
    }

    @Override
    @Transactional
    public String generateCancelledBudgetAppropriationNumber(String appropriationNumber) {
        String original = appropriationNumber.split("/")[0];
        String modified = original + "/C";
        return appropriationNumber.replace(original, modified);
    }
}

