/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.model.bills.EgBillregister;
import org.egov.works.autonumber.AdvanceBillNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdvanceBillNumberGeneratorImpl
implements AdvanceBillNumberGenerator {
    private static final String ADVANCEBILL_NUMBER_SEQ_PREFIX = "SEQ_ADVANCEBILL_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    private int getMonthOfTransaction(Date advanceRequisitionDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(advanceRequisitionDate);
        return cal.get(2) + 1;
    }

    @Override
    @Transactional
    public String getNextNumber(EgBillregister egBillregister) {
        CFinancialYear financialYear = this.financialYearHibernateDAO.getFinYearByDate(egBillregister.getBilldate());
        String[] finYearRange = financialYear.getFinYearRange().split("-");
        String sequenceName = "SEQ_ADVANCEBILL_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("ADV/%06d/%02d/%s", sequenceNumber, this.getMonthOfTransaction(egBillregister.getBilldate()), financialYear.getFinYearRange());
    }
}

