/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.repository.MeasurementSheetRepository;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MeasurementSheetService {
    private final MeasurementSheetRepository measurementSheetRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public MeasurementSheetService(MeasurementSheetRepository measurementSheetRepository) {
        this.measurementSheetRepository = measurementSheetRepository;
    }

    @Transactional
    public MeasurementSheet create(MeasurementSheet measurementSheet) {
        return (MeasurementSheet)((Object)this.measurementSheetRepository.save((Object)measurementSheet));
    }

    @Transactional
    public MeasurementSheet update(MeasurementSheet measurementSheet) {
        return (MeasurementSheet)((Object)this.measurementSheetRepository.save((Object)measurementSheet));
    }

    public List<MeasurementSheet> findAll() {
        return this.measurementSheetRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"}));
    }

    public MeasurementSheet findOne(Long id) {
        return (MeasurementSheet)((Object)this.measurementSheetRepository.findOne(id));
    }

    public List<MeasurementSheet> search(MeasurementSheet measurementSheet) {
        return this.measurementSheetRepository.findAll();
    }

    public List<MeasurementSheet> findMeasurementForEstimateActivities(Long abstractEstimateId) {
        return this.measurementSheetRepository.getMeasurementsForActivites(abstractEstimateId);
    }

    public Boolean existsByEstimate(Long abstractEstimateId) {
        return this.measurementSheetRepository.existsByEstimate(abstractEstimateId);
    }

    public List<MeasurementSheet> findByParentId(Long parentId) {
        return this.measurementSheetRepository.findByParent_Id(parentId, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    public List<MeasurementSheet> findByParentIdForView(Long parentId, Long reId) {
        return this.measurementSheetRepository.findByParent_IdForView(parentId, reId, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }
}

