/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.egov.assets.model.Asset;
import org.egov.assets.service.AssetService;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.commons.service.UOMService;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.services.masters.SchemeService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateDeduction;
import org.egov.works.abstractestimate.entity.AbstractEstimateForCopyEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateForLoaSearchRequest;
import org.egov.works.abstractestimate.entity.AbstractEstimateForLoaSearchResult;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.entity.EstimateTemplateSearchRequest;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.entity.OverheadValue;
import org.egov.works.abstractestimate.entity.ProjectCode;
import org.egov.works.abstractestimate.entity.SearchAbstractEstimate;
import org.egov.works.abstractestimate.entity.SearchRequestCancelEstimate;
import org.egov.works.abstractestimate.repository.AbstractEstimateRepository;
import org.egov.works.abstractestimate.service.EstimateTechnicalSanctionService;
import org.egov.works.autonumber.EstimateNumberGenerator;
import org.egov.works.autonumber.TechnicalSanctionNumberGenerator;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.lineestimate.service.WorkIdentificationNumberGenerator;
import org.egov.works.masters.entity.EstimateTemplate;
import org.egov.works.masters.service.ModeOfAllotmentService;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.masters.service.OverheadService;
import org.egov.works.masters.service.ScheduleCategoryService;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class EstimateService {
    private static final Logger LOG = LoggerFactory.getLogger(EstimateService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final AbstractEstimateRepository abstractEstimateRepository;
    @Autowired
    private EstimateTechnicalSanctionService estimateTechnicalSanctionService;
    @Autowired
    private OverheadService overheadService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<AbstractEstimate> abstractEstimateWorkflowService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private AssetService assetService;
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private UOMService uomService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private WorkIdentificationNumberGenerator workIdentificationNumberGenerator;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private ModeOfAllotmentService modeOfAllotmentService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public EstimateService(AbstractEstimateRepository abstractEstimateRepository, LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.abstractEstimateRepository = abstractEstimateRepository;
    }

    public AbstractEstimate getAbstractEstimateById(Long id) {
        return (AbstractEstimate)((Object)this.abstractEstimateRepository.findOne(id));
    }

    public List<AbstractEstimate> getAbstractEstimateByParentId(Long id) {
        return this.abstractEstimateRepository.findByParent_idAndEgwStatus_codeEquals(id, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    @Transactional
    public AbstractEstimate createAbstractEstimate(AbstractEstimate abstractEstimate, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        AbstractEstimate newAbstractEstimate = null;
        abstractEstimate.setTotalIncludingRE(abstractEstimate.getEstimateValue().doubleValue());
        this.mergeSorAndNonSorActivities(abstractEstimate);
        AbstractEstimate abstractEstimateFromDB = this.getAbstractEstimateByEstimateNumber(abstractEstimate.getEstimateNumber());
        if (abstractEstimate.isSpillOverFlag()) {
            for (EstimateTechnicalSanction ets : abstractEstimate.getEstimateTechnicalSanctions()) {
                ets.setAbstractEstimate(abstractEstimate);
            }
        }
        newAbstractEstimate = abstractEstimateFromDB == null ? this.saveNewAbstractEstimate(abstractEstimate) : this.updateAbstractEstimate(abstractEstimateFromDB, abstractEstimate);
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && !this.worksApplicationProperties.lineEstimateRequired().booleanValue() && "Create And Approve".equals(workFlowAction)) {
            this.doBudgetoryAppropriation(workFlowAction, abstractEstimate);
        }
        if (abstractEstimate.isSpillOverFlag() || !this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            this.setProjectCode(abstractEstimate);
            this.createAccountDetailKey(abstractEstimate.getProjectCode());
        }
        this.createAbstractEstimateWorkflowTransition(newAbstractEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.abstractEstimateRepository.save((Object)newAbstractEstimate);
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newAbstractEstimate, "AbstractEstimate");
        if (!documentDetails.isEmpty()) {
            newAbstractEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        this.abstractEstimateRepository.save((Object)newAbstractEstimate);
        return newAbstractEstimate;
    }

    private void doBudgetoryAppropriation(String workFlowAction, AbstractEstimate abstractEstimate) {
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(abstractEstimate.getFinancialDetails().get(0).getBudgetGroup().getId());
        boolean flag = this.estimateAppropriationService.checkConsumeEncumbranceBudgetForAbstractEstimate(abstractEstimate, this.worksUtils.getFinancialYearByDate(new Date()).getId(), abstractEstimate.getEstimateValue().doubleValue(), budgetheadid);
        if (!flag) {
            throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
        }
    }

    public void validateBudgetAmount(AbstractEstimate abstractEstimate, BindingResult errors) {
        block3: {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            FinancialDetail financialDetail = abstractEstimate.getFinancialDetails().get(0);
            budgetheadid.add(financialDetail.getBudgetGroup().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(abstractEstimate.getExecutingDepartment().getId().toString())), financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getScheme().getId().toString())), financialDetail.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(financialDetail.getFund().getId().toString())));
                if (BudgetControlType.BudgetCheckOption.MANDATORY.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && budgetAvailable.compareTo(abstractEstimate.getEstimateValue()) == -1) {
                    errors.reject("error.budgetappropriation.insufficient.amount", null);
                }
            }
            catch (ValidationException e) {
                Iterator iterator = e.getErrors().iterator();
                if (!iterator.hasNext()) break block3;
                ValidationError error = (ValidationError)iterator.next();
                throw new ApplicationRuntimeException(error.getKey());
            }
        }
    }

    private AbstractEstimate saveNewAbstractEstimate(AbstractEstimate abstractEstimate) {
        for (MultiYearEstimate multiYearEstimate : abstractEstimate.getMultiYearEstimates()) {
            multiYearEstimate.setAbstractEstimate(abstractEstimate);
        }
        for (FinancialDetail financialDetail : abstractEstimate.getFinancialDetails()) {
            financialDetail.setAbstractEstimate(abstractEstimate);
        }
        this.createOverheadValues(abstractEstimate);
        this.createEstimateDeductionValues(abstractEstimate);
        this.createAssetValues(abstractEstimate);
        for (Activity act : abstractEstimate.getActivities()) {
            act.setAbstractEstimate(abstractEstimate);
        }
        if (abstractEstimate.getLineEstimateDetails() != null) {
            abstractEstimate.setProjectCode(abstractEstimate.getLineEstimateDetails().getProjectCode());
        }
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            CFinancialYear financialYear = this.worksUtils.getFinancialYearByDate(abstractEstimate.getEstimateDate());
            EstimateNumberGenerator e = (EstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(EstimateNumberGenerator.class);
            String estimateNumber = e.getEstimateNumber(abstractEstimate, financialYear);
            abstractEstimate.setEstimateNumber(estimateNumber);
        }
        return (AbstractEstimate)((Object)this.abstractEstimateRepository.save((Object)abstractEstimate));
    }

    private void mergeSorAndNonSorActivities(AbstractEstimate abstractEstimate) {
        for (Activity activity : abstractEstimate.getSorActivities()) {
            if (activity.getId() == null) {
                activity.setAbstractEstimate(abstractEstimate);
                abstractEstimate.addActivity(activity);
                continue;
            }
            for (Activity oldActivity : abstractEstimate.getSORActivities()) {
                if (!oldActivity.getId().equals(activity.getId())) continue;
                this.updateActivity(oldActivity, activity);
            }
        }
        for (Activity activity : abstractEstimate.getNonSorActivities()) {
            if (activity.getId() == null) {
                activity.setAbstractEstimate(abstractEstimate);
                abstractEstimate.addActivity(activity);
                continue;
            }
            for (Activity oldActivity : abstractEstimate.getNonSORActivities()) {
                if (!oldActivity.getId().equals(activity.getId())) continue;
                this.updateActivity(oldActivity, activity);
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Activity ac : abstractEstimate.getActivities()) {
                LOG.debug(ac.getMeasurementSheetList().size() + "    " + ac.getQuantity());
            }
        }
        for (Activity ac : abstractEstimate.getSorActivities()) {
            for (MeasurementSheet ms : ac.getMeasurementSheetList()) {
                if (ms.getActivity() != null) continue;
                ms.setActivity(ac);
            }
        }
        for (Activity ac : abstractEstimate.getNonSorActivities()) {
            for (MeasurementSheet ms : ac.getMeasurementSheetList()) {
                if (ms.getActivity() != null) continue;
                ms.setActivity(ac);
            }
        }
    }

    private List<MeasurementSheet> mergeMeasurementSheet(Activity oldActivity, Activity activity) {
        LinkedList<MeasurementSheet> newMsList = new LinkedList<MeasurementSheet>(oldActivity.getMeasurementSheetList());
        for (MeasurementSheet msnew : activity.getMeasurementSheetList()) {
            if (msnew.getId() == null) {
                msnew.setActivity(oldActivity);
                oldActivity.getMeasurementSheetList().add(msnew);
                continue;
            }
            for (MeasurementSheet msold : oldActivity.getMeasurementSheetList()) {
                if (msnew.getId().longValue() != msold.getId().longValue()) continue;
                msold.setLength(msnew.getLength());
                msold.setWidth(msnew.getWidth());
                msold.setDepthOrHeight(msnew.getDepthOrHeight());
                msold.setNo(msnew.getNo());
                msold.setActivity(msnew.getActivity());
                msold.setIdentifier(msnew.getIdentifier());
                msold.setRemarks(msnew.getRemarks());
                msold.setSlNo(msnew.getSlNo());
                msold.setQuantity(msnew.getQuantity());
                newMsList.add(msold);
            }
        }
        LinkedList<MeasurementSheet> toRemove = new LinkedList<MeasurementSheet>();
        for (MeasurementSheet msold : oldActivity.getMeasurementSheetList()) {
            Boolean found = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(oldActivity.getMeasurementSheetList().size() + "activity.getMeasurementSheetList()");
                LOG.debug(msold.getId() + "------msold.getId()");
            }
            if (msold.getId() == null) continue;
            for (MeasurementSheet msnew : activity.getMeasurementSheetList()) {
                if (msnew.getId() == null || msnew.getId().longValue() != msold.getId().longValue()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msnew.getId() + "------msnew.getId()");
                    LOG.debug(msnew.getRemarks() + "------remarks");
                }
                found = true;
            }
            if (found.booleanValue()) continue;
            toRemove.add(msold);
        }
        for (MeasurementSheet msremove : toRemove) {
            if (LOG.isInfoEnabled()) {
                LOG.info("...........Removing rows....................Of MeasurementSheet" + msremove.getId());
            }
            oldActivity.getMeasurementSheetList().remove((Object)msremove);
        }
        return oldActivity.getMeasurementSheetList();
    }

    private void updateActivity(Activity oldActivity, Activity activity) {
        oldActivity.setSchedule(activity.getSchedule());
        oldActivity.setAmt(activity.getAmt());
        oldActivity.setNonSor(activity.getNonSor());
        oldActivity.setQuantity(activity.getQuantity());
        oldActivity.setRate(activity.getRate());
        oldActivity.setServiceTaxPerc(activity.getServiceTaxPerc());
        oldActivity.setEstimateRate(activity.getEstimateRate());
        oldActivity.setUom(activity.getUom());
        oldActivity.setMeasurementSheetList(this.mergeMeasurementSheet(oldActivity, activity));
    }

    @Transactional
    public AbstractEstimate updateAbstractEstimate(AbstractEstimate abstractEstimateFromDB, AbstractEstimate newAbstractEstimate) {
        abstractEstimateFromDB.setEstimateDate(newAbstractEstimate.getEstimateDate());
        abstractEstimateFromDB.setEstimateNumber(newAbstractEstimate.getEstimateNumber());
        abstractEstimateFromDB.setName(newAbstractEstimate.getName());
        abstractEstimateFromDB.setDescription(newAbstractEstimate.getDescription());
        abstractEstimateFromDB.setWard(newAbstractEstimate.getWard());
        abstractEstimateFromDB.setNatureOfWork(newAbstractEstimate.getNatureOfWork());
        abstractEstimateFromDB.setLocation(newAbstractEstimate.getLocation());
        abstractEstimateFromDB.setLatitude(newAbstractEstimate.getLatitude());
        abstractEstimateFromDB.setLongitude(newAbstractEstimate.getLongitude());
        abstractEstimateFromDB.setParentCategory(newAbstractEstimate.getParentCategory());
        abstractEstimateFromDB.setCategory(newAbstractEstimate.getCategory());
        abstractEstimateFromDB.setExecutingDepartment(newAbstractEstimate.getExecutingDepartment());
        abstractEstimateFromDB.setProjectCode(newAbstractEstimate.getProjectCode());
        abstractEstimateFromDB.setLineEstimateDetails(newAbstractEstimate.getLineEstimateDetails());
        abstractEstimateFromDB.setEgwStatus(newAbstractEstimate.getEgwStatus());
        abstractEstimateFromDB.setApprovedBy(newAbstractEstimate.getApprovedBy());
        abstractEstimateFromDB.setApprovedDate(newAbstractEstimate.getApprovedDate());
        abstractEstimateFromDB.getMultiYearEstimates().clear();
        for (MultiYearEstimate multiYearEstimate : newAbstractEstimate.getMultiYearEstimates()) {
            multiYearEstimate.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateFromDB.addMultiYearEstimate(multiYearEstimate);
        }
        abstractEstimateFromDB.getActivities().clear();
        for (Activity activity : newAbstractEstimate.getActivities()) {
            activity.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateFromDB.addActivity(activity);
        }
        abstractEstimateFromDB.getFinancialDetails().clear();
        for (FinancialDetail financialDetail : newAbstractEstimate.getFinancialDetails()) {
            financialDetail.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateFromDB.addFinancialDetails(financialDetail);
        }
        for (AssetsForEstimate assetsForEstimate : newAbstractEstimate.getTempAssetValues()) {
            assetsForEstimate.setAbstractEstimate(abstractEstimateFromDB);
            assetsForEstimate.setAsset(this.assetService.findByCode(assetsForEstimate.getAsset().getCode()));
            abstractEstimateFromDB.addAssetValue(assetsForEstimate);
        }
        abstractEstimateFromDB.setEstimateValue(newAbstractEstimate.getEstimateValue());
        abstractEstimateFromDB.setWorkValue(newAbstractEstimate.getWorkValue());
        abstractEstimateFromDB.setCreatedDate(new Date());
        abstractEstimateFromDB.setLastModifiedDate(new Date());
        abstractEstimateFromDB.setCreatedBy(this.securityUtils.getCurrentUser());
        abstractEstimateFromDB.setLastModifiedBy(this.securityUtils.getCurrentUser());
        abstractEstimateFromDB.getOverheadValues().clear();
        for (OverheadValue overheadValue : newAbstractEstimate.getTempOverheadValues()) {
            OverheadValue newOverheadValue = null;
            newOverheadValue = new OverheadValue();
            newOverheadValue.setOverhead(this.overheadService.getOverheadById(overheadValue.getOverhead().getId()));
            newOverheadValue.setAmount(overheadValue.getAmount());
            newOverheadValue.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateFromDB.getOverheadValues().add(newOverheadValue);
        }
        abstractEstimateFromDB.getEstimateTechnicalSanctions().clear();
        for (EstimateTechnicalSanction estimateTechnicalSanction : newAbstractEstimate.getEstimateTechnicalSanctions()) {
            estimateTechnicalSanction.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateFromDB.getEstimateTechnicalSanctions().add(estimateTechnicalSanction);
        }
        abstractEstimateFromDB.getAbsrtractEstimateDeductions().clear();
        for (AbstractEstimateDeduction abstractEstimateDeduction : newAbstractEstimate.getTempDeductionValues()) {
            AbstractEstimateDeduction abstractEstimateDeductionValue = null;
            abstractEstimateDeductionValue = new AbstractEstimateDeduction();
            abstractEstimateDeductionValue.setAbstractEstimate(abstractEstimateFromDB);
            abstractEstimateDeductionValue.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)abstractEstimateDeduction.getChartOfAccounts().getId(), false));
            abstractEstimateDeductionValue.setAmount(abstractEstimateDeduction.getAmount());
            abstractEstimateDeductionValue.setPercentage(abstractEstimateDeduction.getPercentage());
            abstractEstimateFromDB.getAbsrtractEstimateDeductions().add(abstractEstimateDeductionValue);
        }
        this.abstractEstimateRepository.save((Object)abstractEstimateFromDB);
        return abstractEstimateFromDB;
    }

    @Transactional
    public AbstractEstimate createAbstractEstimateOnLineEstimateTechSanction(LineEstimateDetails lineEstimateDetails, int i) {
        AbstractEstimate savedAbstractEstimate = (AbstractEstimate)((Object)this.abstractEstimateRepository.save((Object)this.populateAbstractEstimate(lineEstimateDetails)));
        this.saveTechnicalSanction(savedAbstractEstimate, i);
        return savedAbstractEstimate;
    }

    private AbstractEstimate populateAbstractEstimate(LineEstimateDetails lineEstimateDetails) {
        AbstractEstimate abstractEstimate = new AbstractEstimate();
        abstractEstimate.setEstimateDate(lineEstimateDetails.getLineEstimate().getLineEstimateDate());
        abstractEstimate.setEstimateNumber(lineEstimateDetails.getEstimateNumber());
        abstractEstimate.setName(lineEstimateDetails.getNameOfWork());
        abstractEstimate.setDescription(lineEstimateDetails.getNameOfWork());
        abstractEstimate.setWard(lineEstimateDetails.getLineEstimate().getWard());
        abstractEstimate.setNatureOfWork(lineEstimateDetails.getLineEstimate().getNatureOfWork());
        if (lineEstimateDetails.getLineEstimate().getLocation() != null) {
            abstractEstimate.setLocation(lineEstimateDetails.getLineEstimate().getLocation().getName());
        }
        abstractEstimate.setParentCategory(lineEstimateDetails.getLineEstimate().getTypeOfWork());
        abstractEstimate.setCategory(lineEstimateDetails.getLineEstimate().getSubTypeOfWork());
        abstractEstimate.setExecutingDepartment(lineEstimateDetails.getLineEstimate().getExecutingDepartment());
        abstractEstimate.setWorkValue(lineEstimateDetails.getActualEstimateAmount().doubleValue());
        abstractEstimate.setEstimateValue(lineEstimateDetails.getActualEstimateAmount());
        abstractEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.APPROVED.toString()));
        abstractEstimate.setProjectCode(lineEstimateDetails.getProjectCode());
        abstractEstimate.setApprovedDate(lineEstimateDetails.getLineEstimate().getTechnicalSanctionDate());
        abstractEstimate.setLineEstimateDetails(lineEstimateDetails);
        abstractEstimate.addFinancialDetails(this.populateEstimateFinancialDetails(abstractEstimate));
        abstractEstimate.addMultiYearEstimate(this.populateMultiYearEstimate(abstractEstimate));
        return abstractEstimate;
    }

    public FinancialDetail populateEstimateFinancialDetails(AbstractEstimate abstractEstimate) {
        FinancialDetail financialDetail = new FinancialDetail();
        financialDetail.setAbstractEstimate(abstractEstimate);
        if (abstractEstimate.getLineEstimateDetails() != null) {
            financialDetail.setFund(abstractEstimate.getLineEstimateDetails().getLineEstimate().getFund());
            financialDetail.setFunction(abstractEstimate.getLineEstimateDetails().getLineEstimate().getFunction());
            financialDetail.setBudgetGroup(abstractEstimate.getLineEstimateDetails().getLineEstimate().getBudgetHead());
            financialDetail.setScheme(abstractEstimate.getLineEstimateDetails().getLineEstimate().getScheme());
            financialDetail.setSubScheme(abstractEstimate.getLineEstimateDetails().getLineEstimate().getSubScheme());
        }
        return financialDetail;
    }

    public MultiYearEstimate populateMultiYearEstimate(AbstractEstimate abstractEstimate) {
        MultiYearEstimate multiYearEstimate = new MultiYearEstimate();
        multiYearEstimate.setAbstractEstimate(abstractEstimate);
        if (abstractEstimate.getLineEstimateDetails() != null) {
            multiYearEstimate.setFinancialYear(this.worksUtils.getFinancialYearByDate(abstractEstimate.getLineEstimateDetails().getLineEstimate().getLineEstimateDate()));
        } else {
            multiYearEstimate.setFinancialYear(this.worksUtils.getFinancialYearByDate(new Date()));
        }
        multiYearEstimate.setPercentage(100.0);
        return multiYearEstimate;
    }

    private EstimateTechnicalSanction saveTechnicalSanction(AbstractEstimate abstractEstimate, int i) {
        EstimateTechnicalSanction estimateTechnicalSanction = new EstimateTechnicalSanction();
        estimateTechnicalSanction.setAbstractEstimate(abstractEstimate);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionNumber());
        if (i > 0) {
            stringBuilder.append("/");
            stringBuilder.append(i);
        }
        estimateTechnicalSanction.setTechnicalSanctionNumber(stringBuilder.toString());
        estimateTechnicalSanction.setTechnicalSanctionDate(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionDate());
        estimateTechnicalSanction.setTechnicalSanctionBy(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionBy());
        return this.estimateTechnicalSanctionService.save(estimateTechnicalSanction);
    }

    public AbstractEstimate getAbstractEstimateByEstimateNumber(String estimateNumber) {
        return this.abstractEstimateRepository.findByEstimateNumberAndEgwStatus_codeNotLike(estimateNumber, AbstractEstimate.EstimateStatus.CANCELLED.toString());
    }

    public AbstractEstimate getAbstractEstimateByEstimateNumberAndStatus(String estimateNumber) {
        List<AbstractEstimate> abstractEstimates = this.abstractEstimateRepository.findByEstimateNumberAndEgwStatus_codeEquals(estimateNumber, AbstractEstimate.EstimateStatus.APPROVED.toString());
        return !abstractEstimates.isEmpty() ? abstractEstimates.get(0) : null;
    }

    public AbstractEstimate getAbstractEstimateByLineEstimateDetailsForCancelLineEstimate(Long id) {
        return this.abstractEstimateRepository.findByLineEstimateDetails_IdAndEgwStatus_codeEquals(id, AbstractEstimate.EstimateStatus.APPROVED.toString());
    }

    public BigDecimal getPaymentsReleasedForLineEstimate(LineEstimateDetails lineEstimateDetails) {
        WorkProgressRegister workProgressRegister = this.workProgressRegisterService.getWorkProgressRegisterByLineEstimateDetailsId(lineEstimateDetails);
        return workProgressRegister != null ? workProgressRegister.getTotalBillPaidSoFar() : BigDecimal.ZERO;
    }

    public BigDecimal getPaymentsReleasedForAbstractEstimate(AbstractEstimate abstractEstimate) {
        WorkProgressRegister workProgressRegister = this.workProgressRegisterService.getWorkProgressRegisterByAbstractEstimate(abstractEstimate);
        return workProgressRegister != null ? workProgressRegister.getTotalBillPaidSoFar() : BigDecimal.ZERO;
    }

    public void loadModelValues(LineEstimateDetails lineEstimateDetails, Model model, AbstractEstimate abstractEstimate) {
        WorkOrderEstimate workOrderEstimate = null;
        BigDecimal paymentsReleased = null;
        if (lineEstimateDetails != null) {
            paymentsReleased = this.getPaymentsReleasedForLineEstimate(lineEstimateDetails);
            workOrderEstimate = this.workOrderEstimateService.getWorkOrderByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        } else if (abstractEstimate.getId() != null) {
            paymentsReleased = this.getPaymentsReleasedForAbstractEstimate(abstractEstimate);
            workOrderEstimate = this.workOrderEstimateService.getWorkOrderByEstimateNumber(abstractEstimate.getEstimateNumber());
        } else {
            paymentsReleased = BigDecimal.ZERO;
        }
        model.addAttribute("workOrder", (Object)(workOrderEstimate != null ? workOrderEstimate.getWorkOrder() : null));
        model.addAttribute("paymentsReleasedSoFar", (Object)paymentsReleased);
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_SERVICE_FIELDS");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isServiceVATRequired", (Object)true);
        } else {
            model.addAttribute("isServiceVATRequired", (Object)false);
        }
        List showEstimateDeductions = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_DEDUCTION_GRID");
        AppConfigValues showEstimateDeduction = (AppConfigValues)showEstimateDeductions.get(0);
        if (showEstimateDeduction.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isEstimateDeductionGrid", (Object)true);
        } else {
            model.addAttribute("isEstimateDeductionGrid", (Object)false);
        }
    }

    public void validateAssetDetails(AbstractEstimate abstractEstimate, BindingResult bindErrors) {
        if (this.worksApplicationProperties.assetRequired().toString().equalsIgnoreCase("Yes")) {
            List appConfigvalues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "ASSETDETAILS_REQUIRED");
            AppConfigValues value = (AppConfigValues)appConfigvalues.get(0);
            if (value.getValue().equalsIgnoreCase("Yes") && abstractEstimate.getTempAssetValues() != null && abstractEstimate.getTempAssetValues().isEmpty()) {
                bindErrors.reject("error.assetdetails.required", "error.assetdetails.required");
            }
            Asset asset = null;
            Integer index = 0;
            for (AssetsForEstimate assetsForEstimate : abstractEstimate.getTempAssetValues()) {
                if (assetsForEstimate == null) continue;
                if (StringUtils.isBlank((CharSequence)assetsForEstimate.getAsset().getCode())) {
                    bindErrors.rejectValue("tempAssetValues[" + index + "].asset.code", "error.assetcode.required");
                }
                if (StringUtils.isBlank((CharSequence)assetsForEstimate.getAsset().getName())) {
                    bindErrors.rejectValue("tempAssetValues[" + index + "].asset.name", "error.assetname.required");
                }
                if (asset != null && asset.getCode().equals(assetsForEstimate.getAsset().getCode())) {
                    bindErrors.rejectValue("tempAssetValues[" + index + "].asset.code", "error.asset.not.unique");
                }
                asset = assetsForEstimate.getAsset();
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
    }

    public Long getApprovalPositionByMatrixDesignation(AbstractEstimate abstractEstimate, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), additionalRule, abstractEstimate.getCurrentState().getValue(), null);
        if (abstractEstimate.getEgwStatus() != null && abstractEstimate.getEgwStatus().getCode() != null && (abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.CREATED.toString()) || abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.RESUBMITTED.toString())) && abstractEstimate.getState() != null && !"Approve".equalsIgnoreCase(workFlowAction)) {
            approvalPosition = mode.equals("edit") ? abstractEstimate.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), abstractEstimate.getState(), abstractEstimate.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    @Transactional
    public AbstractEstimate updateAbstractEstimateDetails(AbstractEstimate abstractEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, MultipartFile[] files, String removedActivityIds) throws ValidationException, IOException {
        AbstractEstimate updatedAbstractEstimate = null;
        if ((abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.NEW.toString()) || abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.REJECTED.toString())) && !workFlowAction.equals("Cancel")) {
            for (MultiYearEstimate multiYearEstimate : abstractEstimate.getMultiYearEstimates()) {
                multiYearEstimate.setAbstractEstimate(abstractEstimate);
            }
            for (FinancialDetail financialDetail : abstractEstimate.getFinancialDetails()) {
                financialDetail.setAbstractEstimate(abstractEstimate);
            }
            this.createOverheadValues(abstractEstimate);
            this.createEstimateDeductionValues(abstractEstimate);
            this.createAssetValues(abstractEstimate);
            this.mergeSorAndNonSorActivities(abstractEstimate);
            List<Activity> activities = new ArrayList<Activity>(abstractEstimate.getActivities());
            activities = this.removeDeletedActivities(activities, removedActivityIds);
            abstractEstimate.setActivities(activities);
            for (Activity activity : abstractEstimate.getActivities()) {
                activity.setAbstractEstimate(abstractEstimate);
            }
            List<DocumentDetails> list = this.worksUtils.getDocumentDetails(files, (Object)abstractEstimate, "AbstractEstimate");
            if (!list.isEmpty()) {
                abstractEstimate.setDocumentDetails(list);
                this.worksUtils.persistDocuments(list);
            }
        }
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && !this.worksApplicationProperties.lineEstimateRequired().booleanValue() && ("Create And Approve".equals(workFlowAction) || "Approve".equals(workFlowAction))) {
            this.doBudgetoryAppropriation(workFlowAction, abstractEstimate);
        }
        updatedAbstractEstimate = (AbstractEstimate)((Object)this.abstractEstimateRepository.save((Object)abstractEstimate));
        this.abstractEstimateStatusChange(updatedAbstractEstimate, workFlowAction, additionalRule);
        this.createAbstractEstimateWorkflowTransition(updatedAbstractEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if ("approve".equalsIgnoreCase(workFlowAction) || "Create And Approve".equalsIgnoreCase(workFlowAction) && !abstractEstimate.isSpillOverFlag()) {
            this.saveTechnicalSanctionDetails(updatedAbstractEstimate);
            this.saveAdminSanctionDetails(updatedAbstractEstimate);
            this.setProjectCode(updatedAbstractEstimate);
            this.createAccountDetailKey(updatedAbstractEstimate.getProjectCode());
        }
        this.abstractEstimateRepository.save((Object)updatedAbstractEstimate);
        return updatedAbstractEstimate;
    }

    private void createOverheadValues(AbstractEstimate abstractEstimate) {
        OverheadValue newOverheadValue = null;
        abstractEstimate.getOverheadValues().clear();
        for (OverheadValue overheadValue : abstractEstimate.getTempOverheadValues()) {
            newOverheadValue = new OverheadValue();
            newOverheadValue.setOverhead(this.overheadService.getOverheadById(overheadValue.getOverhead().getId()));
            newOverheadValue.setAmount(overheadValue.getAmount());
            newOverheadValue.setAbstractEstimate(abstractEstimate);
            abstractEstimate.getOverheadValues().add(newOverheadValue);
        }
    }

    private void createAssetValues(AbstractEstimate abstractEstimate) {
        AssetsForEstimate assetForEstimate = null;
        abstractEstimate.getAssetValues().clear();
        for (AssetsForEstimate assetEstimate : abstractEstimate.getTempAssetValues()) {
            assetForEstimate = new AssetsForEstimate();
            assetForEstimate.setAbstractEstimate(abstractEstimate);
            assetForEstimate.setAsset(this.assetService.findByCode(assetEstimate.getAsset().getCode()));
            abstractEstimate.getAssetValues().add(assetForEstimate);
        }
    }

    private List<Activity> removeDeletedActivities(List<Activity> activities, String removedActivityIds) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        if (null != removedActivityIds) {
            String[] ids = removedActivityIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (Activity activity : activities) {
                if (activity.getId() != null) {
                    if (strList.contains(activity.getId().toString())) continue;
                    activityList.add(activity);
                    continue;
                }
                activityList.add(activity);
            }
        } else {
            return activities;
        }
        return activityList;
    }

    public void saveAdminSanctionDetails(AbstractEstimate abstractEstimate) {
        abstractEstimate.setAdminSanctionBy(this.securityUtils.getCurrentUser().getUsername());
        abstractEstimate.setAdminSanctionDate(new Date());
        abstractEstimate.setApprovedBy(this.securityUtils.getCurrentUser());
        abstractEstimate.setApprovedDate(new Date());
    }

    public void saveTechnicalSanctionDetails(AbstractEstimate abstractEstimate) {
        EstimateTechnicalSanction estimateTechnicalSanction = new EstimateTechnicalSanction();
        estimateTechnicalSanction.setAbstractEstimate(abstractEstimate);
        estimateTechnicalSanction.setTechnicalSanctionBy(this.securityUtils.getCurrentUser());
        estimateTechnicalSanction.setTechnicalSanctionDate(new Date());
        TechnicalSanctionNumberGenerator tsng = (TechnicalSanctionNumberGenerator)this.beanResolver.getAutoNumberServiceFor(TechnicalSanctionNumberGenerator.class);
        if (!abstractEstimate.isSpillOverFlag()) {
            estimateTechnicalSanction.setTechnicalSanctionNumber(tsng.getNextNumber(abstractEstimate));
        } else {
            estimateTechnicalSanction.setTechnicalSanctionNumber(abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionNumber());
        }
        abstractEstimate.getEstimateTechnicalSanctions().clear();
        abstractEstimate.getEstimateTechnicalSanctions().add(estimateTechnicalSanction);
    }

    public void abstractEstimateStatusChange(AbstractEstimate abstractEstimate, String workFlowAction, String additionalRule) {
        if (null != abstractEstimate && workFlowAction.equals("Save")) {
            abstractEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.NEW.toString()));
        } else if (null != abstractEstimate && workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
            abstractEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.REJECTED.toString()));
        } else if (workFlowAction.equals("Cancel")) {
            abstractEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
        } else if (null != abstractEstimate && null != abstractEstimate.getState()) {
            WorkFlowMatrix wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), additionalRule, abstractEstimate.getCurrentState().getValue(), abstractEstimate.getState().getNextAction());
            abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", wfmatrix.getNextStatus().toUpperCase()));
        }
    }

    public void createAbstractEstimateWorkflowTransition(AbstractEstimate abstractEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Abstract/Detailed Estimate";
        WorkFlowMatrix wfmatrix = null;
        if (null != abstractEstimate.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(abstractEstimate.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                abstractEstimate.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Abstract/Detailed Estimate");
            } else {
                abstractEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Abstract/Detailed Estimate");
            }
        } else if ("Save".toString().equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), additionalRule, "NEW", null);
            if (abstractEstimate.getState() == null) {
                abstractEstimate.transition(true).start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("NEW").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Pending Submission").withNatureOfTask("Abstract/Detailed Estimate");
            }
        } else {
            if (!(null == approvalPosition || approvalPosition == -1L || approvalPosition.equals(0L) || "Cancel".toString().equalsIgnoreCase(workFlowAction) || "Approve".toString().equalsIgnoreCase(workFlowAction) || "Create And Approve".equalsIgnoreCase(workFlowAction))) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == abstractEstimate.getState()) {
                wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), additionalRule, "", null);
                abstractEstimate.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Abstract/Detailed Estimate");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                abstractEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Abstract/Detailed Estimate");
            } else {
                wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), additionalRule, abstractEstimate.getCurrentState().getValue(), abstractEstimate.getState().getNextAction());
                abstractEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Abstract/Detailed Estimate");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public List<String> getAbstractEstimateByEstimateNumberLike(String estimateNumber) {
        return this.abstractEstimateRepository.findDistinctEstimateNumberContainingIgnoreCase("%" + estimateNumber + "%");
    }

    public List<User> getAbstractEstimateCreatedByUsers() {
        return this.abstractEstimateRepository.findAbstractEstimateCreatedByUsers();
    }

    public List<AbstractEstimate> searchAbstractEstimates(SearchAbstractEstimate searchAbstractEstimate) {
        if (searchAbstractEstimate != null) {
            Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AbstractEstimate.class).createAlias("egwStatus", "status").createAlias("projectCode", "pc");
            criteria.add(Restrictions.isNull((String)"parent.id"));
            if (searchAbstractEstimate.getAbstractEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)searchAbstractEstimate.getAbstractEstimateNumber()));
            }
            if (searchAbstractEstimate.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)searchAbstractEstimate.getDepartment()));
            }
            if (searchAbstractEstimate.getWorkIdentificationNumber() != null) {
                criteria.add(Restrictions.ilike((String)"pc.code", (String)searchAbstractEstimate.getWorkIdentificationNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchAbstractEstimate.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.id", (Object)Integer.valueOf(searchAbstractEstimate.getStatus())));
            }
            if (searchAbstractEstimate.getCreatedBy() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)searchAbstractEstimate.getCreatedBy()));
            }
            if (searchAbstractEstimate.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"estimateDate", (Object)searchAbstractEstimate.getFromDate()));
            }
            if (searchAbstractEstimate.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"estimateDate", (Object)searchAbstractEstimate.getToDate()));
            }
            if (searchAbstractEstimate.getSpillOverFlag().booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)searchAbstractEstimate.getSpillOverFlag()));
            }
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            return criteria.list();
        }
        return new ArrayList<AbstractEstimate>();
    }

    public List<User> getAbstractEstimateCreatedByUsers(List<Long> departmentIds) {
        return this.abstractEstimateRepository.findAbstractEstimateCreatedByUsers(departmentIds);
    }

    public List<AbstractEstimate> searchAbstractEstimatesForLoa(AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest) {
        ArrayList<AbstractEstimate> abstractEstimates = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(estimate) from AbstractEstimate estimate where estimate.parent.id is null and estimate.egwStatus.code = :aeStatus and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where estimate.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != upper(:woStatus) and upper(estimate.egwStatus.code) = upper(:aeStatus))");
        queryStr.append(" and exists (select act.abstractEstimate from Activity as act where estimate.id = act.abstractEstimate.id )");
        if (abstractEstimateForLoaSearchRequest != null) {
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionNumber() != null) {
                queryStr.append(" and upper(estimate.adminSanctionNumber) like upper(:adminSanctionNumber)");
            }
            if (abstractEstimateForLoaSearchRequest.getExecutingDepartment() != null) {
                queryStr.append(" and estimate.executingDepartment.id = :departmentId");
            }
            if (abstractEstimateForLoaSearchRequest.getEstimateNumber() != null) {
                queryStr.append(" and upper(estimate.estimateNumber) = upper(:estimateNumber)");
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate() != null) {
                queryStr.append(" and estimate.approvedDate >= :fromDate");
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionToDate() != null) {
                queryStr.append(" and estimate.approvedDate <= :toDate");
            }
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy() != null) {
                queryStr.append(" and estimate.createdBy.id = :createdById");
            }
            if (abstractEstimateForLoaSearchRequest.getWorkIdentificationNumber() != null) {
                queryStr.append(" and upper(estimate.projectCode.code) = upper(:projectCode)");
            }
        }
        if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null && abstractEstimateForLoaSearchRequest.getEgwStatus().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString())) {
            queryStr.append(" and exists (select off.id from OfflineStatus as off where off.objectId = estimate.id and off.objectType = :objectType and upper(off.egwStatus.code) = upper(:offStatus) )");
        } else if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null && abstractEstimateForLoaSearchRequest.getEgwStatus().equalsIgnoreCase("APPROVED")) {
            queryStr.append(" and estimate.modeOfAllotment = :modeOfAllotment");
        } else {
            queryStr.append(" and (exists (select off.id from OfflineStatus as off where off.objectId = estimate.id and off.objectType = :objectType and upper(off.egwStatus.code) = upper(:offStatus) ) or estimate.modeOfAllotment = :modeOfAllotment)");
        }
        queryStr.append(" and estimate.spillOverFlag = :spillOverFlag");
        Query query = this.setQueryParametersForCreateLOA(abstractEstimateForLoaSearchRequest, queryStr);
        abstractEstimates = query.getResultList();
        return abstractEstimates;
    }

    private Query setQueryParametersForCreateLOA(AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        List<AppConfigValues> nominationName = this.getNominationName();
        if (abstractEstimateForLoaSearchRequest != null) {
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionNumber() != null) {
                qry.setParameter("adminSanctionNumber", (Object)("%" + abstractEstimateForLoaSearchRequest.getAdminSanctionNumber() + "%"));
            }
            if (abstractEstimateForLoaSearchRequest.getExecutingDepartment() != null) {
                qry.setParameter("departmentId", (Object)abstractEstimateForLoaSearchRequest.getExecutingDepartment());
            }
            if (abstractEstimateForLoaSearchRequest.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)abstractEstimateForLoaSearchRequest.getEstimateNumber());
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate() != null) {
                qry.setParameter("fromDate", (Object)abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate());
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionToDate() != null) {
                qry.setParameter("toDate", (Object)abstractEstimateForLoaSearchRequest.getAdminSanctionToDate());
            }
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy() != null) {
                qry.setParameter("createdById", (Object)abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy());
            }
            if (abstractEstimateForLoaSearchRequest.getWorkIdentificationNumber() != null) {
                qry.setParameter("projectCode", (Object)abstractEstimateForLoaSearchRequest.getWorkIdentificationNumber());
            }
            qry.setParameter("spillOverFlag", (Object)abstractEstimateForLoaSearchRequest.isSpillOverFlag());
            qry.setParameter("woStatus", (Object)"CANCELLED");
            qry.setParameter("aeStatus", (Object)AbstractEstimate.EstimateStatus.APPROVED.toString());
        }
        if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null && abstractEstimateForLoaSearchRequest.getEgwStatus().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString())) {
            qry.setParameter("objectType", (Object)"AbstractEstimate");
            qry.setParameter("offStatus", (Object)AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString());
        } else if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null && abstractEstimateForLoaSearchRequest.getEgwStatus().equalsIgnoreCase("APPROVED")) {
            qry.setParameter("modeOfAllotment", (Object)(!nominationName.isEmpty() ? nominationName.get(0).getValue() : ""));
        } else {
            qry.setParameter("objectType", (Object)"AbstractEstimate");
            qry.setParameter("offStatus", (Object)AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString());
            qry.setParameter("modeOfAllotment", (Object)(!nominationName.isEmpty() ? nominationName.get(0).getValue() : ""));
        }
        return qry;
    }

    public List<AbstractEstimateForLoaSearchResult> searchAbstractEstimatesForLOA(AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest) {
        List<AbstractEstimate> abstractEstimates = this.searchAbstractEstimatesForLoa(abstractEstimateForLoaSearchRequest);
        ArrayList<AbstractEstimateForLoaSearchResult> abstractEstimateForLoaSearchResults = new ArrayList<AbstractEstimateForLoaSearchResult>();
        for (AbstractEstimate ae : abstractEstimates) {
            AbstractEstimateForLoaSearchResult result = new AbstractEstimateForLoaSearchResult();
            if (ae.getLineEstimateDetails() != null) {
                result.setAdminSanctionNumber(ae.getAdminSanctionNumber());
                result.setLeId(ae.getLineEstimateDetails().getLineEstimate().getId());
            }
            result.setAeId(ae.getId());
            result.setCreatedBy(ae.getCreatedBy().getName());
            result.setEstimateAmount(ae.getEstimateValue());
            result.setEstimateNumber(ae.getEstimateNumber());
            result.setNameOfWork(ae.getName());
            if (ae.getApprovedBy() != null) {
                result.setAdminSanctionBy(ae.getApprovedBy().getName());
            }
            if (ae.getProjectCode() != null) {
                result.setWorkIdentificationNumber(ae.getProjectCode().getCode());
            }
            abstractEstimateForLoaSearchResults.add(result);
        }
        return abstractEstimateForLoaSearchResults;
    }

    public void validateActivities(AbstractEstimate abstractEstimate, BindingResult errors) {
        block0: for (int i = 0; i < abstractEstimate.getSorActivities().size() - 1; ++i) {
            for (int j = i + 1; j < abstractEstimate.getSorActivities().size(); ++j) {
                if (abstractEstimate.getSorActivities().get(i).getSchedule() == null || !abstractEstimate.getSorActivities().get(i).getSchedule().getId().equals(abstractEstimate.getSorActivities().get(j).getSchedule().getId())) continue;
                errors.reject("error.sor.duplicate", "error.sor.duplicate");
                continue block0;
            }
        }
        for (Activity activity : abstractEstimate.getSorActivities()) {
            if (activity.getQuantity() <= 0.0) {
                errors.reject("error.quantity.zero", "error.quantity.zero");
            }
            if (!(activity.getRate() <= 0.0)) continue;
            errors.reject("error.rates.zero", "error.rates.zero");
        }
        for (Activity activity : abstractEstimate.getNonSorActivities()) {
            if (activity.getQuantity() <= 0.0) {
                errors.reject("error.quantity.zero", "error.quantity.zero");
            }
            if (!(activity.getRate() <= 0.0)) continue;
            errors.reject("error.rates.zero", "error.rates.zero");
        }
    }

    public void validateOverheads(AbstractEstimate abstractEstimate, BindingResult errors) {
        for (OverheadValue value : abstractEstimate.getTempOverheadValues()) {
            if (value.getOverhead().getId() != null) continue;
            errors.reject("error.overhead.null", "error.overhead.null");
            break;
        }
        for (OverheadValue value : abstractEstimate.getTempOverheadValues()) {
            if (!(value.getAmount() <= 0.0)) continue;
            errors.reject("error.overhead.amount", "error.overhead.amount");
            break;
        }
    }

    public void validateBudgetHead(AbstractEstimate abstractEstimate, BindingResult errors) {
        if (!abstractEstimate.getFinancialDetails().isEmpty()) {
            Boolean check = false;
            ArrayList accountDetails = new ArrayList();
            accountDetails.addAll(abstractEstimate.getFinancialDetails().get(0).getBudgetGroup().getMaxCode().getChartOfAccountDetails());
            for (CChartOfAccountDetail detail : accountDetails) {
                if (detail.getDetailTypeId() == null || !detail.getDetailTypeId().getName().equalsIgnoreCase("PROJECTCODE")) continue;
                check = true;
            }
            if (!check.booleanValue()) {
                errors.reject("error.budgethead.validate", "error.budgethead.validate");
            }
        }
    }

    public void validateMultiYearEstimates(AbstractEstimate abstractEstimate, BindingResult bindErrors) {
        Object cFinancialYear = null;
        Double totalPercentage = 0.0;
        Integer index = 0;
        for (MultiYearEstimate multiYearEstimate : abstractEstimate.getMultiYearEstimates()) {
            totalPercentage = totalPercentage + multiYearEstimate.getPercentage();
            if (multiYearEstimate.getFinancialYear() == null) {
                bindErrors.rejectValue("multiYearEstimates[" + index + "].financialYear", "error.finyear.required");
            }
            if (multiYearEstimate.getPercentage() == 0.0) {
                bindErrors.rejectValue("multiYearEstimates[" + index + "].percentage", "error.percentage.required");
            }
            if (cFinancialYear != null && cFinancialYear.equals(multiYearEstimate.getFinancialYear())) {
                bindErrors.rejectValue("multiYearEstimates[" + index + "].financialYear", "error.financialYear.unique");
            }
            if (totalPercentage > 100.0) {
                bindErrors.rejectValue("multiYearEstimates[" + index + "].percentage", "error.percentage.greater");
            }
            cFinancialYear = multiYearEstimate.getFinancialYear();
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
    }

    public void validateMandatory(AbstractEstimate abstractEstimate, BindingResult bindErrors) {
        LineEstimateDetails lineEstimateDetails;
        if (StringUtils.isBlank((CharSequence)abstractEstimate.getDescription())) {
            bindErrors.rejectValue("description", "error.description.required");
        }
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            if (abstractEstimate.getExecutingDepartment() == null) {
                bindErrors.rejectValue("executingdepartment", "error.executingdepartment.required");
            }
            if (abstractEstimate.getNatureOfWork() == null) {
                bindErrors.rejectValue("natureOfWork", "error.natureofwork.required");
            }
            if (abstractEstimate.getWard() == null) {
                bindErrors.rejectValue("ward", "error.electionward.required");
            }
            if (abstractEstimate.getName() == null) {
                bindErrors.rejectValue("name", "error.nameofwork.required");
            }
            if (abstractEstimate.getParentCategory() == null) {
                bindErrors.rejectValue("parentCategory", "error.typeofwork.select");
            }
            if (abstractEstimate.getWorkCategory() == null) {
                bindErrors.rejectValue("workCategory", "error.workcategory.select");
            }
            if (!abstractEstimate.getFinancialDetails().isEmpty()) {
                if (abstractEstimate.getFinancialDetails().get(0).getFund() == null) {
                    bindErrors.rejectValue("financialDetails[0].fund", "error.fund.required");
                }
                if (abstractEstimate.getFinancialDetails().get(0).getFunction() == null) {
                    bindErrors.rejectValue("financialDetails[0].function", "error.function.required");
                }
                if (abstractEstimate.getFinancialDetails().get(0).getBudgetGroup() == null) {
                    bindErrors.rejectValue("financialDetails[0].budgetGroup", "error.budgethead.required");
                }
            }
        }
        if ((lineEstimateDetails = abstractEstimate.getLineEstimateDetails()) != null && abstractEstimate.getEstimateValue() != null && abstractEstimate.getEstimateValue().compareTo(lineEstimateDetails.getEstimateAmount()) == 1) {
            BigDecimal diffValue = abstractEstimate.getEstimateValue().subtract(lineEstimateDetails.getEstimateAmount());
            bindErrors.reject("error.estimatevalue.greater", (Object[])new String[]{diffValue.toString(), lineEstimateDetails.getEstimateAmount().setScale(2, 0).toString()}, "error.estimatevalue.greater");
        }
    }

    public void setDropDownValues(Model model) {
        model.addAttribute("exceptionaluoms", (Object)this.worksUtils.getExceptionalUOMS());
        model.addAttribute("overheads", this.overheadService.getOverheadsByDate(new Date()));
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
        model.addAttribute("scheduleCategories", this.scheduleCategoryService.getAllScheduleCategories());
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            model.addAttribute("functions", (Object)this.functionHibernateDAO.getAllActiveFunctions());
            model.addAttribute("budgetHeads", (Object)this.budgetGroupDAO.getBudgetGroupList());
        }
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("departments", this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
        model.addAttribute("natureOfWork", this.natureOfWorkService.findAll());
        model.addAttribute("finYear", (Object)this.financialYearDAO.findAll());
        model.addAttribute("uoms", (Object)this.uomService.findAll());
        model.addAttribute("workCategory", (Object)WorkCategory.values());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("localities", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
        model.addAttribute("modeOfAllotment", this.modeOfAllotmentService.findAll());
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_SERVICE_FIELDS");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isServiceVATRequired", (Object)true);
        } else {
            model.addAttribute("isServiceVATRequired", (Object)false);
        }
        this.loadLocationAppConfigValue(model);
    }

    public void validateTechnicalSanctionDetail(AbstractEstimate abstractEstimate, BindingResult errors) {
        AbstractEstimate esistingAbstractEstimate;
        if (abstractEstimate.getEstimateTechnicalSanctions() != null && abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionDate() == null) {
            errors.reject("error.techdate.notnull", "error.techdate.notnull");
        }
        if (abstractEstimate.getEstimateTechnicalSanctions() != null && abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionDate() != null && abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionDate().before(abstractEstimate.getEstimateDate())) {
            errors.reject("error.abstracttechnicalsanctiondate", "error.abstracttechnicalsanctiondate");
        }
        if (abstractEstimate.getEstimateTechnicalSanctions() != null && abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionNumber() == null) {
            errors.reject("error.technumber.notnull", "error.technumber.notnull");
        }
        if (abstractEstimate.getEstimateTechnicalSanctions() != null && abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionNumber() != null && (esistingAbstractEstimate = this.abstractEstimateRepository.findByEstimateTechnicalSanctionsIgnoreCase_TechnicalSanctionNumberAndEgwStatus_CodeNot(abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionNumber(), AbstractEstimate.EstimateStatus.CANCELLED.toString())) != null) {
            errors.reject("error.technumber.unique", "error.technumber.unique");
        }
        if (abstractEstimate.getEstimateDate() == null) {
            errors.reject("errors.abbstractestimate.estimatedate", "errors.abbstractestimate.estimatedate");
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getEstimateDate() != null && abstractEstimate.getEstimateDate().before(abstractEstimate.getLineEstimateDetails().getLineEstimate().getAdminSanctionDate())) {
            errors.reject("error.abstractadminsanctiondatele", "error.abstractadminsanctiondatele");
        }
    }

    public void setTechnicalSanctionDetails(AbstractEstimate abstractEstimate) {
        if (abstractEstimate.getEstimateTechnicalSanctions() != null) {
            abstractEstimate.getEstimateTechnicalSanctions().get(0).setAbstractEstimate(abstractEstimate);
            abstractEstimate.setApprovedDate(abstractEstimate.getEstimateTechnicalSanctions().get(0).getTechnicalSanctionDate());
        }
        abstractEstimate.setApprovedBy(this.securityUtils.getCurrentUser());
    }

    public List<String> getAbstractEstimateNumbersToCancelLineEstimate(Long lineEstimateId) {
        List<String> estimateNumbers = this.abstractEstimateRepository.findAbstractEstimateNumbersToCancelLineEstimate(lineEstimateId, AbstractEstimate.EstimateStatus.CANCELLED.toString());
        return estimateNumbers;
    }

    @Transactional
    public AbstractEstimate cancel(AbstractEstimate abstractEstimate) {
        abstractEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue() && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.estimateAppropriationService.releaseBudgetOnRejectForEstimate(abstractEstimate, abstractEstimate.getEstimateValue().doubleValue(), null);
        }
        return (AbstractEstimate)((Object)this.abstractEstimateRepository.save((Object)abstractEstimate));
    }

    public List<AbstractEstimate> searchEstimatesToCancel(SearchRequestCancelEstimate searchRequestCancelEstimate) {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(ae) from AbstractEstimate ae where exists (select distinct(activity.id) from Activity activity where activity.abstractEstimate.id = ae.id) and not exists (select distinct(woe) from WorkOrderEstimate as woe where woe.estimate.id = ae.id and woe.workOrder.egwStatus.code != :workOrderStatus) ");
        queryStr.append(" and ae.parent.id is null ");
        if (searchRequestCancelEstimate != null) {
            if (searchRequestCancelEstimate.getEstimateNumber() != null) {
                queryStr.append(" and upper(ae.estimateNumber) = upper(:estimateNumber)");
            }
            if (searchRequestCancelEstimate.getLineEstimateNumber() != null) {
                queryStr.append(" and upper(ae.lineEstimateDetails.lineEstimate.lineEstimateNumber) like upper(:lineEstimateNumber)");
            }
            if (searchRequestCancelEstimate.getWinCode() != null) {
                queryStr.append(" and upper(ae.projectCode.code) like upper(:projectCode)");
            }
            if (searchRequestCancelEstimate.getStatus() != null) {
                queryStr.append(" and upper(ae.egwStatus.code) = upper(:status)");
            }
            if (searchRequestCancelEstimate.getFromDate() != null) {
                queryStr.append(" and ae.estimateDate >= :fromDate");
            }
            if (searchRequestCancelEstimate.getToDate() != null) {
                queryStr.append(" and ae.estimateDate <= :toDate");
            }
        }
        Query query = this.setQueryParametersForAbstractEstimate(searchRequestCancelEstimate, queryStr);
        return query.getResultList();
    }

    private Query setQueryParametersForAbstractEstimate(SearchRequestCancelEstimate searchRequestCancelEstimate, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchRequestCancelEstimate != null) {
            if (searchRequestCancelEstimate.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)searchRequestCancelEstimate.getEstimateNumber());
            }
            if (searchRequestCancelEstimate.getLineEstimateNumber() != null) {
                qry.setParameter("lineEstimateNumber", (Object)("%" + searchRequestCancelEstimate.getLineEstimateNumber() + "%"));
            }
            if (searchRequestCancelEstimate.getWinCode() != null) {
                qry.setParameter("projectCode", (Object)("%" + searchRequestCancelEstimate.getWinCode() + "%"));
            }
            if (searchRequestCancelEstimate.getStatus() != null) {
                qry.setParameter("status", (Object)AbstractEstimate.EstimateStatus.APPROVED.toString());
            }
            if (searchRequestCancelEstimate.getFromDate() != null) {
                qry.setParameter("fromDate", (Object)searchRequestCancelEstimate.getFromDate());
            }
            if (searchRequestCancelEstimate.getToDate() != null) {
                qry.setParameter("toDate", (Object)searchRequestCancelEstimate.getToDate());
            }
        }
        qry.setParameter("workOrderStatus", (Object)"CANCELLED");
        return qry;
    }

    public List<String> findEstimateNumbersToCancelEstimate(String code) {
        List<String> estimateNumbers = this.abstractEstimateRepository.findAbstractEstimateNumbersToCancelEstimate("%" + code + "%", AbstractEstimate.EstimateStatus.CANCELLED.toString(), AbstractEstimate.EstimateStatus.APPROVED.toString());
        return estimateNumbers;
    }

    public List<AbstractEstimate> searchAbstractEstimatesForOfflineStatus(AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest) {
        ArrayList<AbstractEstimate> abstractEstimateList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(ae) from AbstractEstimate ae where ae.parent is null and ae.egwStatus.code =:abstractEstimateStatus and ae.modeOfAllotment != :modeOfAllotment and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where woe.estimate.id = ae.id and woe.workOrder.egwStatus.code != :workOrderStatus )");
        if (abstractEstimateForLoaSearchRequest != null) {
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateNumber() != null) {
                queryStr.append(" and upper(ae.estimateNumber) =:abstractEstimateNumber");
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate() != null) {
                queryStr.append(" and ae.approvedDate >= :abstractEstimateFromDate");
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionToDate() != null) {
                queryStr.append(" and ae.approvedDate <= :abstractEstimateToDate");
            }
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy() != null) {
                queryStr.append(" and ae.createdBy.id = :abstractEstimateCreatedBy");
            }
            if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null) {
                if (abstractEstimateForLoaSearchRequest.getEgwStatus().equals("APPROVED")) {
                    queryStr.append(" and not exists (select distinct(os.objectId) from OfflineStatus as os where os.objectType = :objectType and ae.id = os.objectId )");
                } else if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null) {
                    queryStr.append(" and ae.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = ae.id) and os.objectId = ae.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )");
                }
            }
        }
        Query query = this.setQueryParametersForOfflineStatus(abstractEstimateForLoaSearchRequest, queryStr);
        abstractEstimateList = query.getResultList();
        return abstractEstimateList;
    }

    private Query setQueryParametersForOfflineStatus(AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        List<AppConfigValues> nominationName = this.getNominationName();
        if (abstractEstimateForLoaSearchRequest != null) {
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateNumber() != null) {
                qry.setParameter("abstractEstimateNumber", (Object)abstractEstimateForLoaSearchRequest.getAbstractEstimateNumber().toUpperCase());
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate() != null) {
                qry.setParameter("abstractEstimateFromDate", (Object)abstractEstimateForLoaSearchRequest.getAdminSanctionFromDate());
            }
            if (abstractEstimateForLoaSearchRequest.getAdminSanctionToDate() != null) {
                qry.setParameter("abstractEstimateToDate", (Object)abstractEstimateForLoaSearchRequest.getAdminSanctionToDate());
            }
            if (abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy() != null) {
                qry.setParameter("abstractEstimateCreatedBy", (Object)abstractEstimateForLoaSearchRequest.getAbstractEstimateCreatedBy());
            }
            if (abstractEstimateForLoaSearchRequest.getEgwStatus() != null) {
                qry.setParameter("objectType", (Object)"AbstractEstimate");
                if (!abstractEstimateForLoaSearchRequest.getEgwStatus().equals("APPROVED")) {
                    qry.setParameter("offlineStatus", (Object)abstractEstimateForLoaSearchRequest.getEgwStatus().toString().toLowerCase());
                }
            }
            qry.setParameter("abstractEstimateStatus", (Object)"APPROVED");
            qry.setParameter("workOrderStatus", (Object)"CANCELLED");
            qry.setParameter("modeOfAllotment", (Object)(!nominationName.isEmpty() ? nominationName.get(0).getValue() : ""));
        }
        return qry;
    }

    public List<String> getAbstractEstimateNumbersToSetOfflineStatus(String code) {
        List<AppConfigValues> nominationName = this.getNominationName();
        List<String> estimateNumbers = this.abstractEstimateRepository.findAbstractEstimateNumbersToSetOfflineStatus("%" + code + "%", "APPROVED", "CANCELLED", !nominationName.isEmpty() ? nominationName.get(0).getValue() : "");
        return estimateNumbers;
    }

    public void validateLocationDetails(AbstractEstimate abstractEstimate, BindingResult bindErrors) {
        List appConfigvalues;
        AppConfigValues value;
        if (this.worksApplicationProperties.locationDetailsRequired().toString().equalsIgnoreCase("Yes") && (value = (AppConfigValues)(appConfigvalues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "GIS_INTEGRATION")).get(0)).getValue().equalsIgnoreCase("Yes") && (StringUtils.isBlank((CharSequence)abstractEstimate.getLocation()) || abstractEstimate.getLatitude() == null || abstractEstimate.getLongitude() == null)) {
            bindErrors.reject("error.locationdetails.required", "error.locationdetails.required");
        }
    }

    public void loadLocationAppConfigValue(Model model) {
        List locationAppConfigvalues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "GIS_INTEGRATION");
        AppConfigValues locationAppConfigValue = (AppConfigValues)locationAppConfigvalues.get(0);
        if (locationAppConfigValue.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isLocationDetailsRequired", (Object)true);
        } else {
            model.addAttribute("isLocationDetailsRequired", (Object)false);
        }
    }

    public List<String> getApprovedEstimateNumbersForCreateLOA(String estimateNumber) {
        List<AppConfigValues> nominationName = this.getNominationName();
        List<String> estimateNumbers = this.abstractEstimateRepository.findEstimateNumbersToCreateLOA("%" + estimateNumber + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), "CANCELLED", "AbstractEstimate", AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString(), !nominationName.isEmpty() ? nominationName.get(0).getValue() : "");
        return estimateNumbers;
    }

    public List<String> getApprovedAdminSanctionNumbersForCreateLOA(String adminSanctionNumber) {
        List<AppConfigValues> nominationName = this.getNominationName();
        List<String> adminSanctionNumbers = this.abstractEstimateRepository.findAdminSanctionNumbersToCreateLOA("%" + adminSanctionNumber + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), "CANCELLED", "AbstractEstimate", AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString(), !nominationName.isEmpty() ? nominationName.get(0).getValue() : "");
        return adminSanctionNumbers;
    }

    public List<String> getApprovedWorkIdentificationNumbersForCreateLOA(String workIdentificationNumber) {
        List<AppConfigValues> nominationName = this.getNominationName();
        List<String> workIdentificationNumbers = this.abstractEstimateRepository.findWorkIdentificationNumbersToCreateLOA("%" + workIdentificationNumber + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), "CANCELLED", "AbstractEstimate", AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString(), !nominationName.isEmpty() ? nominationName.get(0).getValue() : "");
        return workIdentificationNumbers;
    }

    public List<Hashtable<String, Object>> getMeasurementSheetForEstimate(AbstractEstimate abstractEstimate) {
        ArrayList<Hashtable<String, Object>> measurementSheetList = new ArrayList<Hashtable<String, Object>>();
        int slno = 1;
        Hashtable<String, Object> measurementSheetMap = null;
        ArrayList<String> characters = new ArrayList<String>(26);
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            characters.add(String.valueOf(c));
        }
        for (Activity activity : abstractEstimate.getActivities()) {
            if (activity.getMeasurementSheetList().size() != 0) {
                measurementSheetList.add(this.addActivityName(activity, slno));
                int measurementSNo = 1;
                for (MeasurementSheet ms : activity.getMeasurementSheetList()) {
                    measurementSheetMap = new Hashtable<String, Object>(0);
                    measurementSheetMap.put("sNo", String.valueOf(slno) + (String)characters.get((measurementSNo - 1) % 26));
                    measurementSheetMap.put("no", ms.getNo() != null ? ms.getNo() : "");
                    measurementSheetMap.put("scheduleCategory", "");
                    measurementSheetMap.put("scheduleCode", "");
                    measurementSheetMap.put("description", ms.getRemarks() != null ? ms.getRemarks() : "");
                    measurementSheetMap.put("length", ms.getLength() != null ? ms.getLength() : "");
                    measurementSheetMap.put("width", ms.getWidth() != null ? ms.getWidth() : "");
                    measurementSheetMap.put("depthHeigth", ms.getDepthOrHeight() != null ? ms.getDepthOrHeight() : "");
                    if (ms.getIdentifier() == 'D') {
                        measurementSheetMap.put("quantity", BigDecimal.ZERO.subtract(ms.getQuantity()));
                    } else {
                        measurementSheetMap.put("quantity", ms.getQuantity());
                    }
                    measurementSheetMap.put("rate", "");
                    measurementSheetMap.put("uom", "");
                    measurementSheetMap.put("amount", "");
                    measurementSheetList.add(measurementSheetMap);
                    ++measurementSNo;
                }
                if (activity.getMeasurementSheetList().size() != 0) {
                    measurementSheetMap = new Hashtable(0);
                    measurementSheetMap.put("sNo", "");
                    measurementSheetMap.put("no", "");
                    measurementSheetMap.put("scheduleCategory", "");
                    measurementSheetMap.put("scheduleCode", "");
                    measurementSheetMap.put("description", "");
                    measurementSheetMap.put("length", "");
                    measurementSheetMap.put("width", "");
                    measurementSheetMap.put("depthHeigth", "");
                    measurementSheetMap.put("quantity", activity.getQuantity());
                    measurementSheetMap.put("rate", activity.getRate());
                    measurementSheetMap.put("uom", activity.getUom().getUom());
                    measurementSheetMap.put("amount", activity.getAmount().getValue());
                    measurementSheetList.add(measurementSheetMap);
                }
                ++slno;
                continue;
            }
            measurementSheetList.add(this.addActivityName(activity, slno++));
        }
        return measurementSheetList;
    }

    private Hashtable<String, Object> addActivityName(Activity activity, int slNo) {
        Hashtable<String, Object> measurementSheetMap = new Hashtable<String, Object>(0);
        measurementSheetMap.put("sNo", slNo);
        measurementSheetMap.put("no", "");
        if (activity.getSchedule() != null) {
            measurementSheetMap.put("scheduleCategory", activity.getSchedule().getScheduleCategory().getCode());
            measurementSheetMap.put("scheduleCode", activity.getSchedule().getCode());
            measurementSheetMap.put("description", activity.getSchedule().getDescription());
        } else {
            measurementSheetMap.put("scheduleCategory", "N/A");
            measurementSheetMap.put("scheduleCode", "N/A");
            measurementSheetMap.put("description", activity.getNonSor().getDescription());
        }
        measurementSheetMap.put("length", "");
        measurementSheetMap.put("width", "");
        measurementSheetMap.put("depthHeigth", "");
        if (activity.getMeasurementSheetList().size() != 0) {
            measurementSheetMap.put("quantity", "");
            measurementSheetMap.put("rate", "");
            measurementSheetMap.put("uom", "");
            measurementSheetMap.put("amount", "");
        } else {
            measurementSheetMap.put("quantity", activity.getQuantity());
            measurementSheetMap.put("rate", activity.getEstimateRate());
            measurementSheetMap.put("uom", activity.getUom().getUom());
            measurementSheetMap.put("amount", activity.getAmount().getValue());
        }
        return measurementSheetMap;
    }

    public List<AbstractEstimate> getBySorIdAndEstimateDate(Long sorId, Date estimateDate) {
        return this.abstractEstimateRepository.findBySorIdAndEstimateDate(sorId, estimateDate, "CANCELLED");
    }

    public List<Activity> getActivitiesByParent(Long activityId) {
        return this.abstractEstimateRepository.findActivitiesByParent(activityId, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    public List<WorkOrderEstimate> getBySorIdAndWorkOrderDate(Long sorId, Date workOrderDate) {
        return this.abstractEstimateRepository.findBySorIdAndWorkOrderDate(sorId, workOrderDate, "CANCELLED");
    }

    public List<User> getCreatedByForEstimatePhotograph() {
        return this.abstractEstimateRepository.findCreatedByForEstimatePhotograph(AbstractEstimate.EstimateStatus.APPROVED.toString());
    }

    private void createEstimateDeductionValues(AbstractEstimate abstractEstimate) {
        AbstractEstimateDeduction deduction = null;
        abstractEstimate.getAbsrtractEstimateDeductions().clear();
        for (AbstractEstimateDeduction deductions : abstractEstimate.getTempDeductionValues()) {
            deduction = new AbstractEstimateDeduction();
            deduction.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)deductions.getChartOfAccounts().getId(), false));
            deduction.setAmount(deductions.getAmount());
            deduction.setAbstractEstimate(abstractEstimate);
            deduction.setPercentage(deductions.getPercentage());
            abstractEstimate.getAbsrtractEstimateDeductions().add(deduction);
        }
    }

    public boolean checkForDuplicateAccountCodesInEstimateDeductions(AbstractEstimate abstractEstimate) {
        HashSet<Long> glCodeIdSet = new HashSet<Long>();
        for (AbstractEstimateDeduction deductions : abstractEstimate.getTempDeductionValues()) {
            if (deductions.getChartOfAccounts().getGlcode() == null) continue;
            if (glCodeIdSet.contains(Long.parseLong(deductions.getChartOfAccounts().getGlcode()))) {
                return false;
            }
            glCodeIdSet.add(Long.parseLong(deductions.getChartOfAccounts().getGlcode()));
        }
        return true;
    }

    public List<AppConfigValues> getNominationName() {
        List nominationName = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_NAME");
        return nominationName;
    }

    public List<Map<Long, String>> findEstimateNumbersToCopyEstimate(String code) {
        List<Object[]> estimates = this.abstractEstimateRepository.findAbstractEstimateNumbersToCopyEstimate("%" + code + "%", AbstractEstimate.EstimateStatus.APPROVED.toString());
        ArrayList<Map<Long, String>> estimatesMap = new ArrayList<Map<Long, String>>();
        for (Object[] ae : estimates) {
            HashMap<Long, String> estimateMap = new HashMap<Long, String>();
            estimateMap.put(Long.valueOf(ae[0].toString()), ae[1].toString());
            estimatesMap.add(estimateMap);
        }
        return estimatesMap;
    }

    public List<Activity> getActivitiesByEstimate(Long estimateId) {
        return this.abstractEstimateRepository.findActivitiesByEstimate(estimateId);
    }

    public List<AbstractEstimate> searchEstimatesToCopy(AbstractEstimateForCopyEstimate abstractEstimateForCopyEstimate) {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(ae) from AbstractEstimate ae where exists (select distinct(activity.id) from Activity activity where activity.abstractEstimate.id = ae.id)");
        queryStr.append(" and ae.parent.id is null ");
        if (abstractEstimateForCopyEstimate != null) {
            if (abstractEstimateForCopyEstimate.getEstimateNumber() != null) {
                queryStr.append(" and upper(ae.estimateNumber) = upper(:estimateNumber)");
            }
            if (abstractEstimateForCopyEstimate.getStatus() != null) {
                queryStr.append(" and upper(ae.egwStatus.code) = upper(:status)");
            }
            if (abstractEstimateForCopyEstimate.getAbstractEstimateCreatedBy() != null) {
                queryStr.append(" and ae.createdBy.id = :createdBy");
            }
            if (abstractEstimateForCopyEstimate.getTypeOfWork() != null) {
                queryStr.append(" and ae.parentCategory.id = :typeOfWork");
            }
        }
        Query query = this.setQueryParametersForAbstractEstimateToCopy(abstractEstimateForCopyEstimate, queryStr);
        return query.getResultList();
    }

    private Query setQueryParametersForAbstractEstimateToCopy(AbstractEstimateForCopyEstimate abstractEstimateForCopyEstimate, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (abstractEstimateForCopyEstimate != null) {
            if (abstractEstimateForCopyEstimate.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)abstractEstimateForCopyEstimate.getEstimateNumber());
            }
            if (abstractEstimateForCopyEstimate.getStatus() != null) {
                qry.setParameter("status", (Object)AbstractEstimate.EstimateStatus.APPROVED.toString());
            }
            if (abstractEstimateForCopyEstimate.getAbstractEstimateCreatedBy() != null) {
                qry.setParameter("createdBy", (Object)abstractEstimateForCopyEstimate.getAbstractEstimateCreatedBy());
            }
            if (abstractEstimateForCopyEstimate.getTypeOfWork() != null) {
                qry.setParameter("typeOfWork", (Object)abstractEstimateForCopyEstimate.getTypeOfWork());
            }
        }
        return qry;
    }

    public List<EstimateTemplate> searchEstimateTemplates(EstimateTemplateSearchRequest estimateTemplateSearchRequest) {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(et) from EstimateTemplate et where 1 = 1 ");
        if (estimateTemplateSearchRequest != null) {
            if (estimateTemplateSearchRequest.getTypeOfWork() != null) {
                queryStr.append(" and et.workType.id = :typeOfWork");
            }
            if (estimateTemplateSearchRequest.getSubTypeOfWork() != null) {
                queryStr.append(" and et.subType.id = :subTypeOfWork");
            }
            if (estimateTemplateSearchRequest.getTemplateCode() != null) {
                queryStr.append(" and upper(et.code) = :code");
            }
            if (estimateTemplateSearchRequest.getTemplateDescription() != null) {
                queryStr.append(" and upper(et.description) = :description");
            }
            if (estimateTemplateSearchRequest.getTemplateName() != null) {
                queryStr.append(" and upper(et.name) = :name");
            }
            if (estimateTemplateSearchRequest.getStatus() != null) {
                queryStr.append(" and et.status = :status");
            }
        }
        Query query = this.setQueryParametersForSearchEstimateTemplate(estimateTemplateSearchRequest, queryStr);
        return query.getResultList();
    }

    private Query setQueryParametersForSearchEstimateTemplate(EstimateTemplateSearchRequest estimateTemplateSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (estimateTemplateSearchRequest != null) {
            if (estimateTemplateSearchRequest.getTypeOfWork() != null) {
                qry.setParameter("typeOfWork", (Object)estimateTemplateSearchRequest.getTypeOfWork());
            }
            if (estimateTemplateSearchRequest.getSubTypeOfWork() != null) {
                qry.setParameter("subTypeOfWork", (Object)estimateTemplateSearchRequest.getSubTypeOfWork());
            }
            if (estimateTemplateSearchRequest.getTemplateCode() != null) {
                qry.setParameter("code", (Object)estimateTemplateSearchRequest.getTemplateCode().toUpperCase());
            }
            if (estimateTemplateSearchRequest.getTemplateDescription() != null) {
                qry.setParameter("description", (Object)estimateTemplateSearchRequest.getTemplateDescription().toUpperCase());
            }
            if (estimateTemplateSearchRequest.getTemplateName() != null) {
                qry.setParameter("name", (Object)estimateTemplateSearchRequest.getTemplateName().toUpperCase());
            }
            if (estimateTemplateSearchRequest.getStatus() != null) {
                qry.setParameter("status", (Object)estimateTemplateSearchRequest.getStatus());
            }
        }
        return qry;
    }

    @Transactional
    public void setProjectCode(AbstractEstimate abstractEstimate) {
        ProjectCode projectCode = null;
        if (abstractEstimate.getProjectCode() != null) {
            projectCode = abstractEstimate.getProjectCode();
            projectCode.setCode(abstractEstimate.getProjectCode().getCode());
        } else {
            projectCode = new ProjectCode();
            projectCode.setCode(this.workIdentificationNumberGenerator.generateAbstractEstimateWorkOrderIdentificationNumber(abstractEstimate));
            abstractEstimate.setProjectCode(projectCode);
        }
        projectCode.setCodeName(abstractEstimate.getName());
        projectCode.setDescription(abstractEstimate.getName());
        projectCode.setActive(true);
        projectCode.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ProjectCode.class.getSimpleName(), "CREATED"));
    }

    protected void createAccountDetailKey(ProjectCode proj) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("PROJECTCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(proj.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public void validateWorkflowActionButton(AbstractEstimate abstractEstimate, BindingResult bindErrors, String additionalRule, String workFlowAction) {
        HashMap map = new HashMap();
        map.putAll((Map)this.scriptService.executeScript("ABSTRACTESTIMATE-APPROVALRULES", ScriptService.createContext((Object[])new Object[]{"estimateValue", abstractEstimate.getEstimateValue(), "cityGrade", additionalRule})));
        boolean validateWorkflowButton = (Boolean)map.get("createAndApproveFieldsRequired");
        if (validateWorkflowButton && WorksConstants.FORWARD_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            bindErrors.reject("error.create.approve", "error.create.approve");
        } else if (!validateWorkflowButton && "Create And Approve".toString().equalsIgnoreCase(workFlowAction)) {
            bindErrors.reject("error.forward.approve", "error.forward.approve");
        }
    }

    public List<AbstractEstimate> searchAbstractEstimateForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct(ae) from AbstractEstimate as ae where ae.egwStatus.code != :abstractEstimateStatus and ae.parent is null ");
        if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
            queryStr.append(" and ae.executingDepartment.id = :executingDepartment");
        }
        if (StringUtils.isNotBlank((CharSequence)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
            queryStr.append(" and upper(ae.projectCode.code) = :workIdentificationNumber");
        }
        if (StringUtils.isNotBlank((CharSequence)estimatePhotographSearchRequest.getEstimateNumber())) {
            queryStr.append(" and upper(ae.estimateNumber) = :estimateNumber");
        }
        if (estimatePhotographSearchRequest.getFromDate() != null) {
            queryStr.append(" and ae.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getToDate() != null) {
            queryStr.append(" and ae.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
            queryStr.append(" and ae.natureOfWork.id = :natureOfWork");
        }
        Query query = this.setParameterForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        return query.getResultList();
    }

    private Query setParameterForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("abstractEstimateStatus", (Object)"CANCELLED");
        if (estimatePhotographSearchRequest != null) {
            if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
                qry.setParameter("executingDepartment", (Object)estimatePhotographSearchRequest.getExecutingDepartment());
            }
            if (StringUtils.isNotBlank((CharSequence)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
                qry.setParameter("workIdentificationNumber", (Object)estimatePhotographSearchRequest.getWorkIdentificationNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((CharSequence)estimatePhotographSearchRequest.getEstimateNumber())) {
                qry.setParameter("estimateNumber", (Object)estimatePhotographSearchRequest.getEstimateNumber().toUpperCase());
            }
            if (estimatePhotographSearchRequest.getFromDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getFromDate());
            }
            if (estimatePhotographSearchRequest.getToDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getToDate());
            }
            if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
                qry.setParameter("natureOfWork", (Object)estimatePhotographSearchRequest.getNatureOfWork());
            }
        }
        return qry;
    }

    public List<String> getEstimateNumbersForEstimatePhotograph(String estimateNumber) {
        return this.abstractEstimateRepository.findEstimateNumbersForEstimatePhotograph("%" + estimateNumber + "%", "CANCELLED");
    }

    public List<String> getWinForEstimatePhotograph(String workIdentificationNumber) {
        return this.abstractEstimateRepository.findWorkIdentificationNumberForEstimatePhotograph("%" + workIdentificationNumber + "%", "CANCELLED");
    }
}

