/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_ESTIMATE_PHOTOGRAPHS")
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_PHOTOGRAPHS", sequenceName="SEQ_EGW_ESTIMATE_PHOTOGRAPHS", allocationSize=1)
public class EstimatePhotographs
extends AbstractAuditable {
    private static final long serialVersionUID = -4760202350886149567L;
    public static final String SEQ_EGW_ESTIMATEPHOTOGRAPHS = "SEQ_EGW_ESTIMATE_PHOTOGRAPHS";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_PHOTOGRAPHS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lineestimatedetails")
    private LineEstimateDetails lineEstimateDetails;
    private double latitude;
    private double longitude;
    @SafeHtml
    @Length(max=1024)
    private String description;
    @Temporal(value=TemporalType.DATE)
    private Date dateOfCapture;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="filestore", nullable=false)
    private FileStoreMapper fileStore;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private WorkProgress workProgress;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractestimate")
    private AbstractEstimate abstractestimate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDateOfCapture() {
        return this.dateOfCapture;
    }

    public void setDateOfCapture(Date dateOfCapture) {
        this.dateOfCapture = dateOfCapture;
    }

    public LineEstimateDetails getLineEstimateDetails() {
        return this.lineEstimateDetails;
    }

    public void setLineEstimateDetails(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetails = lineEstimateDetails;
    }

    public FileStoreMapper getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStoreMapper fileStore) {
        this.fileStore = fileStore;
    }

    public WorkProgress getWorkProgress() {
        return this.workProgress;
    }

    public void setWorkProgress(WorkProgress workProgress) {
        this.workProgress = workProgress;
    }

    public AbstractEstimate getAbstractestimate() {
        return this.abstractestimate;
    }

    public void setAbstractestimate(AbstractEstimate abstractestimate) {
        this.abstractestimate = abstractestimate;
    }

    public static enum WorkProgress {
        BEFORE,
        DURING,
        AFTER;


        public String toString() {
            return StringUtils.replace((String)this.name(), (String)"_", (String)" ");
        }
    }
}

