/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.workorder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infstr.models.BaseModel;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.AssetsForWorkOrder;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderActivity;

public class WorkOrderEstimate
extends BaseModel {
    private static final long serialVersionUID = 2083096871794612166L;
    private WorkOrder workOrder;
    private AbstractEstimate estimate;
    private Date workCompletionDate;
    private double estimateWOAmount;
    private List<WorkOrderActivity> workOrderActivities = new LinkedList<WorkOrderActivity>();
    @Valid
    private List<AssetsForWorkOrder> assetValues = new LinkedList<AssetsForWorkOrder>();
    private Set<Milestone> milestone = new HashSet<Milestone>();
    private Milestone latestMilestone;
    private Set<ContractorAdvanceRequisition> contractorAdvanceRequisitions = new HashSet<ContractorAdvanceRequisition>();
    private Set<MBHeader> mbHeaders = new HashSet<MBHeader>();

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public AbstractEstimate getEstimate() {
        return this.estimate;
    }

    public void setEstimate(AbstractEstimate estimate) {
        this.estimate = estimate;
    }

    public List<WorkOrderActivity> getWorkOrderActivities() {
        return this.workOrderActivities;
    }

    public void setWorkOrderActivities(List<WorkOrderActivity> workOrderActivities) {
        this.workOrderActivities = workOrderActivities;
    }

    public void addWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivities.add(workOrderActivity);
    }

    public Money getTotalWorkValue() {
        double amt = 0.0;
        for (WorkOrderActivity workOrderActivity : this.workOrderActivities) {
            amt += workOrderActivity.getApprovedAmount();
        }
        return new Money(amt);
    }

    public Set<MBHeader> getMbHeaders() {
        return this.mbHeaders;
    }

    public void setMbHeaders(Set<MBHeader> mbHeaders) {
        this.mbHeaders = mbHeaders;
    }

    public Date getWorkCompletionDate() {
        return this.workCompletionDate;
    }

    public void setWorkCompletionDate(Date workCompletionDate) {
        this.workCompletionDate = workCompletionDate;
    }

    public List<AssetsForWorkOrder> getAssetValues() {
        return this.assetValues;
    }

    public void setAssetValues(List<AssetsForWorkOrder> assetValues) {
        this.assetValues = assetValues;
    }

    public void addAssetValue(AssetsForWorkOrder assetValue) {
        this.assetValues.add(assetValue);
    }

    public Set<Milestone> getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Set<Milestone> milestone) {
        this.milestone = milestone;
    }

    public Milestone getLatestMilestone() {
        ArrayList<Milestone> milestoneList = new ArrayList<Milestone>();
        milestoneList.addAll(this.getMilestone());
        if (!milestoneList.isEmpty()) {
            Collections.sort(milestoneList, Milestone.milestoneComparator);
            this.latestMilestone = (Milestone)milestoneList.get(milestoneList.size() - 1);
        }
        return this.latestMilestone;
    }

    public void setLatestMilestone(Milestone latestMilestone) {
        this.latestMilestone = latestMilestone;
    }

    public Set<ContractorAdvanceRequisition> getContractorAdvanceRequisitions() {
        return this.contractorAdvanceRequisitions;
    }

    public void setContractorAdvanceRequisitions(Set<ContractorAdvanceRequisition> contractorAdvanceRequisitions) {
        this.contractorAdvanceRequisitions = contractorAdvanceRequisitions;
    }

    public double getEstimateWOAmount() {
        return this.estimateWOAmount;
    }

    public void setEstimateWOAmount(double estimateWOAmount) {
        this.estimateWOAmount = estimateWOAmount;
    }
}

