/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import com.opensymphony.xwork2.validator.annotations.StringLengthFieldValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Unique(fields={"code"}, id="id", tableName="EGW_SCHEDULECATEGORY", columnName={"CODE"}, message="scheduleCategory.code.isunique")
public class ScheduleCategory
extends BaseModel {
    private static final long serialVersionUID = -9168726999209110086L;
    @Length(max=150, message="ScheCategory.description.length")
    private String description;
    @Length(max=15, message="ScheCategory.code.length")
    @Required(message="contractor.code.null")
    private String code;
    private ScheduleCategory parent;
    @PersistenceContext
    private EntityManager entityManager;

    public ScheduleCategory() {
    }

    public ScheduleCategory getParent() {
        return this.parent;
    }

    public void setParent(ScheduleCategory parent) {
        this.parent = parent;
    }

    @StringLengthFieldValidator(fieldName="description", message="ScheCategory.description.length", key="i18n.key", shortCircuit=true, trim=true, minLength="1", maxLength="150")
    @NotEmpty(message="scheduleCategory.description.not.empty")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotEmpty(message="scheduleCategory.code.not.empty")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ScheduleCategory(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getSearchableData() {
        return this.getCode() + " " + this.getDescription() + " " + (this.parent == null ? "" : this.parent.getSearchableData());
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.code == null && this.description == null) {
            return Arrays.asList(new ValidationError("code", "scheduleCategory.code.not.empty"));
        }
        if (this.description == null) {
            return Arrays.asList(new ValidationError("description", "scheduleCategory.description.not.empty"));
        }
        if (validationErrors.isEmpty()) {
            return null;
        }
        return validationErrors;
    }
}

