/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.pims.commons.Designation;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.repository.ContractorBillRegisterRepository;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.entity.WorkOrderHistory;
import org.egov.works.letterofacceptance.repository.LetterOfAcceptanceRepository;
import org.egov.works.letterofacceptance.repository.WorkOrderHistoryRepository;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.utils.WorksUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LetterOfAcceptanceService {
    @PersistenceContext
    private EntityManager entityManager;
    private final LetterOfAcceptanceRepository letterOfAcceptanceRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private WorkOrderHistoryRepository workOrderHistoryRepository;
    @Autowired
    private ContractorBillRegisterRepository contractorBillRegisterRepository;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public LetterOfAcceptanceService(LetterOfAcceptanceRepository letterOfAcceptanceRepository) {
        this.letterOfAcceptanceRepository = letterOfAcceptanceRepository;
    }

    public WorkOrder getWorkOrderById(Long id) {
        return this.letterOfAcceptanceRepository.findById(id);
    }

    public List<String> getApprovedWorkOrderByNumberToModifyLOA(String name) {
        return this.letterOfAcceptanceRepository.findDistinctWorkorderNumberToModifyLOA("%" + name + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
    }

    @Transactional
    public WorkOrder create(WorkOrder workOrder, MultipartFile[] files) throws IOException {
        WorkOrder savedworkOrder;
        List<DocumentDetails> documentDetails;
        workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "APPROVED"));
        if (StringUtils.isNotBlank((String)workOrder.getPercentageSign()) && workOrder.getPercentageSign().equals("-")) {
            workOrder.setTenderFinalizedPercentage(workOrder.getTenderFinalizedPercentage() * -1.0);
        }
        if (!(documentDetails = this.worksUtils.getDocumentDetails(files, (Object)(savedworkOrder = (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder))), "WorkOrder")).isEmpty()) {
            savedworkOrder.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedworkOrder;
    }

    public WorkOrderEstimate createWorkOrderEstimate(WorkOrder workOrder) {
        WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
        workOrderEstimate.setWorkOrder(workOrder);
        workOrderEstimate.setEstimate(this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(workOrder.getEstimateNumber()));
        workOrderEstimate.setEstimateWOAmount(workOrder.getWorkOrderAmount());
        workOrderEstimate.setCreatedBy(this.securityUtils.getCurrentUser());
        workOrderEstimate.setModifiedBy(this.securityUtils.getCurrentUser());
        workOrderEstimate.setCreatedDate(new Date());
        workOrderEstimate.setModifiedDate(new Date());
        workOrder.addWorkOrderEstimate(workOrderEstimate);
        return workOrderEstimate;
    }

    public WorkOrder getWorkOrderByWorkOrderNumber(String workOrderNumber) {
        return this.letterOfAcceptanceRepository.findByWorkOrderNumberAndEgwStatus_codeNotLike(workOrderNumber, "CANCELLED");
    }

    public List<Long> getEngineerInchargeDesignationIds() {
        ArrayList<Long> designationIds = new ArrayList<Long>();
        ArrayList<String> designationNames = new ArrayList<String>();
        List configList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "ENGINEERINCHARGE_DESIGNATION");
        for (AppConfigValues value : configList) {
            designationNames.add(value.getValue().toUpperCase());
        }
        List designations = this.designationService.getDesignationsByNames(designationNames);
        for (Designation designation : designations) {
            designationIds.add(designation.getId());
        }
        return designationIds;
    }

    public List<Assignment> getEngineerInchargeList(Long departmentId, List<Long> designationIds) {
        return this.assignmentService.findByDepartmentDesignationsAndGivenDate(departmentId, designationIds, new Date());
    }

    public WorkOrder getWorkOrderByEstimateNumber(String estimateNumber) {
        return this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeNotLike(estimateNumber, "CANCELLED");
    }

    public WorkOrder getLetterOfAcceptanceDocumentAttachments(WorkOrder workOrder) {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }

    public WorkOrder getApprovedWorkOrder(String workOrderNumber) {
        return this.letterOfAcceptanceRepository.findByWorkOrderNumberAndEgwStatus_codeEquals(workOrderNumber, "APPROVED");
    }

    public List<WorkOrder> searchLetterOfAcceptance(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List<String> estimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(searchRequestLetterOfAcceptance.getDepartmentName());
        if (estimateNumbers.isEmpty()) {
            estimateNumbers.add("");
        }
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrder.class, "wo").addOrder(Order.asc((String)"workOrderDate")).createAlias("wo.contractor", "woc").createAlias("egwStatus", "status");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate()));
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate()));
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestLetterOfAcceptance.getName()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                criteria.add(Restrictions.ilike((String)"fileNumber", (String)searchRequestLetterOfAcceptance.getFileNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestLetterOfAcceptance.getEgwStatus()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<WorkOrder> searchLetterOfAcceptanceForContractorBill(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List<String> estimateNumbers = this.lineEstimateService.getEstimateNumberForDepartment(searchRequestLetterOfAcceptance.getDepartmentName());
        if (estimateNumbers.isEmpty()) {
            estimateNumbers.add("");
        }
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.getDistinctNonCancelledWorkOrderNumbersByBillType(ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrder.class, "wo").createAlias("contractor", "woc").createAlias("egwStatus", "status");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate()));
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate()));
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestLetterOfAcceptance.getName()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                criteria.add(Restrictions.ilike((String)"fileNumber", (String)searchRequestLetterOfAcceptance.getFileNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
            if (workOrderNumbers != null && !workOrderNumbers.isEmpty()) {
                criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"workOrderNumber", workOrderNumbers)));
            }
        }
        criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)"APPROVED"));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> getApprovedEstimateNumbersToModifyLOA(String name) {
        return this.letterOfAcceptanceRepository.findDistinctEstimateNumberToModifyLOA("%" + name + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
    }

    public List<String> findDistinctContractorsInWorkOrderByCodeOrName(String name) {
        List<String> results = this.letterOfAcceptanceRepository.findDistinctContractorByContractor_codeAndNameContainingIgnoreCase("%" + name + "%");
        return results;
    }

    public List<String> findLoaEstimateNumbersForContractorBill(String estimateNumber) {
        List<WorkOrder> workorders = this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeEquals(estimateNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrder details : workorders) {
            results.add(details.getEstimateNumber());
        }
        return results;
    }

    public List<String> getApprovedWorkOrdersForCreateContractorBill(String workOrderNumber) {
        List<String> results = this.letterOfAcceptanceRepository.findWorkOrderNumberForContractorBill("%" + workOrderNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        return results;
    }

    public List<String> getApprovedEstimateNumbersForCreateContractorBill(String estimateNumber) {
        List<String> results = this.letterOfAcceptanceRepository.findEstimateNumberForContractorBill("%" + estimateNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        return results;
    }

    public List<String> getApprovedContractorsForCreateContractorBill(String contractorname) {
        List<String> results = this.letterOfAcceptanceRepository.findContractorForContractorBill("%" + contractorname + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        return results;
    }

    public Boolean validateContractorBillInWorkflowForWorkorder(Long workOrderId) {
        List<String> results = this.letterOfAcceptanceRepository.getContractorBillInWorkflowForWorkorder(workOrderId, ContractorBillRegister.BillStatus.CANCELLED.toString(), ContractorBillRegister.BillStatus.APPROVED.toString());
        if (results.isEmpty()) {
            return true;
        }
        return false;
    }

    public List<ContractorDetail> searchContractorDetails(SearchRequestContractor searchRequestContractor) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ContractorDetail.class, "cd").createAlias("contractor", "contractor").createAlias("cd.status", "status");
        if (searchRequestContractor != null) {
            if (searchRequestContractor.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)searchRequestContractor.getDepartment()));
            }
            if (searchRequestContractor.getContractorClass() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"grade.id", (Object)searchRequestContractor.getContractorClass()));
            }
            if (searchRequestContractor.getContractorCode() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"contractor.code", (Object)searchRequestContractor.getContractorCode()).ignoreCase());
            }
            if (searchRequestContractor.getNameOfAgency() != null) {
                criteria.add(Restrictions.ilike((String)"contractor.name", (String)searchRequestContractor.getNameOfAgency(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)"Active").ignoreCase());
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findLoaWorkOrderNumberForMilestone(String workOrderNumber) {
        List<WorkOrder> workorders = this.letterOfAcceptanceRepository.findByWorkOrderNumberContainingIgnoreCaseAndEgwStatus_codeEquals(workOrderNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrder details : workorders) {
            results.add(details.getWorkOrderNumber());
        }
        return results;
    }

    public List<String> findWorkIdentificationNumbersToCreateMilestone(String code) {
        List<String> workIdNumbers = this.letterOfAcceptanceRepository.findWorkIdentificationNumberToCreateMilestone("%" + code + "%");
        return workIdNumbers;
    }

    public List<WorkOrder> getLoaForCreateMilestone(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClause(searchRequestLetterOfAcceptance, queryStr);
        Query query = this.setParameterForMilestone(searchRequestLetterOfAcceptance, queryStr);
        List workOrderList = query.getResultList();
        return workOrderList;
    }

    private void buildWhereClause(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        queryStr.append("select distinct wo from WorkOrder wo where wo.egwStatus.moduletype = :moduleType and wo.egwStatus.code = :status and not exists (select ms.workOrderEstimate.workOrder.id from Milestone ms where ms.workOrderEstimate.workOrder.id = wo.id and upper(wo.egwStatus.code)  != upper(:workorderstatus) and upper(ms.status.code)  != upper(:milestonestatus))");
        queryStr.append(" and wo.estimateNumber in (select led.estimateNumber from LineEstimateDetails led where led.lineEstimate.executingDepartment.id = :departmentName)");
        if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getWorkIdentificationNumber())) {
            queryStr.append(" and wo.estimateNumber = (select led.estimateNumber from LineEstimateDetails led where led.projectCode = (select po.id from ProjectCode po where upper(po.code) = :workIdentificationNumber))");
        }
        if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getEstimateNumber())) {
            queryStr.append(" and upper(wo.estimateNumber) = :estimateNumber");
        }
        if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getWorkOrderNumber())) {
            queryStr.append(" and upper(wo.workOrderNumber) = :workOrderNumber");
        }
        if (searchRequestLetterOfAcceptance.getTypeOfWork() != null) {
            queryStr.append(" and wo.estimateNumber in (select led.estimateNumber from LineEstimateDetails led where led.lineEstimate.typeOfWork.id = :typeOfWork)");
        }
        if (searchRequestLetterOfAcceptance.getSubTypeOfWork() != null) {
            queryStr.append(" and wo.estimateNumber in (select led.estimateNumber from LineEstimateDetails led where led.lineEstimate.subTypeOfWork.id = :subTypeOfWork)");
        }
        if (searchRequestLetterOfAcceptance.getAdminSanctionFromDate() != null) {
            queryStr.append(" and wo.estimateNumber in (select led.estimateNumber from LineEstimateDetails led where led.lineEstimate.adminSanctionDate >= :adminSanctionFromDate)");
        }
        if (searchRequestLetterOfAcceptance.getAdminSanctionToDate() != null) {
            queryStr.append(" and wo.estimateNumber in (select led.estimateNumber from LineEstimateDetails led where led.lineEstimate.adminSanctionDate <= :adminSanctionFromDate)");
        }
    }

    private Query setParameterForMilestone(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("status", (Object)"APPROVED");
        qry.setParameter("moduleType", (Object)"WorkOrder");
        qry.setParameter("workorderstatus", (Object)"CANCELLED");
        qry.setParameter("milestonestatus", (Object)"CANCELLED");
        if (searchRequestLetterOfAcceptance != null) {
            qry.setParameter("departmentName", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getWorkIdentificationNumber())) {
                qry.setParameter("workIdentificationNumber", (Object)searchRequestLetterOfAcceptance.getWorkIdentificationNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getEstimateNumber())) {
                qry.setParameter("estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)searchRequestLetterOfAcceptance.getWorkOrderNumber())) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getTypeOfWork() != null) {
                qry.setParameter("typeOfWork", (Object)searchRequestLetterOfAcceptance.getTypeOfWork());
            }
            if (searchRequestLetterOfAcceptance.getSubTypeOfWork() != null) {
                qry.setParameter("subTypeOfWork", (Object)searchRequestLetterOfAcceptance.getSubTypeOfWork());
            }
            if (searchRequestLetterOfAcceptance.getAdminSanctionFromDate() != null) {
                qry.setParameter("adminSanctionFromDate", (Object)searchRequestLetterOfAcceptance.getAdminSanctionFromDate());
            }
            if (searchRequestLetterOfAcceptance.getAdminSanctionToDate() != null) {
                qry.setParameter("adminSanctionToDate", (Object)searchRequestLetterOfAcceptance.getAdminSanctionToDate());
            }
        }
        return qry;
    }

    public Double getGrossBillAmountOfBillsCreated(String workOrderNumber, String status, String billstatus) {
        return this.letterOfAcceptanceRepository.getGrossBillAmountOfBillsCreated(workOrderNumber, status, billstatus);
    }

    @Transactional
    public WorkOrder update(WorkOrder workOrder, LineEstimateDetails lineEstimateDetails, Double appropriationAmount, Double revisedWorkOrderAmount) throws ValidationException {
        WorkOrderHistory history = new WorkOrderHistory();
        history.setWorkOrder(workOrder);
        history.setWorkOrderAmount(workOrder.getWorkOrderAmount());
        history.setRevisedWorkOrderAmount(revisedWorkOrderAmount);
        this.workOrderHistoryRepository.save((Object)history);
        workOrder.setWorkOrderAmount(revisedWorkOrderAmount);
        if (StringUtils.isNotBlank((String)workOrder.getPercentageSign()) && workOrder.getPercentageSign().equals("-")) {
            workOrder.setTenderFinalizedPercentage(workOrder.getTenderFinalizedPercentage() * -1.0);
        }
        if (workOrder.getPercentageSign().equals("+")) {
            if (appropriationAmount > 0.0 && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                ArrayList<Long> budgetheadid = new ArrayList<Long>();
                budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
                boolean flag = this.lineEstimateDetailService.checkConsumeEncumbranceBudget(lineEstimateDetails, this.lineEstimateService.getCurrentFinancialYear(new Date()).getId(), appropriationAmount, budgetheadid);
                if (!flag) {
                    throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
                }
            }
        } else if (workOrder.getPercentageSign().equals("-") && appropriationAmount > 0.0 && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            String appropriationNumber = this.lineEstimateAppropriationService.generateBudgetAppropriationNumber(lineEstimateDetails);
            try {
                this.lineEstimateService.releaseBudgetOnReject(lineEstimateDetails, appropriationAmount, appropriationNumber);
            }
            catch (ValidationException v) {
                throw new ValidationException(v.getErrors());
            }
        }
        WorkOrder savedworkOrder = (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
        return savedworkOrder;
    }

    public List<WorkOrder> searchLetterOfAcceptanceToModify(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List<String> estimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(searchRequestLetterOfAcceptance.getDepartmentName());
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.findWorkOrderNumbersToModifyLoa("APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        if (estimateNumbers.isEmpty()) {
            estimateNumbers.add("");
        }
        if (workOrderNumbers.isEmpty()) {
            workOrderNumbers.add("");
        }
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrder.class, "wo").addOrder(Order.asc((String)"workOrderDate")).createAlias("wo.contractor", "woc").createAlias("egwStatus", "status");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate()));
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate()));
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestLetterOfAcceptance.getName()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                criteria.add(Restrictions.ilike((String)"fileNumber", (String)searchRequestLetterOfAcceptance.getFileNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
        }
        criteria.add(Restrictions.in((String)"workOrderNumber", workOrderNumbers));
        criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)"APPROVED"));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<WorkOrder> searchLOAsToCancel(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrder.class, "wo").addOrder(Order.asc((String)"workOrderDate")).createAlias("wo.contractor", "woc").createAlias("egwStatus", "status");
        if (searchRequestLetterOfAcceptance != null) {
            List<String> estimateNumbers;
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getContractor() != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestLetterOfAcceptance.getContractor()).ignoreCase(), (Criterion)Restrictions.eq((String)"woc.code", (Object)searchRequestLetterOfAcceptance.getContractor()).ignoreCase()));
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                estimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(searchRequestLetterOfAcceptance.getDepartmentName());
                if (estimateNumbers.isEmpty()) {
                    estimateNumbers.add("");
                }
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
            if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
                estimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForWorkIdentificationNumber(searchRequestLetterOfAcceptance.getWorkIdentificationNumber());
                if (estimateNumbers.isEmpty()) {
                    estimateNumbers.add("");
                }
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestLetterOfAcceptance.getEgwStatus()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findWorkIdentificationNumbersToSearchLOAToCancel(String code) {
        List<String> workIdNumbers = this.letterOfAcceptanceRepository.findWorkIdentificationNumbersToSearchLOAToCancel("%" + code + "%", "APPROVED".toString());
        return workIdNumbers;
    }

    public List<String> findContractorsToSearchLOAToCancel(String code) {
        List<String> contractors = this.letterOfAcceptanceRepository.findContractorsToSearchLOAToCancel("%" + code + "%", "APPROVED".toString());
        return contractors;
    }

    public String checkIfBillsCreated(Long id) {
        String billNumbers = "";
        WorkOrder workOrder = this.letterOfAcceptanceRepository.findById(id);
        List<ContractorBillRegister> bills = this.contractorBillRegisterRepository.findByWorkOrderAndBillstatusNot(workOrder, ContractorBillRegister.BillStatus.CANCELLED.toString());
        if (bills == null || bills.isEmpty()) {
            return "";
        }
        for (ContractorBillRegister cbr : bills) {
            billNumbers = billNumbers + cbr.getBillnumber() + ", ";
        }
        return billNumbers;
    }

    public boolean checkIfMileStonesCreated(WorkOrder workOrder) {
        Boolean flag = false;
        block0: for (WorkOrderEstimate woe : workOrder.getWorkOrderEstimates()) {
            List<Milestone> milestones = this.milestoneService.getMilestoneByWorkOrderEstimateId(woe.getId());
            for (Milestone ms : milestones) {
                if (!ms.getStatus().getCode().equalsIgnoreCase("cancelled")) {
                    flag = true;
                    continue block0;
                }
                if (!flag.booleanValue()) continue;
                continue block0;
            }
        }
        return flag;
    }

    @Transactional
    public WorkOrder cancel(WorkOrder workOrder) {
        workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
        workOrder.setStatus("cancelled".toString());
        return (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
    }

    public List<WorkOrder> findWorkOrderByEstimateNumberAndEgwStatus(String estimateNumber) {
        return this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeEquals(estimateNumber, "APPROVED");
    }

    public List<String> getEstimateNumbersToSearchLOAToCancel(Long lineEstimateId) {
        List<String> estimateNumbers = this.letterOfAcceptanceRepository.findEstimateNumbersToSearchLOAToCancel(lineEstimateId, "APPROVED".toString());
        return estimateNumbers;
    }

    public List<String> getWorkOrderNumbersForViewEstimatePhotograph(String workOrderNumber) {
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.findworkOrderNumbersToViewEstimatePhotograph("%" + workOrderNumber + "%", "APPROVED".toString());
        return workOrderNumbers;
    }

    public List<String> getContractorsNamesForViewEstimatePhotograph(String contractorName) {
        List<String> contractorNames = this.letterOfAcceptanceRepository.findContractorsToViewEstimatePhotograph("%" + contractorName + "%", "APPROVED".toString());
        return contractorNames;
    }
}

