/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.common.entity.UOM;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetUsage;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.service.EstimateNumberGenerator;
import org.egov.works.models.estimate.BudgetFolioDetail;
import org.egov.works.models.estimate.BudgetNumberGenerator;
import org.egov.works.models.estimate.DepositWorksUsage;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.models.estimate.ProjectCodeGenerator;
import org.egov.works.services.DepositWorksUsageService;
import org.egov.works.services.ProjectCodeService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractEstimateService
extends PersistenceService<AbstractEstimate, Long> {
    private static final Logger logger = Logger.getLogger(AbstractEstimateService.class);
    @Autowired
    private EstimateNumberGenerator estimateNumberGenerator;
    private BudgetNumberGenerator budgetNumberGenerator;
    @Autowired
    private ProjectCodeGenerator projectcodeGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private ProjectCodeService projectCodeService;
    private PersistenceService<AbstractEstimateAppropriation, Long> estimateAppropriationService;
    private DepositWorksUsageService depositWorksUsageService;
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AssignmentService assignmentService;
    private BudgetGroupDAO budgetGroupDAO;
    private WorksService worksService;
    public static final String APPROVED = "APPROVED";
    public static final String UNAPPROVED = "UNAPPROVED";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    private EgovCommon egovCommon;
    private static final String FROM_DATE = "fromDate";
    private static final String TO_DATE = "toDate";
    private PersistenceService<BudgetUsage, Long> budgetUsageService;
    private WorkOrderService workOrderService;
    private WorksPackageService workspackageService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public void setBudgetNumberGenerator(BudgetNumberGenerator budgetNumberGenerator) {
        this.budgetNumberGenerator = budgetNumberGenerator;
    }

    public AbstractEstimateService() {
        this.setType(AbstractEstimate.class);
    }

    public String getBudgetAppropriationNumber(AbstractEstimate entity) {
        CFinancialYear finYear = null;
        finYear = this.isPreviousYearApprRequired(entity.getFinancialDetails().get(0)) != false ? this.getPreviousFinancialYear() : this.getCurrentFinancialYear(new Date());
        return this.budgetNumberGenerator.getBudgetApprNo(entity, finYear);
    }

    private boolean estimateNumberChangeRequired(AbstractEstimate entity, CFinancialYear financialYear) {
        String[] estNum = entity.getEstimateNumber().split("/");
        return !estNum[0].equals(entity.getExecutingDepartment().getCode()) || !estNum[1].equals(financialYear.getFinYearRange());
    }

    public void setEstimateNumber(AbstractEstimate entity) {
        CFinancialYear financialYear = this.getCurrentFinancialYear(entity.getEstimateDate());
        if (entity.getEstimateNumber() == null || entity.getEstimateNumber() != null && this.estimateNumberChangeRequired(entity, financialYear)) {
            entity.setEstimateNumber(this.estimateNumberGenerator.getEstimateNumber(entity, financialYear));
        }
    }

    public void setProjectCode(AbstractEstimate entity) {
        CFinancialYear finYear = this.getCurrentFinancialYear(entity.getEstimateDate());
        ProjectCode projectCode = new ProjectCode(entity, null);
        projectCode.setCode(this.projectcodeGenerator.generateProjectcode(entity, finYear));
        projectCode.setCodeName(entity.getName());
        projectCode.setDescription(entity.getName());
        projectCode.setActive(true);
        projectCode.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ProjectCode.class.getSimpleName(), "CREATED"));
        entity.setProjectCode(projectCode);
        projectCode.addEstimate(entity);
        this.projectCodeService.persist((Object)projectCode);
        this.createAccountDetailKey(projectCode);
    }

    protected void createAccountDetailKey(ProjectCode proj) {
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("PROJECTCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(proj.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public AbstractEstimate persistFinancialDetail(FinancialDetail financialDetail, AbstractEstimate estimate) {
        super.validate((Object)estimate);
        estimate.getFinancialDetails().clear();
        estimate.addFinancialDetails(financialDetail);
        return (AbstractEstimate)((Object)super.persist((Object)estimate));
    }

    public List<AppConfigValues> getAppConfigValue(String moduleName, String key) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
    }

    public boolean checkForBudgetaryAppropriation(FinancialDetail financialDetail, String appropriationNumber) throws ValidationException {
        Date budgetAppDate = null;
        budgetAppDate = this.isPreviousYearApprRequired(financialDetail) != false ? this.getPreviousFinancialYear().getEndingDate() : new Date();
        CFinancialYear budgetApprDate_finYear = this.financialYearHibernateDAO.getFinYearByDate(budgetAppDate);
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(financialDetail.getBudgetGroup().getId());
        boolean flag = false;
        Long finyrId = budgetApprDate_finYear.getId();
        if (budgetAppDate.compareTo(financialDetail.getAbstractEstimate().getEstimateDate()) >= 0) {
            for (MultiYearEstimate multiYearEstimate : financialDetail.getAbstractEstimate().getMultiYearEstimates()) {
                double budgApprAmnt;
                double percAmt;
                if (multiYearEstimate == null || multiYearEstimate.getFinancialYear().getId().compareTo(finyrId) != 0 || !(multiYearEstimate.getPercentage() > 0.0) || (flag = this.checkConsumeEncumbranceBudget(financialDetail, finyrId, percAmt = (budgApprAmnt = financialDetail.getAbstractEstimate().getTotalAmount().getValue()) * multiYearEstimate.getPercentage() / 100.0, budgetheadid, appropriationNumber))) continue;
                return flag;
            }
        }
        return flag;
    }

    public boolean checkConsumeEncumbranceBudget(FinancialDetail financialDetail, Long finyrId, double budgApprAmnt, List<Long> budgetheadid, String appropriationNumber) {
        boolean flag = true;
        BudgetUsage budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(appropriationNumber == null ? null : appropriationNumber, finyrId, Integer.valueOf(11), financialDetail.getAbstractEstimate().getEstimateNumber(), Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getUserDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), financialDetail.getFunctionary() == null ? null : financialDetail.getFunctionary().getId(), financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), financialDetail.getAbstractEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getWard().getId().toString())), financialDetail.getBudgetGroup() == null ? null : budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), budgApprAmnt);
        if (budgetUsage == null) {
            return false;
        }
        this.persistBudgetAppropriationDetails(financialDetail.getAbstractEstimate(), budgetUsage);
        return true;
    }

    public boolean releaseBudgetOnReject(FinancialDetail financialDetail) throws ValidationException {
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{financialDetail.getAbstractEstimate().getId()}));
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(financialDetail.getBudgetGroup().getId());
        BudgetUsage budgetUsage = null;
        boolean flag = false;
        String budgetRejectionNumber = "BC/" + estimateAppropriation.getBudgetUsage().getAppropriationnumber();
        budgetUsage = this.budgetDetailsDAO.releaseEncumbranceBudget(budgetRejectionNumber == null ? null : budgetRejectionNumber, Long.valueOf(estimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), financialDetail.getAbstractEstimate().getEstimateNumber(), Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getUserDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), financialDetail.getFunctionary() == null ? null : financialDetail.getFunctionary().getId(), financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), financialDetail.getAbstractEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getWard().getId().toString())), financialDetail.getBudgetGroup() == null ? null : budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), estimateAppropriation.getBudgetUsage().getConsumedAmount().doubleValue());
        if (financialDetail.getAbstractEstimate() != null) {
            this.persistBudgetReleaseDetails(financialDetail.getAbstractEstimate(), budgetUsage);
        }
        return false;
    }

    public BigDecimal getTotalGrantForYear(FinancialDetail fd) throws ValidationException {
        BigDecimal val = BigDecimal.ZERO;
        HashMap<String, Serializable> searchMap = new HashMap<String, Serializable>();
        CFinancialYear finYear = null;
        if (fd != null) {
            finYear = fd.getAbstractEstimate().getLeastFinancialYearForEstimate();
            searchMap.put("financialyearid", finYear.getId());
        }
        if (fd != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(fd.getBudgetGroup());
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                searchMap.put("functionid", fd.getFunction().getId());
            }
            if (fd.getFunctionary() != null && fd.getFunctionary().getId() != null) {
                searchMap.put("functionaryid", fd.getFunctionary().getId());
            }
            if (fd.getFund() != null && fd.getFund().getId() != null) {
                searchMap.put("fundid", fd.getFund().getId());
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                searchMap.put("budgetheadid", budgetheadid);
            }
            if (fd.getScheme() != null && fd.getScheme().getId() != null) {
                searchMap.put("schemeid", fd.getScheme().getId());
            }
            if (fd.getSubScheme() != null && fd.getSubScheme().getId() != null) {
                searchMap.put("subschemeid", fd.getSubScheme().getId());
            }
            if (fd.getAbstractEstimate().getUserDepartment() != null) {
                searchMap.put("deptid", fd.getAbstractEstimate().getUserDepartment().getId());
            }
            if (fd.getAbstractEstimate().getWard().getId() != null) {
                searchMap.put("boundaryid", fd.getAbstractEstimate().getWard().getId());
            }
        }
        try {
            val = this.budgetDetailsDAO.getBudgetedAmtForYear(searchMap);
        }
        catch (ValidationException valEx) {
            logger.error((Object)valEx);
        }
        return val;
    }

    public BigDecimal getTotalGrantForYear(FinancialDetail fd, Long financialyearid) throws ValidationException {
        BigDecimal val = BigDecimal.ZERO;
        HashMap<String, Serializable> searchMap = new HashMap<String, Serializable>();
        searchMap.put("financialyearid", financialyearid);
        if (fd != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(fd.getBudgetGroup());
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                searchMap.put("functionid", fd.getFunction().getId());
            }
            if (fd.getFunctionary() != null && fd.getFunctionary().getId() != null) {
                searchMap.put("functionaryid", fd.getFunctionary().getId());
            }
            if (fd.getFund() != null && fd.getFund().getId() != null) {
                searchMap.put("fundid", fd.getFund().getId());
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                searchMap.put("budgetheadid", budgetheadid);
            }
            if (fd.getScheme() != null && fd.getScheme().getId() != null) {
                searchMap.put("schemeid", fd.getScheme().getId());
            }
            if (fd.getSubScheme() != null && fd.getSubScheme().getId() != null) {
                searchMap.put("subschemeid", fd.getSubScheme().getId());
            }
            if (fd.getAbstractEstimate().getUserDepartment() != null) {
                searchMap.put("deptid", fd.getAbstractEstimate().getUserDepartment().getId());
            }
            if (fd.getAbstractEstimate().getWard().getId() != null) {
                searchMap.put("boundaryid", fd.getAbstractEstimate().getWard().getId());
            }
        }
        try {
            val = this.budgetDetailsDAO.getBudgetedAmtForYear(searchMap);
        }
        catch (ValidationException valEx) {
            logger.error((Object)valEx);
        }
        return val;
    }

    public BigDecimal getTotalGrantForYear(FinancialDetail fd, Long financialyearid, Integer deptid) throws ValidationException {
        BigDecimal val = BigDecimal.ZERO;
        HashMap<String, Serializable> searchMap = new HashMap<String, Serializable>();
        searchMap.put("financialyearid", financialyearid);
        searchMap.put("deptid", deptid);
        if (fd != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(fd.getBudgetGroup());
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                searchMap.put("functionid", fd.getFunction().getId());
            }
            if (fd.getFunctionary() != null && fd.getFunctionary().getId() != null) {
                searchMap.put("functionaryid", fd.getFunctionary().getId());
            }
            if (fd.getFund() != null && fd.getFund().getId() != null) {
                searchMap.put("fundid", fd.getFund().getId());
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                searchMap.put("budgetheadid", budgetheadid);
            }
            if (fd.getScheme() != null && fd.getScheme().getId() != null) {
                searchMap.put("schemeid", fd.getScheme().getId());
            }
            if (fd.getSubScheme() != null && fd.getSubScheme().getId() != null) {
                searchMap.put("subschemeid", fd.getSubScheme().getId());
            }
            if (fd.getAbstractEstimate().getWard().getId() != null) {
                searchMap.put("boundaryid", fd.getAbstractEstimate().getWard().getId());
            }
        }
        try {
            val = this.budgetDetailsDAO.getBudgetedAmtForYear(searchMap);
        }
        catch (ValidationException valEx) {
            logger.error((Object)valEx);
        }
        return val;
    }

    public BigDecimal getTotalGrantForYearAsOnDate(FinancialDetail fd, Long financialyearid, Integer deptid, Date asOnDate) throws ValidationException {
        BigDecimal val = BigDecimal.ZERO;
        HashMap<String, Serializable> searchMap = new HashMap<String, Serializable>();
        searchMap.put("financialyearid", financialyearid);
        searchMap.put("deptid", deptid);
        if (fd != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(fd.getBudgetGroup());
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                searchMap.put("functionid", fd.getFunction().getId());
            }
            if (fd.getFunctionary() != null && fd.getFunctionary().getId() != null) {
                searchMap.put("functionaryid", fd.getFunctionary().getId());
            }
            if (fd.getFund() != null && fd.getFund().getId() != null) {
                searchMap.put("fundid", fd.getFund().getId());
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                searchMap.put("budgetheadid", budgetheadid);
            }
            if (fd.getScheme() != null && fd.getScheme().getId() != null) {
                searchMap.put("schemeid", fd.getScheme().getId());
            }
            if (fd.getSubScheme() != null && fd.getSubScheme().getId() != null) {
                searchMap.put("subschemeid", fd.getSubScheme().getId());
            }
            if (fd.getAbstractEstimate().getWard().getId() != null) {
                searchMap.put("boundaryid", fd.getAbstractEstimate().getWard().getId());
            }
        }
        try {
            val = this.budgetDetailsDAO.getBudgetedAmtForYearAsOnDate(searchMap, asOnDate);
        }
        catch (ValidationException valEx) {
            logger.error((Object)valEx);
        }
        return val;
    }

    public BigDecimal getPlanningBudgetPercentage(FinancialDetail fd, Long financialyearid, Integer deptid) throws ValidationException {
        BigDecimal val = BigDecimal.ZERO;
        HashMap<String, Serializable> searchMap = new HashMap<String, Serializable>();
        searchMap.put("financialyearid", financialyearid);
        searchMap.put("deptid", deptid);
        if (fd != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(fd.getBudgetGroup());
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                searchMap.put("functionid", fd.getFunction().getId());
            }
            if (fd.getFunctionary() != null && fd.getFunctionary().getId() != null) {
                searchMap.put("functionaryid", fd.getFunctionary().getId());
            }
            if (fd.getFund() != null && fd.getFund().getId() != null) {
                searchMap.put("fundid", fd.getFund().getId());
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                searchMap.put("budgetheadid", budgetheadid);
            }
            if (fd.getScheme() != null && fd.getScheme().getId() != null) {
                searchMap.put("schemeid", fd.getScheme().getId());
            }
            if (fd.getSubScheme() != null && fd.getSubScheme().getId() != null) {
                searchMap.put("subschemeid", fd.getSubScheme().getId());
            }
            if (fd.getAbstractEstimate().getWard().getId() != null) {
                searchMap.put("boundaryid", fd.getAbstractEstimate().getWard().getId());
            }
        }
        try {
            val = this.budgetDetailsDAO.getPlanningPercentForYear(searchMap);
        }
        catch (ValidationException valEx) {
            logger.error((Object)valEx);
        }
        return val;
    }

    public Map<String, List> getApprovedAppropriationDetailsForBugetHead(AbstractEstimate viewEstimate, BigDecimal totalGrantPerc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"1---inside getApprovedAppropriationDetailsForBugetHead------");
        }
        ArrayList<BudgetFolioDetail> approvedBudgetFolioResultList = new ArrayList<BudgetFolioDetail>();
        HashMap<String, Object> queryParamMap = new HashMap<String, Object>();
        FinancialDetail fd = null;
        Long deptId = null;
        Long functionId = null;
        Integer fundId = null;
        Long budgetHeadId = null;
        Long financialYearId = null;
        Map<String, List> budgetFolioMap = null;
        if (viewEstimate != null && viewEstimate.getFinancialDetails().get(0) != null) {
            fd = viewEstimate.getFinancialDetails().get(0);
        }
        if (fd != null) {
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getId() != null) {
                budgetHeadId = viewEstimate.getFinancialDetails().get(0).getBudgetGroup().getId();
                queryParamMap.put("budgetgroupId", budgetHeadId);
            }
            if (fd.getAbstractEstimate().getUserDepartment() != null) {
                deptId = fd.getAbstractEstimate().getUserDepartment().getId();
                queryParamMap.put("ExecutionDepartmentId", deptId);
            }
            if (fd.getFunction() != null && fd.getFunction().getId() != null) {
                functionId = fd.getFunction().getId();
                queryParamMap.put("functionId", functionId);
            }
            if (fd.getFund() != null && fd.getFund() != null && fd.getFund().getId() != null) {
                fundId = fd.getFund().getId();
                queryParamMap.put("fundId", fundId);
            }
            if (fd.getAbstractEstimate() != null && fd.getAbstractEstimate().getLeastFinancialYearForEstimate() != null && fd.getAbstractEstimate().getLeastFinancialYearForEstimate().getId() != null) {
                financialYearId = fd.getAbstractEstimate().getLeastFinancialYearForEstimate().getId();
                queryParamMap.put("financialYearId", financialYearId);
                this.addFinancialYearToQuery(fd, queryParamMap);
            }
        }
        Integer moduleId = 11;
        queryParamMap.put("moduleId", moduleId);
        List budgetUsageList = this.egovCommon.getListBudgetUsage(queryParamMap);
        if (budgetUsageList != null && !budgetUsageList.isEmpty()) {
            budgetFolioMap = this.addApprovedEstimateResultList(approvedBudgetFolioResultList, budgetUsageList, totalGrantPerc);
        }
        return budgetFolioMap;
    }

    public Map<String, List> getApprovedAppropriationDetailsForBugetHead(Map<String, Object> queryParamMap) {
        ArrayList<BudgetFolioDetail> approvedBudgetFolioResultList = new ArrayList<BudgetFolioDetail>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (queryParamMap.get("budgetheadid") != null) {
            List budgetheadid = (List)queryParamMap.get("budgetheadid");
            BudgetGroup bg = (BudgetGroup)budgetheadid.get(0);
            paramMap.put("budgetgroupId", bg.getId());
        }
        if (queryParamMap.get("deptid") != null) {
            paramMap.put("ExecutionDepartmentId", queryParamMap.get("deptid"));
        }
        if (queryParamMap.get("functionid") != null) {
            paramMap.put("functionId", queryParamMap.get("functionid"));
        }
        if (queryParamMap.get("fundid") != null) {
            paramMap.put("fundId", queryParamMap.get("fundid"));
        }
        if (queryParamMap.get("financialyearid") != null) {
            paramMap.put("financialYearId", queryParamMap.get("financialyearid"));
        }
        if (queryParamMap.get(FROM_DATE) != null) {
            paramMap.put(FROM_DATE, queryParamMap.get(FROM_DATE));
        }
        if (queryParamMap.get(TO_DATE) != null) {
            paramMap.put(TO_DATE, queryParamMap.get(TO_DATE));
        }
        Integer moduleId = 11;
        paramMap.put("moduleId", moduleId);
        List budgetUsageList = this.budgetDetailsDAO.getListBudgetUsage(paramMap);
        if (budgetUsageList != null && !budgetUsageList.isEmpty()) {
            return this.addApprovedEstimateResultList(approvedBudgetFolioResultList, budgetUsageList, new BigDecimal(queryParamMap.get("totalGrantPerc").toString()));
        }
        return new HashMap<String, List>();
    }

    public void addFinancialYearToQuery(FinancialDetail fd, Map<String, Object> queryParamMap) {
        if (fd.getAbstractEstimate().getLeastFinancialYearForEstimate().getStartingDate() != null) {
            queryParamMap.put(FROM_DATE, fd.getAbstractEstimate().getLeastFinancialYearForEstimate().getStartingDate());
        }
        queryParamMap.put(TO_DATE, new Date());
    }

    public Map<String, List> addApprovedEstimateResultList(List<BudgetFolioDetail> budgetFolioResultList, List<BudgetUsage> budgetUsageList, BigDecimal totalGrantPerc) {
        int srlNo = 1;
        Double cumulativeTotal = 0.0;
        BigDecimal balanceAvailable = BigDecimal.ZERO;
        HashMap<String, List> budgetFolioMap = new HashMap<String, List>();
        for (BudgetUsage budgetUsage : budgetUsageList) {
            BudgetFolioDetail budgetFolioDetail = new BudgetFolioDetail();
            budgetFolioDetail.setSrlNo(srlNo++);
            AbstractEstimate estimate = (AbstractEstimate)((Object)this.find("from AbstractEstimate ae where ae.estimateNumber=?", new Object[]{budgetUsage.getReferenceNumber()}));
            if (estimate != null) {
                budgetFolioDetail.setEstimateNo(estimate.getEstimateNumber());
                budgetFolioDetail.setNameOfWork(estimate.getName());
                budgetFolioDetail.setWorkValue(estimate.getTotalAmount().getValue());
                budgetFolioDetail.setEstimateDate(this.sdf.format(estimate.getEstimateDate()));
            }
            budgetFolioDetail.setBudgetApprNo(budgetUsage.getAppropriationnumber());
            budgetFolioDetail.setCumulativeTotal(cumulativeTotal);
            balanceAvailable = totalGrantPerc.subtract(new BigDecimal(cumulativeTotal));
            budgetFolioDetail.setBalanceAvailable(balanceAvailable);
            budgetFolioDetail.setAppDate(this.sdf.format(new Date(budgetUsage.getUpdatedTime().getTime())));
            budgetFolioDetail.setAppType(this.getApporpriationType(budgetUsage.getId()));
            budgetFolioResultList.add(budgetFolioDetail);
            if (budgetUsage.getReleasedAmount() > 0.0) {
                cumulativeTotal = cumulativeTotal - budgetUsage.getReleasedAmount();
                budgetFolioDetail.setAppropriatedValue(0.0 - budgetUsage.getReleasedAmount());
                continue;
            }
            cumulativeTotal = cumulativeTotal + budgetUsage.getConsumedAmount();
            budgetFolioDetail.setAppropriatedValue(budgetUsage.getConsumedAmount());
        }
        ArrayList<Number> calculatedValuesList = new ArrayList<Number>();
        calculatedValuesList.add(cumulativeTotal);
        calculatedValuesList.add(totalGrantPerc.subtract(new BigDecimal(cumulativeTotal)));
        budgetFolioMap.put("budgetFolioList", budgetFolioResultList);
        budgetFolioMap.put("calculatedValues", calculatedValuesList);
        return budgetFolioMap;
    }

    public Map<String, Object> createBudgetFolioHeaderJasperObject(AbstractEstimate ae, BigDecimal totalGrant, BigDecimal totalGrantPer) {
        HashMap<String, Object> budgetFolioMapObject = new HashMap<String, Object>();
        String departmentName = "";
        String functionCenter = "";
        String budgetHead = "";
        String fund = "";
        FinancialDetail fd = null;
        if (ae != null && ae.getExecutingDepartment() != null && ae.getExecutingDepartment().getName() != null) {
            departmentName = ae.getExecutingDepartment().getName();
        }
        if (ae != null && ae.getFinancialDetails() != null && ae.getFinancialDetails().get(0) != null) {
            fd = ae.getFinancialDetails().get(0);
        }
        if (fd != null) {
            if (fd.getFunction() != null && fd.getFunction() != null && fd.getFunction().getName() != null) {
                functionCenter = ae.getFinancialDetails().get(0).getFunction().getName();
            }
            if (fd.getBudgetGroup() != null && fd.getBudgetGroup().getName() != null) {
                budgetHead = fd.getBudgetGroup().getName();
            }
            if (fd.getFund() != null && fd.getFund().getName() != null) {
                fund = fd.getFund().getName();
            }
        }
        budgetFolioMapObject.put("departmentName", departmentName);
        budgetFolioMapObject.put("functionCenter", functionCenter);
        budgetFolioMapObject.put("budgetHead", budgetHead);
        budgetFolioMapObject.put("fund", fund);
        budgetFolioMapObject.put("totalGrant", totalGrant);
        budgetFolioMapObject.put("totalGrantPer", totalGrantPer);
        return budgetFolioMapObject;
    }

    public String getApporpriationType(long budgetUsageId) {
        List allReadyAppropriatedBudgetUsageList;
        String appType = "Regular";
        if (this.estimateAppropriationService != null && (allReadyAppropriatedBudgetUsageList = this.estimateAppropriationService.findAllBy("from AbstractEstimateAppropriation where abstractEstimate.id=(select max(abstractEstimate.id) from AbstractEstimateAppropriation where budgetUsage.id=?) and budgetUsage.id<?", new Object[]{budgetUsageId, budgetUsageId})).size() != 0) {
            appType = "Re-Appropriation";
        }
        return appType;
    }

    public BudgetGroupDAO getBudgetGroupDAO() {
        return this.budgetGroupDAO;
    }

    public void setBudgetGroupDAO(BudgetGroupDAO budgetGroupDAO) {
        this.budgetGroupDAO = budgetGroupDAO;
    }

    public BudgetDetailsDAO getBudgetDetailsDAO() {
        return this.budgetDetailsDAO;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Assignment getLatestAssignmentForCurrentLoginUser() {
        Long currentLoginUserId = this.worksService.getCurrentLoggedInUserId();
        Assignment assignment = null;
        if (currentLoginUserId != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForEmployee(currentLoginUserId);
        }
        return assignment;
    }

    public CFinancialYear getCurrentFinancialYear(Date estimateDate) {
        return this.financialYearHibernateDAO.getFinYearByDate(estimateDate);
    }

    public CFinancialYear getPreviousFinancialYear() {
        return this.financialYearHibernateDAO.getFinancialYearById(Long.valueOf(Long.parseLong(this.financialYearHibernateDAO.getPrevYearFiscalId())));
    }

    public Date getLatestApprYearEndDate(FinancialDetail financialDetail) {
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{financialDetail.getAbstractEstimate().getId()}));
        if (estimateAppropriation != null) {
            return this.financialYearHibernateDAO.getFinancialYearById(Long.valueOf(estimateAppropriation.getBudgetUsage().getFinancialYearId().longValue())).getEndingDate();
        }
        return new Date();
    }

    public BigDecimal getBudgetAvailable(AbstractEstimate estimate, Date date) throws ValidationException {
        BigDecimal budgetAvailable = BigDecimal.ZERO;
        Long finYearId = null;
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        finYearId = date == null ? this.financialYearHibernateDAO.getFinYearByDate(new Date()).getId() : this.financialYearHibernateDAO.getFinYearByDate(date).getId();
        if (estimate.getFinancialDetails() != null && estimate.getFinancialDetails().size() > 0) {
            FinancialDetail financialDetail = estimate.getFinancialDetails().get(0);
            budgetheadid.add(financialDetail.getBudgetGroup().getId());
            return this.budgetDetailsDAO.getPlanningBudgetAvailable(finYearId, Integer.valueOf(Integer.parseInt(estimate.getUserDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), Integer.valueOf(Integer.parseInt(estimate.getWard().getId().toString())), financialDetail.getBudgetGroup() == null ? null : budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId());
        }
        return budgetAvailable;
    }

    public Boolean isPreviousYearApprRequired(FinancialDetail financialDetail) {
        if ("yes".equalsIgnoreCase(this.worksService.getWorksConfigValue("PREVIOUS_YEAR_APPROPRIATION_ALLOWED")) && financialDetail != null && financialDetail.getApprYear() != null && "previous".equalsIgnoreCase(financialDetail.getApprYear())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public BigDecimal getBudgetAvailable(Integer departmentId, Long functionId, Integer fundId, Long budgetGroupId, Long finYearId) throws ValidationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start of getBudgetAvailable(Long functionId,Integer fundId,Long budgetGroupId,Long finYearId) : functionId=" + functionId + "fundId:" + fundId + "budgetGroupId=" + budgetGroupId + "finYearId=" + finYearId));
        }
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        if (functionId == null || fundId == null || budgetGroupId == null || finYearId == null || departmentId == null) {
            throw new ApplicationRuntimeException("Error:Invalid Argument passed to getBudgetAvailable(Integer departmentId,Long functionId,Integer fundId,Long budgetGroupId,Long finYearId)");
        }
        budgetheadid.add(budgetGroupId);
        return this.budgetDetailsDAO.getPlanningBudgetAvailable(finYearId, departmentId, functionId, null, null, null, null, budgetheadid, fundId);
    }

    public List<AbstractEstimate> getAbEstimateListById(String estId) {
        String[] estValues = estId.split("`~`");
        Long[] estIdLong = new Long[estValues.length];
        HashSet<Long> abIdentifierSet = new HashSet<Long>();
        int j = 0;
        for (String estValue : estValues) {
            if (!StringUtils.isNotBlank((String)estValue)) continue;
            estIdLong[j] = Long.valueOf(estValue);
            ++j;
        }
        abIdentifierSet.addAll(Arrays.asList(estIdLong));
        return this.findAllByNamedQuery("ABSTRACTESTIMATELIST_BY_ID", new Object[]{abIdentifierSet});
    }

    public Money getWorkValueIncludingTaxesForEstList(List<AbstractEstimate> abList) {
        double amt = 0.0;
        if (!abList.isEmpty()) {
            for (AbstractEstimate ab : abList) {
                amt += ab.getWorkValueIncludingTaxes().getValue();
            }
        }
        return new Money(amt);
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public boolean checkForBudgetaryAppropriationForDepositWorks(FinancialDetail financialDetail, String appropriationNumber) throws ValidationException {
        boolean flag = false;
        Date appDate = new Date();
        double depApprAmnt = 0.0;
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        if (appDate.compareTo(financialDetail.getAbstractEstimate().getEstimateDate()) >= 0) {
            depApprAmnt = financialDetail.getAbstractEstimate().getTotalAmount().getValue();
        }
        BigDecimal creditBalance = this.egovCommon.getDepositAmountForDepositCode(new Date(), financialDetail.getCoa().getGlcode(), financialDetail.getFund().getCode(), accountdetailtype.getId(), Integer.valueOf(financialDetail.getAbstractEstimate().getDepositCode().getId().intValue()));
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(financialDetail, appDate);
        BigDecimal balance = BigDecimal.ZERO;
        if (utilizedAmt == null) {
            balance = creditBalance;
            utilizedAmt = BigDecimal.ZERO;
        } else {
            balance = creditBalance.subtract(utilizedAmt);
        }
        if (balance.doubleValue() >= depApprAmnt) {
            DepositWorksUsage depositWorksUsage = new DepositWorksUsage();
            CFinancialYear budgetApprDate_finYear = this.financialYearHibernateDAO.getFinYearByDate(appDate);
            depositWorksUsage.setTotalDepositAmount(creditBalance);
            depositWorksUsage.setConsumedAmount(new BigDecimal(depApprAmnt));
            depositWorksUsage.setReleasedAmount(BigDecimal.ZERO);
            depositWorksUsage.setAppropriationNumber(appropriationNumber);
            depositWorksUsage.setAbstractEstimate(financialDetail.getAbstractEstimate());
            depositWorksUsage.setAppropriationDate(appDate);
            depositWorksUsage.setFinancialYear(budgetApprDate_finYear);
            depositWorksUsage.setDepositCode(financialDetail.getAbstractEstimate().getDepositCode());
            depositWorksUsage.setCoa(financialDetail.getCoa());
            depositWorksUsage = this.depositWorksUsageService.persist(depositWorksUsage);
            this.persistDepositCodeAppDetails(depositWorksUsage);
            flag = true;
        }
        return flag;
    }

    public boolean releaseDepositWorksAmountOnReject(FinancialDetail financialDetail) throws ValidationException {
        boolean flag = false;
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{financialDetail.getAbstractEstimate().getId()}));
        BigDecimal creditBalance = this.egovCommon.getDepositAmountForDepositCode(new Date(), financialDetail.getCoa().getGlcode(), financialDetail.getFund().getCode(), accountdetailtype.getId(), Integer.valueOf(financialDetail.getAbstractEstimate().getDepositCode().getId().intValue()));
        String budgetRejectionNumber = "BC/" + estimateAppropriation.getDepositWorksUsage().getAppropriationNumber();
        double releaseAmount = estimateAppropriation.getDepositWorksUsage().getConsumedAmount().doubleValue();
        DepositWorksUsage depositWorksUsage = new DepositWorksUsage();
        depositWorksUsage.setTotalDepositAmount(creditBalance);
        depositWorksUsage.setConsumedAmount(BigDecimal.ZERO);
        depositWorksUsage.setReleasedAmount(new BigDecimal(releaseAmount));
        depositWorksUsage.setAppropriationNumber(budgetRejectionNumber);
        depositWorksUsage.setAbstractEstimate(financialDetail.getAbstractEstimate());
        depositWorksUsage.setAppropriationDate(new Date());
        depositWorksUsage.setFinancialYear(estimateAppropriation.getDepositWorksUsage().getFinancialYear());
        depositWorksUsage.setCoa(financialDetail.getCoa());
        depositWorksUsage.setDepositCode(financialDetail.getAbstractEstimate().getDepositCode());
        depositWorksUsage = this.depositWorksUsageService.persist(depositWorksUsage);
        this.persistReleaseDepositWorksAmountDetails(depositWorksUsage);
        flag = true;
        return flag;
    }

    public void setDepositWorksUsageService(DepositWorksUsageService depositWorksUsageService) {
        this.depositWorksUsageService = depositWorksUsageService;
    }

    public DepositWorksUsageService getDepositWorksUsageService() {
        return this.depositWorksUsageService;
    }

    private void persistBudgetAppropriationDetails(AbstractEstimate abstractEstimate, BudgetUsage budgetUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        Integer finYearId = budgetUsage.getFinancialYearId();
        Date endingDate = this.financialYearHibernateDAO.getFinancialYearById(Long.valueOf(finYearId.longValue())).getEndingDate();
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getBudgetUsageForEstimateByFinYear", new Object[]{abstractEstimate.getId(), (int)finYearId}));
        if (estimateAppropriation != null) {
            estimateAppropriation.setBalanceAvailable(this.getBudgetAvailable(abstractEstimate, endingDate));
            estimateAppropriation.setBudgetUsage(budgetUsage);
        } else {
            estimateAppropriation = new AbstractEstimateAppropriation();
            estimateAppropriation.setAbstractEstimate(abstractEstimate);
            estimateAppropriation.setBalanceAvailable(this.getBudgetAvailable(abstractEstimate, endingDate));
            estimateAppropriation.setBudgetUsage(budgetUsage);
        }
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private void persistDepositCodeAppDetails(DepositWorksUsage depositWorksUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        int finYearId = this.financialYearHibernateDAO.getFinYearByDate(new Date()).getId().intValue();
        BigDecimal creditBalance = depositWorksUsage.getTotalDepositAmount();
        AbstractEstimate abstractEstimate = depositWorksUsage.getAbstractEstimate();
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(abstractEstimate.getFinancialDetails().get(0), depositWorksUsage.getCreatedDate());
        BigDecimal balance = BigDecimal.ZERO;
        if (utilizedAmt == null) {
            balance = creditBalance;
            utilizedAmt = BigDecimal.ZERO;
        } else {
            balance = creditBalance.subtract(utilizedAmt);
        }
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getDepositWorksUsageForEstimateByFinYear", new Object[]{abstractEstimate.getId(), finYearId}));
        if (estimateAppropriation != null) {
            estimateAppropriation.setBalanceAvailable(balance);
            estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        } else {
            estimateAppropriation = new AbstractEstimateAppropriation();
            estimateAppropriation.setAbstractEstimate(abstractEstimate);
            estimateAppropriation.setBalanceAvailable(balance);
            estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        }
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private void persistBudgetReleaseDetails(AbstractEstimate abstractEstimate, BudgetUsage budgetUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{abstractEstimate.getId()}));
        Integer finYearId = estimateAppropriation.getBudgetUsage().getFinancialYearId();
        Date endingDate = this.financialYearHibernateDAO.getFinancialYearById(Long.valueOf(finYearId.longValue())).getEndingDate();
        estimateAppropriation.setBalanceAvailable(this.getBudgetAvailable(abstractEstimate, endingDate));
        estimateAppropriation.setBudgetUsage(budgetUsage);
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private void persistReleaseDepositWorksAmountDetails(DepositWorksUsage depositWorksUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        BigDecimal creditBalance = depositWorksUsage.getTotalDepositAmount();
        AbstractEstimate abstractEstimate = depositWorksUsage.getAbstractEstimate();
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(abstractEstimate.getFinancialDetails().get(0), new Date());
        BigDecimal balance = creditBalance.subtract(utilizedAmt);
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{abstractEstimate.getId()}));
        estimateAppropriation.setBalanceAvailable(balance);
        estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    public Double getEstimateAppropriationAmountForFinyear(AbstractEstimate estimate, Integer finYearId) {
        Double percentage = 0.0;
        Double appropriationAmount = 0.0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("start of getEstimateAppropriationAmountByFinyear() || estimate number=" + estimate.getEstimateNumber()));
        }
        if (estimate == null || finYearId == null) {
            throw new ApplicationRuntimeException("Invalid argument passed to getEstimateAppropriationAmountForFinyear()");
        }
        for (MultiYearEstimate multiYearEstimate : estimate.getMultiYearEstimates()) {
            if (multiYearEstimate.getFinancialYear().getId().intValue() != finYearId.intValue()) continue;
            percentage = multiYearEstimate.getPercentage();
            break;
        }
        if (percentage != 0.0) {
            appropriationAmount = estimate.getTotalAmount().getValue() * (percentage / 100.0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("end of getEstimateAppropriationAmountByFinyear() ||appropariation amount=" + appropriationAmount + "||estimate number ||" + estimate.getEstimateNumber() + " Finyear ||" + finYearId));
        }
        return appropriationAmount;
    }

    public void setEstimateAppropriationService(PersistenceService<AbstractEstimateAppropriation, Long> estimateAppropriationService) {
        this.estimateAppropriationService = estimateAppropriationService;
    }

    public PersistenceService<AbstractEstimateAppropriation, Long> getEstimateAppropriationService() {
        return this.estimateAppropriationService;
    }

    public List<UOM> prepareUomListByExcludingSpecialUoms(List<UOM> uomList) {
        Set<String> exceptionSor = this.worksService.getExceptionSOR().keySet();
        ArrayList<UOM> newList = new ArrayList<UOM>();
        for (UOM uom : uomList) {
            if (exceptionSor.contains(uom.getUom())) continue;
            newList.add(uom);
        }
        return newList;
    }

    public List<BudgetUsage> getBudgetUsageListForEstNo(String estNumber) {
        ArrayList<BudgetUsage> buList = new ArrayList();
        buList = this.budgetUsageService.findAllBy("from BudgetUsage  where referenceNumber = ?) ", new Object[]{estNumber});
        return buList;
    }

    public List<Object> getWODetailsForEstimateId(Long estimateId) {
        ArrayList<Object> woDetails = new ArrayList();
        woDetails = this.workOrderService.getWorkOrderDetails(estimateId);
        return woDetails;
    }

    public List<Object> getWPDetailsForEstimateId(Long estimateId) {
        ArrayList<Object> wpDetails = new ArrayList();
        wpDetails = this.workspackageService.getWorksPackageDetails(estimateId);
        return wpDetails;
    }

    public String getLatestEstimateAppropriationNumber(AbstractEstimate estimate) {
        String appropriationNumber = null;
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{estimate.getId()}));
        if (estimateAppropriation != null) {
            appropriationNumber = estimateAppropriation.getBudgetUsage() != null ? estimateAppropriation.getBudgetUsage().getAppropriationnumber() : estimateAppropriation.getDepositWorksUsage().getAppropriationNumber();
        }
        return appropriationNumber;
    }

    public PersistenceService<BudgetUsage, Long> getBudgetUsageService() {
        return this.budgetUsageService;
    }

    public void setBudgetUsageService(PersistenceService<BudgetUsage, Long> budgetUsageService) {
        this.budgetUsageService = budgetUsageService;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public WorksPackageService getWorkspackageService() {
        return this.workspackageService;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }
}

