/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.tender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.Retender;
import org.egov.works.models.tender.RetenderHistory;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.WorksPackageDetails;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class WorksPackage
extends StateAware
implements Auditable {
    private static final long serialVersionUID = -4874817415037202881L;
    private Long id;
    @NotEmpty(message="wp.name.is.null")
    @Length(max=1024, message="workspackage.name.length")
    private String name;
    @Length(max=1024, message="workspackage.description.length")
    private String description;
    @NotNull(message="wp.userDepartment.is.null")
    private Department department;
    @NotNull(message="wp.wpDate.is.null")
    @DateFormat(message="invalid.fieldvalue.wpDate")
    private Date wpDate;
    @NotEmpty(message="wp.wpNumber.is.null")
    private String wpNumber;
    private String employeeName;
    private Money workValueIncludingTaxes;
    private List<WorksPackageDetails> worksPackageDetails = new LinkedList<WorksPackageDetails>();
    private List<RetenderHistory> retenderHistoryDetails = new LinkedList<RetenderHistory>();
    private List<Retender> retenderDetails = new LinkedList<Retender>();
    @NotEmpty(message="wp.tenderFileNumber.is.null")
    @Length(max=50, message="wp.tenderFileNumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="wp.tenderFileNumber.alphaNumeric")
    private String tenderFileNumber;
    private Long documentNumber;
    private EgwStatus egwStatus;
    private String wpOfflineStatus;
    private OfflineStatus latestOfflineStatus;
    private Set<OfflineStatus> offlineStatuses = Collections.EMPTY_SET;
    private List<String> worksPackageActions = new LinkedList<String>();
    private String worksPackageStatus;
    private Date approvedDate;
    private Set<TenderEstimate> tenderEstimateSet = new HashSet<TenderEstimate>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Date getWpDate() {
        return this.wpDate;
    }

    public void setWpDate(Date wpDate) {
        this.wpDate = wpDate;
    }

    public String getWpNumber() {
        return this.wpNumber;
    }

    public void setWpNumber(String wpNumber) {
        this.wpNumber = wpNumber;
    }

    public void addEstimates(WorksPackageDetails wpDetailsObj) {
        this.worksPackageDetails.add(wpDetailsObj);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.worksPackageDetails.isEmpty()) {
            errors.add(new ValidationError("estimates", "estimates.null"));
        }
        return errors;
    }

    public List<WorksPackageDetails> getWorksPackageDetails() {
        return this.worksPackageDetails;
    }

    public void setWorksPackageDetails(List<WorksPackageDetails> worksPackageDetails) {
        this.worksPackageDetails = worksPackageDetails;
    }

    public String getStateDetails() {
        return "Works Package : " + this.getWpNumber();
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Money getWorkValueIncludingTaxes() {
        double amt = 0.0;
        if (!this.worksPackageDetails.isEmpty()) {
            for (WorksPackageDetails wpd : this.worksPackageDetails) {
                amt += wpd.getEstimate().getWorkValueIncludingTaxes().getValue();
            }
        }
        this.workValueIncludingTaxes = new Money(amt);
        return this.workValueIncludingTaxes;
    }

    public void setWorkValueIncludingTaxes(Money workValueIncludingTaxes) {
        this.workValueIncludingTaxes = workValueIncludingTaxes;
    }

    public Collection<EstimateLineItemsForWP> getActivitiesForEstimate() {
        HashMap<Long, EstimateLineItemsForWP> resultMap = new HashMap<Long, EstimateLineItemsForWP>();
        for (Activity act : this.getAllActivities()) {
            EstimateLineItemsForWP estlineItem = new EstimateLineItemsForWP();
            if (act.getSchedule() != null) {
                if (resultMap.containsKey(act.getSchedule().getId())) {
                    EstimateLineItemsForWP preEstlineItem = (EstimateLineItemsForWP)resultMap.get(act.getSchedule().getId());
                    preEstlineItem.setQuantity(act.getQuantity() + preEstlineItem.getQuantity());
                    if (DateUtils.compareDates((Date)act.getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                        preEstlineItem.setRate(act.getSORCurrentRate().getValue());
                        preEstlineItem.setAmt(preEstlineItem.getQuantity() * act.getRate());
                        preEstlineItem.setActivity(act);
                        if (act.getSchedule().hasValidMarketRateFor(act.getAbstractEstimate().getEstimateDate())) {
                            preEstlineItem.setMarketRate(preEstlineItem.getQuantity() * act.getSORCurrentMarketRate().getValue());
                        } else {
                            preEstlineItem.setMarketRate(act.getAmount().getValue());
                        }
                    } else {
                        preEstlineItem.setRate(preEstlineItem.getRate());
                        preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate() * act.getConversionFactor());
                        preEstlineItem.setActivity(act);
                        if (act.getSchedule().hasValidMarketRateFor(act.getAbstractEstimate().getEstimateDate())) {
                            preEstlineItem.setMarketRate(preEstlineItem.getQuantity() * act.getSORCurrentMarketRate().getValue());
                        } else {
                            preEstlineItem.setMarketRate(act.getAmount().getValue());
                        }
                    }
                    resultMap.put(act.getSchedule().getId(), preEstlineItem);
                } else {
                    this.addEstLineItem(act, estlineItem);
                    resultMap.put(act.getSchedule().getId(), estlineItem);
                }
            }
            if (act.getNonSor() == null) continue;
            this.addEstLineItem(act, estlineItem);
            resultMap.put(act.getNonSor().getId(), estlineItem);
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    private void addEstLineItem(Activity act, EstimateLineItemsForWP estlineItem) {
        if (act.getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setSummary("");
            estlineItem.setDescription(act.getNonSor().getDescription());
            estlineItem.setRate(act.getRate());
            estlineItem.setMarketRate(act.getAmount().getValue());
        } else {
            estlineItem.setCode(act.getSchedule().getCode());
            estlineItem.setDescription(act.getSchedule().getDescription());
            estlineItem.setRate(act.getSORCurrentRate().getValue());
            if (act.getSchedule().hasValidMarketRateFor(act.getAbstractEstimate().getEstimateDate())) {
                estlineItem.setMarketRate(act.getQuantity() * act.getSORCurrentMarketRate().getValue());
            } else {
                estlineItem.setMarketRate(act.getAmount().getValue());
            }
            estlineItem.setSummary(act.getSchedule().getSummary());
        }
        estlineItem.setActivity(act);
        estlineItem.setAmt(act.getQuantity() * act.getRate());
        estlineItem.setEstimateDate(act.getAbstractEstimate().getEstimateDate());
        estlineItem.setQuantity(act.getQuantity());
        estlineItem.setUom(act.getUom().getUom());
        estlineItem.setConversionFactor(act.getConversionFactor());
    }

    public List<Activity> getAllActivities() {
        ArrayList<Activity> actList = new ArrayList<Activity>();
        for (AbstractEstimate ab : this.getAllEstimates()) {
            actList.addAll(ab.getActivities());
        }
        return actList;
    }

    public List<Activity> getSorActivities() {
        List actList = Collections.EMPTY_LIST;
        for (Activity act : this.getAllActivities()) {
            if (act.getSchedule() == null) continue;
            actList.add(act);
        }
        return actList;
    }

    public List<Activity> getNonSorActivities() {
        List actList = Collections.EMPTY_LIST;
        for (Activity act : this.getAllActivities()) {
            if (act.getNonSor() == null) continue;
            actList.add(act);
        }
        return actList;
    }

    public double getTotalAmount() {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : this.getActivitiesForEstimate()) {
            totalAmt += act.getAmt();
        }
        return totalAmt;
    }

    public void setTotalAmount(double totalAmount) {
    }

    public double getMarketRateTotalAmount() {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : this.getActivitiesForEstimate()) {
            totalAmt += act.getMarketRate();
        }
        return totalAmt;
    }

    private Collection<EstimateLineItemsForWP> getEstLineItemsWithSrlNo(Collection<EstimateLineItemsForWP> actList) {
        int i = 1;
        ArrayList<EstimateLineItemsForWP> latestEstLineItemList = new ArrayList<EstimateLineItemsForWP>();
        for (EstimateLineItemsForWP act : actList) {
            act.setSrlNo(i);
            latestEstLineItemList.add(act);
            ++i;
        }
        return latestEstLineItemList;
    }

    public List<AbstractEstimate> getAllEstimates() {
        ArrayList<AbstractEstimate> abList = new ArrayList<AbstractEstimate>();
        if (this != null && !this.getWorksPackageDetails().isEmpty()) {
            for (WorksPackageDetails wpd : this.getWorksPackageDetails()) {
                abList.add(wpd.getEstimate());
            }
        }
        return abList;
    }

    public String getTenderFileNumber() {
        return this.tenderFileNumber;
    }

    public void setTenderFileNumber(String tenderFileNumber) {
        this.tenderFileNumber = tenderFileNumber;
    }

    public String getPackageNumberWithoutWP() {
        if (StringUtils.isNotBlank((String)this.wpNumber)) {
            String[] number = this.wpNumber.split("/");
            return number.length == 0 ? "0" : number[2] + "/" + number[3];
        }
        return "0";
    }

    public String getNegotiationNumber() {
        String negotiationNumber = "";
        block0: for (TenderEstimate te : this.getTenderEstimateSet()) {
            for (TenderResponse tr : te.getTenderResponseSet()) {
                if (!"APPROVED".equals(tr.getEgwStatus().getCode())) continue;
                negotiationNumber = tr.getNegotiationNumber();
                continue block0;
            }
        }
        return negotiationNumber;
    }

    public Set<OfflineStatus> getOfflineStatuses() {
        return this.offlineStatuses;
    }

    public void setOfflineStatuses(Set<OfflineStatus> offlineStatuses) {
        this.offlineStatuses = offlineStatuses;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public String getWpOfflineStatus() {
        return this.wpOfflineStatus;
    }

    public void setWpOfflineStatus(String wpOfflineStatus) {
        this.wpOfflineStatus = wpOfflineStatus;
    }

    public Set<TenderEstimate> getTenderEstimateSet() {
        return this.tenderEstimateSet;
    }

    public void setTenderEstimateSet(Set<TenderEstimate> tenderEstimateSet) {
        this.tenderEstimateSet = tenderEstimateSet;
    }

    public List<RetenderHistory> getRetenderHistoryDetails() {
        return this.retenderHistoryDetails;
    }

    public void setRetenderHistoryDetails(List<RetenderHistory> retenderHistoryDetails) {
        this.retenderHistoryDetails = retenderHistoryDetails;
    }

    public List<Retender> getRetenderDetails() {
        return this.retenderDetails;
    }

    public void setRetenderDetails(List<Retender> retenderDetails) {
        this.retenderDetails = retenderDetails;
    }

    public OfflineStatus getLatestOfflineStatus() {
        return this.latestOfflineStatus;
    }

    public void setLatestOfflineStatus(OfflineStatus latestOfflineStatus) {
        this.latestOfflineStatus = latestOfflineStatus;
    }

    public List<String> getWorksPackageActions() {
        return this.worksPackageActions;
    }

    public void setWorksPackageActions(List<String> worksPackageActions) {
        this.worksPackageActions = worksPackageActions;
    }

    public String getWorksPackageStatus() {
        return this.worksPackageStatus;
    }

    public void setWorksPackageStatus(String worksPackageStatus) {
        this.worksPackageStatus = worksPackageStatus;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public static enum Actions {
        SUBMIT_FOR_APPROVAL,
        APPROVE,
        REJECT,
        CANCEL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum WorkPacakgeStatus {
        CREATED,
        CHECKED,
        APPROVED,
        REJECTED,
        CANCELLED,
        RESUBMITTED;


        public String toString() {
            return StringUtils.capitalize((String)this.name());
        }
    }
}

