/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.tender;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.utils.DateConversionUtil;
import org.hibernate.validator.constraints.Length;

public class TenderHeader
extends BaseModel {
    private static final long serialVersionUID = 6208133912780798895L;
    @Required(message="tenderHeader.tenderNo.null")
    @Length(max=50, message="tenderHeader.tenderNo.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="tenderHeader.tenderNo.alphaNumeric")
    private String tenderNo;
    @Required(message="tenderHeader.tenderDate.null")
    @DateFormat(message="invalid.fieldvalue.tenderDate")
    private Date tenderDate;
    @Valid
    private List<TenderEstimate> tenderEstimates = new LinkedList<TenderEstimate>();

    public String getTenderNo() {
        return this.tenderNo;
    }

    public void setTenderNo(String tenderNo) {
        this.tenderNo = tenderNo;
    }

    public Date getTenderDate() {
        return this.tenderDate;
    }

    public void setTenderDate(Date tenderDate) {
        this.tenderDate = tenderDate;
    }

    public List<TenderEstimate> getTenderEstimates() {
        return this.tenderEstimates;
    }

    public void setTenderEstimates(List<TenderEstimate> tenderEstimates) {
        this.tenderEstimates = tenderEstimates;
    }

    public void addTenderEstimate(TenderEstimate tenderEstimate) {
        this.tenderEstimates.add(tenderEstimate);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (TenderEstimate tenderEstimate : this.tenderEstimates) {
            if (this.tenderDate == null) continue;
            if (tenderEstimate.getAbstractEstimate() != null && DateConversionUtil.isBeforeByDate(this.tenderDate, tenderEstimate.getAbstractEstimate().getEstimateDate())) {
                validationErrors.add(new ValidationError("tenderDate", "tenderEstimate.tenderDate.cannot_greaterthan_estimateDate"));
                continue;
            }
            if (tenderEstimate.getWorksPackage() == null || !DateConversionUtil.isBeforeByDate(this.tenderDate, tenderEstimate.getWorksPackage().getWpDate())) continue;
            validationErrors.add(new ValidationError("tenderDate", "tenderEstimate.tenderDate.cannot_greaterthan_wpDate"));
        }
        return validationErrors;
    }
}

