/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.milestone.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.models.workorder.WorkOrderEstimate;

@Entity
@Table(name="EGW_MILESTONE")
@Unique(id="id", tableName="EGW_MILESTONE")
@SequenceGenerator(name="SEQ_EGW_MILESTONE", sequenceName="SEQ_EGW_MILESTONE", allocationSize=1)
public class Milestone
extends StateAware
implements Comparable {
    private static final long serialVersionUID = -366602348464540736L;
    public static final String SEQ_EGW_MILESTONE = "SEQ_EGW_MILESTONE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MILESTONE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Temporal(value=TemporalType.DATE)
    private Date approvedDate;
    private Long documentNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workOrderEstimate", nullable=false)
    private WorkOrderEstimate workOrderEstimate;
    @OrderBy(value="id")
    @OneToMany(mappedBy="milestone", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MilestoneActivity.class)
    private final List<MilestoneActivity> activities = new ArrayList<MilestoneActivity>(0);
    @OrderBy(value="id")
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="milestone", targetEntity=TrackMilestone.class)
    private List<TrackMilestone> trackMilestone = new ArrayList<TrackMilestone>(0);
    private transient String ownerName;
    @Transient
    private String approvalComent;
    private String cancellationReason;
    private String cancellationRemarks;
    public static Comparator milestoneComparator = (milestone1, milestone2) -> {
        Long msObj1 = ((Milestone)milestone1).getId();
        Long msObj2 = ((Milestone)milestone2).getId();
        return msObj1.compareTo(msObj2);
    };

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public List<TrackMilestone> getTrackMilestone() {
        return this.trackMilestone;
    }

    public void setTrackMilestone(List<TrackMilestone> trackMilestone) {
        this.trackMilestone = trackMilestone;
    }

    public String getStateDetails() {
        return "Estimate Number : " + this.getWorkOrderEstimate().getEstimate().getEstimateNumber();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public List<MilestoneActivity> getActivities() {
        return this.activities;
    }

    public void addActivity(MilestoneActivity activity) {
        this.activities.add(activity);
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public static enum MilestoneStatus {
        CREATED,
        APPROVED,
        REJECTED,
        CANCELLED,
        RESUBMITTED;

    }
}

