/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.repository.MBHeaderRepository;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MBHeaderService {
    @PersistenceContext
    private EntityManager entityManager;
    private final MBHeaderRepository mbHeaderRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public MBHeaderService(MBHeaderRepository mbHeaderRepository) {
        this.mbHeaderRepository = mbHeaderRepository;
    }

    public MBHeader getMBHeaderById(Long id) {
        return (MBHeader)((Object)this.mbHeaderRepository.findOne(id));
    }

    public List<MBHeader> getMBHeadersByWorkOrder(WorkOrder workOrder) {
        return this.mbHeaderRepository.findByWorkOrder(workOrder);
    }

    public List<MBHeader> getApprovedMBHeadersByWorkOrder(WorkOrder workOrder) {
        return this.mbHeaderRepository.findByWorkOrderAndEgwStatus_codeEquals(workOrder, MBHeader.MeasurementBookStatus.APPROVED.toString());
    }

    public List<MBHeader> getApprovedMBHeadersByContractorBill(ContractorBillRegister contractorBillRegister) {
        return this.mbHeaderRepository.findByEgBillregisterAndEgwStatus_codeEquals(contractorBillRegister, MBHeader.MeasurementBookStatus.APPROVED.toString());
    }

    public List<MBHeader> getMBHeadersByContractorBill(ContractorBillRegister contractorBillRegister) {
        return this.mbHeaderRepository.findByEgBillregister(contractorBillRegister);
    }

    @Transactional
    public MBHeader create(MBHeader mbHeader) {
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        return savedMBHeader;
    }

    @Transactional
    public MBHeader update(MBHeader mbHeader) {
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        return savedMBHeader;
    }

    @Transactional
    public MBHeader cancel(MBHeader mbHeader) {
        mbHeader.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CANCELLED.toString()));
        MBHeader savedMBHeader = (MBHeader)((Object)this.mbHeaderRepository.save((Object)mbHeader));
        return savedMBHeader;
    }
}

