/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.budget.BudgetUsage;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateNumberGenerator;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.LineEstimateForLoaSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimateForLoaSearchResult;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.repository.LineEstimateAppropriationRepository;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.repository.LineEstimateRepository;
import org.egov.works.lineestimate.service.BudgetAppropriationNumberGenerator;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.lineestimate.service.LineEstimateNumberGenerator;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LineEstimateService {
    private static final Logger LOG = LoggerFactory.getLogger(LineEstimateService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final LineEstimateRepository lineEstimateRepository;
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    private final LineEstimateAppropriationRepository lineEstimateAppropriationRepository;
    @Autowired
    private LineEstimateNumberGenerator lineEstimateNumberGenerator;
    @Autowired
    private BudgetAppropriationNumberGenerator budgetAppropriationNumberGenerator;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private EstimateNumberGenerator estimateNumberGenerator;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<LineEstimate> lineEstimateWorkflowService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private UserService userService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public LineEstimateService(LineEstimateRepository lineEstimateRepository, LineEstimateDetailsRepository lineEstimateDetailsRepository, LineEstimateAppropriationRepository lineEstimateAppropriationRepository) {
        this.lineEstimateRepository = lineEstimateRepository;
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
        this.lineEstimateAppropriationRepository = lineEstimateAppropriationRepository;
    }

    public LineEstimate getLineEstimateById(Long id) {
        return this.lineEstimateRepository.findById(id);
    }

    @Transactional
    public LineEstimate create(LineEstimate lineEstimate, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
        CFinancialYear financialYear = this.getCurrentFinancialYear(lineEstimate.getLineEstimateDate());
        for (LineEstimateDetails lineEstimateDetail : lineEstimate.getLineEstimateDetails()) {
            String estimateNumber = this.estimateNumberGenerator.generateEstimateNumber(lineEstimate, financialYear);
            lineEstimateDetail.setEstimateNumber(estimateNumber);
            lineEstimateDetail.setLineEstimate(lineEstimate);
        }
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            String lineEstimateNumber = this.lineEstimateNumberGenerator.generateLineEstimateNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        this.createLineEstimateWorkflowTransition(newLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return newLineEstimate;
    }

    private LineEstimate update(LineEstimate lineEstimate, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws IOException {
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            if (lineEstimateDetails == null || lineEstimateDetails.getId() != null) continue;
            String estimateNumber = this.estimateNumberGenerator.generateEstimateNumber(lineEstimate, financialYear);
            lineEstimateDetails.setEstimateNumber(estimateNumber);
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        List<LineEstimateDetails> list = new ArrayList<LineEstimateDetails>(lineEstimate.getLineEstimateDetails());
        list = this.removeDeletedLineEstimateDetails(list, removedLineEstimateDetailsIds);
        lineEstimate.setLineEstimateDetails(list);
        LineEstimate persistedLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)persistedLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            persistedLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)persistedLineEstimate));
    }

    public LineEstimate getLineEstimateByLineEstimateNumber(String lineEstimateNumber) {
        return this.lineEstimateRepository.findByLineEstimateNumber(lineEstimateNumber);
    }

    public List<LineEstimateDetails> removeDeletedLineEstimateDetails(List<LineEstimateDetails> list, String removedLineEstimateDetailsIds) {
        ArrayList<LineEstimateDetails> details = new ArrayList<LineEstimateDetails>();
        if (null != removedLineEstimateDetailsIds) {
            String[] ids = removedLineEstimateDetailsIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (LineEstimateDetails line : list) {
                if (line.getId() != null) {
                    if (strList.contains(line.getId().toString())) continue;
                    details.add(line);
                    continue;
                }
                details.add(line);
            }
        } else {
            return list;
        }
        return details;
    }

    public List<LineEstimate> searchLineEstimates(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "lineEstimateDetail");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getAdminSanctionNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"adminSanctionNumber", (Object)lineEstimateSearchRequest.getAdminSanctionNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getBudgetHead() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"budgetHead.id", (Object)lineEstimateSearchRequest.getBudgetHead()));
            }
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getFunction() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"function.id", (Object)lineEstimateSearchRequest.getFunction()));
            }
            if (lineEstimateSearchRequest.getFund() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"fund.id", (Object)lineEstimateSearchRequest.getFund().intValue()));
            }
            if (lineEstimateSearchRequest.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionFromDate()));
            }
            if (lineEstimateSearchRequest.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionToDate()));
            }
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<LineEstimateDetails> searchLineEstimatesForLoa(LineEstimateForLoaSearchRequest lineEstimateForLoaSearchRequest) {
        List<String> lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersToSearchLineEstimatesForLoa("CANCELLED");
        if (!lineEstimateNumbers.isEmpty()) {
            Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimateDetails.class).createAlias("lineEstimate", "lineEstimate").createAlias("lineEstimate.status", "status").createAlias("projectCode", "projectCode");
            if (lineEstimateForLoaSearchRequest != null) {
                if (lineEstimateForLoaSearchRequest.getAdminSanctionNumber() != null) {
                    criteria.add(Restrictions.ilike((String)"lineEstimate.adminSanctionNumber", (Object)lineEstimateForLoaSearchRequest.getAdminSanctionNumber()));
                }
                if (lineEstimateForLoaSearchRequest.getExecutingDepartment() != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"lineEstimate.executingDepartment.id", (Object)lineEstimateForLoaSearchRequest.getExecutingDepartment()));
                }
                if (lineEstimateForLoaSearchRequest.getEstimateNumber() != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)lineEstimateForLoaSearchRequest.getEstimateNumber()).ignoreCase());
                }
                if (lineEstimateForLoaSearchRequest.getAdminSanctionFromDate() != null) {
                    criteria.add((Criterion)Restrictions.ge((String)"lineEstimate.adminSanctionDate", (Object)lineEstimateForLoaSearchRequest.getAdminSanctionFromDate()));
                }
                if (lineEstimateForLoaSearchRequest.getAdminSanctionToDate() != null) {
                    criteria.add((Criterion)Restrictions.le((String)"lineEstimate.adminSanctionDate", (Object)lineEstimateForLoaSearchRequest.getAdminSanctionToDate()));
                }
                if (lineEstimateForLoaSearchRequest.getLineEstimateCreatedBy() != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"lineEstimate.createdBy.id", (Object)lineEstimateForLoaSearchRequest.getLineEstimateCreatedBy()));
                }
                if (lineEstimateForLoaSearchRequest.getWorkIdentificationNumber() != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"projectCode.code", (Object)lineEstimateForLoaSearchRequest.getWorkIdentificationNumber()).ignoreCase());
                }
                criteria.add(Restrictions.in((String)"estimateNumber", lineEstimateNumbers));
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString()));
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimate.spillOverFlag", (Object)lineEstimateForLoaSearchRequest.isSpillOverFlag()));
            }
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            return criteria.list();
        }
        return new ArrayList<LineEstimateDetails>();
    }

    public List<String> findLineEstimateNumbers(String name) {
        List<LineEstimate> lineEstimates = this.lineEstimateRepository.findByLineEstimateNumberContainingIgnoreCase(name);
        ArrayList<String> results = new ArrayList<String>();
        for (LineEstimate details : lineEstimates) {
            results.add(details.getLineEstimateNumber());
        }
        return results;
    }

    public List<String> findEstimateNumbersForLoa(String name) {
        List<String> lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForLoa("%" + name + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        return lineEstimateNumbers;
    }

    public List<String> findAdminSanctionNumbers(String name) {
        List<LineEstimate> lineEstimates = this.lineEstimateRepository.findByAdminSanctionNumberContainingIgnoreCase(name);
        ArrayList<String> results = new ArrayList<String>();
        for (LineEstimate estimate : lineEstimates) {
            results.add(estimate.getAdminSanctionNumber());
        }
        return results;
    }

    public List<String> findAdminSanctionNumbersForLoa(String name) {
        List<String> adminSanctionNumbers = this.lineEstimateDetailsRepository.findAdminSanctionNumbersForLoa("%" + name + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        return adminSanctionNumbers;
    }

    public List<String> findWorkIdentificationNumbersToSearchLineEstimatesForLoa(String name) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchLineEstimatesForLoa("%" + name + "%", "CANCELLED");
        return workIdNumbers;
    }

    public List<LineEstimateForLoaSearchResult> searchLineEstimatesForLOA(LineEstimateForLoaSearchRequest lineEstimateForLoaSearchRequest) {
        List<LineEstimateDetails> lineEstimateDetails = this.searchLineEstimatesForLoa(lineEstimateForLoaSearchRequest);
        ArrayList<LineEstimateForLoaSearchResult> lineEstimateForLoaSearchResults = new ArrayList<LineEstimateForLoaSearchResult>();
        for (LineEstimateDetails led : lineEstimateDetails) {
            LineEstimateForLoaSearchResult result = new LineEstimateForLoaSearchResult();
            result.setId(led.getLineEstimate().getId());
            result.setAdminSanctionNumber(led.getLineEstimate().getAdminSanctionNumber());
            result.setCreatedBy(led.getLineEstimate().getCreatedBy().getName());
            result.setEstimateAmount(led.getEstimateAmount());
            result.setEstimateNumber(led.getEstimateNumber());
            result.setNameOfWork(led.getNameOfWork());
            if (led.getLineEstimate().getAdminSanctionBy() != null) {
                result.setAdminSanctionBy(led.getLineEstimate().getAdminSanctionBy().getName());
            }
            result.setActualEstimateAmount(led.getActualEstimateAmount());
            result.setWorkIdentificationNumber(led.getProjectCode().getCode());
            lineEstimateForLoaSearchResults.add(result);
        }
        return lineEstimateForLoaSearchResults;
    }

    public List<Hashtable<String, Object>> getHistory(State state, List<StateHistory> history) {
        User user = null;
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        Hashtable<String, Object> map = new Hashtable<String, Object>(0);
        if (null != state) {
            if (!history.isEmpty() && history != null) {
                Collections.reverse(history);
            }
            for (StateHistory stateHistory : history) {
                Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public Long getApprovalPositionByMatrixDesignation(LineEstimate lineEstimate, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, null, additionalRule, lineEstimate.getCurrentState().getValue(), null);
        if (lineEstimate.getStatus() != null && lineEstimate.getStatus().getCode() != null && lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && lineEstimate.getState() != null) {
            approvalPosition = mode.equals("edit") ? lineEstimate.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString())) {
            approvalPosition = this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    @Transactional
    public LineEstimate updateLineEstimateDetails(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws ValidationException, IOException {
        LineEstimate updatedLineEstimate = null;
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString())) {
            updatedLineEstimate = this.update(lineEstimate, removedLineEstimateDetailsIds, files, financialYear);
            try {
                if (workFlowAction.equals(WorksConstants.FORWARD_ACTION) && lineEstimate.getWorkCategory().toString().equals(WorkCategory.NON_SLUM_WORK.toString())) {
                    this.resetWorkCategoryDetailsOnModify(lineEstimate);
                }
                this.lineEstimateStatusChange(updatedLineEstimate, workFlowAction, mode);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        }
        try {
            List values;
            AppConfigValues appConfigValues;
            if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                this.resetAdminSanctionDetails(lineEstimate);
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                this.setAdminSanctionByAndDate(lineEstimate);
                for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
                    this.lineEstimateDetailService.setProjectCode(lineEstimateDetails);
                }
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                this.setTechnicalSanctionBy(lineEstimate);
                int i = 0;
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    if (lineEstimate.getLineEstimateDetails().size() > 1) {
                        ++i;
                    }
                    this.estimateService.createAbstractEstimateOnLineEstimateTechSanction(led, i);
                }
            }
            if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                List values2 = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetCheckRequired");
                AppConfigValues appConfigValues2 = (AppConfigValues)values2.get(0);
                if (appConfigValues2.getValue().equalsIgnoreCase("Y")) {
                    this.doBudgetoryAppropriation(lineEstimate);
                }
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION) && lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && (appConfigValues = (AppConfigValues)(values = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetCheckRequired")).get(0)).getValue().equalsIgnoreCase("Y")) {
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    this.releaseBudgetOnReject(led, null, null);
                }
            }
            this.lineEstimateStatusChange(lineEstimate, workFlowAction, mode);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        updatedLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        this.createLineEstimateWorkflowTransition(updatedLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        return updatedLineEstimate;
    }

    private void resetWorkCategoryDetailsOnModify(LineEstimate lineEstimate) {
        lineEstimate.setTypeOfSlum(null);
        lineEstimate.setBeneficiary(null);
    }

    private void resetAdminSanctionDetails(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionNumber(null);
        lineEstimate.setCouncilResolutionNumber(null);
        lineEstimate.setCouncilResolutionDate(null);
    }

    private void setAdminSanctionByAndDate(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionDate(new Date());
        lineEstimate.setAdminSanctionBy(this.securityUtils.getCurrentUser());
    }

    private void setTechnicalSanctionBy(LineEstimate lineEstimate) {
        lineEstimate.setTechnicalSanctionBy(this.securityUtils.getCurrentUser());
    }

    private void doBudgetoryAppropriation(LineEstimate lineEstimate) {
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimate.getBudgetHead().getId());
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            boolean flag;
            BigDecimal appropriationAmount = lineEstimate.isBillsCreated() && led.getGrossAmountBilled() != null ? led.getEstimateAmount().subtract(led.getGrossAmountBilled()) : led.getEstimateAmount();
            if (appropriationAmount.compareTo(BigDecimal.ZERO) != 1 || (flag = this.lineEstimateDetailService.checkConsumeEncumbranceBudget(led, this.getCurrentFinancialYear(new Date()).getId(), appropriationAmount.doubleValue(), budgetheadid))) continue;
            throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
        }
    }

    public void lineEstimateStatusChange(LineEstimate lineEstimate, String workFlowAction, String mode) throws ValidationException {
        if (null != lineEstimate && null != lineEstimate.getStatus() && null != lineEstimate.getStatus().getCode()) {
            if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && lineEstimate.getState() != null && workFlowAction.equals("Submit")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CHECKED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.BUDGET_SANCTIONED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.TECHNICAL_SANCTIONED.toString()));
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.REJECTED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString()) && workFlowAction.equals("Cancel")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
            }
        }
    }

    public List<User> getLineEstimateCreatedByUsers() {
        return this.lineEstimateRepository.getLineEstimateCreatedByUsers(LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public List<Department> getUserDepartments(User currentUser) {
        List assignments = this.assignmentService.findByEmployeeAndGivenDate(currentUser.getId(), new Date());
        ArrayList<Department> uniqueDepartmentList = new ArrayList<Department>();
        Department prevDepartment = new Department();
        for (Assignment assignment : assignments) {
            if (!assignment.getDepartment().getName().equals(prevDepartment.getName())) {
                uniqueDepartmentList.add(assignment.getDepartment());
            }
            prevDepartment = assignment.getDepartment();
        }
        return uniqueDepartmentList;
    }

    public LineEstimateDetails findByEstimateNumber(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeEquals(estimateNumber, LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public void createLineEstimateWorkflowTransition(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Line Estimate";
        if (null != lineEstimate.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(lineEstimate.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                lineEstimate.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Line Estimate");
            } else {
                String stateValue = "Rejected";
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Line Estimate");
            }
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == lineEstimate.getState()) {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, null, additionalRule, "", null);
                lineEstimate.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Line Estimate");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, null, additionalRule, lineEstimate.getCurrentState().getValue(), null);
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Line Estimate");
            } else {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, null, additionalRule, lineEstimate.getCurrentState().getValue(), null);
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Line Estimate");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public LineEstimate getLineEstimateByTechnicalSanctionNumber(String technicalSanctionNumber) {
        return this.lineEstimateRepository.findByTechnicalSanctionNumberIgnoreCaseAndStatus_CodeNot(technicalSanctionNumber, LineEstimateStatus.CANCELLED.toString());
    }

    public CFinancialYear getCurrentFinancialYear(Date estimateDate) {
        return this.financialYearHibernateDAO.getFinYearByDate(estimateDate);
    }

    public LineEstimate getLineEstimateByAdminSanctionNumber(String adminSanctionNumber) {
        return this.lineEstimateRepository.findByAdminSanctionNumberIgnoreCaseAndStatus_codeNotLike(adminSanctionNumber, "CANCELLED");
    }

    public boolean releaseBudgetOnReject(LineEstimateDetails lineEstimateDetails, Double budgApprAmnt, String appropriationnumber) throws ValidationException {
        LineEstimateAppropriation lineEstimateAppropriation = this.lineEstimateAppropriationRepository.findLatestByLineEstimateDetails_EstimateNumber(lineEstimateDetails.getEstimateNumber());
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
        BudgetUsage budgetUsage = null;
        boolean flag = false;
        if (lineEstimateAppropriation != null) {
            if (budgApprAmnt == null) {
                budgApprAmnt = lineEstimateAppropriation.getBudgetUsage().getConsumedAmount();
            }
            if (appropriationnumber == null) {
                appropriationnumber = lineEstimateAppropriation.getBudgetUsage().getAppropriationnumber();
            }
            budgetUsage = this.budgetDetailsDAO.releaseEncumbranceBudget(lineEstimateAppropriation.getBudgetUsage() == null ? null : this.budgetAppropriationNumberGenerator.generateCancelledBudgetAppropriationNumber(appropriationnumber), Long.valueOf(lineEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), lineEstimateAppropriation.getLineEstimateDetails().getEstimateNumber(), Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getExecutingDepartment().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction().getId(), null, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getBudgetHead() == null ? null : budgetheadid, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund().getId(), budgApprAmnt.doubleValue());
            if (lineEstimateAppropriation.getLineEstimateDetails() != null) {
                this.persistBudgetReleaseDetails(lineEstimateDetails, budgetUsage);
            }
        }
        return false;
    }

    private void persistBudgetReleaseDetails(LineEstimateDetails lineEstimateDetails, BudgetUsage budgetUsage) {
        LineEstimateAppropriation lineEstimateAppropriation = null;
        lineEstimateAppropriation = this.lineEstimateAppropriationRepository.findLatestByLineEstimateDetails_EstimateNumber(lineEstimateDetails.getEstimateNumber());
        lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        this.lineEstimateAppropriationRepository.save((Object)lineEstimateAppropriation);
    }

    @Transactional
    public LineEstimate createSpillOver(LineEstimate lineEstimate, MultipartFile[] files) throws IOException {
        List<DocumentDetails> documentDetails;
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.TECHNICAL_SANCTIONED.toString()));
        lineEstimate.setSpillOverFlag(true);
        List assignments = this.assignmentService.findPrimaryAssignmentForDesignationName("Commissioner");
        if (assignments != null && !assignments.isEmpty()) {
            User adminUser = this.userService.getUserById(((Assignment)assignments.get(0)).getEmployee().getId());
            lineEstimate.setAdminSanctionBy(adminUser);
        }
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            String lineEstimateNumber = this.lineEstimateNumberGenerator.generateLineEstimateNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            this.lineEstimateDetailService.setProjectCode(led);
        }
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetCheckRequired");
        AppConfigValues value = (AppConfigValues)list.get(0);
        if (value.getValue().equalsIgnoreCase("Y")) {
            this.doBudgetoryAppropriation(lineEstimate);
        }
        if (!(documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate")).isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        int i = 0;
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            if (lineEstimate.getLineEstimateDetails().size() > 1) {
                ++i;
            }
            this.estimateService.createAbstractEstimateOnLineEstimateTechSanction(led, i);
        }
        return newLineEstimate;
    }

    public List<String> getEstimateNumberForDepartment(Long departmentId) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(departmentId);
    }

    public List<String> getEstimateNumbersForWorkIdentificationNumber(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForWorkIdentificationNumber(workIdentificationNumber);
    }

    public List<String> getEstimateNumbersForSpillOverFlag(boolean spillOverFlag) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForSpillOverFlag(spillOverFlag);
    }

    public List<User> getCreatedByUsersForCancelLineEstimateByDepartment(Long department) {
        return this.lineEstimateDetailsRepository.findCreatedByForCancelLineEstimateByDepartment(department, LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "APPROVED");
    }

    public List<LineEstimate> searchLineEstimatesToCancel(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "led").createAlias("executingDepartment", "ed").createAlias("led.projectCode", "pc").createAlias("status", "status");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"ed.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getLineEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getLineEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getWorkIdentificationNumber() != null) {
                criteria.add(Restrictions.ilike((String)"pc.code", (String)lineEstimateSearchRequest.getWorkIdentificationNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (lineEstimateSearchRequest.getCreatedBy() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)lineEstimateSearchRequest.getCreatedBy()));
        }
        if (lineEstimateSearchRequest.isSpillOverFlag()) {
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString()).ignoreCase());
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public String checkIfLOAsCreated(Long lineEstimateId) {
        List<String> listString = this.letterOfAcceptanceService.getEstimateNumbersToSearchLOAToCancel(lineEstimateId);
        String estimateNumbers = "";
        for (String estimateNumber : listString) {
            estimateNumbers = estimateNumbers + estimateNumber + ", ";
        }
        if (estimateNumbers.equals("")) {
            return "";
        }
        return estimateNumbers;
    }

    @Transactional
    public LineEstimate cancel(LineEstimate lineEstimate) {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetCheckRequired");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Y")) {
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                this.releaseBudgetOnReject(led, null, null);
            }
        }
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            Long id = led.getId();
            AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByLineEstimateDetailsForCancelLineEstimate(id);
            if (abstractEstimate == null) continue;
            abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
    }

    public LineEstimate getLineEstimateByCouncilResolutionNumber(String councilResolutionNumber) {
        return this.lineEstimateRepository.findByCouncilResolutionNumberIgnoreCaseAndStatus_codeNotLike(councilResolutionNumber, "CANCELLED");
    }
}

