/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LineEstimateNumberGenerator {
    private static final String LINEESTIMATE_NUMBER_SEQ_PREFIX = "SEQ_LINEESTIMATE_NUMBER";
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Transactional
    public String generateLineEstimateNumber(LineEstimate lineEstimate) {
        try {
            Serializable sequenceNumber;
            CFinancialYear financialYear = this.financialYearHibernateDAO.getFinancialYearByDate(lineEstimate.getLineEstimateDate());
            String[] finYearRange = financialYear.getFinYearRange().split("-");
            String sequenceName = "SEQ_LINEESTIMATE_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("LE/%s/%05d/%02d/%s", lineEstimate.getExecutingDepartment().getCode(), sequenceNumber, this.getMonthOfTransaction(lineEstimate.getLineEstimateDate()), financialYear.getFinYearRange());
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Line Estimate Number", (Throwable)e);
        }
    }

    private int getMonthOfTransaction(Date lineEstimateDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(lineEstimateDate);
        return cal.get(2) + 1;
    }
}

