/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.LineEstimateAppropriationRepository;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.BudgetAppropriationNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LineEstimateAppropriationService {
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private LineEstimateAppropriationRepository lineEstimateAppropriationRepository;
    @Autowired
    private BudgetAppropriationNumberGenerator budgetAppropriationNumberGenerator;

    @Autowired
    public LineEstimateAppropriationService(LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
    }

    @Transactional
    public void save(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.save((Object)lineEstimateDetails);
    }

    @Transactional
    public void update(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.saveAndFlush((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.delete((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(List<LineEstimateDetails> lineEstimateDetailsList) {
        this.lineEstimateDetailsRepository.delete(lineEstimateDetailsList);
    }

    public LineEstimateDetails getById(Long id) {
        return (LineEstimateDetails)((Object)this.lineEstimateDetailsRepository.findOne(id));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleType, code);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public LineEstimateAppropriation findLatestByLineEstimateDetails_EstimateNumber(String estimateNumber) {
        return this.lineEstimateAppropriationRepository.findLatestByLineEstimateDetails_EstimateNumber(estimateNumber);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public String generateBudgetAppropriationNumber(LineEstimateDetails lineEstimateDetails) {
        return this.budgetAppropriationNumberGenerator.generateBudgetAppropriationNumber(lineEstimateDetails);
    }
}

