/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.Serializable;
import java.sql.SQLException;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BudgetAppropriationNumberGenerator {
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Transactional
    public String generateBudgetAppropriationNumber(LineEstimateDetails lineEstimateDetails) {
        try {
            Serializable sequenceNumber;
            CFinancialYear cFinancialYear = this.financialYearHibernateDAO.getFinYearByDate(lineEstimateDetails.getLineEstimate().getLineEstimateDate());
            String sequenceName = "SEQ_LINEESTIMATEAPPROPRIATION_NUMBER";
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence("SEQ_LINEESTIMATEAPPROPRIATION_NUMBER");
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence("SEQ_LINEESTIMATEAPPROPRIATION_NUMBER");
            }
            return String.format("BAS/%05d/%s", sequenceNumber, cFinancialYear.getFinYearRange());
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Budget Appropriation Number", (Throwable)e);
        }
    }

    @Transactional
    public String generateCancelledBudgetAppropriationNumber(String appropriationNumber) {
        String original = appropriationNumber.split("/")[0];
        String modified = original + "/C";
        return appropriationNumber.replace(original, modified);
    }
}

