/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorbill.repository;

import java.math.BigDecimal;
import java.util.List;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ContractorBillRegisterRepository
extends JpaRepository<ContractorBillRegister, Long> {
    public ContractorBillRegister findByBillnumber(String var1);

    public List<ContractorBillRegister> findByBillnumberContainingIgnoreCase(String var1);

    public List<ContractorBillRegister> findByWorkOrder(WorkOrder var1);

    @Query(value="select max(billSequenceNumber) from ContractorBillRegister cbr where cbr.workOrderEstimate.estimate.lineEstimateDetails.projectCode.code = :workIdentificationNumber")
    public Integer findMaxBillSequenceNumberByWorkOrder(@Param(value="workIdentificationNumber") String var1);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and exists (select distinct(cbr.workOrder.estimateNumber) from ContractorBillRegister as cbr where led.estimateNumber = cbr.workOrder.estimateNumber)")
    public List<String> findWorkIdentificationNumberToSearchContractorBill(@Param(value="code") String var1);

    @Query(value="select distinct(cbr.workOrder.contractor.name) from ContractorBillRegister as cbr where upper(cbr.workOrder.contractor.name) like upper(:contractorname) or upper(cbr.workOrder.contractor.code) like upper(:contractorname)  and cbr.workOrder.egwStatus.code = :workOrderStatus ")
    public List<String> findContractorForContractorBill(@Param(value="contractorname") String var1, @Param(value="workOrderStatus") String var2);

    @Query(value="select sum(cbr.billamount) from ContractorBillRegister as cbr where cbr.workOrder = :workOrder and upper(cbr.billstatus) not in (:billStatus)")
    public BigDecimal findSumOfBillAmountByWorkOrderAndStatus(@Param(value="workOrder") WorkOrder var1, @Param(value="billStatus") String var2);

    @Query(value="select sum(cbr.billamount) from ContractorBillRegister as cbr where cbr.workOrder = :workOrder and cbr.id != :id and upper(cbr.billstatus) not in (:billStatus)")
    public BigDecimal findSumOfBillAmountByWorkOrderAndStatusAndNotContractorBillRegister(@Param(value="workOrder") WorkOrder var1, @Param(value="billStatus") String var2, @Param(value="id") Long var3);

    @Query(value="select distinct(cbr.workOrder.workOrderNumber) from ContractorBillRegister as cbr where cbr.workOrder.workOrderNumber like :workOrderNumber and upper(cbr.billstatus) != :status")
    public List<String> findWorkOrderNumbersToCancel(@Param(value="workOrderNumber") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and exists (select distinct(cbr.workOrder.estimateNumber) from ContractorBillRegister as cbr where led.estimateNumber = cbr.workOrder.estimateNumber and billstatus = :status)")
    public List<String> findWorkIdentificationNumberToSearchContractorBillToCancel(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(cbr.billnumber) from ContractorBillRegister as cbr where upper(cbr.billnumber) like upper(:billnumber) and billstatus = :status")
    public List<String> findBillNumberToSearchContractorBillToCancel(@Param(value="billnumber") String var1, @Param(value="status") String var2);

    public List<ContractorBillRegister> findByWorkOrderAndBillstatusNot(WorkOrder var1, String var2);
}

