/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.io.Serializable;
import java.sql.SQLException;
import javax.script.ScriptContext;
import org.egov.commons.CFinancialYear;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EstimateNumberGenerator {
    private static final String ESTIMATE_NUMBER_SEQ_PREFIX = "SEQ_ESTIMATE_NUMBER";
    @Autowired
    private SequenceNumberGenerator sequenceGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private ScriptService scriptService;

    public String getEstimateNumber(AbstractEstimate estimate, CFinancialYear financialYear) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"estimate", estimate, "finYear", financialYear, "sequenceGenerator", this.sequenceGenerator, "dbSequenceGenerator", this.dbSequenceGenerator});
        return this.scriptService.executeScript("works.estimatenumber.generator", scriptContext).toString();
    }

    @Transactional(readOnly=true)
    public String generateEstimateNumber(LineEstimate lineEstimate, CFinancialYear financialYear) {
        try {
            Serializable sequenceNumber;
            String financialYearRange = financialYear.getFinYearRange();
            String[] finYearRange = financialYearRange.split("-");
            String sequenceName = "SEQ_ESTIMATE_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
            try {
                sequenceNumber = this.sequenceGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s/%s/%05d", lineEstimate.getExecutingDepartment().getCode(), financialYearRange, sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Estimate Number", (Throwable)e);
        }
    }
}

