/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.model.budget.BudgetGroup;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.FinancingSource;

@Entity
@Table(name="EGW_ESTIMATE_FINANCIALDETAIL")
@NamedQueries(value={@NamedQuery(name="FINANCIALDETAILS_BY_ESTIMATEID", query="from FinancialDetail fd where fd.abstractEstimate.id = ?")})
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_FINANCIALDETAIL", sequenceName="SEQ_EGW_ESTIMATE_FINANCIALDETAIL", allocationSize=1)
public class FinancialDetail
extends AbstractAuditable {
    private static final long serialVersionUID = 3577937589290853091L;
    public static final String SEQ_EGW_ESTIMATEFINANCIALDETAIL = "SEQ_EGW_ESTIMATE_FINANCIALDETAIL";
    public static final String FINANCIALDETAILS_BY_ESTIMATEID = "FINANCIALDETAILS_BY_ESTIMATEID";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_FINANCIALDETAIL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractEstimate")
    private AbstractEstimate abstractEstimate;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fund")
    private Fund fund;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="function")
    private CFunction function;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="functionary")
    private Functionary functionary;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scheme")
    private Scheme scheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subScheme")
    private SubScheme subScheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="budgetGroup")
    private BudgetGroup budgetGroup;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="coa")
    private CChartOfAccounts coa;
    private transient String apprYear;
    @Valid
    @OrderBy(value="id")
    @OneToMany(mappedBy="financialDetail", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=FinancingSource.class)
    private List<FinancingSource> financingSources = new ArrayList<FinancingSource>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate estimate) {
        this.abstractEstimate = estimate;
    }

    public BudgetGroup getBudgetGroup() {
        return this.budgetGroup;
    }

    public void setBudgetGroup(BudgetGroup budgetGroup) {
        this.budgetGroup = budgetGroup;
    }

    @NotNull(message="financial.fund.null")
    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public Functionary getFunctionary() {
        return this.functionary;
    }

    public void setFunctionary(Functionary functionary) {
        this.functionary = functionary;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public SubScheme getSubScheme() {
        return this.subScheme;
    }

    public void setSubScheme(SubScheme subScheme) {
        this.subScheme = subScheme;
    }

    public List<FinancingSource> getFinancingSources() {
        return this.financingSources;
    }

    public void setFinancingSources(List<FinancingSource> financingSources) {
        this.financingSources = financingSources;
    }

    public void addFinancingSource(FinancingSource financingSource) {
        this.financingSources.add(financingSource);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        double total = 0.0;
        boolean finSourceError = false;
        if (this.fund == null) {
            validationErrors.add(new ValidationError("fund_null", "financial.fund.null"));
        }
        if (this.financingSources == null || this.financingSources.isEmpty()) {
            validationErrors.add(new ValidationError("financingsource_null", "financingsource.null"));
        }
        int errorCnt = validationErrors.size();
        if (this.financingSources != null) {
            for (FinancingSource financingSource : this.financingSources) {
                if (!finSourceError) {
                    validationErrors.addAll(financingSource.validate());
                }
                if (!finSourceError && errorCnt < validationErrors.size()) {
                    finSourceError = true;
                }
                total += financingSource.getPercentage();
            }
        }
        if (this.financingSources != null && !this.financingSources.isEmpty() && total != 100.0) {
            validationErrors.add(new ValidationError("percentageequalto100", "financingsource.percentage.percentageequalto100"));
        }
        return validationErrors;
    }

    public FinancingSource getMaxFinancingSource() {
        double max = 0.0;
        FinancingSource maxFinSource = null;
        for (FinancingSource finSource : this.financingSources) {
            if (!(finSource.getPercentage() > max)) continue;
            max = finSource.getPercentage();
            maxFinSource = finSource;
        }
        return maxFinSource;
    }

    public CChartOfAccounts getCoa() {
        return this.coa;
    }

    public void setCoa(CChartOfAccounts coa) {
        this.coa = coa;
    }

    public String getApprYear() {
        return this.apprYear;
    }

    public void setApprYear(String apprYear) {
        this.apprYear = apprYear;
    }
}

