/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.common.entity.UOM;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.NonSor;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;

@Entity
@Table(name="EGW_ESTIMATE_ACTIVITY")
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_ACTIVITY", sequenceName="SEQ_EGW_ESTIMATE_ACTIVITY", allocationSize=1)
public class Activity
extends AbstractAuditable {
    private static final long serialVersionUID = 8113772958762752328L;
    public static final String SEQ_EGW_ESTIMATEACTIVITY = "SEQ_EGW_ESTIMATE_ACTIVITY";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_ACTIVITY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractEstimate")
    private AbstractEstimate abstractEstimate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scheduleofrate")
    private ScheduleOfRate schedule;
    @Valid
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="nonSor")
    private NonSor nonSor;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="uom")
    private UOM uom;
    @NotNull(message="activity.rate.not.null")
    @Column(name="unitrate")
    private double rate = 0.0;
    private double sorRate = 0.0;
    @NotNull(message="activity.quantity.not.null")
    @GreaterThan(value=0L, message="activity.quantity.non.negative")
    private double quantity;
    @Min(value=0L, message="activity.servicetax.non.negative")
    private double serviceTaxPerc;
    @Enumerated(value=EnumType.STRING)
    private RevisionType revisionType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    private Activity parent;
    @Transient
    private Money sORCurrentRate = new Money(0.0);
    @Transient
    private double amt;
    @Transient
    private Integer srlNo;
    @Transient
    private String signValue;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public ScheduleOfRate getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScheduleOfRate schedule) {
        this.schedule = schedule;
    }

    public NonSor getNonSor() {
        return this.nonSor;
    }

    public void setNonSor(NonSor nonSor) {
        this.nonSor = nonSor;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getServiceTaxPerc() {
        return this.serviceTaxPerc;
    }

    public void setServiceTaxPerc(double serviceTaxPerc) {
        this.serviceTaxPerc = serviceTaxPerc;
    }

    public Money getAmount() {
        double amt = this.rate * this.quantity;
        return new Money(amt);
    }

    public Money getTaxAmount() {
        return new Money(this.rate * this.quantity * this.serviceTaxPerc / 100.0);
    }

    public Money getAmountIncludingTax() {
        return new Money(this.getAmount().getValue() + this.getTaxAmount().getValue());
    }

    public Money getSORCurrentRate() {
        Money sorCurrentRate = this.schedule.getRateOn(this.abstractEstimate.getEstimateDate()).getRate();
        if (sorCurrentRate != null) {
            BigDecimal currentRate = BigDecimal.valueOf(sorCurrentRate.getValue());
            currentRate = currentRate.setScale(2, 0);
            sorCurrentRate = new Money(currentRate.doubleValue());
        }
        return sorCurrentRate;
    }

    public void setSORCurrentRate(Money sORCurrentRate) {
        this.sORCurrentRate = sORCurrentRate;
    }

    public Money getSORCurrentMarketRate() {
        Money sorCurrentMarketRate = this.schedule.getMarketRateOn(this.abstractEstimate.getEstimateDate()).getMarketRate();
        if (sorCurrentMarketRate != null) {
            BigDecimal marketRate = BigDecimal.valueOf(sorCurrentMarketRate.getValue());
            marketRate = marketRate.setScale(2, 0);
            sorCurrentMarketRate = new Money(marketRate.doubleValue());
        }
        return sorCurrentMarketRate;
    }

    public double getConversionFactorForRE(Date asOnDate) {
        if (this.revisionType != null && RevisionType.LUMP_SUM_ITEM.equals((Object)this.revisionType) && this.schedule == null) {
            return 1.0;
        }
        if (this.revisionType != null && (RevisionType.ADDITIONAL_QUANTITY.equals((Object)this.revisionType) || RevisionType.REDUCED_QUANTITY.equals((Object)this.revisionType)) && this.schedule == null) {
            return 1.0;
        }
        if (this.revisionType != null && (RevisionType.NON_TENDERED_ITEM.equals((Object)this.revisionType) || RevisionType.ADDITIONAL_QUANTITY.equals((Object)this.revisionType) || RevisionType.REDUCED_QUANTITY.equals((Object)this.revisionType)) && this.schedule != null) {
            double masterRate = this.getSORRateForDate(asOnDate) == null ? Double.valueOf(0.0).doubleValue() : this.getSORRateForDate(asOnDate).getValue();
            double unitRate = this.rate;
            if (unitRate > 0.0 && masterRate > 0.0) {
                return unitRate / masterRate;
            }
            return 1.0;
        }
        return 1.0;
    }

    public Money getSORRateForDate(Date asOnDate) {
        Money sorCurrentRate = this.schedule.getRateOn(asOnDate).getRate();
        if (sorCurrentRate != null) {
            BigDecimal currentRate = BigDecimal.valueOf(sorCurrentRate.getValue());
            currentRate = currentRate.setScale(2, 0);
            sorCurrentRate = new Money(currentRate.doubleValue());
        }
        return sorCurrentRate;
    }

    public double getConversionFactor() {
        if (this.schedule == null) {
            return 1.0;
        }
        double masterRate = this.getSORCurrentRate() == null ? Double.valueOf(0.0).doubleValue() : this.getSORCurrentRate().getValue();
        double unitRate = this.rate;
        if (unitRate > 0.0 && masterRate > 0.0) {
            return unitRate / masterRate;
        }
        return 1.0;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.rate <= 0.0) {
            validationErrors.add(new ValidationError("activity.rate.not.null", "activity.rate.not.null"));
        }
        if (this.nonSor != null && (this.nonSor.getUom() == null || this.nonSor.getUom().getId() == null || this.nonSor.getUom().getId() == 0)) {
            validationErrors.add(new ValidationError("activity.nonsor.invalid", "activity.nonsor.invalid"));
        }
        return validationErrors;
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uom) {
        this.uom = uom;
    }

    public double getAmt() {
        return this.amt;
    }

    public void setAmt(double amt) {
        this.amt = amt;
    }

    public Integer getSrlNo() {
        return this.srlNo;
    }

    public void setSrlNo(Integer srlNo) {
        this.srlNo = srlNo;
    }

    public RevisionType getRevisionType() {
        return this.revisionType;
    }

    public void setRevisionType(RevisionType revisionType) {
        this.revisionType = revisionType;
    }

    public Activity getParent() {
        return this.parent;
    }

    public void setParent(Activity parent) {
        this.parent = parent;
    }

    public String getSignValue() {
        return this.signValue;
    }

    public void setSignValue(String signValue) {
        this.signValue = signValue;
    }

    public double getSorRate() {
        return this.sorRate;
    }

    public void setSorRate(double sorRate) {
        this.sorRate = sorRate;
    }
}

