/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Fundsource;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.entity.OverheadValue;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.models.masters.DepositCode;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_ABSTRACTESTIMATE")
@Inheritance(strategy=InheritanceType.JOINED)
@NamedQueries(value={@NamedQuery(name="ABSTRACTESTIMATELIST_BY_ID", query="from AbstractEstimate ab where ab.id in(:param_0)"), @NamedQuery(name="REVISION_ESTIMATES_BY_ESTID", query="from AbstractEstimate ae where ae.parent.id=? and ae.egwStatus.code='APPROVED' order by ae.id"), @NamedQuery(name="REVISION_ESTIMATES_BY_ESTID_WOID", query="from AbstractEstimate ae where ae.parent.id=? and ae.egwStatus.code='APPROVED' order by ae.id")})
@SequenceGenerator(name="SEQ_EGW_ABSTRACTESTIMATE", sequenceName="SEQ_EGW_ABSTRACTESTIMATE", allocationSize=1)
public class AbstractEstimate
extends StateAware
implements Auditable {
    private static final long serialVersionUID = 5010991868891221454L;
    public static final String SEQ_EGW_ABSTRACTESTIMATE = "SEQ_EGW_ABSTRACTESTIMATE";
    public static final String ABSTRACTESTIMATELIST_BY_ID = "ABSTRACTESTIMATELIST_BY_ID";
    public static final String REVISION_ESTIMATES_BY_ESTID = "REVISION_ESTIMATES_BY_ESTID";
    public static final String REVISION_ESTIMATES_BY_ESTID_WOID = "REVISION_ESTIMATES_BY_ESTID_WOID";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ABSTRACTESTIMATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    @Length(max=256)
    private String estimateNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date estimateDate;
    @NotNull
    @SafeHtml
    @Length(max=1024)
    @Column(name="nameofwork")
    private String name;
    @NotNull
    @SafeHtml
    @Length(max=1024)
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userdepartment")
    private Department userDepartment;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="executingdepartment")
    private Department executingDepartment;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="jurisdiction", nullable=false)
    private Boundary ward;
    @SafeHtml
    @Length(max=250)
    private String location;
    private BigDecimal latitude;
    private BigDecimal longitude;
    @NotNull(message="estimate.worktype.null")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="natureofwork", nullable=false)
    private NatureOfWork natureOfWork;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="typeofwork", nullable=false)
    private EgwTypeOfWork parentCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subtypeofwork")
    private EgwTypeOfWork category;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fundsource")
    private Fundsource fundSource;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="status", nullable=false)
    private EgwStatus egwStatus;
    private double workValue;
    private BigDecimal estimateValue;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="projectcode")
    private ProjectCode projectCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="despositcode")
    private DepositCode depositCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    private AbstractEstimate parent;
    @Temporal(value=TemporalType.DATE)
    @Column(name="approveddate")
    private Date approvedDate;
    private boolean copiedEstimate = false;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lineEstimateDetails")
    private LineEstimateDetails lineEstimateDetails;
    @Transient
    private String positionAndUserName;
    @Transient
    private Integer approverUserId;
    @Valid
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=OverheadValue.class)
    private List<OverheadValue> overheadValues = new ArrayList<OverheadValue>(0);
    @Valid
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=AssetsForEstimate.class)
    private List<AssetsForEstimate> assetValues = new ArrayList<AssetsForEstimate>(0);
    @Valid
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=Activity.class)
    private List<Activity> activities = new ArrayList<Activity>(0);
    @Valid
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MultiYearEstimate.class)
    private List<MultiYearEstimate> multiYearEstimates = new ArrayList<MultiYearEstimate>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=AbstractEstimateAppropriation.class)
    private List<AbstractEstimateAppropriation> abstractEstimateAppropriations = new ArrayList<AbstractEstimateAppropriation>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=FinancialDetail.class)
    private List<FinancialDetail> financialDetails = new ArrayList<FinancialDetail>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=EstimatePhotographs.class)
    private List<EstimatePhotographs> estimatePhotographsList = new ArrayList<EstimatePhotographs>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="abstractEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=EstimateTechnicalSanction.class)
    private List<EstimateTechnicalSanction> estimateTechnicalSanctions = new ArrayList<EstimateTechnicalSanction>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Required(message="estimate.name.null")
    @Length(max=1024, message="estimate.name.length")
    public String getName() {
        return this.name;
    }

    public String getNameJS() {
        return org.egov.infra.utils.StringUtils.escapeJavaScript((String)this.name);
    }

    public String getNameJson() {
        return StringUtils.escape((String)this.name);
    }

    public void setName(String name) {
        this.name = StringEscapeUtils.unescapeHtml((String)name);
    }

    @Required(message="estimate.date.null")
    @DateFormat(message="invalid.fieldvalue.estimateDate")
    public Date getEstimateDate() {
        return this.estimateDate;
    }

    public void setEstimateDate(Date estimateDate) {
        this.estimateDate = estimateDate;
    }

    @Required(message="estimate.desc.null")
    @Length(max=1024, message="estimate.desc.length")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Length(max=250, message="estimate.loc.length")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Required(message="estimate.natureofwork.null")
    public NatureOfWork getNatureOfWork() {
        return this.natureOfWork;
    }

    public void setNatureOfWork(NatureOfWork natureOfWork) {
        this.natureOfWork = natureOfWork;
    }

    public EgwTypeOfWork getCategory() {
        return this.category;
    }

    public void setCategory(EgwTypeOfWork category) {
        this.category = category;
    }

    public Department getUserDepartment() {
        return this.userDepartment;
    }

    public void setUserDepartment(Department userDepartment) {
        this.userDepartment = userDepartment;
    }

    @Required(message="estimate.executingDept.null")
    public Department getExecutingDepartment() {
        return this.executingDepartment;
    }

    public void setExecutingDepartment(Department executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    @Required(message="estimate.ward.null")
    public Boundary getWard() {
        return this.ward;
    }

    public void setWard(Boundary ward) {
        this.ward = ward;
    }

    public double getWorkValue() {
        double amt = 0.0;
        if (!this.activities.isEmpty()) {
            for (Activity activity : this.activities) {
                if (activity.getRevisionType() != null && activity.getRevisionType().equals((Object)RevisionType.REDUCED_QUANTITY)) {
                    amt -= activity.getAmount().getValue();
                    continue;
                }
                amt += activity.getAmount().getValue();
            }
            this.workValue = amt;
        }
        return this.workValue;
    }

    public Money getWorkValueIncludingTaxes() {
        return new Money(this.getWorkValue() + this.getTotalTax().getValue());
    }

    public Money getTotalTax() {
        double amt = 0.0;
        for (Activity activity : this.activities) {
            if (activity.getRevisionType() != null && activity.getRevisionType().equals((Object)RevisionType.REDUCED_QUANTITY)) {
                amt -= activity.getTaxAmount().getValue();
                continue;
            }
            amt += activity.getTaxAmount().getValue();
        }
        return new Money(amt);
    }

    public void setWorkValue(double workValue) {
        this.workValue = workValue;
    }

    public List<OverheadValue> getOverheadValues() {
        return this.overheadValues;
    }

    public void setOverheadValues(List<OverheadValue> overheadValues) {
        this.overheadValues = overheadValues;
    }

    public void addOverheadValue(OverheadValue overheadValue) {
        this.overheadValues.add(overheadValue);
    }

    public List<AssetsForEstimate> getAssetValues() {
        return this.assetValues;
    }

    public void setAssetValues(List<AssetsForEstimate> assetValues) {
        this.assetValues = assetValues;
    }

    public void addAssetValue(AssetsForEstimate assetValue) {
        this.assetValues.add(assetValue);
    }

    public List<FinancialDetail> getFinancialDetails() {
        return this.financialDetails;
    }

    public void setFinancialDetails(List<FinancialDetail> financialDetails) {
        this.financialDetails = financialDetails;
    }

    public void addFinancialDetails(FinancialDetail financialDetails) {
        this.financialDetails.add(financialDetails);
    }

    public Money getTotalAmount() {
        return new Money(this.estimateValue.doubleValue());
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public ProjectCode getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(ProjectCode projectCode) {
        this.projectCode = projectCode;
    }

    public Collection<Activity> getSORActivities() {
        return CollectionUtils.select(this.activities, activity -> ((Activity)((Object)((Object)activity))).getSchedule() != null);
    }

    public Collection<Activity> getNonSORActivities() {
        return CollectionUtils.select(this.activities, activity -> ((Activity)((Object)((Object)activity))).getNonSor() != null);
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public EgwTypeOfWork getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(EgwTypeOfWork parentCategory) {
        this.parentCategory = parentCategory;
    }

    public List<MultiYearEstimate> getMultiYearEstimates() {
        return this.multiYearEstimates;
    }

    public void setMultiYearEstimates(List<MultiYearEstimate> multiYearEstimates) {
        this.multiYearEstimates = multiYearEstimates;
    }

    public void addMultiYearEstimate(MultiYearEstimate multiYearEstimate) {
        this.multiYearEstimates.add(multiYearEstimate);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        validationErrors.addAll(this.validateActivities());
        validationErrors.addAll(this.validateOverheads());
        validationErrors.addAll(this.validateAssets());
        validationErrors.addAll(this.validateMultiYearEstimates());
        validationErrors.addAll(this.validateFinancialDetails());
        return validationErrors;
    }

    public List<ValidationError> validateFinancialDetails() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (FinancialDetail financialDetail : this.financialDetails) {
            validationErrors.addAll(financialDetail.validate());
        }
        return validationErrors;
    }

    public List<ValidationError> validateActivities() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (Activity activity : this.activities) {
            validationErrors.addAll(activity.validate());
        }
        return validationErrors;
    }

    public List<ValidationError> validateOverheads() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (OverheadValue overheadValue : this.overheadValues) {
            validationErrors.addAll(overheadValue.validate());
        }
        return validationErrors;
    }

    public List<ValidationError> validateAssets() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (AssetsForEstimate assetValue : this.assetValues) {
            validationErrors.addAll(assetValue.validate());
        }
        return validationErrors;
    }

    public List<ValidationError> validateMultiYearEstimates() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (MultiYearEstimate multiYearEstimate : this.multiYearEstimates) {
            validationErrors.addAll(multiYearEstimate.validate());
        }
        return validationErrors;
    }

    public CFinancialYear getLeastFinancialYearForEstimate() {
        CFinancialYear minfinYr = null;
        Date minStartDate = new Date();
        if (this.getMultiYearEstimates() != null) {
            minStartDate = this.getMultiYearEstimates().get(0).getFinancialYear().getStartingDate();
            minfinYr = this.getMultiYearEstimates().get(0).getFinancialYear();
        }
        for (int i = 1; i < this.getMultiYearEstimates().size(); ++i) {
            Date startDate = this.getMultiYearEstimates().get(i).getFinancialYear().getStartingDate();
            if (!startDate.before(minStartDate)) continue;
            minStartDate = startDate;
            minfinYr = this.getMultiYearEstimates().get(i).getFinancialYear();
        }
        return minfinYr;
    }

    public String getStateDetails() {
        return "Abstract Estimate : " + this.getEstimateNumber();
    }

    public Fundsource getFundSource() {
        return this.fundSource;
    }

    public void setFundSource(Fundsource fundSource) {
        this.fundSource = fundSource;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public String getPositionAndUserName() {
        return this.positionAndUserName;
    }

    public void setPositionAndUserName(String positionAndUserName) {
        this.positionAndUserName = positionAndUserName;
    }

    public DepositCode getDepositCode() {
        return this.depositCode;
    }

    public void setDepositCode(DepositCode depositCode) {
        this.depositCode = depositCode;
    }

    public String getCurrentStateCreatedDate() {
        String createdDate = "";
        if (this.getCurrentState() != null) {
            createdDate = new SimpleDateFormat("dd/MM/yyyy").format(this.getCurrentState().getCreatedDate());
        }
        return createdDate;
    }

    public List<AbstractEstimateAppropriation> getAbstractEstimateAppropriations() {
        return this.abstractEstimateAppropriations;
    }

    public void setAbstractEstimateAppropriations(List<AbstractEstimateAppropriation> abstractEstimateAppropriations) {
        this.abstractEstimateAppropriations = abstractEstimateAppropriations;
    }

    public AbstractEstimate getParent() {
        return this.parent;
    }

    public void setParent(AbstractEstimate parent) {
        this.parent = parent;
    }

    public void setTotalAmount(Money totalAmount) {
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public List<EstimatePhotographs> getEstimatePhotographsList() {
        return this.estimatePhotographsList;
    }

    public void setEstimatePhotographsList(List<EstimatePhotographs> estimatePhotographsList) {
        this.estimatePhotographsList = estimatePhotographsList;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public String toString() {
        return "AbstractEstimate ( Id : " + this.getId() + "Estimate No: " + this.estimateNumber + ")";
    }

    public BigDecimal getEstimateValue() {
        return this.estimateValue;
    }

    public void setEstimateValue(BigDecimal estimateValue) {
        this.estimateValue = estimateValue;
    }

    public LineEstimateDetails getLineEstimateDetails() {
        return this.lineEstimateDetails;
    }

    public void setLineEstimateDetails(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetails = lineEstimateDetails;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public boolean isCopiedEstimate() {
        return this.copiedEstimate;
    }

    public void setCopiedEstimate(boolean copiedEstimate) {
        this.copiedEstimate = copiedEstimate;
    }

    public List<EstimateTechnicalSanction> getEstimateTechnicalSanctions() {
        return this.estimateTechnicalSanctions;
    }

    public void setEstimateTechnicalSanctions(List<EstimateTechnicalSanction> estimateTechnicalSanctions) {
        this.estimateTechnicalSanctions = estimateTechnicalSanctions;
    }

    public static enum Actions {
        SUBMIT_FOR_APPROVAL,
        TECH_SANCTION,
        BUDGET_DETAILS_SAVE,
        BUDGET_APPROPRIATION,
        ADMIN_SANCTION,
        REJECT,
        CANCEL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EstimateStatus {
        CREATED,
        TECH_SANCTION_CHECKED,
        TECH_SANCTIONED,
        BUDGETARY_APPR_CHECKED,
        BUDGETARY_APPROPRIATION_DONE,
        ADMIN_CHECKED,
        ADMIN_SANCTIONED,
        REJECTED,
        CANCELLED,
        APPROVED;

    }
}

