/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.workorder.service;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptanceForRE;
import org.egov.works.models.masters.Contractor;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.repository.WorkOrderEstimateRepository;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkOrderEstimateService {
    @PersistenceContext
    private EntityManager entityManager;
    private final WorkOrderEstimateRepository workOrderEstimateRepository;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public WorkOrderEstimateService(WorkOrderEstimateRepository workOrderEstimateRepository) {
        this.workOrderEstimateRepository = workOrderEstimateRepository;
    }

    public WorkOrderEstimate getEstimateByWorkOrderAndEstimateAndStatus(Long workOrderId, Long estimateId) {
        return this.workOrderEstimateRepository.findByWorkOrder_IdAndEstimate_IdAndWorkOrder_EgwStatus_Code(workOrderId, estimateId, "APPROVED");
    }

    public WorkOrderEstimate getWorkOrderEstimateById(Long id) {
        return (WorkOrderEstimate)((Object)this.workOrderEstimateRepository.findOne(id));
    }

    public WorkOrderEstimate getWorkOrderEstimateByAbstractEstimateId(Long estimateId) {
        return this.workOrderEstimateRepository.findByEstimate_IdAndWorkOrder_EgwStatus_Code(estimateId, "APPROVED");
    }

    public WorkOrderEstimate getWorkOrderEstimateByWorkOrderId(Long workOrderId) {
        return this.workOrderEstimateRepository.findByWorkOrder_Id(workOrderId);
    }

    public List<String> findWorkOrderForMBHeader(String workOrderNo) {
        List<String> workOrderNumbers = this.workOrderEstimateRepository.findWorkOrderNumbersToCreateMB("%" + workOrderNo + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        return workOrderNumbers;
    }

    public List<WorkOrderEstimate> searchWorkOrderToCreateMBHeader(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        ArrayList<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        this.getWorkOrdersWhereBoqIsCreated(searchRequestLetterOfAcceptance, queryStr);
        Query query = this.setParameterForLetterOfAcceptanceToCreateMB(searchRequestLetterOfAcceptance, queryStr);
        query.setParameter("offlineStatus", (Object)WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toLowerCase());
        query.setParameter("objectType", (Object)"WorkOrder");
        workOrderEstimateList = query.getResultList();
        return workOrderEstimateList;
    }

    private Query setParameterForLetterOfAcceptanceToCreateMB(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("billStatus", (Object)ContractorBillRegister.BillStatus.CANCELLED.toString());
        qry.setParameter("billType", (Object)BillTypes.Final_Bill.toString());
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                qry.setParameter("executingDepartment", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            }
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                qry.setParameter("fromWorkOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate());
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                qry.setParameter("toWorkOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate());
            }
            if (searchRequestLetterOfAcceptance.getContractor() != null) {
                qry.setParameter("contractorName", (Object)searchRequestLetterOfAcceptance.getContractor().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                qry.setParameter("woStatus", (Object)"APPROVED");
            }
            if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
                qry.setParameter("workIdentificationNo", (Object)searchRequestLetterOfAcceptance.getWorkIdentificationNumber());
            }
        }
        return qry;
    }

    private void getWorkOrdersWhereBoqIsCreated(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        queryStr.append(" select distinct woe from WorkOrderEstimate woe where woe.workOrder.egwStatus.code = :woStatus and  not exists (select distinct(cbr.workOrderEstimate) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) !=:billStatus and cbr.billtype =:billType and cbr.workOrderEstimate.id is not null) ");
        queryStr.append(" and exists (select workOrderEstimate  from WorkOrderActivity where woe.id =workOrderEstimate.id ) ");
        queryStr.append(" and exists ( select distinct(woe1) from WorkOrderEstimate as woe1 where woe1 = woe and woe1.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe1.workOrder.id) and os.objectId = woe1.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType ) ) ");
        if (searchRequestLetterOfAcceptance != null) {
            this.getSubQuery(searchRequestLetterOfAcceptance, queryStr);
        }
    }

    private void getSubQuery(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
            queryStr.append(" and woe.estimate.executingDepartment.id =:executingDepartment ");
        }
        if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
            queryStr.append(" and woe.workOrder.workOrderNumber =:workOrderNumber ");
        }
        if (searchRequestLetterOfAcceptance.getFromDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate >=:fromWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptance.getToDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate <=:toWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptance.getContractor() != null) {
            queryStr.append(" and upper(woe.workOrder.contractor.name) =:contractorName ");
        }
        if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
            queryStr.append(" and upper(woe.estimate.estimateNumber) =:estimateNumber ");
        }
        if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
            queryStr.append(" and upper(woe.estimate.projectCode.code) =:workIdentificationNo ");
        }
    }

    public void getContratorBillForWorkOrderEstimateAndBillType(Long workOrderEstimateId, JsonObject jsonObject) {
        WorkOrderEstimate workOrderEstimate = this.getWorkOrderEstimateById(workOrderEstimateId);
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContratorBillForWorkOrder(workOrderEstimate, ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        if (contractorBillRegister != null) {
            jsonObject.addProperty("mberror", this.messageSource.getMessage("error.mbheader.create", (Object[])new String[0], null));
        }
    }

    public List<String> getApprovedAndWorkCommencedWorkOrderNumbers(String workOrderNo) {
        return this.workOrderEstimateRepository.findWordOrderByStatus("%" + workOrderNo + "%", "APPROVED", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString(), "WorkOrder");
    }

    public List<String> getEstimateNumbersByApprovedAndWorkCommencedWorkOrders(String EstimateNumber) {
        return this.workOrderEstimateRepository.findEstimatesByWorkOrderStatus("%" + EstimateNumber + "%", "APPROVED", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString(), "WorkOrder");
    }

    public List<String> getEstimateNumbersForApprovedLoa(String estimateNumber) {
        List<WorkOrderEstimate> workOrderEstimates = this.workOrderEstimateRepository.findByEstimate_EstimateNumberContainingIgnoreCaseAndWorkOrder_EgwStatus_codeEquals(estimateNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrderEstimate details : workOrderEstimates) {
            results.add(details.getEstimate().getEstimateNumber());
        }
        return results;
    }

    public List<Contractor> getContractorsByWorkOrderStatus(String contractorNameCode) {
        return this.workOrderEstimateRepository.findContractorByWorkOrderStatus("%" + contractorNameCode + "%", "APPROVED", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString(), "WorkOrder");
    }

    public List<WorkOrderEstimate> getWorkOrderEstimatesToCancelEstimates(String estimateNumber) {
        return this.workOrderEstimateRepository.findByEstimate_EstimateNumberContainingIgnoreCaseAndWorkOrder_EgwStatus_codeNotLike(estimateNumber, "CANCELLED");
    }

    public List<String> findWorkOrderForRE(String workOrderNo) {
        List<String> workOrderNumbers = this.workOrderEstimateRepository.findWorkOrderNumbersToCreateRE("%" + workOrderNo + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        return workOrderNumbers;
    }

    public List<WorkOrderEstimate> searchWorkOrderToCreateRE(SearchRequestLetterOfAcceptanceForRE searchRequestLetterOfAcceptanceForRE) {
        ArrayList<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append(" select distinct woe from WorkOrderEstimate woe where woe.workOrder.egwStatus.code = :woStatus and  not exists (select distinct(cbr.workOrderEstimate) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) !=:billStatus and cbr.billtype =:billType and cbr.workOrderEstimate.id is not null) ");
        queryStr.append(" and exists (select workOrderEstimate  from WorkOrderActivity where woe.id =workOrderEstimate.id ) ");
        if (searchRequestLetterOfAcceptanceForRE != null) {
            this.getSubQueryForRE(searchRequestLetterOfAcceptanceForRE, queryStr);
        }
        Query query = this.setParameterForLetterOfAcceptanceToCreateRE(searchRequestLetterOfAcceptanceForRE, queryStr);
        workOrderEstimateList = query.getResultList();
        return workOrderEstimateList;
    }

    private Query setParameterForLetterOfAcceptanceToCreateRE(SearchRequestLetterOfAcceptanceForRE searchRequestLetterOfAcceptanceForRE, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("billStatus", (Object)ContractorBillRegister.BillStatus.CANCELLED.toString());
        qry.setParameter("billType", (Object)BillTypes.Final_Bill.toString());
        if (searchRequestLetterOfAcceptanceForRE != null) {
            if (searchRequestLetterOfAcceptanceForRE.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptanceForRE.getWorkOrderNumber());
            }
            if (searchRequestLetterOfAcceptanceForRE.getFromDate() != null) {
                qry.setParameter("fromWorkOrderDate", (Object)searchRequestLetterOfAcceptanceForRE.getFromDate());
            }
            if (searchRequestLetterOfAcceptanceForRE.getToDate() != null) {
                qry.setParameter("toWorkOrderDate", (Object)searchRequestLetterOfAcceptanceForRE.getToDate());
            }
            if (searchRequestLetterOfAcceptanceForRE.getContractor() != null) {
                qry.setParameter("contractorName", (Object)searchRequestLetterOfAcceptanceForRE.getContractor().toUpperCase());
            }
            if (searchRequestLetterOfAcceptanceForRE.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)("%" + searchRequestLetterOfAcceptanceForRE.getEstimateNumber().toUpperCase() + "%"));
            }
            if (searchRequestLetterOfAcceptanceForRE.getEgwStatus() != null) {
                qry.setParameter("woStatus", (Object)"APPROVED");
            }
            if (searchRequestLetterOfAcceptanceForRE.getWorkAssignedTo() != null) {
                qry.setParameter("workAssignedTo", (Object)searchRequestLetterOfAcceptanceForRE.getWorkAssignedTo());
            }
        }
        return qry;
    }

    private void getSubQueryForRE(SearchRequestLetterOfAcceptanceForRE searchRequestLetterOfAcceptanceForRE, StringBuilder queryStr) {
        queryStr.append(" and woe.estimate.parent.id is null ");
        if (searchRequestLetterOfAcceptanceForRE.getWorkOrderNumber() != null) {
            queryStr.append(" and woe.workOrder.workOrderNumber =:workOrderNumber ");
        }
        if (searchRequestLetterOfAcceptanceForRE.getFromDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate >=:fromWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptanceForRE.getToDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate <=:toWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptanceForRE.getContractor() != null) {
            queryStr.append(" and upper(woe.workOrder.contractor.name) =:contractorName ");
        }
        if (searchRequestLetterOfAcceptanceForRE.getEstimateNumber() != null) {
            queryStr.append(" and upper(woe.estimate.estimateNumber) like :estimateNumber ");
        }
        if (searchRequestLetterOfAcceptanceForRE.getWorkAssignedTo() != null) {
            queryStr.append(" and woe.workOrder.engineerIncharge.id =:workAssignedTo ");
        }
    }

    public List<Contractor> findContractorsByWorkOrderStatus(String code) {
        return this.workOrderEstimateRepository.findContractorsByWorkOrderStatus("%" + code + "%", "APPROVED");
    }

    public WorkOrderEstimate findWorkOrderByRevisionEstimateNumber(String estimateNumber) {
        return this.workOrderEstimateRepository.findByEstimate_EstimateNumberContainingIgnoreCaseAndWorkOrder_EgwStatus_codeEquals(estimateNumber, "APPROVED").get(0);
    }

    public WorkOrderEstimate getWorkOrderEstimateByEstimateNumber(String estimateNumber) {
        return this.workOrderEstimateRepository.findWorkOrderEstimateByEstimateNumber(estimateNumber, "APPROVED");
    }
}

