/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.egov.works.services.impl.BaseServiceImpl;
import org.egov.works.workorder.entity.AbstractEstimateForWp;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderNumberGenerator;

public class WorkOrderServiceImpl
extends BaseServiceImpl<WorkOrder, Long>
implements WorkOrderService {
    private static final Logger logger = Logger.getLogger(WorkOrderServiceImpl.class);
    private WorksService worksService;
    private MeasurementBookService measurementBookService;
    private WorkOrderNumberGenerator workOrderNumberGenerators;
    public static final String CONTRACTOR_ID = "CONTRACTOR_ID";
    public static final String CREATE_DATE = "CREATE_DATE";
    public static final String FROM_DATE = "FROM_DATE";
    public static final String TO_DATE = "TO_DATE";
    public static final String STATUS = "STATUS";
    public static final String TENDER_NO = "TENDER_NO";
    public static final String WORKORDER_NO = "WORKORDER_NO";
    public static final String MB_CREATION = "MB_CREATION";
    public static final String WORKORDER_ID = "WORKORDER_ID";
    public static final String WORKORDER_ESTIMATE_ID = "WORKORDER_ESTIMATE_ID";
    public static final String PROJECT_CODE = "PROJECT_CODE";
    public static final String ACTIVITY_DESC = "ACTIVITY_DESC";
    public static final String ACTIVITY_CODE = "ACTIVITY_CODE";
    public static final String ACTION_FLAG = "ACTION_FLAG";
    public static final String ESTIMATE_NO = "ESTIMATE_NO";
    public static final String WP_NO = "WP_NO";
    public static final String TENDER_FILE_NO = "TENDER_FILE_NO";
    public static final String REVISION_TYPE = "REVISION_TYPE";
    public static final String SOURCEPAGE = "sourcepage";
    public static final String CANCELWO = "cancelWO";
    private WorksPackageService workspackageService;

    public WorkOrderServiceImpl(PersistenceService<WorkOrder, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public Double getSecurityDepositConfValue() {
        String securityDepConfValue = this.worksService.getWorksConfigValue("SECURITY_DEPOSIT_MULTIPLIER");
        if (StringUtils.isNotBlank((String)securityDepConfValue)) {
            return Double.valueOf(securityDepConfValue);
        }
        return 0.0;
    }

    @Override
    public Double getLabourWelfareFundConfValue() {
        String labourWelfareConfValue = this.worksService.getWorksConfigValue("LWF_MULTIPLIER");
        if (StringUtils.isNotBlank((String)labourWelfareConfValue)) {
            return Double.valueOf(labourWelfareConfValue);
        }
        return 0.0;
    }

    @Override
    public WorkOrder setWorkOrderNumber(AbstractEstimate abstractEstimate, WorkOrder workOrder, WorksPackage worksPackage) {
        CFinancialYear financialYear = this.getCurrentFinancialYear(workOrder.getWorkOrderDate());
        if (workOrder.getWorkOrderNumber() == null) {
            workOrder.setWorkOrderNumber(this.workOrderNumberGenerators.getWorkOrderNumberGenerator(abstractEstimate, financialYear, worksPackage, workOrder, this.persistenceService));
        }
        return workOrder;
    }

    @Override
    public List<Contractor> getContractorsWithWO() {
        logger.info((Object)"-------------------------Inside getContractorsWithWO---------------------");
        List contractorList = null;
        contractorList = this.genericService.findAllByNamedQuery("getContractorsWithWO", new Object[0]);
        return contractorList;
    }

    @Override
    public List<WorkOrder> searchWOForMB(Map<String, Object> criteriaMap) {
        logger.info((Object)"---------------------------Inside searchWOForMB----------------------------");
        ArrayList<WorkOrder> filteredList = new ArrayList<WorkOrder>();
        criteriaMap.put(ACTION_FLAG, "searchWOForMB");
        for (WorkOrder workorder : this.searchWO(criteriaMap)) {
            if (this.isApprovalLimitReachedForWO(workorder.getId()).booleanValue()) continue;
            filteredList.add(workorder);
        }
        return filteredList;
    }

    @Override
    public List<WorkOrder> searchWOForBilling(Map<String, Object> criteriaMap) {
        logger.debug((Object)"-------------------------Inside searchWOForBilling-----------------------");
        ArrayList<WorkOrder> filteredList = new ArrayList<WorkOrder>();
        criteriaMap.put(ACTION_FLAG, "searchWOForBilling");
        for (WorkOrder workorder : this.searchWO(criteriaMap)) {
            if (this.isWOValidforBill(workorder.getId()).booleanValue()) continue;
            filteredList.add(workorder);
        }
        return filteredList;
    }

    @Override
    public List<String> searchWOToPaginatedView(Map<String, Object> criteriaMap, List<Object> paramList) {
        logger.info((Object)"-------------------------Inside searchWOToView-----------------------");
        return this.searchWOQuery(criteriaMap, paramList);
    }

    public List<String> searchWOQuery(Map<String, Object> criteriaMap, List<Object> paramList) {
        logger.info((Object)"-------------------------Inside searchWO---------------------------------");
        ArrayList<String> qryList = new ArrayList<String>();
        StringBuffer commonQueryFilter = new StringBuffer();
        String CountQry = " select count(distinct wo) from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null and wo.egwStatus.code<>'NEW' ";
        String dynQuery = "select distinct wo from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null and wo.egwStatus.code<>'NEW' ";
        String setStat = this.worksService.getWorksConfigValue("WorkOrder.setstatus");
        if (criteriaMap.get(STATUS) != null) {
            if (criteriaMap.get(STATUS).equals("APPROVED") || criteriaMap.get(STATUS).equals("CANCELLED")) {
                if (criteriaMap.get(SOURCEPAGE) != null && CANCELWO.equals(criteriaMap.get(SOURCEPAGE))) {
                    commonQueryFilter = commonQueryFilter.append(" and wo.egwStatus.code = ? ");
                    paramList.add(criteriaMap.get(STATUS));
                } else if (criteriaMap.get(STATUS).equals("APPROVED")) {
                    commonQueryFilter = commonQueryFilter.append(" and wo.egwStatus.code = ? and  wo.id not in (select objectId from OfflineStatus where objectType=?)");
                    paramList.add(criteriaMap.get(STATUS));
                    paramList.add("WorkOrder");
                } else if (criteriaMap.get(STATUS).equals("CANCELLED")) {
                    commonQueryFilter = commonQueryFilter.append(" and wo.egwStatus.code = ? ");
                    paramList.add(criteriaMap.get(STATUS));
                }
            } else if (!criteriaMap.get(STATUS).equals("-1") && Arrays.asList(setStat.split(",")).contains(criteriaMap.get(STATUS))) {
                commonQueryFilter = commonQueryFilter.append(" and wo.egwStatus.code = 'APPROVED' and wo.id in(select stat.objectId from OfflineStatus stat where stat.egwStatus.code=? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where wo.id=stat1.objectId and stat1.objectType=?) and stat.objectType=?)");
                paramList.add(criteriaMap.get(STATUS));
                paramList.add("WorkOrder");
                paramList.add("WorkOrder");
            } else if (!criteriaMap.get(STATUS).equals("-1") && !Arrays.asList(setStat.split(",")).contains(criteriaMap.get(STATUS))) {
                commonQueryFilter = commonQueryFilter.append(" and wo.egwStatus.code = ?");
                paramList.add(criteriaMap.get(STATUS));
            }
        }
        if (criteriaMap.get(CREATE_DATE) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.workOrderDate = ? ");
            paramList.add(criteriaMap.get(CREATE_DATE));
        }
        if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) == null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.workOrderDate >= ? ");
            paramList.add(criteriaMap.get(FROM_DATE));
        } else if (criteriaMap.get(TO_DATE) != null && criteriaMap.get(FROM_DATE) == null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.workOrderDate <= ? ");
            paramList.add(criteriaMap.get(TO_DATE));
        } else if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.workOrderDate between ? and ? ");
            paramList.add(criteriaMap.get(FROM_DATE));
            paramList.add(criteriaMap.get(TO_DATE));
        }
        if (criteriaMap.get(WORKORDER_NO) != null) {
            commonQueryFilter = commonQueryFilter.append(" and UPPER(wo.workOrderNumber) like ? ");
            paramList.add("%" + criteriaMap.get(WORKORDER_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(WP_NO) != null) {
            commonQueryFilter = commonQueryFilter.append(" and UPPER(wo.packageNumber) like ? ");
            paramList.add("%" + criteriaMap.get(WP_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(TENDER_FILE_NO) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.negotiationNumber in (select tr1.negotiationNumber from TenderResponse tr1 where UPPER(tr1.tenderEstimate.worksPackage.tenderFileNumber) like ? )");
            paramList.add("%" + criteriaMap.get(TENDER_FILE_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(CONTRACTOR_ID) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.contractor.id = ? ");
            paramList.add(criteriaMap.get(CONTRACTOR_ID));
        }
        if (criteriaMap.get("DEPT_ID") != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  we.estimate.executingDepartment.id = ?) ");
            paramList.add(criteriaMap.get("DEPT_ID"));
        }
        if (criteriaMap.get(ESTIMATE_NO) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  UPPER(we.estimate.estimateNumber) like ? ) ");
            paramList.add("%" + criteriaMap.get(ESTIMATE_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(TENDER_NO) != null && !"".equalsIgnoreCase((String)criteriaMap.get(TENDER_NO))) {
            logger.debug((Object)("-------TENDER_NO-----------" + criteriaMap.get(TENDER_NO)));
            commonQueryFilter = commonQueryFilter.append(" and UPPER(wo.tenderNumber like) ? ) ");
            paramList.add("%" + criteriaMap.get(TENDER_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(PROJECT_CODE) != null) {
            commonQueryFilter = commonQueryFilter.append(" and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  UPPER(we.estimate.executingDepartment.projectCode.code) like ? ) ");
            paramList.add("%" + criteriaMap.get(PROJECT_CODE).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(ACTION_FLAG) != null && criteriaMap.get(ACTION_FLAG).toString().equalsIgnoreCase("searchWOForMB")) {
            commonQueryFilter = commonQueryFilter.append(" and workOrderEstimate.estimate.projectCode.egwStatus.code!='CLOSED' and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code=?  or mbh.egwStatus.code=? or mbh.egwStatus.code=? or mbh.egwStatus.code=? or mbh.egwStatus.code=? )and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where  mbh.egwStatus.code = ? and  mbh.egBillregister.billstatus = ? and  mbh.egBillregister.billtype=?)");
            paramList.add(MBHeader.MeasurementBookStatus.CREATED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CHECKED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.RESUBMITTED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.REJECTED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.NEW.toString());
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(this.getFinalBillTypeConfigValue());
        }
        if (criteriaMap.get(ACTION_FLAG) != null && criteriaMap.get(ACTION_FLAG).toString().equalsIgnoreCase("searchWOForBilling")) {
            commonQueryFilter = commonQueryFilter.append(" and workOrderEstimate.estimate.projectCode.egwStatus.code!='CLOSED' and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code = ?  and (mbh.egBillregister.billstatus <> ? and mbh.egBillregister.billtype = ?))");
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            paramList.add(this.getFinalBillTypeConfigValue());
        }
        String orderQry = " Order by wo.workOrderDate ";
        logger.info((Object)"Query is ::select distinct wo from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null and wo.egwStatus.code<>'NEW' ");
        qryList.add(" select count(distinct wo) from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null and wo.egwStatus.code<>'NEW' " + commonQueryFilter + " Order by wo.workOrderDate ");
        qryList.add("select distinct wo from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null and wo.egwStatus.code<>'NEW' " + commonQueryFilter + " Order by wo.workOrderDate ");
        return qryList;
    }

    @Override
    public List<WorkOrder> searchWOToView(Map<String, Object> criteriaMap) {
        logger.debug((Object)"-------------------------Inside searchWOToView-----------------------");
        return this.searchWO(criteriaMap);
    }

    public List<WorkOrder> searchWO(Map<String, Object> criteriaMap) {
        logger.info((Object)"-------------------------Inside searchWO---------------------------------");
        List<WorkOrder> wolList = null;
        String dynQuery = "select distinct wo from WorkOrder wo left join wo.workOrderEstimates workOrderEstimate where wo.id is not null and wo.parent is null ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        String setStat = this.worksService.getWorksConfigValue("WorkOrder.setstatus");
        if (criteriaMap.get(STATUS) != null) {
            if (criteriaMap.get(STATUS).equals("APPROVED") || criteriaMap.get(STATUS).equals("CANCELLED")) {
                if (criteriaMap.get(SOURCEPAGE) != null && CANCELWO.equals(criteriaMap.get(SOURCEPAGE))) {
                    dynQuery = dynQuery + " and wo.egwStatus.code = ? ";
                    paramList.add(criteriaMap.get(STATUS));
                } else {
                    dynQuery = dynQuery + " and wo.egwStatus.code = ? and  wo.id not in (select objectId from OfflineStatus where objectType=?)";
                    paramList.add(criteriaMap.get(STATUS));
                    paramList.add("WorkOrder");
                }
            } else if (!criteriaMap.get(STATUS).equals("-1") && Arrays.asList(setStat.split(",")).contains(criteriaMap.get(STATUS))) {
                dynQuery = dynQuery + " and wo.id in(select stat.objectId from OfflineStatus stat where stat.egwStatus.code=? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where wo.id=stat1.objectId and stat1.objectType=?) and stat.objectType=?)";
                paramList.add(criteriaMap.get(STATUS));
                paramList.add("WorkOrder");
                paramList.add("WorkOrder");
            } else if (!criteriaMap.get(STATUS).equals("-1") && !Arrays.asList(setStat.split(",")).contains(criteriaMap.get(STATUS))) {
                dynQuery = dynQuery + " and wo.egwStatus.code = ?";
                paramList.add(criteriaMap.get(STATUS));
            }
        }
        if (criteriaMap.get(CREATE_DATE) != null) {
            dynQuery = dynQuery + " and wo.workOrderDate = ? ";
            paramList.add(criteriaMap.get(CREATE_DATE));
        }
        if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) == null) {
            dynQuery = dynQuery + " and wo.workOrderDate >= ? ";
            paramList.add(criteriaMap.get(FROM_DATE));
        } else if (criteriaMap.get(TO_DATE) != null && criteriaMap.get(FROM_DATE) == null) {
            dynQuery = dynQuery + " and wo.workOrderDate <= ? ";
            paramList.add(criteriaMap.get(TO_DATE));
        } else if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) != null) {
            dynQuery = dynQuery + " and wo.workOrderDate between ? and ? ";
            paramList.add(criteriaMap.get(FROM_DATE));
            paramList.add(criteriaMap.get(TO_DATE));
        }
        if (criteriaMap.get(WORKORDER_NO) != null) {
            dynQuery = dynQuery + " and UPPER(wo.workOrderNumber) like ? ";
            paramList.add("%" + criteriaMap.get(WORKORDER_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(WP_NO) != null) {
            dynQuery = dynQuery + " and UPPER(wo.packageNumber) like ? ";
            paramList.add("%" + criteriaMap.get(WP_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(TENDER_FILE_NO) != null) {
            dynQuery = dynQuery + " and wo.negotiationNumber in (select tr1.negotiationNumber from TenderResponse tr1 where UPPER(tr1.tenderEstimate.worksPackage.tenderFileNumber) like ? )";
            paramList.add("%" + criteriaMap.get(TENDER_FILE_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(CONTRACTOR_ID) != null) {
            dynQuery = dynQuery + " and wo.contractor.id = ? ";
            paramList.add(criteriaMap.get(CONTRACTOR_ID));
        }
        if (criteriaMap.get("DEPT_ID") != null) {
            dynQuery = dynQuery + " and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  we.estimate.executingDepartment.id = ?) ";
            paramList.add(criteriaMap.get("DEPT_ID"));
        }
        if (criteriaMap.get(ESTIMATE_NO) != null) {
            dynQuery = dynQuery + " and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  UPPER(we.estimate.estimateNumber) like ? ) ";
            paramList.add("%" + criteriaMap.get(ESTIMATE_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(TENDER_NO) != null && !"".equalsIgnoreCase((String)criteriaMap.get(TENDER_NO))) {
            logger.debug((Object)("-------TENDER_NO-----------" + criteriaMap.get(TENDER_NO)));
            dynQuery = dynQuery + " and UPPER(wo.tenderNumber like) ? ) ";
            paramList.add("%" + criteriaMap.get(TENDER_NO).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(PROJECT_CODE) != null) {
            dynQuery = dynQuery + " and wo.id in (select we.workOrder.id from WorkOrderEstimate we where we.workOrder.id=wo.id and  UPPER(we.estimate.executingDepartment.projectCode.code) like ? ) ";
            paramList.add("%" + criteriaMap.get(PROJECT_CODE).toString().trim().toUpperCase() + "%");
        }
        if (criteriaMap.get(ACTION_FLAG) != null && criteriaMap.get(ACTION_FLAG).toString().equalsIgnoreCase("searchWOForMB")) {
            dynQuery = dynQuery + " and workOrderEstimate.workOrder.egwStatus.code!='CANCELLED' and workOrderEstimate.estimate.projectCode.egwStatus.code!='CLOSED' and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code=?  or mbh.egwStatus.code=? or mbh.egwStatus.code=? or mbh.egwStatus.code=? or mbh.egwStatus.code=? )and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where  mbh.egwStatus.code = ? and  mbh.egBillregister.billstatus = ? and  mbh.egBillregister.billtype=?)";
            paramList.add(MBHeader.MeasurementBookStatus.CREATED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CHECKED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.RESUBMITTED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.REJECTED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.NEW.toString());
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(this.getFinalBillTypeConfigValue());
        }
        if (criteriaMap.get(ACTION_FLAG) != null && criteriaMap.get(ACTION_FLAG).toString().equalsIgnoreCase("searchWOForBilling")) {
            dynQuery = dynQuery + " and workOrderEstimate.workOrder.egwStatus.code!='CANCELLED' and workOrderEstimate.estimate.projectCode.egwStatus.code!='CLOSED' and workOrderEstimate.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code = ?  and (mbh.egBillregister.billstatus <> ? and mbh.egBillregister.billtype = ?))";
            paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            paramList.add(this.getFinalBillTypeConfigValue());
        }
        logger.debug((Object)("Query is ::" + dynQuery));
        if (paramList.isEmpty()) {
            wolList = this.findAllBy(dynQuery, new Object[0]);
        } else {
            Object[] params = new Object[paramList.size()];
            params = paramList.toArray(params);
            wolList = this.findAllBy(dynQuery, params);
        }
        return wolList;
    }

    public Boolean isApprovalLimitReachedForWO(Long woId) {
        Boolean result = false;
        WorkOrder wo = (WorkOrder)((Object)this.findById(woId, false));
        if (this.measurementBookService.getWorkOrderEstimatesForMB(wo.getWorkOrderEstimates()).isEmpty()) {
            result = true;
        }
        return result;
    }

    public Boolean isWOValidforBill(Long woId) {
        Boolean result = false;
        WorkOrder wo = (WorkOrder)((Object)this.findById(woId, false));
        if (this.measurementBookService.getWOEstForBillExludingLegacyMB(wo.getWorkOrderEstimates()).isEmpty()) {
            result = true;
        }
        return result;
    }

    @Override
    public List<WorkOrderActivity> searchWOActivities(Map<String, Object> criteriaMap) {
        logger.info((Object)"-------------------------Inside searchWOActivities-----------------------");
        String dynQuery = "select distinct woa from WorkOrderActivity woa left join woa.activity.schedule schedule left join woa.activity.nonSor nonSor where woa.id != null and woa.workOrderEstimate.estimate.parent is null  and woa.workOrderEstimate.workOrder.egwStatus.code != 'CANCELLED' ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (criteriaMap.get(WORKORDER_NO) != null) {
            dynQuery = dynQuery + " and woa.workOrderEstimate.workOrder.workOrderNumber = ? ";
            paramList.add(criteriaMap.get(WORKORDER_NO));
        }
        if (criteriaMap.get(WORKORDER_ESTIMATE_ID) != null) {
            dynQuery = dynQuery + " and woa.workOrderEstimate.estimate.id = ? ";
            paramList.add(criteriaMap.get(WORKORDER_ESTIMATE_ID));
        }
        if (criteriaMap.get(ACTIVITY_DESC) != null) {
            dynQuery = dynQuery + " and ((UPPER(schedule.description) like ?) or ( UPPER(nonSor.description)  like ? ))";
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%");
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%");
        }
        if (criteriaMap.get(ACTIVITY_CODE) != null) {
            dynQuery = dynQuery + " and UPPER(schedule.code) like ? ";
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_CODE)).toUpperCase() + "%");
        }
        Double extraPercentage = this.worksService.getConfigval();
        double factor = 1.0;
        if (extraPercentage > 0.0) {
            factor = 1.0 + extraPercentage / 100.0;
        }
        if (!"Required".equals(this.worksService.getWorksConfigValue("ORDER_NUMBER_REQUIRED"))) {
            dynQuery = dynQuery + "and ((woa.approvedQuantity*? > (select sum(mbd.quantity) as sumq from MBDetails mbd  where mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity having mbd.workOrderActivity.id = woa.id)) or (select sum(mbd.quantity) as sumq from MBDetails mbd  where mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity having mbd.workOrderActivity.id = woa.id) is null)";
            paramList.add(factor);
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
        }
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        List woActivityList = this.genericService.findAllBy(dynQuery, params);
        return woActivityList;
    }

    @Override
    public List<WorkOrderActivity> searchWOActivitiesForChangeQuantity(Map<String, Object> criteriaMap) {
        logger.info((Object)"-------------------------Inside searchWOActivities-----------------------");
        String dynQuery = "select distinct woa from WorkOrderActivity woa left join woa.activity.schedule schedule left join woa.activity.nonSor nonSor where woa.id is not null ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (criteriaMap.get(ACTIVITY_DESC) != null) {
            dynQuery = dynQuery + " and ((UPPER(schedule.description) like '%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%') or ( UPPER(nonSor.description)  like '%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%' ))";
        }
        if (criteriaMap.get(ACTIVITY_CODE) != null) {
            dynQuery = dynQuery + " and UPPER(schedule.code) like '%" + ((String)criteriaMap.get(ACTIVITY_CODE)).toUpperCase() + "%'";
        }
        if (criteriaMap.get(WORKORDER_ESTIMATE_ID) != null) {
            if (criteriaMap.get(WORKORDER_ID) != null) {
                dynQuery = dynQuery + " and (woa.workOrderEstimate.estimate.id = ? and woa.workOrderEstimate.workOrder.egwStatus.code=? and woa.workOrderEstimate.workOrder.id = ?) ";
                paramList.add(criteriaMap.get(WORKORDER_ESTIMATE_ID));
                paramList.add("APPROVED");
                paramList.add(criteriaMap.get(WORKORDER_ID));
            } else {
                dynQuery = dynQuery + " and (woa.workOrderEstimate.estimate.id = ? and woa.workOrderEstimate.workOrder.egwStatus.code=?) ";
                paramList.add(criteriaMap.get(WORKORDER_ESTIMATE_ID));
                paramList.add("APPROVED");
            }
            dynQuery = dynQuery + " or ((woa.workOrderEstimate.estimate.egwStatus is not null and woa.workOrderEstimate.estimate.egwStatus.code=?) and (woa.workOrderEstimate.estimate.parent is not null and woa.workOrderEstimate.estimate.parent.id = ? ))";
            paramList.add(AbstractEstimate.EstimateStatus.APPROVED.toString());
            paramList.add(criteriaMap.get(WORKORDER_ESTIMATE_ID));
        }
        if (criteriaMap.get(WORKORDER_ID) != null) {
            dynQuery = dynQuery + " and (woa.workOrderEstimate.workOrder.id = ?) or ((woa.workOrderEstimate.workOrder.egwStatus is not null and woa.workOrderEstimate.workOrder.egwStatus.code=?) and (woa.workOrderEstimate.workOrder.parent is not null and woa.workOrderEstimate.workOrder.parent.id = ? ))";
            paramList.add(criteriaMap.get(WORKORDER_ID));
            paramList.add("APPROVED");
            paramList.add(criteriaMap.get(WORKORDER_ID));
        }
        dynQuery = dynQuery + "and woa.id not in (select distinct mbd.workOrderActivity.id from MBDetails mbd where mbd.mbHeader.egwStatus.code not in (?,?) and mbd.workOrderActivity.id = woa.id)";
        paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
        paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        dynQuery = dynQuery + " order by woa.activity.id asc";
        List woActivityList = this.genericService.findAllBy(dynQuery, params);
        return woActivityList;
    }

    @Override
    public List<WorkOrderActivity> searchWOActivitiesFromRevEstimates(Map<String, Object> criteriaMap) {
        logger.info((Object)"-------------------------Inside searchWOActivities-----------------------");
        String dynQuery = "select distinct woa from WorkOrderActivity woa left join woa.activity.schedule schedule left join woa.activity.nonSor nonSor where woa.id != null ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (criteriaMap.get(WORKORDER_NO) != null) {
            dynQuery = dynQuery + " and woa.workOrderEstimate.workOrder.parent.workOrderNumber = ? ";
            paramList.add(criteriaMap.get(WORKORDER_NO));
        }
        if (criteriaMap.get(WORKORDER_ESTIMATE_ID) != null) {
            dynQuery = dynQuery + " and woa.workOrderEstimate.estimate.parent.id = ? ";
            paramList.add(criteriaMap.get(WORKORDER_ESTIMATE_ID));
        }
        if (criteriaMap.get(ACTIVITY_DESC) != null) {
            dynQuery = dynQuery + " and ((UPPER(schedule.description) like ?) or ( UPPER(nonSor.description)  like ? ))";
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%");
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_DESC)).toUpperCase() + "%");
        }
        if (criteriaMap.get(ACTIVITY_CODE) != null) {
            dynQuery = dynQuery + " and UPPER(schedule.code) like ? ";
            paramList.add("%" + ((String)criteriaMap.get(ACTIVITY_CODE)).toUpperCase() + "%");
        }
        dynQuery = dynQuery + " and  woa.workOrderEstimate.estimate.egwStatus.code=?   ";
        paramList.add("APPROVED");
        if (criteriaMap.get(REVISION_TYPE) != null) {
            dynQuery = dynQuery + " and woa.activity.revisionType=?  ";
            paramList.add(criteriaMap.get(REVISION_TYPE));
        }
        Double extraPercentage = this.worksService.getConfigval();
        double factor = 1.0;
        if (extraPercentage > 0.0) {
            factor = 1.0 + extraPercentage / 100.0;
        }
        if (!"Required".equals(this.worksService.getWorksConfigValue("ORDER_NUMBER_REQUIRED"))) {
            dynQuery = dynQuery + "and ((woa.approvedQuantity*? > (select sum(mbd.quantity) as sumq from MBDetails mbd  where mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity having mbd.workOrderActivity.id = woa.id)) or (select sum(mbd.quantity) as sumq from MBDetails mbd  where mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity having mbd.workOrderActivity.id = woa.id) is null)";
            paramList.add(factor);
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
        }
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        List woActivityList = this.genericService.findAllBy(dynQuery, params);
        return woActivityList;
    }

    @Override
    public MBHeader findLastMBPageNoForLineItem(WorkOrderActivity workOrderActivity, Long mbHeaderId) {
        logger.info((Object)"-------------------------Inside findLastMBPageNoForLineItem--------------");
        String query = "select distinct mbh from MBHeader mbh join mbh.mbDetails as mbDetail ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        query = query + " where mbDetail.workOrderActivity.id = ?  and mbh.id != ? and mbh.egwStatus.code=?  and mbh.modifiedDate < (select modifiedDate from MBHeader where id = ? ) order by mbh.modifiedDate desc";
        paramList.add(workOrderActivity.getId());
        paramList.add(mbHeaderId);
        paramList.add("APPROVED");
        paramList.add(mbHeaderId);
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        List mbHeaderList = this.genericService.findAllBy(query, params);
        MBHeader result = null;
        if (mbHeaderList != null && !mbHeaderList.isEmpty()) {
            result = (MBHeader)((Object)mbHeaderList.get(0));
        }
        return result;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setWorkOrderNumberGenerators(WorkOrderNumberGenerator workOrderNumberGenerators) {
        this.workOrderNumberGenerators = workOrderNumberGenerators;
    }

    @Override
    public List<Contractor> getAllContractorForWorkOrder() {
        logger.info((Object)"-------------------------Inside getAllContractorForWorkOrder---------------------");
        String status = this.worksService.getWorksConfigValue("CONTRACTOR_STATUS");
        List contractorList = null;
        contractorList = this.genericService.findAllByNamedQuery("GET_All_CONTRACTORS", new Object[]{status});
        return contractorList;
    }

    @Override
    public Boolean isMBInApprovalPendingForWO(String woNumber) {
        Boolean result = false;
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        criteriaMap.put(WORKORDER_NO, woNumber);
        criteriaMap.put(ACTION_FLAG, "searchWOForMB");
        if (this.searchWO(criteriaMap).isEmpty()) {
            result = true;
        }
        return result;
    }

    @Override
    public Collection<EstimateLineItemsForWP> getActivitiesForWorkorder(TenderResponse tenderResponse) {
        HashMap<Long, EstimateLineItemsForWP> resultMap = new HashMap<Long, EstimateLineItemsForWP>();
        Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
        List<String> tenderTypeList = this.worksService.getTendertypeList();
        String percTenderType = "";
        if (tenderTypeList != null && !tenderTypeList.isEmpty()) {
            percTenderType = tenderTypeList.get(0);
        }
        for (TenderResponseActivity tenAct : tenderResponse.getTenderResponseActivities()) {
            EstimateLineItemsForWP estlineItem = new EstimateLineItemsForWP();
            if (tenAct.getActivity().getSchedule() != null) {
                if (resultMap.containsKey(tenAct.getActivity().getSchedule().getId())) {
                    EstimateLineItemsForWP preEstlineItem = (EstimateLineItemsForWP)resultMap.get(tenAct.getActivity().getSchedule().getId());
                    preEstlineItem.setQuantity(tenAct.getNegotiatedQuantity() + preEstlineItem.getQuantity());
                    if (DateUtils.compareDates((Date)tenAct.getActivity().getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                        if (tenderResponse.getTenderEstimate().getTenderType().equals(percTenderType)) {
                            preEstlineItem.setRate(tenAct.getActivity().getEstimateRate());
                        } else {
                            preEstlineItem.setRate(tenAct.getNegotiatedRate());
                        }
                        double result = 1.0;
                        if (tenAct.getActivity().getSchedule() != null && exceptionaSorMap.containsKey(tenAct.getActivity().getUom().getUom())) {
                            result = exceptionaSorMap.get(tenAct.getActivity().getUom().getUom()).intValue();
                            preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate() / result);
                        } else {
                            preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate());
                        }
                        preEstlineItem.setActivity(tenAct.getActivity());
                    }
                    resultMap.put(tenAct.getActivity().getSchedule().getId(), preEstlineItem);
                } else {
                    this.addEstLineItem(tenAct, estlineItem);
                    resultMap.put(tenAct.getActivity().getSchedule().getId(), estlineItem);
                }
            }
            if (tenAct.getActivity().getNonSor() == null) continue;
            this.addEstLineItem(tenAct, estlineItem);
            resultMap.put(tenAct.getActivity().getNonSor().getId(), estlineItem);
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    @Override
    public Collection<EstimateLineItemsForWP> getActivitiesForWorksPackage(TenderResponse tenderResponse) {
        HashMap<Long, EstimateLineItemsForWP> resultMap = new HashMap<Long, EstimateLineItemsForWP>();
        Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
        List<String> tenderTypeList = this.worksService.getTendertypeList();
        if (tenderTypeList != null && !tenderTypeList.isEmpty()) {
            tenderTypeList.get(0);
        }
        for (TenderResponseActivity tenAct : tenderResponse.getTenderResponseActivities()) {
            EstimateLineItemsForWP estlineItem = new EstimateLineItemsForWP();
            if (tenAct.getActivity().getSchedule() != null) {
                if (resultMap.containsKey(tenAct.getActivity().getSchedule().getId())) {
                    EstimateLineItemsForWP preEstlineItem = (EstimateLineItemsForWP)resultMap.get(tenAct.getActivity().getSchedule().getId());
                    preEstlineItem.setQuantity(tenAct.getActivity().getQuantity() + preEstlineItem.getQuantity());
                    if (DateUtils.compareDates((Date)tenAct.getActivity().getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                        preEstlineItem.setRate(tenAct.getActivity().getEstimateRate());
                        double result = 1.0;
                        if (tenAct.getActivity().getSchedule() != null && exceptionaSorMap.containsKey(tenAct.getActivity().getUom().getUom())) {
                            result = exceptionaSorMap.get(tenAct.getActivity().getUom().getUom()).intValue();
                            preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate() / result);
                        } else {
                            preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate());
                        }
                        preEstlineItem.setActivity(tenAct.getActivity());
                    }
                    resultMap.put(tenAct.getActivity().getSchedule().getId(), preEstlineItem);
                } else {
                    this.addEstLineItemWP(tenAct, estlineItem);
                    resultMap.put(tenAct.getActivity().getSchedule().getId(), estlineItem);
                }
            }
            if (tenAct.getActivity().getNonSor() == null) continue;
            this.addEstLineItemWP(tenAct, estlineItem);
            resultMap.put(tenAct.getActivity().getNonSor().getId(), estlineItem);
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    private Map<String, Integer> getSpecialUoms() {
        return this.worksService.getExceptionSOR();
    }

    private Collection<EstimateLineItemsForWP> getEstLineItemsWithSrlNo(Collection<EstimateLineItemsForWP> actList) {
        int i = 1;
        ArrayList<EstimateLineItemsForWP> latestEstLineItemList = new ArrayList<EstimateLineItemsForWP>();
        for (EstimateLineItemsForWP act : actList) {
            act.setSrlNo(i);
            latestEstLineItemList.add(act);
            ++i;
        }
        return latestEstLineItemList;
    }

    private void addEstLineItem(TenderResponseActivity act, EstimateLineItemsForWP estlineItem) {
        if (act.getActivity().getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setSummary("");
            estlineItem.setDescription(act.getActivity().getNonSor().getDescription());
            estlineItem.setRate(act.getNegotiatedRate());
            estlineItem.setAmt(act.getNegotiatedQuantity() * act.getNegotiatedRate());
        } else {
            estlineItem.setCode(act.getActivity().getSchedule().getCode());
            estlineItem.setDescription(act.getActivity().getSchedule().getDescription());
            estlineItem.setRate(act.getNegotiatedRate());
            estlineItem.setSummary(act.getActivity().getSchedule().getSummary());
            Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
            double result = 1.0;
            if (exceptionaSorMap.containsKey(act.getActivity().getUom().getUom())) {
                result = exceptionaSorMap.get(act.getActivity().getUom().getUom()).intValue();
            }
            estlineItem.setAmt(act.getNegotiatedQuantity() * act.getNegotiatedRate() / result);
        }
        estlineItem.setActivity(act.getActivity());
        estlineItem.setQuantity(act.getNegotiatedQuantity());
        estlineItem.setUom(act.getActivity().getUom().getUom());
        estlineItem.setConversionFactor(act.getActivity().getConversionFactor());
    }

    private void addEstLineItemWP(TenderResponseActivity act, EstimateLineItemsForWP estlineItem) {
        if (act.getActivity().getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setSummary("");
            estlineItem.setDescription(act.getActivity().getNonSor().getDescription());
            estlineItem.setRate(act.getActivity().getRate());
            estlineItem.setAmt(act.getActivity().getQuantity() * estlineItem.getRate());
        } else {
            estlineItem.setCode(act.getActivity().getSchedule().getCode());
            estlineItem.setDescription(act.getActivity().getSchedule().getDescription());
            estlineItem.setRate(act.getActivity().getEstimateRate());
            estlineItem.setSummary(act.getActivity().getSchedule().getSummary());
            Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
            double result = 1.0;
            if (exceptionaSorMap.containsKey(act.getActivity().getUom().getUom())) {
                result = exceptionaSorMap.get(act.getActivity().getUom().getUom()).intValue();
            }
            estlineItem.setAmt(act.getActivity().getQuantity() * estlineItem.getRate() / result);
        }
        estlineItem.setActivity(act.getActivity());
        estlineItem.setQuantity(act.getActivity().getQuantity());
        estlineItem.setUom(act.getActivity().getUom().getUom());
        estlineItem.setConversionFactor(act.getActivity().getConversionFactor());
    }

    @Override
    public Collection<EstimateLineItemsForWP> getActivitiesForWorkorder(WorkOrder workOrder) {
        HashMap<Long, EstimateLineItemsForWP> resultMap = new HashMap<Long, EstimateLineItemsForWP>();
        Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
        for (WorkOrderEstimate workOrderEstimate : workOrder.getWorkOrderEstimates()) {
            for (WorkOrderActivity woAct : workOrderEstimate.getWorkOrderActivities()) {
                EstimateLineItemsForWP estlineItem = new EstimateLineItemsForWP();
                if (woAct.getActivity().getSchedule() != null) {
                    if (resultMap.containsKey(woAct.getActivity().getSchedule().getId())) {
                        EstimateLineItemsForWP preEstlineItem = (EstimateLineItemsForWP)resultMap.get(woAct.getActivity().getSchedule().getId());
                        preEstlineItem.setQuantity(woAct.getApprovedQuantity() + preEstlineItem.getQuantity());
                        if (DateUtils.compareDates((Date)woAct.getActivity().getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                            preEstlineItem.setRate(woAct.getActivity().getEstimateRate());
                            double result = 1.0;
                            if (woAct.getActivity().getSchedule() != null && exceptionaSorMap.containsKey(woAct.getActivity().getUom().getUom())) {
                                result = exceptionaSorMap.get(woAct.getActivity().getUom().getUom()).intValue();
                                preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate() / result);
                            } else {
                                preEstlineItem.setAmt(preEstlineItem.getQuantity() * preEstlineItem.getRate());
                            }
                            preEstlineItem.setActivity(woAct.getActivity());
                        }
                        resultMap.put(woAct.getActivity().getSchedule().getId(), preEstlineItem);
                    } else {
                        this.addEstLineItem(woAct, estlineItem);
                        resultMap.put(woAct.getActivity().getSchedule().getId(), estlineItem);
                    }
                }
                if (woAct.getActivity().getNonSor() == null) continue;
                this.addEstLineItem(woAct, estlineItem);
                resultMap.put(woAct.getActivity().getNonSor().getId(), estlineItem);
            }
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    private void addEstLineItem(WorkOrderActivity act, EstimateLineItemsForWP estlineItem) {
        if (act.getActivity().getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setSummary("");
            estlineItem.setDescription(act.getActivity().getNonSor().getDescription());
            estlineItem.setRate(act.getApprovedRate());
            estlineItem.setAmt(act.getApprovedQuantity() * act.getApprovedRate());
        } else {
            estlineItem.setCode(act.getActivity().getSchedule().getCode());
            estlineItem.setDescription(act.getActivity().getSchedule().getDescription());
            estlineItem.setRate(act.getApprovedRate());
            estlineItem.setSummary(act.getActivity().getSchedule().getSummary());
            Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
            double result = 1.0;
            if (exceptionaSorMap.containsKey(act.getActivity().getUom().getUom())) {
                result = exceptionaSorMap.get(act.getActivity().getUom().getUom()).intValue();
            }
            estlineItem.setAmt(act.getApprovedQuantity() * act.getApprovedRate() / result);
        }
        estlineItem.setActivity(act.getActivity());
        estlineItem.setQuantity(act.getApprovedQuantity());
        estlineItem.setUom(act.getActivity().getUom().getUom());
        estlineItem.setConversionFactor(act.getActivity().getConversionFactor());
    }

    public Map createHeaderParams(WorkOrder workOrder, String type) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (workOrder != null) {
            if ("estimate".equalsIgnoreCase(type)) {
                for (WorkOrderEstimate workOrderEstimate : workOrder.getWorkOrderEstimates()) {
                    if (workOrderEstimate == null || workOrderEstimate.getEstimate() == null) continue;
                    reportParams.put("deptName", workOrderEstimate.getEstimate().getExecutingDepartment().getName());
                    Boundary b = this.getTopLevelBoundary(workOrderEstimate.getEstimate().getWard());
                    reportParams.put("cityName", b == null ? "" : b.getName());
                    reportParams.put("deptAddress", "");
                    reportParams.put("aeWorkNameForEstimate", workOrderEstimate.getEstimate().getName());
                    reportParams.put("negotiatedAmtForEstimate", workOrder.getWorkOrderAmount());
                    reportParams.put("estimateNo", workOrderEstimate.getEstimate().getEstimateNumber());
                    reportParams.put("estimateDate", workOrderEstimate.getEstimate().getEstimateDate());
                    if (workOrderEstimate.getEstimate().getProjectCode() == null) continue;
                    reportParams.put("projectCode", workOrderEstimate.getEstimate().getProjectCode().getCode());
                }
            } else {
                List<WorkOrderEstimate> aeList = this.getAbstractEstimateListForWp(workOrder);
                String projectCode = this.getProjectCodeListForAe(aeList);
                reportParams.put("projectCodeList", projectCode);
                WorksPackage wp = (WorksPackage)((Object)this.workspackageService.findByNamedQuery("GET_WORKSPACKAGE_PACKAGENUMBER", workOrder.getPackageNumber()));
                if (wp != null) {
                    reportParams.put("workPackageDate", wp.getCreatedDate());
                }
                if (wp != null) {
                    reportParams.put("tenderFileNumber", wp.getTenderFileNumber());
                }
                reportParams.put("workPackageNo", workOrder.getPackageNumber());
                if (aeList != null && !aeList.isEmpty()) {
                    reportParams.put("deptName", aeList.get(0).getEstimate().getExecutingDepartment().getName());
                    Boundary b = this.getTopLevelBoundary(aeList.get(0).getEstimate().getWard());
                    reportParams.put("cityName", b == null ? "" : b.getName());
                    reportParams.put("deptAddress", "");
                }
            }
        }
        if (workOrder != null && workOrder.getContractor() != null) {
            String contractorAddress = workOrder.getContractor().getName() + "  ,  " + workOrder.getContractor().getCode();
            if (workOrder.getContractor().getPaymentAddress() != null) {
                contractorAddress = contractorAddress + "  ,  " + workOrder.getContractor().getPaymentAddress();
            }
            reportParams.put("contractorAddress", contractorAddress);
        }
        reportParams.put("WorkOrderObj", (Object)workOrder);
        return reportParams;
    }

    public double getGrandTotal(List<AbstractEstimateForWp> aeForWp) {
        double grandTotal = 0.0;
        for (AbstractEstimateForWp aeforWp : aeForWp) {
            grandTotal += aeforWp.getNegotiatedAmtForWp();
        }
        return grandTotal;
    }

    protected Boundary getTopLevelBoundary(Boundary boundary) {
        Boundary b;
        for (b = boundary; b != null && b.getParent() != null; b = b.getParent()) {
        }
        return b;
    }

    protected String getProjectCodeListForAe(List<WorkOrderEstimate> aeList) {
        String projectCodes = "";
        int i = 0;
        for (WorkOrderEstimate ae : aeList) {
            if (ae.getEstimate().getProjectCode() != null && ae.getEstimate().getProjectCode().getCode() != null) {
                projectCodes = projectCodes + ae.getEstimate().getProjectCode().getCode();
            }
            if (i < aeList.size() - 1) {
                projectCodes = projectCodes.concat(", ");
            }
            ++i;
        }
        return projectCodes;
    }

    protected List<AbstractEstimateForWp> getAeForWp(List<WorkOrderEstimate> aeList) {
        ArrayList<AbstractEstimateForWp> aeForWpList = new ArrayList<AbstractEstimateForWp>();
        int srlNo = 0;
        for (WorkOrderEstimate ae : aeList) {
            AbstractEstimateForWp aeForWp = new AbstractEstimateForWp();
            aeForWp.setSrlNo(++srlNo);
            aeForWp.setAeWorkNameForWp(ae.getEstimate().getName());
            aeForWp.setNegotiatedAmtForWp(this.getWorkOrderEstimateAmount(ae));
            aeForWpList.add(aeForWp);
        }
        return aeForWpList;
    }

    public double getWorkOrderEstimateAmount(WorkOrderEstimate ae) {
        double totalAmt = 0.0;
        for (WorkOrderActivity wact : ae.getWorkOrderActivities()) {
            totalAmt += wact.getApprovedAmount();
        }
        return totalAmt;
    }

    @Override
    public List<AbstractEstimateForWp> getAeForWp(WorkOrder workOrder) {
        List<WorkOrderEstimate> aeList = this.getAbstractEstimateListForWp(workOrder);
        return this.getAeForWp(aeList);
    }

    public List<WorkOrderEstimate> getAbstractEstimateListForWp(WorkOrder workOrder) {
        ArrayList<WorkOrderEstimate> aeList = new ArrayList<WorkOrderEstimate>();
        List<WorkOrderEstimate> workOrderEstimateList = workOrder.getWorkOrderEstimates();
        for (WorkOrderEstimate workOrderEstimate : workOrderEstimateList) {
            aeList.add(workOrderEstimate);
        }
        return aeList;
    }

    @Override
    public WorkOrderEstimate calculateCumulativeDetailsForRE(WorkOrderEstimate workOrderEstimate) {
        List<WorkOrderActivity> woaList = workOrderEstimate.getWorkOrderActivities();
        double lPrevCumlvQuant = 0.0;
        for (WorkOrderActivity detail : woaList) {
            if (detail.getActivity().getParent() == null) {
                lPrevCumlvQuant = this.measurementBookService.prevCumulativeQuantityIncludingCQ(detail.getId(), null, detail.getActivity().getId(), workOrderEstimate.getWorkOrder());
                detail.setTotalEstQuantity(this.measurementBookService.totalEstimatedQuantityForPreviousREs(detail.getId(), workOrderEstimate.getEstimate().getId(), detail.getActivity().getId(), workOrderEstimate.getWorkOrder()));
            } else {
                WorkOrderActivity woa = null;
                woa = detail.getActivity().getParent().getRevisionType() != null && (detail.getActivity().getParent().getRevisionType().equals((Object)RevisionType.NON_TENDERED_ITEM) || detail.getActivity().getParent().getRevisionType().equals((Object)RevisionType.LUMP_SUM_ITEM)) ? (WorkOrderActivity)((Object)this.genericService.find("from WorkOrderActivity where activity.id=? and workOrderEstimate.estimate.id=?", new Object[]{detail.getActivity().getParent().getId(), detail.getActivity().getParent().getAbstractEstimate().getId()})) : (WorkOrderActivity)((Object)this.genericService.find("from WorkOrderActivity where activity.id=? and workOrderEstimate.estimate.id=?", new Object[]{detail.getActivity().getParent().getId(), workOrderEstimate.getEstimate().getParent().getId()}));
                detail.setParent(woa);
                lPrevCumlvQuant = this.measurementBookService.prevCumulativeQuantityIncludingCQ(detail.getId(), null, detail.getActivity().getParent().getId(), workOrderEstimate.getWorkOrder().getParent());
                detail.setTotalEstQuantity(this.measurementBookService.totalEstimatedQuantityForPreviousREs(detail.getId(), workOrderEstimate.getEstimate().getId(), detail.getActivity().getParent().getId(), workOrderEstimate.getWorkOrder().getParent()));
            }
            if (detail.getTotalEstQuantity() == 0.0 && detail.getParent() != null && detail.getParent().getActivity().getQuantity() != 0.0) {
                detail.setTotalEstQuantity(detail.getApprovedQuantity());
            }
            detail.setPrevCumlvQuantity(lPrevCumlvQuant);
        }
        return workOrderEstimate;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    @Override
    public Date getWorkCommencedDateByWOId(Long id) {
        Object wOCommencedDate = this.persistenceService.find(" select stat.statusDate from OfflineStatus stat where stat.objectId = ? and stat.objectType = ? and stat.egwStatus.code = ? ", new Object[]{id, "WorkOrder", "Work commenced"});
        return (Date)wOCommencedDate;
    }

    @Override
    public String getWorksPackageName(String wpNumber) {
        Object nameOfWO = this.persistenceService.find(" select wp.name from WorksPackage wp where wp.wpNumber = ? and wp.egwStatus.code = ? ", new Object[]{wpNumber, "APPROVED"});
        return nameOfWO.toString();
    }

    @Override
    public Object getTenderNegotiationInfo(String negotiationNo) {
        Object obj = this.persistenceService.find("select tr.percNegotiatedAmountRate,tr.tenderEstimate.tenderType from TenderResponse tr where tr.egwStatus.code = 'APPROVED' and tr.negotiationNumber = ? ", new Object[]{negotiationNo});
        return obj;
    }

    @Override
    public WorkOrderEstimate getWorkOrderEstimateForWOIdAndEstimateId(Long workOrderId, Long estimateId) {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)((Object)this.genericService.find("from WorkOrderEstimate woe where woe.workOrder.id = ? and woe.estimate.id = ? and woe.estimate.egwStatus.code = ? and woe.workOrder.egwStatus.code = ? and woe.workOrder.parent is null ", new Object[]{workOrderId, estimateId, AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString(), "APPROVED"}));
        return workOrderEstimate;
    }

    @Override
    public List<Object> getWorkOrderDetails(Long estimateId) {
        List woDetails = this.genericService.findAllBy("select woe.workOrder.id ,woe.workOrder.workOrderNumber from WorkOrderEstimate woe  where woe.estimate.id = ? and woe.workOrder.egwStatus.code not in (?,?) ", new Object[]{estimateId, "NEW", "CANCELLED"});
        return woDetails;
    }

    @Override
    public Collection<WorkOrderActivity> getActionWorkOrderActivitiesList(List<WorkOrderActivity> actionWorkOrderActivities) {
        return CollectionUtils.select(actionWorkOrderActivities, workOrderActivity -> (WorkOrderActivity)((Object)((Object)workOrderActivity)) != null);
    }
}

